/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;

class IntConstantInstruction
implements Instruction {
    private int i;

    IntConstantInstruction(int n) {
        this.i = n;
    }

    public void writeCode(CodeContext codeContext) throws CodeException {
        int n = codeContext.getConstants().resolveInt(this.i);
        if (n < 256) {
            codeContext.writeByte((byte)18);
            codeContext.writeByte((byte)n);
        } else {
            codeContext.writeByte((byte)19);
            codeContext.writeShort(n);
        }
    }
}

