/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.Instruction;

class FieldInstruction
implements Instruction {
    private CodeField field;
    private byte opcode;

    FieldInstruction(byte by, CodeField codeField) {
        if (codeField == null) {
            throw new NullPointerException("CodeField can not be null");
        }
        this.opcode = by;
        this.field = codeField;
    }

    public void writeCode(CodeContext codeContext) throws CodeException {
        codeContext.writeByte(this.opcode);
        codeContext.writeShort(codeContext.getConstants().resolveField(this.field));
    }
}

