/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Iterator;
import org.biojava.stats.svm.CachingKernel;
import org.biojava.stats.svm.DiagonalCachingKernel;
import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.NormalizingKernel;
import org.biojava.stats.svm.PolynomialKernel;
import org.biojava.stats.svm.SMOTrainer;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SimpleSVMTarget;
import org.biojava.stats.svm.SparseVector;
import org.biojava.stats.svm.TrainingEvent;
import org.biojava.stats.svm.TrainingListener;
import org.biojava.stats.svm.tools.SVM_Light;

public class Train {
    public static void main(String[] stringArray) throws Throwable {
        Object object;
        String string;
        if (stringArray.length != 2) {
            throw new Exception("usage: stats.svm.tools.Classify <train_examples> <model_file>");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        SimpleSVMTarget simpleSVMTarget = new SimpleSVMTarget();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.startsWith("#")) continue;
            object = SVM_Light.parseExample(string);
            simpleSVMTarget.addItemTarget(((SVM_Light.LabelledVector)object).getVector(), ((SVM_Light.LabelledVector)object).getLabel());
        }
        bufferedReader.close();
        object = new PolynomialKernel();
        ((PolynomialKernel)object).setOrder(2.0);
        ((NestedKernel)object).setNestedKernel(SparseVector.kernel);
        DiagonalCachingKernel diagonalCachingKernel = new DiagonalCachingKernel();
        diagonalCachingKernel.setNestedKernel((SVMKernel)object);
        NormalizingKernel normalizingKernel = new NormalizingKernel();
        normalizingKernel.setNestedKernel(diagonalCachingKernel);
        CachingKernel cachingKernel = new CachingKernel();
        cachingKernel.setNestedKernel(normalizingKernel);
        SMOTrainer sMOTrainer = new SMOTrainer();
        sMOTrainer.setEpsilon(1.0E-9);
        sMOTrainer.setC(1000.0);
        TrainingListener trainingListener = new TrainingListener(){

            public void trainingComplete(TrainingEvent trainingEvent) {
                System.out.println("");
            }

            public void trainingCycleComplete(TrainingEvent trainingEvent) {
                System.out.print('.');
            }
        };
        System.out.println("Training");
        SVMClassifierModel sVMClassifierModel = sMOTrainer.trainModel(simpleSVMTarget, cachingKernel, trainingListener);
        System.out.println("Done");
        Iterator iterator = simpleSVMTarget.items().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            System.out.println(String.valueOf(simpleSVMTarget.getTarget(e)) + "\t" + sVMClassifierModel.classify(e) + "\t(" + sVMClassifierModel.getAlpha(e) + ")");
        }
        SVM_Light.writeModelFile(sVMClassifierModel, string3);
    }
}

