/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.biojava.stats.svm.PolynomialKernel;
import org.biojava.stats.svm.RadialBaseKernel;
import org.biojava.stats.svm.SMOTrainer;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleSVMTarget;

public class ClassifierExample {
    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().setLayout(new BorderLayout());
        final PointClassifier pointClassifier = new PointClassifier();
        jFrame.getContentPane().add("Center", pointClassifier);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton("postive");
        buttonGroup.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton("negative");
        buttonGroup.add(jRadioButton2);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton2 = (JRadioButton)actionEvent.getSource();
                pointClassifier.setAddPos(jRadioButton.isSelected());
            }
        };
        jRadioButton.addActionListener(actionListener);
        jPanel.add(jRadioButton);
        jRadioButton2.addActionListener(actionListener);
        jPanel.add(jRadioButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pointClassifier.classify();
            }
        };
        JButton jButton = new JButton("classify");
        jButton.addActionListener(actionListener2);
        jPanel.add(jButton);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pointClassifier.clear();
            }
        };
        JButton jButton2 = new JButton("clear");
        jButton2.addActionListener(actionListener3);
        jPanel.add(jButton2);
        jRadioButton.setSelected(pointClassifier.getAddPos());
        jRadioButton2.setSelected(pointClassifier.getAddPos() ^ true);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("polynomeal");
        jComboBox.addItem("rbf");
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object = itemEvent.getItem();
                    if (object.equals("polynomeal")) {
                        pointClassifier.setKernel(PointClassifier.polyKernel);
                    } else if (object.equals("rbf")) {
                        pointClassifier.setKernel(PointClassifier.rbfKernel);
                    }
                }
            }
        });
        jPanel.add(jComboBox);
        jFrame.getContentPane().add("North", jPanel);
        ((Component)jFrame).setSize(400, 300);
        ((Component)jFrame).setVisible(true);
    }

    public static class PointClassifier
    extends JComponent {
        public static SVMKernel polyKernel;
        public static SVMKernel rbfKernel;
        public static SMOTrainer trainer;
        private SVMTarget target = new SimpleSVMTarget();
        private SVMClassifierModel model = null;
        private boolean addPos;
        private Shape posShape;
        private Shape negShape;
        private Paint svPaint;
        private Paint plainPaint;
        private Paint posPaint;
        private Paint negPaint;
        private SVMKernel kernel;

        static {
            trainer = new SMOTrainer();
            trainer.setC(1.0E7);
            trainer.setEpsilon(1.0E-9);
            SVMKernel sVMKernel = new SVMKernel(){

                public double evaluate(Object object, Object object2) {
                    Point2D point2D = (Point2D)object;
                    Point2D point2D2 = (Point2D)object2;
                    double d = point2D.getX() * point2D2.getX() + point2D.getY() * point2D2.getY();
                    return d;
                }
            };
            PolynomialKernel polynomialKernel = new PolynomialKernel();
            polynomialKernel.setNestedKernel(sVMKernel);
            polynomialKernel.setOrder(2.0);
            polynomialKernel.setConstant(1.0);
            polynomialKernel.setMultiplier(1.0E-7);
            RadialBaseKernel radialBaseKernel = new RadialBaseKernel();
            radialBaseKernel.setNestedKernel(sVMKernel);
            radialBaseKernel.setWidth(10000.0);
            polyKernel = polynomialKernel;
            rbfKernel = radialBaseKernel;
        }

        public PointClassifier() {
            this.setCursor(new Cursor(1));
            this.addPos = true;
            this.setPosShape(new Rectangle2D.Double(-2.0, -2.0, 5.0, 5.0));
            this.setNegShape(new Ellipse2D.Double(-2.0, -2.0, 5.0, 5.0));
            this.setKernel(polyKernel);
            this.plainPaint = Color.black;
            this.svPaint = Color.green;
            this.posPaint = Color.red;
            this.negPaint = Color.blue;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ PointClassifier this$0;
                {
                    this.this$0 = pointClassifier;
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    if (this.this$0.getAddPos()) {
                        PointClassifier.access$0(this.this$0).addItemTarget(point, 1.0);
                    } else {
                        PointClassifier.access$0(this.this$0).addItemTarget(point, -1.0);
                    }
                    PointClassifier.access$3(this.this$0, null);
                    this.this$0.repaint();
                }
            });
        }

        static /* synthetic */ SVMTarget access$0(PointClassifier pointClassifier) {
            return pointClassifier.target;
        }

        static /* synthetic */ SVMKernel access$1(PointClassifier pointClassifier) {
            return pointClassifier.kernel;
        }

        static /* synthetic */ SVMClassifierModel access$2(PointClassifier pointClassifier) {
            return pointClassifier.model;
        }

        static /* synthetic */ void access$3(PointClassifier pointClassifier, SVMClassifierModel sVMClassifierModel) {
            pointClassifier.model = sVMClassifierModel;
        }

        public void classify() {
            new Thread(this){
                private final /* synthetic */ PointClassifier this$0;
                {
                    this.this$0 = pointClassifier;
                }

                public void run() {
                    Cursor cursor = this.this$0.getCursor();
                    this.this$0.setCursor(new Cursor(3));
                    System.out.println("Training");
                    PointClassifier.access$3(this.this$0, PointClassifier.trainer.trainModel(PointClassifier.access$0(this.this$0), PointClassifier.access$1(this.this$0), null));
                    System.out.println("Threshold = " + PointClassifier.access$2(this.this$0).getThreshold());
                    Iterator<E> iterator = PointClassifier.access$2(this.this$0).items().iterator();
                    while (iterator.hasNext()) {
                        E e = iterator.next();
                        System.out.println(String.valueOf(String.valueOf(e)) + "\t" + PointClassifier.access$0(this.this$0).getTarget(e) + "\t" + PointClassifier.access$2(this.this$0).getAlpha(e) + "\t" + PointClassifier.access$2(this.this$0).classify(e));
                    }
                    PointClassifier.access$3(this.this$0, PointClassifier.access$2(this.this$0));
                    this.this$0.setCursor(cursor);
                    this.this$0.repaint();
                }
            }.start();
        }

        public void clear() {
            this.target.clear();
            this.model = null;
            this.repaint();
        }

        public boolean getAddPos() {
            return this.addPos;
        }

        public SVMKernel getKernel() {
            return this.kernel;
        }

        public Shape getNegShape() {
            return this.negShape;
        }

        public Shape getPosShape() {
            return this.posShape;
        }

        public void paintComponent(Graphics graphics) {
            Object object;
            Object object2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = new AffineTransform();
            int n = 0;
            Rectangle rectangle = graphics2D.getClipBounds();
            int n2 = 3;
            if (this.model != null) {
                object2 = new Rectangle(rectangle.x, rectangle.y, n2, n2);
                object = new Point(rectangle.x, rectangle.y);
                int n3 = rectangle.x;
                while (n3 < rectangle.x + rectangle.width) {
                    ((Point)object).x = n3;
                    ((Rectangle)object2).x = n3;
                    int n4 = rectangle.y;
                    while (n4 < rectangle.y + rectangle.height) {
                        ((Point)object).y = n4;
                        ((Rectangle)object2).y = n4;
                        double d = this.model.classify(object);
                        if (d <= -1.0) {
                            graphics2D.setPaint(this.negPaint);
                        } else if (d >= 1.0) {
                            graphics2D.setPaint(this.posPaint);
                        } else {
                            graphics2D.setPaint(Color.white);
                        }
                        graphics2D.fill((Shape)object2);
                        n4 += n2;
                    }
                    n3 += n2;
                }
            }
            object2 = Collections.EMPTY_SET;
            if (this.model != null) {
                object2 = this.model.items();
            }
            object = this.target.items().iterator();
            while (object.hasNext()) {
                Point2D point2D = (Point2D)object.next();
                affineTransform.setToTranslation(point2D.getX(), point2D.getY());
                Shape shape = this.target.getTarget(point2D) > 0.0 ? this.getPosShape() : this.getNegShape();
                Shape shape2 = affineTransform.createTransformedShape(shape);
                if (object2.contains(point2D)) {
                    graphics2D.setPaint(this.svPaint);
                } else {
                    graphics2D.setPaint(this.plainPaint);
                }
                graphics2D.draw(shape2);
                ++n;
            }
        }

        public void setAddPos(boolean bl) {
            this.firePropertyChange("addPos", this.addPos, bl);
            this.addPos = bl;
        }

        public void setKernel(SVMKernel sVMKernel) {
            this.firePropertyChange("kernel", this.kernel, sVMKernel);
            this.kernel = sVMKernel;
        }

        public void setNegShape(Shape shape) {
            this.firePropertyChange("negShape", this.negShape, shape);
            this.negShape = shape;
        }

        public void setPosShape(Shape shape) {
            this.firePropertyChange("posShape", this.posShape, shape);
            this.posShape = shape;
        }
    }
}

