/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.biojava.stats.svm.SVMKernel;

public class SparseVector
implements Serializable {
    int size;
    int[] keys;
    double[] values;
    public static final SVMKernel kernel = new SparseVectorKernel();

    public SparseVector() {
        this(1);
    }

    public SparseVector(int n) {
        this.keys = new int[n];
        this.values = new double[n];
        Arrays.fill(this.keys, 0, n, Integer.MAX_VALUE);
        this.size = 0;
    }

    public double get(int n) {
        int n2 = Arrays.binarySearch(this.keys, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0.0;
    }

    public int getDimAtIndex(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Attempted to read item " + n + " of an array with " + this.size + "elements");
        }
        return this.keys[n];
    }

    public double getValueAtIndex(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Attempted to read item " + n + " of an array with " + this.size + "elements");
        }
        return this.values[n];
    }

    public int maxIndex() {
        return this.keys[this.size - 1];
    }

    public static SparseVector normalLengthVector(SparseVector sparseVector, double d) {
        SparseVector sparseVector2 = new SparseVector(sparseVector.size);
        double d2 = 0.0;
        int n = 0;
        while (n < sparseVector.size) {
            d2 += sparseVector.values[n] * sparseVector.values[n];
            ++n;
        }
        d2 = Math.sqrt(d2);
        int n2 = 0;
        while (n2 < sparseVector.size) {
            sparseVector2.put(sparseVector.keys[n2], sparseVector.values[n2] * d / d2);
            ++n2;
        }
        return sparseVector2;
    }

    public void put(int n, double d) {
        int n2 = Arrays.binarySearch(this.keys, n);
        if (n2 >= 0) {
            this.values[n2] = d;
        } else {
            n2 = -(n2 + 1);
            if (this.size + 1 >= this.keys.length) {
                int[] nArray = new int[this.keys.length * 2];
                Arrays.fill(nArray, this.size, nArray.length, Integer.MAX_VALUE);
                System.arraycopy(this.keys, 0, nArray, 0, n2);
                System.arraycopy(this.keys, n2, nArray, n2 + 1, this.size - n2);
                this.keys = nArray;
                double[] dArray = new double[this.values.length * 2];
                Arrays.fill(dArray, this.size, dArray.length, Double.NaN);
                System.arraycopy(this.values, 0, dArray, 0, n2);
                System.arraycopy(this.values, n2, dArray, n2 + 1, this.size - n2);
                this.values = dArray;
            } else {
                try {
                    System.arraycopy(this.keys, n2, this.keys, n2 + 1, this.size - n2);
                    System.arraycopy(this.values, n2, this.values, n2 + 1, this.size - n2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("dim         = " + n);
                    System.out.println("value       = " + d);
                    System.out.println("keys.length = " + this.keys.length);
                    System.out.println("size        = " + this.size);
                    System.out.println("indx        = " + n2);
                    System.out.println("indx+1      = " + (n2 + 1));
                    System.out.println("size-indx   = " + (this.size - n2));
                    System.out.println("size+1      = " + (this.size + 1));
                    throw arrayIndexOutOfBoundsException;
                }
            }
            this.keys[n2] = n;
            this.values[n2] = d;
            ++this.size;
        }
    }

    public int size() {
        return this.size;
    }

    private static class SparseVectorKernel
    implements SVMKernel,
    Serializable {
        SparseVectorKernel() {
        }

        public double evaluate(Object object, Object object2) {
            SparseVector sparseVector = (SparseVector)object;
            SparseVector sparseVector2 = (SparseVector)object2;
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            while (n < sparseVector.size && n2 < sparseVector2.size) {
                if (sparseVector.keys[n] > sparseVector2.keys[n2]) {
                    ++n2;
                    continue;
                }
                if (sparseVector.keys[n] < sparseVector2.keys[n2]) {
                    ++n;
                    continue;
                }
                d += sparseVector.values[n++] * sparseVector2.values[n2++];
            }
            return d;
        }

        public String toString() {
            return "SparseVector kernel K(x, y) = sum_i ( x_i * y_i ).";
        }
    }

    public static class NormalizingKernel
    implements SVMKernel,
    Serializable {
        private SparseVector s;

        public NormalizingKernel(List list) {
            this.s = new SparseVector();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SparseVector sparseVector = (SparseVector)iterator.next();
                int n = 0;
                while (n < sparseVector.size()) {
                    this.s.put(sparseVector.keys[n], this.s.get(sparseVector.keys[n]) + sparseVector.values[n]);
                    ++n;
                }
            }
            int n = 0;
            while (n < this.s.size()) {
                this.s.values[n] = (double)list.size() / this.s.values[n];
                int n2 = n;
                this.s.values[n2] = this.s.values[n2] * this.s.values[n];
                ++n;
            }
        }

        public NormalizingKernel(SparseVector sparseVector) {
            this.s = sparseVector;
        }

        public double evaluate(Object object, Object object2) {
            SparseVector sparseVector = (SparseVector)object;
            SparseVector sparseVector2 = (SparseVector)object2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            double d = 0.0;
            while (n < sparseVector.size && n2 < sparseVector2.size && n3 < this.s.size) {
                if (sparseVector.keys[n] < sparseVector2.keys[n2] || sparseVector.keys[n] < this.s.keys[n3]) {
                    ++n;
                    continue;
                }
                if (sparseVector2.keys[n2] < sparseVector.keys[n] || sparseVector2.keys[n2] < this.s.keys[n3]) {
                    ++n2;
                    continue;
                }
                if (this.s.keys[n3] < sparseVector.keys[n] || this.s.keys[n3] < sparseVector2.keys[n2]) {
                    ++n3;
                    continue;
                }
                if (sparseVector.keys[n] == this.s.keys[n3] && sparseVector2.keys[n2] == this.s.keys[n3]) {
                    d += sparseVector.values[n++] * sparseVector2.values[n2++] * (double)sparseVector.keys[n - 1];
                    continue;
                }
                System.out.println("ai = " + n);
                System.out.println("bi = " + n2);
                System.out.println("si = " + n3);
                System.exit(1);
            }
            return d;
        }

        public SparseVector getNormalizingVector() {
            return this.s;
        }

        public void setNormalizingVector(SparseVector sparseVector) {
            this.s = sparseVector;
        }

        public String toString() {
            return "SparseVector.NormalizingKernel K(x, y | s) = sum_i ( x_i * y_i * s_i ).";
        }
    }
}

