/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bridge.Biocorba.Seqcore;

import java.util.Iterator;
import org.Biocorba.Seqcore.NameValueSet;
import org.Biocorba.Seqcore.SeqFeature;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bridge.Biocorba.Seqcore.SequenceAdapter;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class FeatureAdapter
implements Feature {
    private SequenceAdapter parent;
    private SeqFeature seqFeature;
    private Annotation annotation;
    private Location location;

    public FeatureAdapter(SequenceAdapter sequenceAdapter, SeqFeature seqFeature) {
        this.parent = sequenceAdapter;
        this.seqFeature = seqFeature;
        SimpleAnnotation simpleAnnotation = new SimpleAnnotation();
        NameValueSet[] nameValueSetArray = seqFeature.qualifiers();
        int n = 0;
        while (n < nameValueSetArray.length) {
            try {
                simpleAnnotation.setProperty(nameValueSetArray[n].name, nameValueSetArray[n].values);
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "Assertion failure: Couldn't modify my annotations");
            }
            ++n;
        }
        this.annotation = simpleAnnotation;
        this.location = new RangeLocation(seqFeature.start(), seqFeature.end());
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public int countFeatures() {
        return FeatureHolder.EMPTY_FEATURE_HOLDER.countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws ChangeVetoException {
        throw new ChangeVetoException("FeatureAdapter is immutable");
    }

    public Iterator features() {
        return FeatureHolder.EMPTY_FEATURE_HOLDER.features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        return FeatureHolder.EMPTY_FEATURE_HOLDER.filter(featureFilter, bl);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Location getLocation() {
        return this.location;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    public Sequence getSequence() {
        return this.parent;
    }

    public String getSource() {
        return this.seqFeature.source();
    }

    public SymbolList getSymbols() {
        return this.getLocation().symbols(this.parent);
    }

    public String getType() {
        return this.seqFeature.type();
    }

    public Feature.Template makeTemplate() {
        Feature.Template template = new Feature.Template();
        template.location = this.getLocation();
        template.source = this.getSource();
        template.type = this.getType();
        template.annotation = this.getAnnotation();
        return template;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        throw new ChangeVetoException("FeatureAdapter is immutable");
    }
}

