/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractSymbolList
extends AbstractChangeable
implements SymbolList {
    protected AbstractSymbolList() {
    }

    public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSymbolList is immutable");
    }

    public abstract Alphabet getAlphabet();

    public Iterator iterator() {
        return new SymbolIterator(1, this.length());
    }

    public abstract int length();

    public String seqString() {
        return this.subStr(1, this.length());
    }

    public SymbolList subList(int n, int n2) {
        return new SubList(n, n2);
    }

    public String subStr(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 <= n2) {
            stringBuffer.append(this.symbolAt(n3).getToken());
            ++n3;
        }
        return stringBuffer.toString();
    }

    public abstract Symbol symbolAt(int var1) throws IndexOutOfBoundsException;

    public List toList() {
        return new ListView(this);
    }

    private class SymbolIterator
    implements Iterator,
    Serializable {
        private int min;
        private int max;
        private int pos;

        protected SymbolIterator() {
        }

        public SymbolIterator(int n, int n2) {
            this.min = n;
            this.max = n2;
            this.pos = n;
        }

        public boolean hasNext() {
            return this.pos <= this.max;
        }

        public Object next() {
            if (this.pos > this.max) {
                throw new NoSuchElementException();
            }
            return AbstractSymbolList.this.symbolAt(this.pos++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SubList
    extends AbstractChangeable
    implements SymbolList,
    Serializable {
        private int start;
        private int end;
        private transient EditTranslater editTranslater = null;
        private transient Annotatable.AnnotationForwarder annotationForwarder = null;

        public SubList(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
            AbstractSymbolList.this.edit(new Edit(edit.pos + this.start - 1, edit.length, edit.replacement));
        }

        public Alphabet getAlphabet() {
            return AbstractSymbolList.this.getAlphabet();
        }

        protected ChangeSupport getChangeSupport(ChangeType changeType) {
            ChangeSupport changeSupport = super.getChangeSupport(changeType);
            if ((changeType == null || changeType == SymbolList.EDIT) && this.editTranslater == null) {
                this.editTranslater = new EditTranslater(this, changeSupport, this.start, this.end);
                AbstractSymbolList.this.addChangeListener(this.editTranslater, SymbolList.EDIT);
            }
            if ((changeType == null || changeType == Annotation.PROPERTY) && this.annotationForwarder == null) {
                this.annotationForwarder = new Annotatable.AnnotationForwarder(this, changeSupport);
                AbstractSymbolList.this.addChangeListener(this.annotationForwarder, Annotation.PROPERTY);
            }
            return changeSupport;
        }

        public Iterator iterator() {
            return new SymbolIterator(this.start, this.end);
        }

        public int length() {
            return this.end - this.start + 1;
        }

        public String seqString() {
            return this.subStr(1, this.length());
        }

        public SymbolList subList(int n, int n2) {
            if (n < 1 || n2 > this.length() || n2 < 1 || n2 > this.length()) {
                throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + this.start + "," + n2);
            }
            if (n2 < n) {
                throw new IndexOutOfBoundsException("send must not be lower than sstart: sstart=" + this.start + ", send=" + n2);
            }
            return new SubList(n + this.start - 1, n2 + this.start - 1);
        }

        public String subStr(int n, int n2) throws IndexOutOfBoundsException {
            if (n < 1 || n > this.end || n2 < 1 || n2 > this.end || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            return AbstractSymbolList.this.subStr(n + this.start - 1, n2 + this.start - 1);
        }

        public Symbol symbolAt(int n) {
            if (n < 1 || n > this.length()) {
                throw new IndexOutOfBoundsException("Symbol index out of bounds " + this.length() + ":" + n);
            }
            return AbstractSymbolList.this.symbolAt(n + this.start - 1);
        }

        public List toList() {
            return new ListView(this);
        }
    }

    private static class ListView
    extends AbstractList
    implements Serializable {
        private SymbolList rl;

        ListView(SymbolList symbolList) {
            this.rl = symbolList;
        }

        public Object get(int n) {
            return this.rl.symbolAt(n + 1);
        }

        public int size() {
            return this.rl.length();
        }
    }

    public class EditScreener
    extends ChangeForwarder {
        protected final int min;
        protected final int max;

        public EditScreener(Object object, ChangeSupport changeSupport, int n, int n2) {
            super(object, changeSupport);
            this.min = n;
            this.max = n2;
        }

        protected ChangeEvent generateEvent(ChangeEvent changeEvent) {
            Object object;
            ChangeType changeType = changeEvent.getType();
            if (changeType == SymbolList.EDIT && (object = changeEvent.getChange()) != null && object instanceof Edit) {
                Edit edit = (Edit)object;
                int n = edit.pos;
                int n2 = n + edit.length - 1;
                if (n <= this.max && n2 >= this.min) {
                    return new ChangeEvent(this.getSource(), changeType, edit, null, changeEvent);
                }
            }
            return null;
        }
    }

    public class EditTranslater
    extends EditScreener {
        public EditTranslater(Object object, ChangeSupport changeSupport, int n, int n2) {
            super(object, changeSupport, n, n2);
        }

        protected ChangeEvent generateEvent(ChangeEvent changeEvent) {
            if ((changeEvent = super.generateEvent(changeEvent)) != null) {
                Edit edit = (Edit)changeEvent.getChange();
                return new ChangeEvent(changeEvent.getSource(), changeEvent.getType(), new Edit(edit.pos - this.min, edit.length, edit.replacement), null, changeEvent.getChainedEvent());
            }
            return null;
        }
    }
}

