/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolParser;

public class StreamReader
implements SequenceIterator {
    private SymbolParser symParser;
    private SequenceFormat format;
    private SequenceBuilderFactory sf;
    private BufferedReader reader;
    private boolean moreSequenceAvailable = true;

    public StreamReader(BufferedReader bufferedReader, SequenceFormat sequenceFormat, SymbolParser symbolParser, SequenceBuilderFactory sequenceBuilderFactory) {
        this.reader = bufferedReader;
        this.format = sequenceFormat;
        this.symParser = symbolParser;
        this.sf = sequenceBuilderFactory;
    }

    public StreamReader(InputStream inputStream, SequenceFormat sequenceFormat, SymbolParser symbolParser, SequenceBuilderFactory sequenceBuilderFactory) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.format = sequenceFormat;
        this.symParser = symbolParser;
        this.sf = sequenceBuilderFactory;
    }

    public boolean hasNext() {
        return this.moreSequenceAvailable;
    }

    public Sequence nextSequence() throws NoSuchElementException, BioException {
        if (!this.moreSequenceAvailable) {
            throw new NoSuchElementException("Stream is empty");
        }
        try {
            SequenceBuilder sequenceBuilder = this.sf.makeSequenceBuilder();
            this.moreSequenceAvailable = this.format.readSequence(this.reader, this.symParser, sequenceBuilder);
            return sequenceBuilder.makeSequence();
        }
        catch (Exception exception) {
            throw new BioException(exception, "Could not read sequence");
        }
    }
}

