/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.OptimizableFilter;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.utils.ChangeVetoException;

public class FilterUtils {
    public static boolean areDisjoint(FeatureFilter featureFilter, FeatureFilter featureFilter2) {
        if (featureFilter.equals(featureFilter2)) {
            return false;
        }
        if (featureFilter instanceof OptimizableFilter) {
            return ((OptimizableFilter)featureFilter).isDisjoint(featureFilter2);
        }
        return false;
    }

    public static boolean areProperSubset(FeatureFilter featureFilter, FeatureFilter featureFilter2) {
        if (featureFilter.equals(featureFilter2)) {
            return true;
        }
        if (featureFilter instanceof OptimizableFilter) {
            return ((OptimizableFilter)featureFilter).isProperSubset(featureFilter2);
        }
        return false;
    }

    public FeatureHolder evaluate(FeatureFilter featureFilter, FeatureHolder featureHolder) throws BioException {
        return this.evaluatePolish(FilterUtils.reversePolish(featureFilter), featureHolder);
    }

    public FeatureHolder evaluatePolish(List list, FeatureHolder featureHolder) throws BioException {
        try {
            Stack<FeatureHolder> stack = new Stack<FeatureHolder>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                FeatureHolder featureHolder2;
                FeatureFilter featureFilter = (FeatureFilter)iterator.next();
                if (featureFilter instanceof FeatureFilter.And) {
                    featureHolder2 = new SimpleFeatureHolder();
                    object3 = (FeatureHolder)stack.pop();
                    object2 = (FeatureHolder)stack.pop();
                    if (object2.countFeatures() < object3.countFeatures()) {
                        object = object2;
                        object2 = object3;
                        object3 = object;
                    }
                    object = object3.features();
                    while (object.hasNext()) {
                        Feature feature = (Feature)object.next();
                        if (!object2.containsFeature(feature)) continue;
                        ((SimpleFeatureHolder)featureHolder2).addFeature(feature);
                    }
                    stack.push(featureHolder2);
                    continue;
                }
                if (featureFilter instanceof FeatureFilter.AndNot) {
                    featureHolder2 = (FeatureHolder)stack.pop();
                    object3 = (SimpleFeatureHolder)stack.peek();
                    object2 = featureHolder2.features();
                    while (object2.hasNext()) {
                        object = (Feature)object2.next();
                        if (!((SimpleFeatureHolder)object3).containsFeature((Feature)object)) continue;
                        ((SimpleFeatureHolder)object3).removeFeature((Feature)object);
                    }
                    continue;
                }
                if (featureFilter instanceof FeatureFilter.Or) {
                    featureHolder2 = (FeatureHolder)stack.pop();
                    object3 = (SimpleFeatureHolder)stack.peek();
                    object2 = featureHolder2.features();
                    while (object2.hasNext()) {
                        object = (Feature)object2.next();
                        if (((SimpleFeatureHolder)object3).containsFeature((Feature)object)) continue;
                        ((SimpleFeatureHolder)object3).addFeature((Feature)object);
                    }
                    continue;
                }
                if (featureFilter instanceof FeatureFilter.Not) {
                    throw new IllegalArgumentException("Can't evaluate Not - transform them into AndNot statements");
                }
                if (featureFilter instanceof FilterWrapper) {
                    stack.add(featureHolder.filter(((FilterWrapper)featureFilter).getWrapped(), false));
                    continue;
                }
                stack.add(featureHolder.filter(featureFilter, false));
            }
            return (FeatureHolder)stack.pop();
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioException(changeVetoException, "Couldn't evaluate the query");
        }
    }

    private static void reversePolish(List list, FeatureFilter featureFilter) {
        if (featureFilter instanceof FeatureFilter.And) {
            FeatureFilter.And and = (FeatureFilter.And)featureFilter;
            FeatureFilter featureFilter2 = and.getChild1();
            FeatureFilter featureFilter3 = and.getChild2();
            FilterUtils.reversePolish(list, featureFilter2);
            FilterUtils.reversePolish(list, featureFilter3);
        } else if (featureFilter instanceof FeatureFilter.AndNot) {
            FeatureFilter.AndNot andNot = (FeatureFilter.AndNot)featureFilter;
            FeatureFilter featureFilter4 = andNot.getChild1();
            FeatureFilter featureFilter5 = andNot.getChild2();
            FilterUtils.reversePolish(list, featureFilter4);
            FilterUtils.reversePolish(list, featureFilter5);
        } else if (featureFilter instanceof FeatureFilter.Or) {
            FeatureFilter.Or or = (FeatureFilter.Or)featureFilter;
            FeatureFilter featureFilter6 = or.getChild1();
            FeatureFilter featureFilter7 = or.getChild2();
            FilterUtils.reversePolish(list, featureFilter6);
            FilterUtils.reversePolish(list, featureFilter7);
        } else if (featureFilter instanceof FeatureFilter.Not) {
            FeatureFilter.Not not = (FeatureFilter.Not)featureFilter;
            FeatureFilter featureFilter8 = not.getChild();
            FilterUtils.reversePolish(list, featureFilter8);
        }
        list.add(featureFilter);
    }

    public static List reversePolish(FeatureFilter featureFilter) {
        ArrayList arrayList = new ArrayList();
        FilterUtils.reversePolish(arrayList, featureFilter);
        return arrayList;
    }

    private static class FilterWrapper
    implements FeatureFilter {
        private FeatureFilter wrapped;

        public FilterWrapper(FeatureFilter featureFilter) {
            this.wrapped = featureFilter;
        }

        public boolean accept(Feature feature) {
            return this.wrapped.accept(feature);
        }

        public FeatureFilter getWrapped() {
            return this.wrapped;
        }
    }
}

