/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionSupport;
import org.biojava.bio.gui.sequence.SequenceViewerSupport;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class SequencePanel
extends JComponent
implements SwingConstants,
SequenceRenderContext,
Changeable {
    public static final ChangeType RENDERER = new ChangeType("The renderer for this SequencePanel has changed", "org.biojava.bio.gui.sequence.SequencePanel", "RENDERER", SequenceRenderContext.LAYOUT);
    private SymbolList sequence;
    private RangeLocation range;
    private int direction = 0;
    private double scale = 12.0;
    private SequenceRenderContext.Border leadingBorder;
    private SequenceRenderContext.Border trailingBorder;
    private SequenceRenderer renderer;
    private RendererMonitor theMonitor;
    private transient ChangeSupport changeSupport = null;
    private SequenceViewerSupport svSupport = new SequenceViewerSupport();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            SequenceViewerEvent sequenceViewerEvent = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, mouseEvent, new ArrayList(), SequencePanel.this.range);
            SequencePanel.this.svSupport.fireMouseClicked(sequenceViewerEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            SequenceViewerEvent sequenceViewerEvent = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, mouseEvent, new ArrayList(), SequencePanel.this.range);
            SequencePanel.this.svSupport.fireMousePressed(sequenceViewerEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            SequenceViewerEvent sequenceViewerEvent = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, mouseEvent, new ArrayList(), SequencePanel.this.range);
            SequencePanel.this.svSupport.fireMouseReleased(sequenceViewerEvent);
        }
    };
    private SequenceViewerMotionSupport svmSupport = new SequenceViewerMotionSupport();
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            SequenceViewerEvent sequenceViewerEvent = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, mouseEvent, new ArrayList(), SequencePanel.this.range);
            SequencePanel.this.svmSupport.fireMouseDragged(sequenceViewerEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            SequenceViewerEvent sequenceViewerEvent = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, mouseEvent, new ArrayList(), SequencePanel.this.range);
            SequencePanel.this.svmSupport.fireMouseMoved(sequenceViewerEvent);
        }
    };
    private ChangeListener layoutListener = new ChangeAdapter(){

        public void postChange(ChangeEvent changeEvent) {
            SequencePanel.this.resizeAndValidate();
        }
    };
    private ChangeListener repaintListener = new ChangeAdapter(){

        public void postChange(ChangeEvent changeEvent) {
            SequencePanel.this.repaint();
        }
    };

    public SequencePanel() {
        this.theMonitor = new RendererMonitor();
        this.leadingBorder = new SequenceRenderContext.Border();
        this.trailingBorder = new SequenceRenderContext.Border();
        if (this.getFont() == null) {
            this.setFont(new Font("Times New Roman", 0, 12));
        }
        this.addPropertyChangeListener(this.theMonitor);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    protected void _setRenderer(SequenceRenderer sequenceRenderer) {
        Changeable changeable;
        if (this.renderer != null && this.renderer instanceof Changeable) {
            changeable = (Changeable)((Object)this.renderer);
            changeable.removeChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            changeable.removeChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
        this.renderer = sequenceRenderer;
        if (sequenceRenderer != null && sequenceRenderer instanceof Changeable) {
            changeable = (Changeable)((Object)sequenceRenderer);
            changeable.addChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            changeable.addChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.addChangeListener(changeListener, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        ChangeSupport changeSupport;
        ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(changeType);
        synchronized (changeSupport2) {
            changeSupport.addChangeListener(changeListener);
        }
    }

    public void addSequenceViewerListener(SequenceViewerListener sequenceViewerListener) {
        this.svSupport.addSequenceViewerListener(sequenceViewerListener);
    }

    public void addSequenceViewerMotionListener(SequenceViewerMotionListener sequenceViewerMotionListener) {
        this.svmSupport.addSequenceViewerMotionListener(sequenceViewerMotionListener);
    }

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        return this.changeSupport;
    }

    public int getDirection() {
        return this.direction;
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return this.leadingBorder;
    }

    public RangeLocation getRange() {
        return this.range;
    }

    public double getScale() {
        return this.scale;
    }

    public SymbolList getSequence() {
        return this.sequence;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return this.trailingBorder;
    }

    public int graphicsToSequence(double d) {
        return (int)(d / this.scale) + 1;
    }

    public int graphicsToSequence(Point point) {
        if (this.direction == 0) {
            return this.graphicsToSequence(point.getX());
        }
        return this.graphicsToSequence(point.getY());
    }

    protected boolean hasChangeListeners() {
        return this.changeSupport != null;
    }

    protected boolean isActive() {
        return this.sequence != null && this.renderer != null && this.range != null;
    }

    public void paintComponent(Graphics graphics) {
        if (!this.isActive()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D rectangle2D = graphics2D.getClip().getBounds2D();
        double d = this.sequenceToGraphics(this.range.getMin()) - this.renderer.getMinimumLeader(this, this.range);
        double d2 = this.sequenceToGraphics(this.range.getMax()) + this.renderer.getMinimumTrailer(this, this.range);
        double d3 = d2 - d;
        double d4 = this.renderer.getDepth(this, this.range);
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (this.direction == 0) {
            double_.x = d;
            double_.y = 0.0;
            double_.width = d3;
            double_.height = d4;
            graphics2D.translate(this.leadingBorder.getSize() - d, 0.0);
        } else {
            double_.x = 0.0;
            double_.y = d;
            double_.width = d4;
            double_.height = d3;
            graphics2D.translate(0.0, this.leadingBorder.getSize() - d);
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clip(double_);
        this.renderer.paint(graphics2D, this, this.range);
        graphics2D.setClip(shape);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.removeChangeListener(changeListener, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        ChangeSupport changeSupport;
        ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(changeType);
        synchronized (changeSupport2) {
            changeSupport.removeChangeListener(changeListener);
        }
    }

    public void removeSequenceViewerListener(SequenceViewerListener sequenceViewerListener) {
        this.svSupport.removeSequenceViewerListener(sequenceViewerListener);
    }

    public void removeSequenceViewerMotionListener(SequenceViewerMotionListener sequenceViewerMotionListener) {
        this.svmSupport.removeSequenceViewerMotionListener(sequenceViewerMotionListener);
    }

    public void resizeAndValidate() {
        Dimension dimension = null;
        if (!this.isActive()) {
            System.out.println("No sequence");
            this.leadingBorder.setSize(0.0);
            this.trailingBorder.setSize(0.0);
            dimension = new Dimension(0, 0);
        } else {
            double d = this.sequenceToGraphics(this.range.getMin());
            double d2 = this.sequenceToGraphics(this.range.getMax());
            double d3 = this.renderer.getMinimumLeader(this, this.range);
            double d4 = this.renderer.getMinimumTrailer(this, this.range);
            double d5 = d2 - d + d3 + d4;
            double d6 = this.renderer.getDepth(this, this.range);
            dimension = this.direction == 0 ? new Dimension((int)Math.ceil(d5), (int)Math.ceil(d6)) : new Dimension((int)Math.ceil(d6), (int)Math.ceil(d5));
        }
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.revalidate();
    }

    public double sequenceToGraphics(int n) {
        return (double)(n - 1) * this.scale;
    }

    public void setDirection(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Direction must be either HORIZONTAL or VERTICAL");
        }
        int n2 = this.direction;
        this.direction = n;
        this.resizeAndValidate();
        this.firePropertyChange("direction", n2, this.direction);
    }

    public void setRange(RangeLocation rangeLocation) {
        this.range = rangeLocation;
    }

    public void setRenderer(SequenceRenderer sequenceRenderer) throws ChangeVetoException {
        if (this.hasChangeListeners()) {
            ChangeSupport changeSupport;
            ChangeEvent changeEvent = new ChangeEvent(this, RENDERER, sequenceRenderer, this.renderer);
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERER);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(changeEvent);
                this._setRenderer(sequenceRenderer);
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this._setRenderer(sequenceRenderer);
        }
        this.resizeAndValidate();
    }

    public void setScale(double d) {
        double d2 = this.scale;
        this.scale = d;
        this.resizeAndValidate();
        this.firePropertyChange("scale", d2, d);
    }

    public void setSequence(SymbolList symbolList) {
        SymbolList symbolList2 = this.sequence;
        if (symbolList2 != null) {
            symbolList2.removeChangeListener(this.layoutListener);
        }
        this.sequence = symbolList;
        this.sequence.addChangeListener(this.layoutListener);
        this.resizeAndValidate();
        this.firePropertyChange("sequence", symbolList2, symbolList);
    }

    private class RendererMonitor
    implements PropertyChangeListener {
        RendererMonitor() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SequencePanel.this.repaint();
        }
    }

    public class Border
    implements Serializable,
    SwingConstants {
        protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private double size = 0.0;
        private int alignment = 0;

        private Border() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public int getAlignment() {
            return this.alignment;
        }

        public double getSize() {
            return this.size;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public void setAlignment(int n) throws IllegalArgumentException {
            if (n != 10 && n != 11 && n != 0) {
                throw new IllegalArgumentException("Alignment must be one of the constants LEADING, TRAILING or CENTER");
            }
            int n2 = this.alignment;
            this.alignment = n;
            this.pcs.firePropertyChange("alignment", n2, n);
        }

        private void setSize(double d) {
            this.size = d;
        }
    }
}

