/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.LayeredRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class MultiLineRenderer
extends AbstractChangeable
implements SequenceRenderer,
Serializable {
    public static final ChangeType RENDERERS = new ChangeType("A SequenceRenderer has been added or removed.", "org.biojava.bio.gui.sequence.MultiLineRenderer", "RENDERERS", SequenceRenderContext.LAYOUT);
    private List renderers = new ArrayList();
    private transient ChangeForwarder rendererForwarder = null;

    protected void _addRenderer(SequenceRenderer sequenceRenderer) {
        this.renderers.add(sequenceRenderer);
    }

    protected void _removeRenderer(SequenceRenderer sequenceRenderer) {
        this.renderers.remove(sequenceRenderer);
    }

    public void addRenderer(SequenceRenderer sequenceRenderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeEvent changeEvent = new ChangeEvent(this, RENDERERS, sequenceRenderer, null);
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERERS);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(changeEvent);
                this._addRenderer(sequenceRenderer);
                if (sequenceRenderer instanceof Changeable) {
                    Changeable changeable = (Changeable)((Object)sequenceRenderer);
                    changeable.addChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this._addRenderer(sequenceRenderer);
        }
    }

    public void clearRenderers() throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeEvent changeEvent = new ChangeEvent(this, RENDERERS);
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERERS);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(changeEvent);
                Iterator iterator = this.renderers.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Changeable)) continue;
                    Changeable changeable = (Changeable)e;
                    changeable.removeChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                this.renderers.clear();
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.renderers.clear();
        }
    }

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        ChangeSupport changeSupport = super.getChangeSupport(changeType);
        if (this.rendererForwarder == null) {
            this.rendererForwarder = new SequenceRenderer.RendererForwarder(this, changeSupport);
            Iterator iterator = this.renderers.iterator();
            while (iterator.hasNext()) {
                SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator.next();
                if (!(sequenceRenderer instanceof Changeable)) continue;
                Changeable changeable = (Changeable)((Object)sequenceRenderer);
                changeable.addChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
            }
        }
        return changeSupport;
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return LayeredRenderer.INSTANCE.getDepth(Collections.nCopies(this.renderers.size(), sequenceRenderContext), rangeLocation, this.renderers);
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return LayeredRenderer.INSTANCE.getMinimumLeader(Collections.nCopies(this.renderers.size(), sequenceRenderContext), rangeLocation, this.renderers);
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return LayeredRenderer.INSTANCE.getMinimumTrailer(Collections.nCopies(this.renderers.size(), sequenceRenderContext), rangeLocation, this.renderers);
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        LayeredRenderer.INSTANCE.paint(graphics2D, Collections.nCopies(this.renderers.size(), sequenceRenderContext), rangeLocation, this.renderers);
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext sequenceRenderContext, MouseEvent mouseEvent, List list, RangeLocation rangeLocation) {
        list.add(this);
        SequenceViewerEvent sequenceViewerEvent = LayeredRenderer.INSTANCE.processMouseEvent(Collections.nCopies(this.renderers.size(), sequenceRenderContext), mouseEvent, list, rangeLocation, this.renderers);
        if (sequenceViewerEvent == null) {
            sequenceViewerEvent = new SequenceViewerEvent(this, null, sequenceRenderContext.graphicsToSequence(mouseEvent.getPoint()), mouseEvent, list);
        }
        return sequenceViewerEvent;
    }

    public void removeRenderer(SequenceRenderer sequenceRenderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeEvent changeEvent = new ChangeEvent(this, RENDERERS, null, sequenceRenderer);
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERERS);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(changeEvent);
                this._removeRenderer(sequenceRenderer);
                if (sequenceRenderer instanceof Changeable) {
                    Changeable changeable = (Changeable)((Object)sequenceRenderer);
                    changeable.removeChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this._removeRenderer(sequenceRenderer);
        }
    }
}

