/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.DiscreteDistribution;

public class EnvelopedWaveDistribution
implements DiscreteDistribution {
    private static double FREQ = 10.2;
    private DiscreteDistribution envelope;
    private double phase;
    private int offset;
    private double[] values;
    private double max;

    public EnvelopedWaveDistribution(DiscreteDistribution discreteDistribution, double d) {
        this.envelope = discreteDistribution;
        this.phase = d % FREQ;
        this.offset = -discreteDistribution.getMin();
        this.values = new double[discreteDistribution.getMax() - discreteDistribution.getMin() + 1];
        double d2 = 0.0;
        int n = discreteDistribution.getMin();
        while (n <= discreteDistribution.getMax()) {
            double d3 = Math.pow(Math.cos(((double)n + this.phase) / (FREQ / Math.PI)), 2.0);
            this.values[n + this.offset] = d3 * discreteDistribution.probability(n);
            d2 += this.values[n + this.offset];
            ++n;
        }
        this.max = 0.0;
        int n2 = 0;
        while (n2 < this.values.length) {
            this.values[n2] = this.values[n2] / d2;
            this.max = Math.max(this.max, this.values[n2]);
            ++n2;
        }
    }

    public DiscreteDistribution getEnvelope() {
        return this.envelope;
    }

    public double getPhase() {
        return this.phase;
    }

    public int getMin() {
        return this.envelope.getMin();
    }

    public int getMax() {
        return this.envelope.getMax();
    }

    public double probability(int n) {
        if ((n += this.offset) < 0 && n >= this.values.length) {
            return 0.0;
        }
        return this.values[n];
    }

    public double probabilityDivMax(int n) {
        return this.probability(n) / this.max;
    }

    public int hashCode() {
        return this.envelope.hashCode() + (int)(this.phase * 98653.0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EnvelopedWaveDistribution)) {
            return false;
        }
        EnvelopedWaveDistribution envelopedWaveDistribution = (EnvelopedWaveDistribution)object;
        return envelopedWaveDistribution.getPhase() == this.phase && envelopedWaveDistribution.getEnvelope().equals(this.envelope);
    }
}

