/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import eponine.SequenceContext;
import eponine.datasource.DataSource;
import eponine.model.EponineXML;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.utils.xml.AppEntry;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import stats.glm.GLMClassificationModel;

public class TestCore
implements AppEntry {
    private DataSource dataSource;
    private String fileName;
    private double threshold;
    private int interval = 0;
    private boolean testTrainingSet = false;
    private String densityFile = null;
    private double rocMin = -4.0;
    private double rocMax = -1.0;
    private double rocStep = 0.2;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public void setTestTrainingSet(boolean bl) {
        this.testTrainingSet = bl;
    }

    public void setRocMin(double d) {
        this.rocMin = d;
    }

    public void setRocMax(double d) {
        this.rocMax = d;
    }

    public void setRocStep(double d) {
        this.rocStep = d;
    }

    public void setDensityFile(String string) {
        this.densityFile = string;
    }

    public void start(String[] stringArray) {
        try {
            Object object;
            EponineXML eponineXML = new EponineXML();
            InputSource inputSource = new InputSource(new FileInputStream(this.fileName));
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            GLMClassificationModel gLMClassificationModel = eponineXML.xmlToModel(document.getDocumentElement());
            SVMTarget sVMTarget = null;
            sVMTarget = this.testTrainingSet ? this.dataSource.getTrainingExamples() : this.dataSource.getTestExamples();
            double[] dArray = new double[sVMTarget.itemTargets().size()];
            double[] dArray2 = new double[sVMTarget.itemTargets().size()];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            double[] dArray3 = new double[this.interval * 2 + 1];
            int n7 = 0;
            Iterator iterator = sVMTarget.itemTargets().iterator();
            while (iterator.hasNext()) {
                object = (ItemValue)iterator.next();
                double d = object.getValue();
                SequenceContext sequenceContext = (SequenceContext)object.getItem();
                SequenceContext sequenceContext2 = new SequenceContext(sequenceContext.getSequence(), sequenceContext.getPosition());
                double d2 = 0.0;
                int n8 = -this.interval;
                while (n8 <= this.interval) {
                    sequenceContext2.setPosition(sequenceContext.getPosition() + n8);
                    double d3 = gLMClassificationModel.positiveProbability(sequenceContext2);
                    d2 = Math.max(d2, d3);
                    if (d3 > 1.0 - this.threshold) {
                        int n9 = n8 + this.interval;
                        dArray3[n9] = dArray3[n9] + 1.0;
                    }
                    ++n8;
                }
                dArray[n7] = d;
                dArray2[n7] = d2;
                ++n7;
                System.out.println("" + d + " -> " + d2);
                if (d == 1.0) {
                    if (d2 > 1.0 - this.threshold) {
                        ++n4;
                        continue;
                    }
                    if (d2 < this.threshold) {
                        ++n5;
                        continue;
                    }
                    ++n6;
                    continue;
                }
                if (d2 > 1.0 - this.threshold) {
                    ++n;
                    continue;
                }
                if (d2 < this.threshold) {
                    ++n2;
                    continue;
                }
                ++n3;
            }
            if (this.densityFile != null) {
                object = new PrintWriter(new FileWriter(this.densityFile));
                int n10 = 0;
                while (n10 < dArray3.length) {
                    ((PrintWriter)object).println("" + (n10 - this.interval) + "\t" + dArray3[n10]);
                    ++n10;
                }
                ((PrintWriter)object).close();
            }
            System.out.println("Accuracy (%positives true): " + (double)n4 * 100.0 / (double)(n4 + n));
            System.out.println("Sensitivity (%positives detected): " + (double)n4 * 100.0 / (double)(n4 + n5 + n6));
            System.out.println("\n\nROC curve");
            double d = this.rocMin;
            int n11 = 0;
            while (d <= this.rocMax) {
                double d4 = Math.pow(10.0, d);
                n = 0;
                n2 = 0;
                n3 = 0;
                n4 = 0;
                n5 = 0;
                n6 = 0;
                int n12 = 0;
                while (n12 < dArray.length) {
                    if (dArray[n12] == 1.0) {
                        if (dArray2[n12] > 1.0 - d4) {
                            ++n4;
                        } else if (dArray2[n12] < d4) {
                            ++n5;
                        } else {
                            ++n6;
                        }
                    } else if (dArray2[n12] > 1.0 - d4) {
                        ++n;
                    } else if (dArray2[n12] < d4) {
                        ++n2;
                    } else {
                        ++n3;
                    }
                    ++n12;
                }
                System.out.print("" + d);
                System.out.print(" " + (double)n4 * 100.0 / (double)(n4 + n));
                System.out.print(" " + (double)n4 * 100.0 / (double)(n4 + n5 + n6));
                System.out.println();
                d = this.rocMin + this.rocStep * (double)(++n11);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

