/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.Channel;
import edu.oswego.cs.dl.util.concurrent.Executor;
import edu.oswego.cs.dl.util.concurrent.SynchronousChannel;
import edu.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PooledExecutor
extends ThreadFactoryUser
implements Executor {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 60000L;
    protected volatile int maximumPoolSize_ = Integer.MAX_VALUE;
    protected volatile int minimumPoolSize_ = 1;
    protected long keepAliveTime_ = 60000L;
    protected final Channel handOff_;
    protected Object poolLock_ = new Object();
    protected volatile int poolSize_ = 0;
    protected final Map threads_;
    protected BlockedExecutionHandler blockedExecutionHandler_;

    public PooledExecutor() {
        this(new SynchronousChannel(), Integer.MAX_VALUE);
    }

    public PooledExecutor(int n) {
        this(new SynchronousChannel(), n);
    }

    public PooledExecutor(Channel channel) {
        this(channel, Integer.MAX_VALUE);
    }

    public PooledExecutor(Channel channel, int n) {
        this.maximumPoolSize_ = n;
        this.handOff_ = channel;
        this.runWhenBlocked();
        this.threads_ = new HashMap();
    }

    protected void addThread(Runnable runnable) {
        ++this.poolSize_;
        Worker worker = new Worker(runnable);
        Thread thread = this.getThreadFactory().newThread(worker);
        this.threads_.put(worker, thread);
        thread.start();
    }

    public int createThreads(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object object = this.poolLock_;
            synchronized (object) {
                if (this.getPoolSize() < this.getMaximumPoolSize()) {
                    ++n2;
                } else {
                    break;
                }
                this.addThread(null);
            }
            ++n3;
        }
        return n2;
    }

    public synchronized void discardWhenBlocked() {
        this.blockedExecutionHandler_ = new DiscardWhenBlocked();
    }

    public List drain() {
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>();
        while (true) {
            try {
                Object object;
                while ((object = this.handOff_.poll(0L)) != null) {
                    vector.addElement(object);
                }
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return vector;
    }

    public void execute(Runnable runnable) throws InterruptedException {
        do {
            Object object = this.poolLock_;
            synchronized (object) {
                if (this.getPoolSize() < this.getMinimumPoolSize()) {
                    this.addThread(runnable);
                    return;
                }
                if (this.handOff_.offer(runnable, 0L)) {
                    return;
                }
                if (this.getPoolSize() < this.getMaximumPoolSize()) {
                    this.addThread(runnable);
                    return;
                }
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(runnable));
    }

    protected synchronized BlockedExecutionHandler getBlockedExecutionHandler() {
        return this.blockedExecutionHandler_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public int getPoolSize() {
        return this.poolSize_;
    }

    protected Runnable getTask() throws InterruptedException {
        long l = this.getKeepAliveTime();
        if (l >= 0L) {
            return (Runnable)this.handOff_.poll(l);
        }
        return (Runnable)this.handOff_.take();
    }

    public void interruptAll() {
        Object object = this.poolLock_;
        synchronized (object) {
            Iterator iterator = this.threads_.values().iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                thread.interrupt();
            }
        }
    }

    public synchronized void runWhenBlocked() {
        this.blockedExecutionHandler_ = new RunWhenBlocked();
    }

    public synchronized void setKeepAliveTime(long l) {
        this.keepAliveTime_ = l;
    }

    public void setMaximumPoolSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = n;
    }

    public void setMinimumPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = n;
    }

    public synchronized void waitWhenBlocked() {
        this.blockedExecutionHandler_ = new WaitWhenBlocked();
    }

    protected void workerDone(Worker worker) {
        Object object = this.poolLock_;
        synchronized (object) {
            --this.poolSize_;
            this.threads_.remove(worker);
        }
    }

    protected class DiscardWhenBlocked
    extends BlockedExecutionHandler {
        protected DiscardWhenBlocked() {
        }

        protected boolean blockedAction(Runnable runnable) {
            return true;
        }
    }

    protected class WaitWhenBlocked
    extends BlockedExecutionHandler {
        protected WaitWhenBlocked() {
        }

        protected boolean blockedAction(Runnable runnable) {
            try {
                PooledExecutor.this.handOff_.put(runnable);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    protected class RunWhenBlocked
    extends BlockedExecutionHandler {
        protected RunWhenBlocked() {
        }

        protected boolean blockedAction(Runnable runnable) {
            runnable.run();
            return true;
        }
    }

    protected abstract class BlockedExecutionHandler {
        protected BlockedExecutionHandler() {
        }

        abstract boolean blockedAction(Runnable var1);
    }

    protected class Worker
    implements Runnable {
        protected Runnable firstTask_;

        Worker(Runnable runnable) {
            this.firstTask_ = runnable;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    Runnable runnable = this.firstTask_;
                    this.firstTask_ = null;
                    if (runnable != null) {
                        runnable.run();
                    }
                    while (PooledExecutor.this.getPoolSize() <= PooledExecutor.this.getMaximumPoolSize() && (runnable = PooledExecutor.this.getTask()) != null) {
                        runnable.run();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object var3_4 = null;
                    PooledExecutor.this.workerDone(this);
                    return;
                }
                Object var3_3 = null;
                PooledExecutor.this.workerDone(this);
                return;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                PooledExecutor.this.workerDone(this);
                throw throwable;
            }
        }
    }
}

