/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.IntDoubleProcedure;
import cern.colt.function.IntIntDoubleFunction;
import cern.colt.map.AbstractIntDoubleMap;
import cern.colt.map.OpenIntDoubleHashMap;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SelectedSparseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;

public class SparseDoubleMatrix2D
extends DoubleMatrix2D {
    protected AbstractIntDoubleMap elements;

    public SparseDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public SparseDoubleMatrix2D(int n, int n2) {
        this(n, n2, n * (n2 / 1000), 0.2, 0.5);
    }

    public SparseDoubleMatrix2D(int n, int n2, int n3, double d, double d2) {
        this.setUp(n, n2);
        this.elements = new OpenIntDoubleHashMap(n3, d, d2);
    }

    protected SparseDoubleMatrix2D(int n, int n2, AbstractIntDoubleMap abstractIntDoubleMap, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractIntDoubleMap;
        this.isNoView = false;
    }

    public DoubleMatrix2D assign(double d) {
        if (this.isNoView && d == 0.0) {
            this.elements.clear();
        } else {
            super.assign(d);
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleFunction doubleFunction) {
        if (this.isNoView && doubleFunction instanceof Mult) {
            this.elements.assign(doubleFunction);
        } else {
            super.assign(doubleFunction);
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (!(doubleMatrix2D instanceof SparseDoubleMatrix2D)) {
            return super.assign(doubleMatrix2D);
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = (SparseDoubleMatrix2D)doubleMatrix2D;
        if (sparseDoubleMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseDoubleMatrix2D);
        if (this.isNoView && sparseDoubleMatrix2D.isNoView) {
            this.elements.assign(sparseDoubleMatrix2D.elements);
            return this;
        }
        return super.assign(doubleMatrix2D);
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        if (!this.isNoView) {
            return super.assign(doubleMatrix2D, doubleDoubleFunction);
        }
        this.checkShape(doubleMatrix2D);
        if (doubleDoubleFunction instanceof PlusMult) {
            final double d = ((PlusMult)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    SparseDoubleMatrix2D.this.setQuick(n, n2, SparseDoubleMatrix2D.this.getQuick(n, n2) + d * d2);
                    return d2;
                }
            });
            return this;
        }
        if (doubleDoubleFunction == Functions.mult) {
            this.elements.forEachPair(new IntDoubleProcedure(){

                public boolean apply(int n, double d) {
                    int n2 = n / SparseDoubleMatrix2D.this.columns;
                    int n3 = n % SparseDoubleMatrix2D.this.columns;
                    double d2 = d * doubleMatrix2D.getQuick(n2, n3);
                    if (d2 != d) {
                        SparseDoubleMatrix2D.this.elements.put(n, d2);
                    }
                    return true;
                }
            });
        }
        if (doubleDoubleFunction == Functions.div) {
            this.elements.forEachPair(new IntDoubleProcedure(){

                public boolean apply(int n, double d) {
                    int n2 = n / SparseDoubleMatrix2D.this.columns;
                    int n3 = n % SparseDoubleMatrix2D.this.columns;
                    double d2 = d / doubleMatrix2D.getQuick(n2, n3);
                    if (d2 != d) {
                        SparseDoubleMatrix2D.this.elements.put(n, d2);
                    }
                    return true;
                }
            });
        }
        return super.assign(doubleMatrix2D, doubleDoubleFunction);
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction intIntDoubleFunction) {
        if (this.isNoView) {
            this.elements.forEachPair(new IntDoubleProcedure(){

                public boolean apply(int n, double d) {
                    int n2 = n / SparseDoubleMatrix2D.this.columns;
                    int n3 = n % SparseDoubleMatrix2D.this.columns;
                    double d2 = intIntDoubleFunction.apply(n2, n3, d);
                    if (d2 != d) {
                        SparseDoubleMatrix2D.this.elements.put(n, d2);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(intIntDoubleFunction);
        }
        return this;
    }

    public double getQuick(int n, int n2) {
        return this.elements.get(this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride);
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D instanceof SelectedSparseDoubleMatrix2D) {
            SelectedSparseDoubleMatrix2D selectedSparseDoubleMatrix2D = (SelectedSparseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == selectedSparseDoubleMatrix2D.elements;
        }
        if (doubleMatrix2D instanceof SparseDoubleMatrix2D) {
            SparseDoubleMatrix2D sparseDoubleMatrix2D = (SparseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == sparseDoubleMatrix2D.elements;
        }
        return false;
    }

    protected int index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        return new SparseDoubleMatrix1D(n, this.elements, n2, n3);
    }

    public void setQuick(int n, int n2, double d) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        if (d == 0.0) {
            this.elements.removeKey(n3);
        } else {
            this.elements.put(n3, d);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseDoubleMatrix2D(this.elements, nArray, nArray2, 0);
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d, double d2, final boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = doubleMatrix1D2 == null;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(this.isNoView && doubleMatrix1D instanceof DenseDoubleMatrix1D && doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if (n2 != doubleMatrix1D.size() || n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        if (!bl2) {
            doubleMatrix1D2.assign(Functions.mult(d2 / d));
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        final double[] dArray = denseDoubleMatrix1D.elements;
        final int n3 = denseDoubleMatrix1D.stride;
        final int n4 = doubleMatrix1D2.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        final double[] dArray2 = denseDoubleMatrix1D2.elements;
        final int n5 = denseDoubleMatrix1D2.stride;
        final int n6 = doubleMatrix1D.index(0);
        if (dArray2 == null || dArray == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d) {
                int n2 = n / SparseDoubleMatrix2D.this.columns;
                int n32 = n % SparseDoubleMatrix2D.this.columns;
                if (bl) {
                    int n42 = n2;
                    n2 = n32;
                    n32 = n42;
                }
                int n52 = n4 + n3 * n2;
                dArray[n52] = dArray[n52] + d * dArray2[n6 + n5 * n32];
                return true;
            }
        });
        if (d != 1.0) {
            doubleMatrix1D2.assign(Functions.mult(d));
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, final double d, double d2, final boolean bl, boolean bl2) {
        boolean bl3;
        if (!this.isNoView) {
            return super.zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, bl, bl2);
        }
        if (bl2) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = doubleMatrix2D.columns;
        boolean bl4 = bl3 = doubleMatrix2D2 == null;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (doubleMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort());
        }
        if (doubleMatrix2D2.rows != n || doubleMatrix2D2.columns != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            doubleMatrix2D2.assign(Functions.mult(d2));
        }
        final DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            doubleMatrix1DArray[n4] = doubleMatrix2D.viewRow(n4);
        }
        final DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            doubleMatrix1DArray2[n5] = doubleMatrix2D2.viewRow(n5);
        }
        final PlusMult plusMult = PlusMult.plusMult(0.0);
        this.elements.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d2) {
                int n2 = n / SparseDoubleMatrix2D.this.columns;
                int n3 = n % SparseDoubleMatrix2D.this.columns;
                plusMult.multiplicator = d2 * d;
                if (!bl) {
                    doubleMatrix1DArray2[n2].assign(doubleMatrix1DArray[n3], plusMult);
                } else {
                    doubleMatrix1DArray2[n3].assign(doubleMatrix1DArray[n2], plusMult);
                }
                return true;
            }
        });
        return doubleMatrix2D2;
    }
}

