/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget;

import fr.cea.ig.metatarget.MetaBin;
import fr.cea.ig.metatarget.datastructures.ClusterPoisson;
import fr.cea.ig.metatarget.datastructures.ClusterVectorAB;
import fr.cea.ig.metatarget.datastructures.Dictionary;
import fr.cea.ig.metatarget.datastructures.FastaManager;
import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.datastructures.SequenceProcessor;
import fr.cea.ig.metatarget.datastructures.VectorUtils;
import fr.cea.ig.metatarget.kmeans.ClusterVectorCB;
import fr.cea.ig.metatarget.kmeans.ConcurrentKMeans;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;

public class MTxABxCB
implements MetaBin {
    private static String version;
    private static Dictionary dictionary;
    private FastaManager frm;
    private StringBuilder sb = null;
    private TIntIntHashMap sequenceAssignmentsAB;
    private TIntIntHashMap sequenceAssignmentsCB;
    private TIntObjectHashMap<double[]> sequenceDistancesCB;
    private AtomicInteger currCBid;
    private StringBuilder clustersDesign = null;
    private boolean finalStep = false;
    private List<BufferedOutputStream> bos;
    private List<AtomicInteger> spc;

    public String go(String[] args) throws Exception {
        version = new Date(Utils.classBuildTimeMillis(this.getClass())).toString();
        System.out.println("version MTxABxCB =" + version);
        int numOfThreads = 1;
        int excludeMin = 1;
        int excludeMax = 0;
        int kAB = 10;
        int kCB = 4;
        int numOfClustersAB = 3;
        int readLength = 400;
        long genomeSize = 3000000L;
        List<String> inputFastaFileNames = null;
        String outputClustersFileNamePrefix = null;
        boolean keepQualities = false;
        boolean compressOut = false;
        boolean dryRun = false;
        BasicParser parser = new BasicParser();
        Options options = this.createOptions();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            if (args.length < 1) {
                throw new Exception();
            }
            if (cmd.hasOption("t")) {
                numOfThreads = Integer.parseInt(cmd.getOptionValue("t"));
            }
            if (cmd.hasOption("i")) {
                inputFastaFileNames = Arrays.asList(cmd.getOptionValues("i"));
            }
            if (cmd.hasOption("kAB")) {
                kAB = Integer.parseInt(cmd.getOptionValue("kAB"));
            }
            if (cmd.hasOption("kCB")) {
                kCB = Integer.parseInt(cmd.getOptionValue("kCB"));
            }
            if (cmd.hasOption("nAB")) {
                numOfClustersAB = Integer.parseInt(cmd.getOptionValue("nAB"));
            }
            if (cmd.hasOption("r")) {
                readLength = Integer.parseInt(cmd.getOptionValue("r"));
            }
            if (cmd.hasOption("g")) {
                genomeSize = new BigDecimal(cmd.getOptionValue("g")).intValue();
            }
            if (cmd.hasOption("oC")) {
                outputClustersFileNamePrefix = cmd.getOptionValue("oC");
            }
            if (cmd.hasOption("eMin")) {
                excludeMin = Integer.parseInt(cmd.getOptionValue("eMin"));
            }
            if (cmd.hasOption("eMax")) {
                excludeMax = new BigDecimal(cmd.getOptionValue("eMax")).intValue();
            }
            if (cmd.hasOption("q")) {
                keepQualities = true;
            }
            if (cmd.hasOption("z")) {
                compressOut = true;
            }
            if (cmd.hasOption("d")) {
                dryRun = true;
            }
        }
        catch (Exception exp) {
            formatter.printHelp("MTxABxCB", options, true);
            exp.printStackTrace(System.err);
            return null;
        }
        this.sequenceAssignmentsAB = new TIntIntHashMap();
        this.sequenceAssignmentsCB = new TIntIntHashMap();
        this.sequenceDistancesCB = new TIntObjectHashMap();
        this.currCBid = new AtomicInteger(0);
        this.clustersDesign = new StringBuilder();
        this.clustersDesign.append("ABxCB\tAB\tsize\n");
        this.sb = new StringBuilder();
        this.processSequencesAB_count(numOfThreads, kAB, inputFastaFileNames, excludeMin, excludeMax);
        this.removeMinKmers(excludeMin);
        System.out.println(Utils.RAMInfo(Runtime.getRuntime()));
        TIntLongHashMap countsHistoAB = dictionary.getCountsHisto();
        readLength = this.guessSeqLength(kAB);
        if (!dryRun) {
            this.save_histogram(countsHistoAB, outputClustersFileNamePrefix);
        }
        ClusterPoisson[] clusterPoissonsAB = VectorUtils.createABClusterPoissonsEMsync(numOfClustersAB, excludeMin, excludeMax, dictionary);
        System.out.println(Utils.time() + "\tFilter before=" + clusterPoissonsAB.length);
        ClusterPoisson[] filtered_clusterPoissonsAB = VectorUtils.filterClusterPoissons(clusterPoissonsAB);
        numOfClustersAB = filtered_clusterPoissonsAB.length;
        System.out.println(Utils.time() + "\tFilter after=" + filtered_clusterPoissonsAB.length);
        ClusterVectorAB[] clusterVectorsAB = dictionary.createABClusterVectors(filtered_clusterPoissonsAB, excludeMin, excludeMax);
        dictionary.clear();
        dictionary = null;
        this.processSequencesAB_assign(numOfThreads, kAB, inputFastaFileNames, clusterVectorsAB, keepQualities);
        for (ClusterVectorAB cv : clusterVectorsAB) {
            cv.clear();
            cv = null;
        }
        clusterVectorsAB = null;
        this.processSequencesCB_count(numOfThreads, kCB, inputFastaFileNames);
        System.out.println(Utils.RAMInfo(Runtime.getRuntime()));
        Object[] listsAB = this.getSequenceListsAB(numOfClustersAB);
        List sequenceListsAB = (List)listsAB[0];
        List sequenceIdsMappingsAB = (List)listsAB[1];
        this.CBBinning(numOfThreads, kCB, sequenceListsAB, sequenceIdsMappingsAB, filtered_clusterPoissonsAB, readLength, genomeSize, outputClustersFileNamePrefix);
        System.out.println(Utils.RAMInfo(Runtime.getRuntime()));
        int numOfClustersCB = this.currCBid.get();
        this.prepareOutputFiles(numOfClustersCB, outputClustersFileNamePrefix, keepQualities, compressOut, dryRun);
        this.finalStep = true;
        this.processSequencesCB_assign(numOfThreads, inputFastaFileNames, keepQualities);
        this.closeOutputFiles(numOfClustersCB);
        System.out.println(Utils.RAMInfo(Runtime.getRuntime()));
        return this.sb.toString();
    }

    private Options createOptions() {
        Options options = new Options();
        OptionBuilder.withArgName("numOfThreads");
        OptionBuilder.withLongOpt("numOfThreads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Number of threads to use.");
        OptionBuilder.isRequired(false);
        Option t = OptionBuilder.create("t");
        options.addOption(t);
        OptionBuilder.withArgName("kMerSizeAB");
        OptionBuilder.withLongOpt("kMerSizeAB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("k-mer length for AB.");
        OptionBuilder.isRequired(false);
        Option kAB = OptionBuilder.create("kAB");
        options.addOption(kAB);
        OptionBuilder.withArgName("kMerSizeCB");
        OptionBuilder.withLongOpt("kMerSizeCB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("k-mer length for CB.");
        OptionBuilder.isRequired(false);
        Option kCB = OptionBuilder.create("kCB");
        options.addOption(kCB);
        OptionBuilder.withArgName("input");
        OptionBuilder.withLongOpt("input");
        OptionBuilder.hasArgs(Integer.MAX_VALUE);
        OptionBuilder.withDescription("Input Fasta/q files paths.");
        OptionBuilder.isRequired(true);
        Option input = OptionBuilder.create("i");
        options.addOption(input);
        OptionBuilder.withArgName("eMin");
        OptionBuilder.withLongOpt("eMin");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("ExcludeMin kmers.");
        OptionBuilder.isRequired(false);
        Option excludeMinOption = OptionBuilder.create("eMin");
        options.addOption(excludeMinOption);
        OptionBuilder.withArgName("eMax");
        OptionBuilder.withLongOpt("eMax");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("ExcludeMax kmers.");
        OptionBuilder.isRequired(false);
        Option excludeMaxOption = OptionBuilder.create("eMax");
        options.addOption(excludeMaxOption);
        OptionBuilder.withArgName("outputC");
        OptionBuilder.withLongOpt("outputC");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Output Clusters files prefix.");
        OptionBuilder.isRequired(true);
        Option output_C = OptionBuilder.create("oC");
        options.addOption(output_C);
        OptionBuilder.withArgName("numOfClustersAB");
        OptionBuilder.withLongOpt("numOfClustersAB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Number of Clusters for AB.");
        OptionBuilder.isRequired(false);
        Option numOfClustersAB = OptionBuilder.create("nAB");
        options.addOption(numOfClustersAB);
        OptionBuilder.withArgName("readLength");
        OptionBuilder.withLongOpt("readLength");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Read length.");
        OptionBuilder.isRequired(false);
        Option readLength = OptionBuilder.create("r");
        options.addOption(readLength);
        OptionBuilder.withArgName("genomeSize");
        OptionBuilder.withLongOpt("genomeSize");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Average genome size.");
        OptionBuilder.isRequired(false);
        Option genomeSize = OptionBuilder.create("g");
        options.addOption(genomeSize);
        OptionBuilder.withArgName("q");
        OptionBuilder.withLongOpt("quality");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Keep qualities.");
        OptionBuilder.isRequired(false);
        Option keepQualities = OptionBuilder.create("q");
        options.addOption(keepQualities);
        OptionBuilder.withArgName("z");
        OptionBuilder.withLongOpt("gzip");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Compress output.");
        OptionBuilder.isRequired(false);
        Option compressOut = OptionBuilder.create("z");
        options.addOption(compressOut);
        OptionBuilder.withArgName("d");
        OptionBuilder.withLongOpt("dry");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Dry run.");
        OptionBuilder.isRequired(false);
        Option dryRun = OptionBuilder.create("d");
        options.addOption(dryRun);
        return options;
    }

    private void processSequencesAB_count(int numOfThreads, int kAB, List<String> inputFastaFileNames, int excludeMin, int excludeMax) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            dictionary = new Dictionary(0x100000, usingThreads, excludeMin, excludeMax);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            System.out.println(Utils.time() + " START of AB Counting");
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            if (this.frm != null) {
                this.frm.clear();
                this.frm = null;
            }
            this.frm = new FastaManager(false, inputFastaFileNames, startSignal, doneSignal);
            pool.execute(this.frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(this, dictionary, this.frm, SequenceProcessor.MODE.AB_KMERCOUNT, kAB, startSignal, doneSignal, null);
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
            System.out.println(Utils.time() + " END of AB Counting");
            System.out.println(Utils.time() + " Loaded sequences: " + SequenceProcessor.getSequenceCount().get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int guessSeqLength(int kAB) {
        try {
            return (int)((double)dictionary.getTotalKmers() / (2.0 * (double)this.frm.getStaticSequences().size())) + (kAB - 1);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 150;
        }
    }

    private void removeMinKmers(int excludeMin) {
        try {
            System.out.println(Utils.time() + " Distinct kmers(before remove):\t" + dictionary.getKmerCodes().size() + "\n");
            if (excludeMin > 1) {
                System.out.println(Utils.time() + " Removing kmer with global count < " + excludeMin);
                dictionary.removeAll(excludeMin);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void save_histogram(TIntLongHashMap countsHistoAB, String outputClustersFileNamePrefix) {
        try {
            File f = new File(outputClustersFileNamePrefix + "__ABxCB.histogram.tsv").getCanonicalFile();
            f.getParentFile().mkdirs();
            BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(f));
            IOUtils.write("counts\tfrequency\n", (OutputStream)bo, StandardCharsets.UTF_8);
            TIntLongIterator it = countsHistoAB.iterator();
            while (it.hasNext()) {
                it.advance();
                IOUtils.write(it.key() + "\t" + it.value() + "\n", (OutputStream)bo, StandardCharsets.UTF_8);
            }
            bo.flush();
            bo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processSequencesAB_assign(int numOfThreads, int kAB, List<String> inputFastaFileNames, ClusterVectorAB[] ABClusterVectors, boolean keepQualities) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            System.out.println(Utils.time() + " START of AB Binning");
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            if (this.frm != null) {
                this.frm.clear();
                this.frm = null;
            }
            this.frm = new FastaManager(false, inputFastaFileNames, startSignal, doneSignal);
            pool.execute(this.frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(this, dictionary, this.frm, SequenceProcessor.MODE.AB_BINNING, kAB, startSignal, doneSignal, new Object[]{keepQualities});
                sp.setABClusterVectors(ABClusterVectors);
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
            System.out.println(Utils.time() + " END of AB Binning");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processSequencesCB_count(int numOfThreads, int kCB, List<String> inputFastaFileNames) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            System.out.println(Utils.time() + " START of CB Counting");
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            if (this.frm != null) {
                this.frm.clear();
                this.frm = null;
            }
            this.frm = new FastaManager(false, inputFastaFileNames, startSignal, doneSignal);
            pool.execute(this.frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(this, null, this.frm, SequenceProcessor.MODE.CB_SEQUENCEVECTORBUILD, kCB, startSignal, doneSignal, null);
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
            System.out.println(Utils.time() + " END of CB Counting");
            System.out.println(Utils.time() + " Loaded sequences: " + SequenceProcessor.getSequenceCount().get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object[] getSequenceListsAB(int numOfClustersAB) {
        try {
            ArrayList sequenceLists = new ArrayList();
            for (int i = 0; i < numOfClustersAB; ++i) {
                sequenceLists.add(new ArrayList());
            }
            ArrayList sequenceIdsMappings = new ArrayList();
            for (int i = 0; i < numOfClustersAB; ++i) {
                sequenceIdsMappings.add(new ArrayList());
            }
            for (Sequence s : this.frm.getStaticSequences()) {
                s.setAssignedCluster(this.sequenceAssignmentsAB.get(s.getSequenceId()));
                if (s.getAssignedCluster() <= 0) continue;
                ((List)sequenceLists.get(s.getAssignedCluster() - 1)).add(s);
                ((List)sequenceIdsMappings.get(s.getAssignedCluster() - 1)).add(s.getSequenceId());
            }
            return new Object[]{sequenceLists, sequenceIdsMappings};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void CBBinning(int numOfThreads, int kCB, List<List<Sequence>> sequenceListsAB, List<List<Integer>> sequenceIdsMappingsAB, ClusterPoisson[] clusterPoissonsAB, int readLength, long genomeSize, String outputClustersFileNamePrefix) {
        try {
            int i;
            for (i = 0; i < sequenceListsAB.size(); ++i) {
                System.out.println(Utils.time() + " AB Cluster=" + (i + 1) + "\tSize=" + sequenceListsAB.get(i).size());
            }
            System.out.println("");
            for (i = 0; i < sequenceListsAB.size(); ++i) {
                int cpus = Runtime.getRuntime().availableProcessors();
                int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
                System.out.println("cpus=" + cpus);
                System.out.println("using=" + usingThreads);
                CountDownLatch startSignal = new CountDownLatch(1);
                CountDownLatch doneSignal = new CountDownLatch(1);
                ExecutorService pool = Executors.newFixedThreadPool(1);
                List<Sequence> sequences = sequenceListsAB.get(i);
                List<Integer> sequencesIdsMapping = sequenceIdsMappingsAB.get(i);
                ClusterPoisson clusterPoisson = clusterPoissonsAB[i];
                int numOfClustersCB = this.guessNumOfClustersCB(i, clusterPoisson.getGenomeAbundance(), clusterPoisson.getGenomeLength(), sequences.size(), readLength, genomeSize);
                if (sequences.size() < 10) {
                    System.out.println(Utils.time() + " AB Cluster=" + (i + 1) + "\tSize=" + sequences.size() + " quiting CB phase.");
                    continue;
                }
                System.out.println(Utils.time() + " START of Creating CB Clusters for AB Cluster=" + (i + 1) + "\tSize=" + sequences.size());
                ConcurrentKMeans kMeans = new ConcurrentKMeans(numOfClustersCB, kCB, sequences, 25, System.currentTimeMillis(), usingThreads, startSignal, doneSignal);
                pool.execute(kMeans);
                startSignal.countDown();
                doneSignal.await();
                pool.shutdown();
                System.out.println(Utils.time() + " END of Creating CB Clusters for AB Cluster=" + (i + 1));
                ClusterVectorCB[] clusterVectorsCB = kMeans.getClusters();
                this.parseAssignmentsCB(clusterVectorsCB, sequencesIdsMapping, i + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int guessNumOfClustersCB(int ABid, double abundance, double EMLength, long size, long readLength, long genomeSize) {
        int estimatednewSpecies;
        double newLength = (double)(size * readLength) / abundance;
        int estimatedEMSpecies = (int)(EMLength / (double)genomeSize);
        if (estimatedEMSpecies < 1) {
            estimatedEMSpecies = 1;
        }
        if ((estimatednewSpecies = (int)(newLength / (double)genomeSize)) < 1) {
            estimatednewSpecies = 1;
        }
        System.out.println(String.format("%5s", "ABid") + "\t" + String.format("%8s", "size") + "\t" + String.format("%12.12s", "abundance") + "\t" + String.format("%10.10s", "EMLength") + "\t" + String.format("%10s", "newLength") + "\t" + String.format("%10s", "EMspecies") + "\t" + String.format("%10s", "newspecies"));
        System.out.println(String.format("%5s", "-----") + "\t" + String.format("%8s", "----") + "\t" + String.format("%12.12s", "---------") + "\t" + String.format("%10.10s", "--------") + "\t" + String.format("%10s", "---------") + "\t" + String.format("%10s", "---------") + "\t" + String.format("%10s", "----------"));
        System.out.println(String.format("%5d", ABid + 1) + "\t" + String.format("%,8d", size) + "\t" + String.format("%12.5f", abundance) + "\t" + String.format("%,10d", (long)EMLength) + "\t" + String.format("%,10d", (long)newLength) + "\t" + String.format("%5d", estimatedEMSpecies) + "\t\t" + String.format("%5d", estimatednewSpecies));
        return estimatedEMSpecies;
    }

    private void parseAssignmentsCB(ClusterVectorCB[] CBClusters, List<Integer> sequencesIdsMapping, int currABid) {
        try {
            for (int i = 0; i < CBClusters.length; ++i) {
                this.currCBid.incrementAndGet();
                for (int seq_index : CBClusters[i].getMemberIndexes()) {
                    this.sequenceAssignmentsCB.put(sequencesIdsMapping.get(seq_index), this.currCBid.get());
                }
                this.clustersDesign.append(this.currCBid.get() + "\t" + currABid + "\t" + CBClusters[i].getMemberIndexes().length + "\n");
            }
            for (Sequence s : this.frm.getStaticSequences()) {
                this.sequenceDistancesCB.put(s.getSequenceId(), s.getDistancesToClusters());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareOutputFiles(int numOfClustersCB, String outputClustersFileNamePrefix, boolean keepQualities, boolean compressOut, boolean dryRun) {
        try {
            this.bos = Arrays.asList(new BufferedOutputStream[numOfClustersCB + 2]);
            this.spc = new ArrayList<AtomicInteger>();
            for (int i = 0; i < numOfClustersCB; ++i) {
                if (!dryRun) {
                    File f = compressOut ? new File(outputClustersFileNamePrefix + "__ABxCB." + (i + 1) + (this.frm.isFastq && keepQualities ? ".fastq.gz" : ".fasta.gz")).getCanonicalFile() : new File(outputClustersFileNamePrefix + "__ABxCB." + (i + 1) + (this.frm.isFastq && keepQualities ? ".fastq" : ".fasta")).getCanonicalFile();
                    f.getParentFile().mkdirs();
                    BufferedOutputStream bo = null;
                    bo = compressOut ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(f))) : new BufferedOutputStream(new FileOutputStream(f));
                    this.bos.set(i, bo);
                }
                this.spc.add(new AtomicInteger(0));
            }
            List numbers = Stream.iterate(1, n -> n + 1).limit(numOfClustersCB).collect(Collectors.toList());
            String line = "read_id\tABxCB\tABxCB." + numbers.stream().map(String::valueOf).collect(Collectors.joining("\tABxCB.")) + "\n";
            this.sb.append(line);
            if (!dryRun) {
                File f = new File(outputClustersFileNamePrefix + "__ABxCB.assignments.tsv").getCanonicalFile();
                f.getParentFile().mkdirs();
                this.bos.set(numOfClustersCB, new BufferedOutputStream(new FileOutputStream(f)));
                IOUtils.write(line, (OutputStream)this.bos.get(numOfClustersCB), StandardCharsets.UTF_8);
                f = new File(outputClustersFileNamePrefix + "__ABxCB.clustersDesign.tsv").getCanonicalFile();
                f.getParentFile().mkdirs();
                this.bos.set(numOfClustersCB + 1, new BufferedOutputStream(new FileOutputStream(f)));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void processSequencesCB_assign(int numOfThreads, List<String> inputFastaFileNames, boolean keepQualities) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            System.out.println(Utils.time() + " START of CB Binning");
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            if (this.frm != null) {
                this.frm.clear();
                this.frm = null;
            }
            this.frm = new FastaManager(false, inputFastaFileNames, startSignal, doneSignal);
            pool.execute(this.frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(this, null, this.frm, SequenceProcessor.MODE.CB_BINNING, -1, startSignal, doneSignal, new Object[]{keepQualities});
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeOutputFiles(int numOfClustersCB) {
        try {
            BufferedOutputStream bo;
            System.out.println("\tClustered reads:");
            for (int i = 0; i < numOfClustersCB; ++i) {
                bo = this.bos.get(i);
                if (bo != null) {
                    bo.flush();
                    bo.close();
                }
                System.out.println("\t\tABxCB Cluster " + (i + 1) + ": " + this.spc.get(i).get());
            }
            bo = this.bos.get(numOfClustersCB);
            if (bo != null) {
                bo.flush();
                bo.close();
            }
            if ((bo = this.bos.get(numOfClustersCB + 1)) != null) {
                IOUtils.write(this.clustersDesign.toString(), (OutputStream)bo, StandardCharsets.UTF_8);
                bo.flush();
                bo.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public synchronized boolean saveSeqToCluster(Sequence sequence, boolean keepQualities) {
        try {
            if (!this.finalStep) {
                this.sequenceAssignmentsAB.put(sequence.getSequenceId(), sequence.getAssignedCluster());
            } else {
                BufferedOutputStream bo;
                int clusterId = this.sequenceAssignmentsCB.get(sequence.getSequenceId());
                if (clusterId <= 0) {
                    return false;
                }
                this.spc.get(clusterId - 1).incrementAndGet();
                Object[] distancesLine = new String[this.currCBid.get()];
                Arrays.fill(distancesLine, "NA");
                double[] distances = this.sequenceDistancesCB.get(sequence.getSequenceId());
                int indxMin = Utils.indexOfSmallest(distances);
                for (int i = 0; i < distances.length; ++i) {
                    distancesLine[clusterId - 1 - indxMin + i] = String.valueOf(distances[i]);
                }
                String line = sequence.getShortName() + "\t" + clusterId + "\t" + Arrays.stream(distancesLine).collect(Collectors.joining("\t")) + "\n";
                this.sb.append(line);
                if (this.bos.get(this.bos.size() - 2) != null) {
                    IOUtils.write(line, (OutputStream)this.bos.get(this.bos.size() - 2), StandardCharsets.UTF_8);
                }
                if ((bo = this.bos.get(clusterId - 1)) == null) {
                    return false;
                }
                if (sequence.getHeader() != null) {
                    IOUtils.write(sequence.getHeader(), (OutputStream)bo);
                    IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
                }
                if (sequence.getSeq() != null) {
                    IOUtils.write(sequence.getSeq(), (OutputStream)bo);
                    IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
                }
                if (keepQualities && sequence.getQual() != null) {
                    IOUtils.write("+\n", (OutputStream)bo, StandardCharsets.UTF_8);
                    IOUtils.write(sequence.getQual(), (OutputStream)bo);
                    IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        MTxABxCB MT_AB_CB = new MTxABxCB();
        try {
            System.out.println(MT_AB_CB.go(args));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

