## A script to make the metadata.csv file located in inst/extdata of
## the package.See ?AnnotationHubData::makeAnnotationHubMetadata for a
## description of the metadata.csv file, expected fields and data
## types. This AnnotationHubData::makeAnnotationHubMetadata() function
## can be used to validate the metadata.csv file before submitting the
## package.

metadata <-
    data.frame(
        Title = c(
            "ko15.CDF",
            "cptac_a_b_c_peptides.txt",
            "cptac_a_b_peptides.txt",
            "cptac_peptides.txt",
            "TMT_Erwinia_1uLSike_Top10HCD_isol2_45stepped_60min_01-20141210.mzid",
            "TMT_Erwinia_1uLSike_Top10HCD_isol2_45stepped_60min_01-20141210.mzML.gz",
            "20171016_POOL_POS_1_105-134.mzML",
            "20171016_POOL_POS_3_105-134.mzML",
            "PestMix1_DDA.mzML",
            "PestMix1_SWATH.mzML",
            "benchmarkingDIA.tsv",
            "Report-Derks2022-plexDIA.tsv",
            "Ai2025_aCMs_report.tsv",
            "Ai2025_iCMs_report.tsv",
            "crap_gpm.fasta",
            "crap_ccp.fasta",
            "crap_maxquant.fasta.gz",
            "CEMS_10ppm.mzML",
            "CEMS_25ppm.mzML",
            "HAM004_641fE_14-11-07--Exp1.extracted.mzML",
            "HAM004_641fE_14-11-07--Exp2.extracted.mzML",
            "HAM004_641fE_14-11-07--Exp3.extracted.mzML",
            "HAM004_641fE_14-11-07--Exp4.extracted.mzML",
            "HAM004_641fE_14-11-07--Exp5.extracted.mzML",
            "HAM005_641fE_14-11-07--Exp1.extracted.mzML",
            "HAM005_641fE_14-11-07--Exp2.extracted.mzML",
            "HAM005_641fE_14-11-07--Exp3.extracted.mzML",
            "HAM005_641fE_14-11-07--Exp4.extracted.mzML",
            "HAM005_641fE_14-11-07--Exp5.extracted.mzML",
            "MRM-standmix-5.mzML"
        ),
        Description = c(
            "Raw metabolomics MS file in netCDF format. See ?ko15.CDF for details.",
            "Conditions A, B and C of the CPTAC quantitative proteomics data (tab-delimited format). See ?cptac for details.",
            "Conditions A and B of the CPTAC quantitative proteomics data (tab-delimited format). See ?cptac for details.",
            "CPTAC quantitative proteomics data (tab-delimited format). See ?cptac for details.",
            "Peptide spectrum matches from the PDX000001 experiment. See ?PXD000001 for details.",
            "Raw MS data from the PDX000001 experiment, in mzML format. See ?PXD000001 for details.",
            "AB Sciex LC-MS data file (injection index 1), in mzML format. See ?sciex for details.",
            "AB Sciex LC-MS data file (injection index 19), in mzML format. See ?sciex for details.",
            "Triple TOF DDA raw data, in mzML format. See ?TripleTOF for details.",
            "Triple TOF SWATH raw data, in mzML format. See ?TripleTOF for details.",
            "Output of DIA-NN software (report.tsv)",
            "Derk et al. (2022) single-cell proteomics plexDIA results (DIA-NN report.tsv).",
            "Ai et al. (2025) Single Cell Proteomics Reveals Specific Cellular Subtypes in Cardiomyocytes Derived from Human iPSCs and Adult Hearts.",
            "Ai et al. (2025) Single Cell Proteomics Reveals Specific Cellular Subtypes in Cardiomyocytes Derived from Human iPSCs and Adult Hearts.",
            "common Repository of Adventitious Proteins (cRAP) from the Global Proteome Machine (GPM)",
            "common Repository of Adventitious Proteins (cRAP) from the Cambridge Centre for Proteomics (CCP)",
            "MaxQuant's contaminant database",
            "CE-MS data file (10ppm), in mzML format. See ?CEMS for details.",
            "CE-MS data file (25ppm) in mzML format. See ?CEMS for details.",
            "FTICR-MS data file HAM4, experiment 1, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM4, experiment 2, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM4, experiment 3, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM4, experiment 4, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM4, experiment 5, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM5, experiment 1, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM5, experiment 2, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM5, experiment 3, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM5, experiment 4, in mzML file. See ?FTICR for details",
            "FTICR-MS data file HAM5, experiment 5, in mzML file. See ?FTICR for details",
            "Multiple Reaction Monitoring mode (MRM) file from a mouse brain sample. See ?MRM fo details"
            ),
        BiocVersion = c(
            rep("3.17", 11),
            "3.19",
            "3.21",
            "3.21",
            "3.21",
            "3.21",
            "3.21",
            "3.22",
            "3.22",
            rep("3.22", 10),
            "3.22"
        ),
        Genome = "",
        SourceType = c(
            "CDF",
            "TXT",
            "TXT",
            "TXT",
            "mzid",
            "mzML",
            "mzML",
            "mzML",
            "mzML",
            "mzML",
            "TSV",
            "TSV",
            "TSV",
            "TSV",
            "FASTA",
            "FASTA",
            "FASTA",
            "mzML",
            "mzML",
            rep("mzML", 10),
            "mzML"
       ),
        SourceUrl = c(
            "https://bioconductor.org/packages/3.16/data/experiment/html/msdata.html",
            "https://uclouvain-cbio.github.io/WSBIM2122/data/cptac_a_b_c_peptides.txt",
            "https://bioconductor.org/packages/3.16/data/experiment/html/msdata.html",
            "https://raw.githubusercontent.com/statOmics/PDA/data/quantification/fullCptacDatasSetNotForTutorial/peptides.txt",
            "https://bioconductor.org/packages/3.16/data/experiment/html/msdata.html",
            "https://ftp.pride.ebi.ac.uk/pride/data/archive/2012/03/PXD000001/",
            "https://bioconductor.org/packages/3.16/data/experiment/html/msdata.html",
            "https://bioconductor.org/packages/3.16/data/experiment/html/msdata.html",
            "https://bioconductor.org/packages/3.16/data/experiment/html/msdata.html",
            "https://bioconductor.org/packages/3.16/data/experiment/html/msdata.html",
            "https://zenodo.org/records/8063173",
            "https://drive.google.com/drive/folders/1pUC2zgXKtKYn22mlor0lmUDK0frgwL_-",
            "ftp://massive.ucsd.edu/v07/MSV000094438/updates/2024-10-23_bineka_5deafa61/other/Supplementary%20Files/aCMs/report.tsv",
            "ftp://massive.ucsd.edu/v07/MSV000094438/updates/2024-10-23_bineka_5deafa61/other/Supplementary%20Files/iCMs/report1.tsv",
            "https://zenodo.org/records/15115102/files/crap_gpm.fasta",
            "https://zenodo.org/records/15115102/files/crap_ccp.fasta",
            "https://zenodo.org/records/15115102/files/crap_maxquant.fasta.gz",
            "https://zenodo.org/records/18481720/files/CEMS_10ppm.mzML",
            "https://zenodo.org/records/18481720/files/CEMS_25ppm.mzML",
            "https://zenodo.org/records/18494294/files/HAM004_641fE_14-11-07--Exp1.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM004_641fE_14-11-07--Exp2.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM004_641fE_14-11-07--Exp3.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM004_641fE_14-11-07--Exp4.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM004_641fE_14-11-07--Exp5.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM005_641fE_14-11-07--Exp1.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM005_641fE_14-11-07--Exp2.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM005_641fE_14-11-07--Exp3.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM005_641fE_14-11-07--Exp4.extracted.mzML",
            "https://zenodo.org/records/18494294/files/HAM005_641fE_14-11-07--Exp5.extracted.mzML",
            "https://zenodo.org/records/18502866/files/MRM-standmix-5.mzML"
        ),
        SourceVersion = rep("1.0", 30),
        Species = c(
            "Mus musculus",
            "Saccharomyces cerevisiae",
            "Saccharomyces cerevisiae",
            "Saccharomyces cerevisiae",
            "Erwinia carotovora",
            "Erwinia carotovora",
            "Homo sapiens",
            "Homo sapiens",
            "",
            "",
            "Homo sapiens",
            "Homo sapiens",
            "Homo sapiens",
            "Homo sapiens",
            "",
            "",
            "",
            "",
            "",
            rep("", 10),
            "Mus musculus"
        ),
        TaxonomyId = c(
            "10090",
            "4932",
            "4932",
            "4932",
            "554",
            "554",
            "9606",
            "9606",
            "",
            "",
            "9606",
            "9606",
            "9606",
            "9606",
            "",
            "",
            "",
            "",
            "",
            rep("", 10),
            "10090"
        ),
        Coordinate_1_based = "",
        DataProvider = "",
        Maintainer = "Laurent Gatto <laurent.gatto@uclouvain.be>",
        RDataClass = c(
            "Spectra",
            "data.frame",
            "data.frame",
            "data.frame",
            "Spectra",
            "PSM",
            "Spectra",
            "Spectra",
            "Spectra",
            "Spectra",
            "data.frame",
            "data.frame",
            "data.frame",
            "data.frame",
            "AAStringSet",
            "AAStringSet",
            "AAStringSet",
            "Spectra",
            "Spectra",
            rep("Spectra", 10),
            "Spectra"
        ),
        DispatchClass = c(
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            "FilePath",
            rep("FilePath", 10),
            "FilePath"
        ),
        ## NB: locally, the data are stored in the package's data directory, but
        ## in the Azure cloud, they are located in the package's root directory.
        Location_Prefix = c(
          rep("", times = 10),
          "https://zenodo.org/",
          "https://zenodo.org/",
          "ftp://massive.ucsd.edu/",
          "ftp://massive.ucsd.edu/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/",
          "https://zenodo.org/"
        ),
         RDataPath = c(
            "MsDataHub/cdf/ko15.CDF",
            "MsDataHub/cptac/cptac_a_b_c_peptides.txt",
            "MsDataHub/cptac/cptac_a_b_peptides.txt",
            "MsDataHub/cptac/cptac_peptides.txt",
            "MsDataHub/PXD000001/TMT_Erwinia_1uLSike_Top10HCD_isol2_45stepped_60min_01-20141210.mzid",
            "MsDataHub/PXD000001/TMT_Erwinia_1uLSike_Top10HCD_isol2_45stepped_60min_01-20141210.mzML.gz",
            "MsDataHub/sciex/20171016_POOL_POS_1_105-134.mzML",
            "MsDataHub/sciex/20171016_POOL_POS_3_105-134.mzML",
            "MsDataHub/TripleTOF-SWATH/PestMix1_DDA.mzML",
            "MsDataHub/TripleTOF-SWATH/PestMix1_SWATH.mzML",
            "record/8063173/files/benchmarkingDIA.tsv",
            "records/10938597/files/Report-Derks2022-plexDIA.tsv",
            "v07/MSV000094438/updates/2024-10-23_bineka_5deafa61/other/Supplementary%20Files/aCMs/report.tsv",
            "v07/MSV000094438/updates/2024-10-23_bineka_5deafa61/other/Supplementary%20Files/iCMs/report1.tsv",
            "records/15115102/files/crap_gpm.fasta",
            "records/15115102/files/crap_ccp.fasta",
            "records/15115102/files/crap_maxquant.fasta.gz",
            "records/18481720/files/CEMS_10ppm.mzML",
            "records/18481720/files/CEMS_25ppm.mzML",
            "records/18494294/files/HAM004_641fE_14-11-07--Exp1.extracted.mzML",
            "records/18494294/files/HAM004_641fE_14-11-07--Exp2.extracted.mzML",
            "records/18494294/files/HAM004_641fE_14-11-07--Exp3.extracted.mzML",
            "records/18494294/files/HAM004_641fE_14-11-07--Exp4.extracted.mzML",
            "records/18494294/files/HAM004_641fE_14-11-07--Exp5.extracted.mzML",
            "records/18494294/files/HAM005_641fE_14-11-07--Exp1.extracted.mzML",
            "records/18494294/files/HAM005_641fE_14-11-07--Exp2.extracted.mzML",
            "records/18494294/files/HAM005_641fE_14-11-07--Exp3.extracted.mzML",
            "records/18494294/files/HAM005_641fE_14-11-07--Exp4.extracted.mzML",
            "records/18494294/files/HAM005_641fE_14-11-07--Exp5.extracted.mzML",
            "records/18502866/files/MRM-standmix-5.mzML"
         ),
       Tags = ""
    )


## The experiment titles are conferted into functions to directly
## access the individual resources. This requires that they correspond
## to valid unique symbol names. To assert this, then are converted
## with make.names().
metadata[["Title"]] <- make.names(metadata[["Title"]])


if (!grepl("MsDataHub/inst/scripts", getwd()))
    stop("Run from MsDataHub/inst/scripts")

library(here)
write.csv(metadata, file = here("inst", "extdata", "metadata.csv"),
          row.names = FALSE)

# pkg_source <- file.path(ifelse(file.exists("~/wrk"), "~/wrk", "~/dev"),
#                         "MsDataHub")

pkg_source <- file.path(ifelse(file.exists("~/dev"), "~/dev", "~/wrk"),
                        "MsDataHub")

stopifnot(file.exists(pkg_source))

AnnotationHubData::makeAnnotationHubMetadata(pathToPackage = pkg_source,
                                             fileName = "metadata.csv")
