## ----eval=FALSE---------------------------------------------------------------
# # Install BiocManager if not already installed
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# # Install devtools if not already installed
# if (!requireNamespace("devtools", quietly = TRUE))
#     install.packages("devtools")
# 
# # Install ggcyto development version from GitHub - otherwise does not work with ggplot2
# devtools::install_github("RGLab/ggcyto", ref = "devel")
# 
# # Install CompensAID from GitHub
# devtools::install_github("Olsman/CompensAID")
# 
# # Install ggplot2 from Bioconductor - older version otherwise it ggcyto gives errors
# devtools::install_version("ggplot2", version = "3.5.2", repos = "http://cran.us.r-project.org")
# 
# # Load libraries
# library(ggplot2)
# library(ggcyto)
# library(CompensAID)

## ----eval=FALSE---------------------------------------------------------------
# # Read flowFrame
# file <- flowCore::read.FCS(system.file("extdata", "raw.68983.fcs", package = "CompensAID"))
# 
# # Remove margins (for conventional only)
# file <- PeacoQC::RemoveMargins(ff = file,
#                                channels = colnames(flowCore::exprs(file)),
#                                output = "frame")
# 
# # Compensate data (for conventional only)
# file <- flowCore::compensate(file, file@description$SPILL)
# 
# # Transform data
# file <- flowCore::transform(file,
#                             flowCore::estimateLogicle(file, colnames(flowCore::keyword(file)$SPILL)))
# 
# # Run PeacoQC
# file <- PeacoQC::PeacoQC(ff = file,
#                        channels = colnames(flowCore::exprs(file)),
#                        save_fcs = FALSE,
#                        plot = FALSE,
#                        report = FALSE,
#                        output_directory = NULL)
# file <- file$FinalFF
# 
# # Retain only markers
# file <- file[, names(flowCore::markernames(file))]

## ----Clean--------------------------------------------------------------------
# Pre-processed data 
file <- flowCore::read.FCS(system.file("extdata", "68983.fcs", package = "CompensAID"))

## ----CompensAID---------------------------------------------------------------
# CompensAID
res.compensaid <- CompensAID::CompensAID(ff = file)

## ----Matrix, fig.width=5, fig.height=5----------------------------------------
matrix <- CompensAID::PlotMatrix(output = res.compensaid)
print(matrix)

## ----Identification-----------------------------------------------------------
# Check SSI < -1
index <- which(res.compensaid[["matrix"]] < -1, arr.ind = TRUE)

# Obtain marker names
library(dplyr)
combination <- data.frame(primary.channel = rownames(res.compensaid[["matrix"]])[index[, "col"]],
                          secondary.channel = rownames(res.compensaid[["matrix"]])[index[, "row"]]) |>
  dplyr::mutate(primary.marker = flowCore::markernames(file)[primary.channel],
                secondary.marker = flowCore::markernames(file)[secondary.channel])

## ----Dotplot, fig.width=5, fig.height=5---------------------------------------
# Visualize dot plot with SSI scores
dotPlot <- CompensAID::PlotDotSSI(output = res.compensaid,
                                  og = file,
                                  primary = combination$primary.marker[1],
                                  secondary = combination$secondary.marker[1],
                                  showScores = TRUE)
print(dotPlot)

## ----SessionInfo--------------------------------------------------------------
sessionInfo()

