/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import org.apache.xmlrpc.XmlRpcException;
import reder.application.GraphTask;
import reder.application.JButtonGradient;
import reder.application.Methods;
import reder.application.RedHandler;
import reder.application.RedPreferences;
import reder.application.RedXmlRpc;
import reder.application.RedeR;
import reder.application.Zoom;
import reder.application.graph.EdgeBank;
import reder.application.graph.LegendBank;
import reder.application.graph.NodeBank;
import reder.application.graph.OutEdgesMap;
import reder.application.io.ExportImage;
import reder.application.io.ExportPDF;
import reder.application.io.ExportSVG;
import reder.application.io.FileOpen;
import reder.application.io.FileSave;
import reder.application.io.LoadData;
import reder.application.io.PrintImage;
import reder.application.io.SaveData;

public final class RederMainFrame
extends JFrame {
    public static ArrayList<NodeBank> NodeList;
    public static ArrayList<EdgeBank> EdgeList;
    public static ArrayList<LegendBank> LegendList;
    public static ArrayList<String> keyNodeArray;
    public static HashMap keyPairwiseHash;
    public static HashMap keyNodeHash;
    public static ArrayList<OutEdgesMap> VirtualOutEdges;
    protected NodeBank nodeAccount;
    protected EdgeBank edgeAccount;
    private static String saveAddress;
    private static String openAddress;
    public static GraphTask drawpanel;
    public static Color backgroundColor;
    private String ioFileType;
    private String loadingOption;
    private static double zoomInOut;
    private static double edgeTarget;
    private static double outEdgeTarget;
    private static double repulsionFactor;
    private static double outRepulsionFactor;
    private static double centralPull;
    private static double stiffness;
    private static double perimeterEffect;
    private static double nodeSpeedLimit;
    private static double repulsionRadius;
    public static double temperature;
    public static double coolingFactor;
    private double bufferByK;
    private double degreeThreshold;
    private static boolean showTree;
    private static boolean overrideEdges;
    private static boolean isSystemOpened;
    private static boolean optimizeRendering;
    private static boolean requesting_zoom_and_flips;
    public static Methods methods;
    public static RedXmlRpc rederServer;
    public static boolean lockMouse;
    public static boolean lockDragAndZoom;
    public static RedPreferences preferences;
    public static File opendir;
    public static File savedir;
    private Rectangle2D lastDragArea;
    private static Rectangle2D areaSelect;
    public static boolean isRelaxActive;
    public static boolean activateRelaxDcall;
    public static boolean updateRelaxPanel;
    public static boolean isPaintActive;
    private static boolean isInProgress;
    private final double INITIAL_TEMP = 1.0;
    private final double FIT_WIN_SCALE = 0.85;
    private static int serverPort;
    private TarefaFilterZoom taskFilterZoom = null;
    private TarefaListenerDcall taskListenerDcall = null;
    private TarefaOpen taskOpen = null;
    private TarefaSave taskSave = null;
    private TarefaLayout taskLayout = null;
    private TarefaRelax taskRelax = null;
    private TarefaExport taskExport = null;
    private static Rectangle2D viewArea;
    private static double scale;
    private int graphType;
    private int ncolgrid;
    private float gapxgrid;
    private float gapygrid;
    private double contMeanR;
    private double treeMaxSz;
    private float kMax;
    private double kMed;
    private double edgeDensity;
    public static ArrayList<Integer> originalMarcados;
    public static ArrayList<Integer> newMarcados;
    private boolean stop_casting_to_updates = false;
    private NodeBank nodeAccountFound;
    private EdgeBank edgeAccountFound;
    private String objectFound;
    private static boolean movendoNodos;
    boolean shift = false;
    boolean ctrcmd = false;
    boolean alt = false;
    int key1 = -9999;
    private int pressedX;
    private int pressedY;
    private int scrollX;
    private int scrollY;
    public int mouseButtonPressed;
    private int clickedX;
    private int clickedY;
    private JButton EdgeLineDashed;
    private JButton EdgeLineDashedLong;
    private JButton EdgeLineDotted;
    private JButton EdgeLineSolid;
    private JButton NodeLineDashed;
    private JButton NodeLineDashedLong;
    private JButton NodeLineDotted;
    private JButton NodeLineSolid;
    private ButtonGroup buttonGroupFind;
    private JButton jButton1;
    private JButton jButtonAddGuide;
    private JButton jButtonAddNodesCancel;
    private JButton jButtonAddNodesOK;
    private JButton jButtonAddSpot;
    private JButton jButtonAliasesExit;
    private JButton jButtonAliasesUpdate;
    private JButton jButtonArrow0;
    private JButton jButtonArrow1;
    private JButton jButtonArrow2;
    private JButton jButtonArrow3;
    private JButton jButtonArrow4;
    private JButton jButtonArrow5;
    private JButton jButtonArrow6;
    private JButton jButtonArrow7;
    private JButton jButtonArrow8;
    private JButton jButtonCancelSpotEffect;
    private JButton jButtonCircularLayout;
    private JButton jButtonCollapseRigthTabs;
    private JButton jButtonContractJFrame;
    private JButton jButtonDiamond;
    private JButton jButtonEdgeLineColorPicker;
    private JButton jButtonEllipse;
    private JButton jButtonExitFindNode;
    private JButton jButtonExitGrid;
    private JButton jButtonExitRotate;
    private JButton jButtonExpandJFrame;
    private JButton jButtonExpandRigthTabs;
    private JButton jButtonExportImageCancel;
    private JButton jButtonExportImageOK;
    private JButton jButtonFindNode;
    private JButton jButtonFitNodeToLabel;
    private JButton jButtonFlatSurface;
    private JButton jButtonFlipHor;
    private JButton jButtonFlipVer;
    private JButton jButtonFontColorPicker;
    private JButton jButtonGradientSurface;
    private JButton jButtonGridLayout;
    private JButton jButtonHideLabels;
    private JButton jButtonIconFind;
    private JButton jButtonIconFit;
    private JButton jButtonIconOpen;
    private JButton jButtonIconPDF;
    private JButton jButtonIconRotateLeft;
    private JButton jButtonIconRotateRigth;
    private JButton jButtonIconSave;
    private JButton jButtonIconSelectAll;
    private JButton jButtonIconZoomIn;
    private JButton jButtonIconZoomOut;
    private JButton jButtonIconZoomReset;
    private JButton jButtonLabelBottom;
    private JButton jButtonLabelCenter;
    private JButton jButtonLabelLeft;
    private JButton jButtonLabelMiddle;
    private JButton jButtonLabelRight;
    private JButton jButtonLabelTop;
    private JButton jButtonNodeFillColorPicker;
    private JButton jButtonNodeLineColorPicker;
    private JButton jButtonRandomLayout;
    private JButton jButtonRectangle;
    private JButton jButtonResetRelax;
    private JButton jButtonRoundedRec;
    private JButton jButtonShowLabels;
    private JButton jButtonStartRelax;
    private JButton jButtonStopRelax;
    private JButton jButtonTriangle;
    private JButton jButtonUpdateGrid;
    private JButton jButtonUpdateRotate;
    private JButton jButtonUpdateSpotEffect;
    private JCheckBox jCheckBoxCoolingN;
    private JCheckBox jCheckBoxDefaultNestingOption;
    private JCheckBoxMenuItem jCheckBoxMenuItemShowTree;
    private JCheckBox jCheckBoxOptimizeRendering;
    private JCheckBox jCheckBoxOverrideEdges;
    private JCheckBox jCheckBoxPartitionEffect;
    private JCheckBox jCheckBoxScaleArrowAngle;
    private JCheckBox jCheckBoxScaleArrowLen;
    private JCheckBox jCheckBoxScaleEdgeWeight;
    private JCheckBox jCheckBoxScaleEdgeWidth;
    private JCheckBox jCheckBoxScaleNodeLines;
    private JCheckBox jCheckBoxScaleNodes;
    private JCheckBoxMenuItem jCheckBoxToolbarsEdit;
    private JCheckBoxMenuItem jCheckBoxToolbarsFile;
    private JCheckBoxMenuItem jCheckBoxToolbarsLayout;
    private JCheckBoxMenuItem jCheckBoxToolbarsSelect;
    private JColorChooser jColorChooser;
    private JComboBox<String> jComboBoxFontStyle;
    private JComboBox<String> jComboBoxFontType;
    private JDialog jDialogAbout;
    private JDialog jDialogAddNodeEdge;
    private JDialog jDialogExportImage;
    private JDialog jDialogModelFindNodeLabel;
    private JDialog jDialogModelGrid;
    private JDialog jDialogModelRotate;
    private JDialog jDialogNodeID;
    private JDialog jDialogProgress;
    private JDialog jDialogSpotEffect;
    private JFormattedTextField jFormattedTextFieldHexaEdgeLine;
    private JFormattedTextField jFormattedTextFieldHexaFont;
    private JFormattedTextField jFormattedTextFieldHexaNodeFill;
    private JFormattedTextField jFormattedTextFieldHexaNodeLine;
    private JLabel jLabeSeletorRelaxP1;
    private JLabel jLabeSeletorRelaxP2;
    private JLabel jLabeSeletorRelaxP3;
    private JLabel jLabeSeletorRelaxP4;
    private JLabel jLabeSeletorRelaxP5;
    private JLabel jLabeSeletorRelaxP6;
    private JLabel jLabeSeletorRelaxP7;
    private JLabel jLabeSeletorRelaxP8;
    private JLabel jLabeSeletorRelaxP9;
    private JLabel jLabeSeletorRelaxSlider;
    private JLabel jLabeSpotEffect1;
    private JLabel jLabeSpotEffect2;
    private JLabel jLabeSpotEffect3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelLineWith;
    private JLabel jLabelPress;
    private JLabel jLabelSize;
    private JMenu jMenu1;
    private JMenu jMenu10;
    private JMenu jMenu11;
    private JMenu jMenu12;
    private JMenu jMenu13;
    private JMenu jMenu14;
    private JMenu jMenu15;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenu jMenu7;
    private JMenu jMenu8;
    private JMenu jMenu9;
    private JMenuItem jMenuEdgeDelete;
    private JMenuItem jMenuISetSpotEffect;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JMenuItem jMenuItem15;
    private JMenuItem jMenuItem16;
    private JMenuItem jMenuItem17;
    private JMenuItem jMenuItem18;
    private JMenuItem jMenuItem19;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem20;
    private JMenuItem jMenuItem21;
    private JMenuItem jMenuItem22;
    private JMenuItem jMenuItem23;
    private JMenuItem jMenuItem24;
    private JMenuItem jMenuItem26;
    private JMenuItem jMenuItem27;
    private JMenuItem jMenuItem28;
    private JMenuItem jMenuItem29;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem30;
    private JMenuItem jMenuItem31;
    private JMenuItem jMenuItem32;
    private JMenuItem jMenuItem33;
    private JMenuItem jMenuItem34;
    private JMenuItem jMenuItem35;
    private JMenuItem jMenuItem36;
    private JMenuItem jMenuItem37;
    private JMenuItem jMenuItem38;
    private JMenuItem jMenuItem39;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem40;
    private JMenuItem jMenuItem42;
    private JMenuItem jMenuItem43;
    private JMenuItem jMenuItem44;
    private JMenuItem jMenuItem45;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JMenuItem jMenuItemAnchor;
    private JMenuItem jMenuItemAspectF1;
    private JMenuItem jMenuItemAspectF2;
    private JMenuItem jMenuItemBackward;
    private JMenuItem jMenuItemBreakTree;
    private JMenuItem jMenuItemDownGradeTree;
    private JMenuItem jMenuItemDuplicate;
    private JMenuItem jMenuItemForward;
    private JMenuItem jMenuItemHide;
    private JMenuItem jMenuItemMergeNodes;
    private JMenuItem jMenuItemMergeOutEdges;
    private JMenuItem jMenuItemMigrate;
    private JMenuItem jMenuItemMove;
    private JMenuItem jMenuItemNeighbourhood;
    private JMenuItem jMenuItemNestNodes;
    private JMenuItem jMenuItemNodeID;
    private JMenuItem jMenuItemPlainNest;
    private JMenuItem jMenuItemResetZoom;
    private JMenuItem jMenuItemText1;
    private JMenuItem jMenuItemText2;
    private JMenuItem jMenuItemTransform;
    private JMenuItem jMenuItemTransparent;
    private JMenuItem jMenuItemUnanchor;
    private JMenuItem jMenuItemUpdateNestSize;
    private JMenuItem jMenuItemUpdateNestedPosition;
    private JMenu jMenuNestObjects;
    private JMenuItem jMenuNodeDelete;
    private JMenuItem jMenuSpotDelete;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel2;
    private JPanel jPanel27;
    private JPanel jPanel28;
    private JPanel jPanel29;
    private JPanel jPanel3;
    private JPanel jPanel30;
    private JPanel jPanel31;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanelEdgeLineColorView;
    private JPanel jPanelEdges1;
    private JPanel jPanelEdges2;
    private JPanel jPanelEdges3;
    private JPanel jPanelEdges4;
    private JPanel jPanelFontColorView;
    private JPanel jPanelInicial;
    private JPanel jPanelJtabbedEdges;
    private JPanel jPanelJtabbedLabels;
    private JPanel jPanelJtabbedLayout;
    private JPanel jPanelJtabbedNodes;
    private JPanel jPanelLabels1;
    private JPanel jPanelLabels2;
    private JPanel jPanelLabels3;
    private JPanel jPanelLabels4;
    private JPanel jPanelLayout1;
    private JPanel jPanelLayout2;
    private JPanel jPanelLayout3;
    private JPanel jPanelNodeFillColorView;
    private JPanel jPanelNodeLineColorView;
    private JPanel jPanelNodes1;
    private JPanel jPanelNodes2;
    private JPanel jPanelNodes3;
    private JPanel jPanelNodes4;
    private JPanel jPanelNodes5;
    private JPanel jPanelNodes6;
    private JPopupMenu jPopupMenuGeneralText;
    private JPopupMenu jPopupMenuMigrate;
    private JProgressBar jProgressBar;
    private JProgressBar jProgressBarRelax;
    private JRadioButton jRadioButtonPerfectMatch;
    private JRadioButton jRadioButtonRegEx;
    private JScrollPane jScrollMainPane;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPaneEdges;
    private JScrollPane jScrollPaneLabels;
    private JScrollPane jScrollPaneLayout;
    private JScrollPane jScrollPaneNodes;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JSlider jSliderNodeBend;
    private JSlider jSliderSeletorRelax;
    private JSpinner jSpinnerArrowAngle;
    private JSpinner jSpinnerArrowLength;
    private JSpinner jSpinnerEdgeWeight;
    private JSpinner jSpinnerEdgeWidth;
    private JSpinner jSpinnerFontOffsetX;
    private JSpinner jSpinnerFontOffsetY;
    private JSpinner jSpinnerFontSize;
    private JSpinner jSpinnerGapx;
    private JSpinner jSpinnerGapy;
    private JSpinner jSpinnerGrid;
    private JSpinner jSpinnerImageResolution;
    private JSpinner jSpinnerNodeLineWidth;
    private JSpinner jSpinnerNodeSize;
    private JSpinner jSpinnerRotate;
    private JSpinner jSpinnerSeletorRelaxP1;
    private JSpinner jSpinnerSeletorRelaxP2;
    private JSpinner jSpinnerSeletorRelaxP3;
    private JSpinner jSpinnerSeletorRelaxP4;
    private JSpinner jSpinnerSeletorRelaxP5;
    private JSpinner jSpinnerSeletorRelaxP6;
    private JSpinner jSpinnerSeletorRelaxP7;
    private JSpinner jSpinnerSeletorRelaxP8;
    private JSpinner jSpinnerSeletorRelaxP9;
    private JSpinner jSpinnerSeletorRelaxSlider;
    private JSpinner jSpinnerSpotEffect1;
    private JSpinner jSpinnerSpotEffect2;
    private JSpinner jSpinnerSpotEffect3;
    private JSplitPane jSplitPane;
    private JTabbedPane jTabbedPaneAttribs;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextArea jTextAreaSpotEffect;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextFieldAddNodeA;
    private JTextField jTextFieldAddNodeB;
    private JTextField jTextFieldFindNode;
    private JTextField jTextFieldLegend;
    private JTextField jTextFieldLegendREF;
    private JButton jToggleButtonOKabout;
    private JToggleButton jToggleButtonRederLayout;
    private JToolBar jToolBarEdit;
    private JToolBar jToolBarExpandPanel;
    private JToolBar jToolBarFile;
    private JToolBar jToolBarLayout;
    private JToolBar jToolBarMainBar;
    private JToolBar jToolBarMinorBar;
    private JToolBar jToolBarSelect;
    private JMenuBar menuBar;
    private JPopupMenu popEdgeChanges;
    private JPopupMenu popNodeChanges;
    private JPopupMenu popSpotChanges;

    public RederMainFrame() {
        this.initComponents();
        isSystemOpened = false;
        JFileChooser fileChooser = new JFileChooser();
        savedir = opendir = fileChooser.getCurrentDirectory();
        methods = new Methods();
        NodeList = new ArrayList();
        EdgeList = new ArrayList();
        LegendList = new ArrayList();
        keyNodeArray = new ArrayList();
        VirtualOutEdges = new ArrayList();
        keyNodeHash = new HashMap();
        drawpanel = new GraphTask();
        this.jScrollMainPane.setViewportView(drawpanel);
        preferences = new RedPreferences();
        rederServer = null;
        areaSelect = null;
        this.lastDragArea = null;
        lockMouse = false;
        this.closeSystem();
        this.sessionOptions();
        this.setServerPort(9091);
        String[] systemArgs = RedeR.getArguments();
        if (systemArgs.length > 1 && systemArgs[0].equals("openshellDcall")) {
            this.setServerPort(systemArgs[1]);
        }
        this.loadServer();
        this.openSystem();
        this.startListenerDcall();
        this.resetPreferences();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.resetPreferences();
        this.pack();
        this.checkJavaVersion();
    }

    public void checkJavaVersion() {
        float jversion = preferences.getJavaVersion();
        if (jversion < 11.0f) {
            String jv = jversion < 5.0f ? String.valueOf(jversion) : String.valueOf((int)jversion);
            JOptionPane.showMessageDialog(this.jPanelInicial, "The RedeR application requires Java>=11,\nbut this system seems to be running Java " + jv + ";\n...the application may work with reduced\n...functionality on this earlier Java version.", "Note: RedeR requires Java>=11", 1);
        }
    }

    private void resetPreferences() {
        if (preferences.isMainPaneExpanded()) {
            double h = 795.0;
            double w = 1335.0;
            double pfactor = this.getScreenFactor();
            this.setPreferredSize(new Dimension((int)(w *= pfactor), (int)(h *= pfactor)));
            this.resetDetailedPreferredSizes((int)w);
            this.jButtonExpandJFrame.setVisible(false);
            this.jButtonContractJFrame.setVisible(true);
        } else {
            double h = 795.0;
            double w = 1091.0;
            double pfactor = this.getScreenFactor();
            this.setPreferredSize(new Dimension((int)(w *= pfactor), (int)(h *= pfactor)));
            this.resetDetailedPreferredSizes((int)w);
            this.jButtonExpandJFrame.setVisible(true);
            this.jButtonContractJFrame.setVisible(false);
        }
        if (preferences.isRigthTabsExpanded()) {
            this.setVisibleRightSplitPane(true);
        } else {
            this.setVisibleRightSplitPane(false);
        }
        if (preferences.isToolBarFileVisible()) {
            this.jCheckBoxToolbarsFile.setSelected(true);
            this.jToolBarFile.setVisible(true);
        } else {
            this.jCheckBoxToolbarsFile.setSelected(false);
            this.jToolBarFile.setVisible(false);
        }
        if (preferences.isToolBarSelectVisible()) {
            this.jCheckBoxToolbarsSelect.setSelected(true);
            this.jToolBarSelect.setVisible(true);
        } else {
            this.jCheckBoxToolbarsSelect.setSelected(false);
            this.jToolBarSelect.setVisible(false);
        }
        if (preferences.isToolBarEditVisible()) {
            this.jCheckBoxToolbarsEdit.setSelected(true);
            this.jToolBarEdit.setVisible(true);
        } else {
            this.jCheckBoxToolbarsEdit.setSelected(false);
            this.jToolBarEdit.setVisible(false);
        }
        if (preferences.isToolBarLayoutVisible()) {
            this.jCheckBoxToolbarsLayout.setSelected(true);
            this.jToolBarLayout.setVisible(true);
        } else {
            this.jCheckBoxToolbarsLayout.setSelected(false);
            this.jToolBarLayout.setVisible(false);
        }
    }

    private double getScreenFactor() {
        boolean screenCheck;
        double panelHeight = 795.0;
        double panelWidth = 1335.0;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double pfactor = 1.0;
        boolean bl = screenCheck = panelHeight > screenSize.getHeight() * 0.9 || panelWidth > screenSize.getWidth() * 0.9;
        if (screenCheck) {
            double pr = panelWidth / panelHeight;
            double sr = screenSize.getWidth() / screenSize.getHeight();
            pfactor = pr < sr ? screenSize.getHeight() * 0.9 / panelHeight : screenSize.getWidth() * 0.9 / panelWidth;
        }
        return pfactor;
    }

    private void loadIcons() {
        Color bg_menu = RederMainFrame.HexToColor("#f5f5f5");
        this.menuBar.setBackground(bg_menu);
        this.menuBar.setOpaque(true);
        this.jToolBarMainBar.setBackground(bg_menu);
        this.jToolBarMainBar.setOpaque(true);
        Color bg_atts = RederMainFrame.HexToColor("#f5f6f7");
        int iconsz = 24;
        ImageIcon imgIcon = new ImageIcon(this.getClass().getResource("/OPEN.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconOpen.setText(null);
        this.jButtonIconOpen.setBackground(bg_menu);
        this.jButtonIconOpen.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/SAVE.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconSave.setText(null);
        this.jButtonIconSave.setBackground(bg_menu);
        this.jButtonIconSave.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/FILE_PDF.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconPDF.setText(null);
        this.jButtonIconPDF.setBackground(bg_menu);
        this.jButtonIconPDF.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ZOOM_IN.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconZoomIn.setText(null);
        this.jButtonIconZoomIn.setBackground(bg_menu);
        this.jButtonIconZoomIn.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ZOOM_OUT.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconZoomOut.setText(null);
        this.jButtonIconZoomOut.setBackground(bg_menu);
        this.jButtonIconZoomOut.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ZOOM_RESET.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconZoomReset.setText(null);
        this.jButtonIconZoomReset.setBackground(bg_menu);
        this.jButtonIconZoomReset.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/SEARCH_ALT.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconFind.setText(null);
        this.jButtonIconFind.setBackground(bg_menu);
        this.jButtonIconFind.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/SCREENSHOT.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconSelectAll.setText(null);
        this.jButtonIconSelectAll.setBackground(bg_menu);
        this.jButtonIconSelectAll.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/EXPAND_ALT.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconFit.setText(null);
        this.jButtonIconFit.setBackground(bg_menu);
        this.jButtonIconFit.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/MOVE_VERTICAL.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonFlipVer.setText(null);
        this.jButtonFlipVer.setBackground(bg_menu);
        this.jButtonFlipVer.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/MOVE_HORIZONTAL.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonFlipHor.setText(null);
        this.jButtonFlipHor.setBackground(bg_menu);
        this.jButtonFlipHor.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ROTATE_LEFT.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconRotateLeft.setText(null);
        this.jButtonIconRotateLeft.setBackground(bg_menu);
        this.jButtonIconRotateLeft.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ROTATE_RIGHT.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonIconRotateRigth.setText(null);
        this.jButtonIconRotateRigth.setBackground(bg_menu);
        this.jButtonIconRotateRigth.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/NETWORK_CHART.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jToggleButtonRederLayout.setText(null);
        this.jToggleButtonRederLayout.setBackground(bg_menu);
        this.jToggleButtonRederLayout.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/GRID_3X3_GAP.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonGridLayout.setText(null);
        this.jButtonGridLayout.setBackground(bg_menu);
        this.jButtonGridLayout.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/SHAPE_CIRCLE.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonCircularLayout.setText(null);
        this.jButtonCircularLayout.setBackground(bg_menu);
        this.jButtonCircularLayout.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/SHUFFLE.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonRandomLayout.setText(null);
        this.jButtonRandomLayout.setBackground(bg_menu);
        this.jButtonRandomLayout.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/CHEVRONS_LEFT.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonExpandRigthTabs.setText(null);
        this.jButtonExpandRigthTabs.setBackground(bg_menu);
        this.jButtonExpandRigthTabs.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/CHEVRONS_RIGHT.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonCollapseRigthTabs.setText(null);
        this.jButtonCollapseRigthTabs.setBackground(bg_menu);
        this.jButtonCollapseRigthTabs.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/EXPAND.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonExpandJFrame.setText(null);
        this.jButtonExpandJFrame.setBackground(bg_menu);
        this.jButtonExpandJFrame.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/COLLAPSE.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonContractJFrame.setText(null);
        this.jButtonContractJFrame.setBackground(bg_menu);
        this.jButtonContractJFrame.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/CIRCLE.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonEllipse.setText(null);
        this.jButtonEllipse.setBackground(bg_atts);
        this.jButtonEllipse.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/SQUARE.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonRectangle.setText(null);
        this.jButtonRectangle.setBackground(bg_atts);
        this.jButtonRectangle.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/APP.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonRoundedRec.setText(null);
        this.jButtonRoundedRec.setBackground(bg_atts);
        this.jButtonRoundedRec.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/TRIANGLE.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonTriangle.setText(null);
        this.jButtonTriangle.setBackground(bg_atts);
        this.jButtonTriangle.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/DIAMOND.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonDiamond.setText(null);
        this.jButtonDiamond.setBackground(bg_atts);
        this.jButtonDiamond.setIcon(imgIcon);
        this.jButtonFlatSurface.setText(null);
        this.jButtonFlatSurface.setBackground(bg_atts);
        this.jButtonGradientSurface.setText(null);
        this.jButtonGradientSurface.setBackground(bg_atts);
        int w = 48;
        int h = 11;
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/line_solid.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(w, h, 1));
        this.NodeLineSolid.setText(null);
        this.NodeLineSolid.setBackground(bg_atts);
        this.NodeLineSolid.setIcon(imageIcon);
        imageIcon = new ImageIcon(this.getClass().getResource("/line_dotted.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(w, h, 1));
        this.NodeLineDotted.setText(null);
        this.NodeLineDotted.setBackground(bg_atts);
        this.NodeLineDotted.setIcon(imageIcon);
        imageIcon = new ImageIcon(this.getClass().getResource("/line_dashed.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(w, h, 1));
        this.NodeLineDashed.setText(null);
        this.NodeLineDashed.setBackground(bg_atts);
        this.NodeLineDashed.setIcon(imageIcon);
        imageIcon = new ImageIcon(this.getClass().getResource("/line_dashed_long.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(w, h, 1));
        this.NodeLineDashedLong.setText(null);
        this.NodeLineDashedLong.setBackground(bg_atts);
        this.NodeLineDashedLong.setIcon(imageIcon);
        imageIcon = new ImageIcon(this.getClass().getResource("/line_solid.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(w, h, 1));
        this.EdgeLineSolid.setText(null);
        this.EdgeLineSolid.setBackground(bg_atts);
        this.EdgeLineSolid.setIcon(imageIcon);
        imageIcon = new ImageIcon(this.getClass().getResource("/line_dotted.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(w, h, 1));
        this.EdgeLineDotted.setText(null);
        this.EdgeLineDotted.setBackground(bg_atts);
        this.EdgeLineDotted.setIcon(imageIcon);
        imageIcon = new ImageIcon(this.getClass().getResource("/line_dashed.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(w, h, 1));
        this.EdgeLineDashed.setText(null);
        this.EdgeLineDashed.setBackground(bg_atts);
        this.EdgeLineDashed.setIcon(imageIcon);
        imageIcon = new ImageIcon(this.getClass().getResource("/line_dashed_long.png"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(w, h, 1));
        this.EdgeLineDashedLong.setText(null);
        this.EdgeLineDashedLong.setBackground(bg_atts);
        this.EdgeLineDashedLong.setIcon(imageIcon);
        iconsz = 16;
        imgIcon = new ImageIcon(this.getClass().getResource("/ALIGN_TOP.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonLabelTop.setText(null);
        this.jButtonLabelTop.setBackground(bg_atts);
        this.jButtonLabelTop.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ALIGN_BOTTOM.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonLabelBottom.setText(null);
        this.jButtonLabelBottom.setBackground(bg_atts);
        this.jButtonLabelBottom.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ALIGN_CENTER.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonLabelCenter.setText(null);
        this.jButtonLabelCenter.setBackground(bg_atts);
        this.jButtonLabelCenter.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ALIGN_MIDDLE.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonLabelMiddle.setText(null);
        this.jButtonLabelMiddle.setBackground(bg_atts);
        this.jButtonLabelMiddle.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ALIGN_START.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonLabelLeft.setText(null);
        this.jButtonLabelLeft.setBackground(bg_atts);
        this.jButtonLabelLeft.setIcon(imgIcon);
        imgIcon = new ImageIcon(this.getClass().getResource("/ALIGN_END.png"));
        imgIcon = new ImageIcon(imgIcon.getImage().getScaledInstance(iconsz, iconsz, 1));
        this.jButtonLabelRight.setText(null);
        this.jButtonLabelRight.setBackground(bg_atts);
        this.jButtonLabelRight.setIcon(imgIcon);
        this.jButtonArrow0.setBackground(bg_atts);
        this.jButtonArrow1.setBackground(bg_atts);
        this.jButtonArrow2.setBackground(bg_atts);
        this.jButtonArrow3.setBackground(bg_atts);
        this.jButtonArrow4.setBackground(bg_atts);
        this.jButtonArrow5.setBackground(bg_atts);
        this.jButtonArrow6.setBackground(bg_atts);
        this.jButtonArrow7.setBackground(bg_atts);
        this.jButtonArrow8.setBackground(bg_atts);
    }

    public void cancelTasks() {
        if (this.taskOpen != null && !this.taskOpen.isCancelled()) {
            this.taskOpen.cancel(true);
        }
        if (this.taskSave != null && !this.taskSave.isCancelled()) {
            this.taskSave.cancel(true);
        }
        if (this.taskLayout != null && !this.taskLayout.isCancelled()) {
            this.taskLayout.cancel(true);
        }
        if (this.taskRelax != null && !this.taskRelax.isCancelled()) {
            this.stopRelax();
        }
        if (this.taskExport != null && !this.taskExport.isCancelled()) {
            this.taskExport.cancel(true);
        }
    }

    public void setServerPort(int port) {
        serverPort = port;
    }

    public void setServerPort(String port) {
        int p = 9091;
        try {
            p = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        serverPort = p;
    }

    private void startListenerDcall() {
        this.taskListenerDcall = new TarefaListenerDcall();
        this.taskListenerDcall.execute();
    }

    private int loadServer() {
        try {
            if (rederServer == null) {
                rederServer = new RedXmlRpc(serverPort);
                rederServer.startXmlServer();
            }
        }
        catch (IOException | XmlRpcException ex) {
            Logger.getLogger(RederMainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        return serverPort;
    }

    private void reset() {
        this.loadIcons();
        this.cancelTasks();
        lockMouse = false;
        lockDragAndZoom = false;
        isInProgress = false;
        NodeList.clear();
        EdgeList.clear();
        LegendList.clear();
        keyNodeHash.clear();
        keyNodeArray.clear();
        this.nodeAccount = null;
        this.edgeAccount = null;
        zoomInOut = 1.0;
        drawpanel.setZoom((float)zoomInOut);
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(4);
        drawpanel.setLayout(fl);
        drawpanel.revalidate();
        backgroundColor = Color.white;
        drawpanel.setBackground(backgroundColor);
        this.resetRelaxSettings();
        this.resetNodeAttributeSettings();
        this.resetEdgeAttributeSettings();
        this.resetNodeLabelAttributeSettings();
        this.jMenuItemTransform.setEnabled(true);
        this.jMenuItemUpdateNestSize.setEnabled(false);
        this.jMenuItemUpdateNestedPosition.setEnabled(false);
        this.jMenuItemDuplicate.setEnabled(false);
        this.jMenuItemDownGradeTree.setEnabled(false);
        isRelaxActive = false;
        isPaintActive = true;
        activateRelaxDcall = false;
        updateRelaxPanel = false;
        requesting_zoom_and_flips = false;
    }

    private void closeSystem() {
        isSystemOpened = false;
        isInProgress = false;
        this.reset();
        isRelaxActive = false;
        isPaintActive = true;
        activateRelaxDcall = false;
        updateRelaxPanel = false;
        temperature = 1.0;
        this.jPanelInicial.revalidate();
        this.repaint();
    }

    private void resetDetailedPreferredSizes(Integer width) {
        this.jSplitPane.setOneTouchExpandable(false);
        this.jSplitPane.setResizeWeight(1.0);
        this.jSplitPane.setDividerLocation(726);
        this.jSplitPane.setResizeWeight(1.0);
        this.jSplitPane.setDividerSize(5);
        this.jToolBarMinorBar.setLayout(new FlowLayout(2));
        this.menuBar.setPreferredSize(new Dimension(250, 28));
        this.jPanelInicial.setPreferredSize(new Dimension(width, 767));
        this.jSplitPane.setPreferredSize(new Dimension(width, 726));
        this.jToolBarMainBar.setPreferredSize(new Dimension(1091, 40));
        this.jScrollMainPane.setPreferredSize(new Dimension(726, 726));
        this.jTabbedPaneAttribs.setPreferredSize(new Dimension(365, 726));
        this.menuBar.setMinimumSize(new Dimension(150, 28));
        this.jPanelInicial.setMinimumSize(new Dimension(718, 572));
        this.jToolBarMainBar.setMinimumSize(new Dimension(718, 40));
        this.jSplitPane.setMinimumSize(new Dimension(718, 532));
        this.jScrollMainPane.setMinimumSize(new Dimension(353, 532));
        this.jTabbedPaneAttribs.setMinimumSize(new Dimension(365, 532));
        this.menuBar.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPanelInicial.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jToolBarMainBar.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jSplitPane.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jScrollMainPane.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jTabbedPaneAttribs.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    private void setVisibleRightSplitPane(boolean setVisible) {
        if (setVisible) {
            int dl = this.jSplitPane.getWidth() - this.jTabbedPaneAttribs.getPreferredSize().width;
            this.jSplitPane.setDividerLocation(dl);
            this.jSplitPane.setResizeWeight(1.0);
            this.jTabbedPaneAttribs.setVisible(true);
            this.jButtonCollapseRigthTabs.setVisible(true);
            this.jButtonExpandRigthTabs.setVisible(false);
            this.jSplitPane.setDividerSize(5);
            preferences.setRigthTabsVisible(true);
        } else {
            this.jTabbedPaneAttribs.setVisible(false);
            this.jButtonCollapseRigthTabs.setVisible(false);
            this.jButtonExpandRigthTabs.setVisible(true);
            this.jSplitPane.setDividerSize(0);
            preferences.setRigthTabsVisible(false);
        }
        this.jSplitPane.resetToPreferredSizes();
    }

    private void sessionOptions() {
        showTree = false;
        overrideEdges = false;
        optimizeRendering = false;
    }

    private void openSystem() {
        this.reset();
        backgroundColor = new Color(255, 255, 255);
        drawpanel.setBackground(backgroundColor);
        isSystemOpened = true;
        this.legtest();
        this.repaint();
    }

    private void legtest() {
    }

    private void testLegSize(Color col, float interspace, int ftsize, String labx, float labxdist, String position, float dxborder, float dyborder, boolean isVertical, String legtype, float edgelen) {
        ArrayList<Float> sizevec = new ArrayList<Float>();
        ArrayList<String> labvec = new ArrayList<String>();
        ArrayList<Color> colvec = new ArrayList<Color>();
        sizevec.clear();
        labvec.clear();
        colvec.clear();
        for (int i = 0; i < 6; ++i) {
            sizevec.add(Float.valueOf(15.0f + (float)(15 * i)));
            labvec.add("00000");
            float mb = (float)i / 2.0f;
            if (mb > (float)((int)mb)) {
                colvec.add(Color.GRAY);
                continue;
            }
            colvec.add(Color.RED);
        }
        methods.addLegendSize(sizevec, labvec, colvec, interspace, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype, edgelen);
        this.repaint();
    }

    private void testLegColor(float size, float bend, int ftsize, String labx, float labxdist, String position, float dxborder, float dyborder, boolean isVertical, String legtype) {
        ArrayList<Color> colvec = new ArrayList<Color>();
        ArrayList<String> labvec = new ArrayList<String>();
        colvec.clear();
        labvec.clear();
        for (int i = 0; i < 13; ++i) {
            float mb = (float)i / 2.0f;
            if (mb > (float)((int)mb)) {
                colvec.add(Color.GRAY);
            } else {
                colvec.add(Color.RED);
            }
            labvec.add("00000");
        }
        methods.addLegendColor(colvec, labvec, size, bend, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype, 1);
        this.repaint();
    }

    private void testLegShape(float size, float interspace, int ftsize, String labx, float labxdist, String position, float dxborder, float dyborder, boolean isVertical, String legtype) {
        ArrayList<String> shapevec = new ArrayList<String>();
        ArrayList<String> labvec = new ArrayList<String>();
        ArrayList<Color> colvec = new ArrayList<Color>();
        shapevec.clear();
        labvec.clear();
        colvec.clear();
        for (int i = 0; i < 6; ++i) {
            float mb = (float)i / 2.0f;
            if (mb > (float)((int)mb)) {
                colvec.add(Color.GRAY);
            } else {
                colvec.add(Color.RED);
            }
            shapevec.add("SOLID");
            labvec.add("000");
        }
        methods.addLegendShape(shapevec, labvec, colvec, size, interspace, ftsize, labx, labxdist, position, dxborder, dyborder, isVertical, legtype, 1);
        this.repaint();
    }

    public void overrideEdges() {
        overrideEdges = this.jCheckBoxOverrideEdges.isSelected();
        if (isPaintActive) {
            this.repaint();
        }
    }

    public static boolean isToOverrideEdges() {
        return overrideEdges;
    }

    public static boolean isToShowTree() {
        return showTree;
    }

    public static float getCentroX() {
        float centroX = drawpanel.getWidth() / 2;
        return centroX;
    }

    public static float getCentroY() {
        float centroY = drawpanel.getHeight() / 2;
        return centroY;
    }

    public static double getZoom() {
        return zoomInOut;
    }

    public static void setZoom(Double z) {
        zoomInOut = z;
    }

    public static void setRelaxArgs(double att1, double att2, double att3, double att4, double att5, double att6, double att7, double att8, double att9) {
        edgeTarget = att1;
        stiffness = att2;
        repulsionFactor = att3;
        perimeterEffect = att4;
        nodeSpeedLimit = att5;
        repulsionRadius = att6;
        centralPull = att7;
        outEdgeTarget = att8;
        outRepulsionFactor = att9;
    }

    public static Rectangle2D getViewArea() {
        viewArea = RederMainFrame.rectangleArea(drawpanel.getX(), drawpanel.getY(), drawpanel.getWidth(), drawpanel.getHeight());
        return viewArea;
    }

    public static Rectangle getSmallViewArea() {
        Rectangle rt = RederMainFrame.getViewArea().getBounds();
        rt.setBounds(rt.x + 40, rt.y + 40, rt.width - 80, rt.height - 80);
        return rt;
    }

    private static Rectangle2D rectangleArea(float x, float y, float w, float h) {
        Rectangle2D.Double node = new Rectangle2D.Double(x - 40.0f, y - 40.0f, w + 80.0f, h + 80.0f);
        return node;
    }

    public void actionBackgroundColor() {
        Color newColor = JColorChooser.showDialog(this, "Background color", backgroundColor);
        if (newColor != null) {
            backgroundColor = newColor;
            drawpanel.setBackground(backgroundColor);
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public static boolean isSystemOpened() {
        return isSystemOpened;
    }

    public static void updateGraph() {
        if (!isSystemOpened) {
            return;
        }
        if (isInProgress) {
            return;
        }
        for (int i = 0; i < LegendList.size(); ++i) {
            LegendBank legAccount = LegendList.get(i);
            legAccount.realocateMembers();
        }
        if (isPaintActive) {
            drawpanel.repaint();
        }
    }

    public void loadEmptyGraph() throws FileNotFoundException, IOException {
        this.cancelTasks();
        this.openSystem();
    }

    public void loadSample1Graph() throws FileNotFoundException, IOException {
        this.cancelTasks();
        this.openSystem();
        LoadData carregar = new LoadData();
        carregar.inputAndGo("null", "sample1", 0.0f, 0.0f);
        NodeList = carregar.getNodeBank();
        EdgeList = carregar.getEdgeBank();
        keyNodeHash = carregar.getKeyNodeHash();
        keyNodeArray = carregar.getKeyNodeArray();
        this.redoZoomScale();
        this.fitToWindow(0.85);
        methods.updateBanks();
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void loadSample2Xgmml() {
        this.cancelTasks();
        this.openSystem();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        repulsionRadius = 100.0;
        this.updateRelaxSettings();
        this.loadingOption = "newGraph";
        this.ioFileType = "resource";
        openAddress = "/sample2.xgmml";
        this.taskOpen = new TarefaOpen();
        this.taskOpen.execute();
        this.startProgress();
    }

    public void loadSample3Xgmml() {
        this.cancelTasks();
        this.openSystem();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.loadingOption = "newGraph";
        this.ioFileType = "resource";
        openAddress = "/sample3.xgmml";
        this.taskOpen = new TarefaOpen();
        this.taskOpen.execute();
        this.startProgress();
    }

    public void openDefault() {
        this.loadingOption = "newGraph";
        this.jDialogProgress.setTitle("Open");
        this.jLabelPress.setText("Loading network...");
        this.ioFileType = "default";
        this.openFile();
    }

    public void openNodesAndEdges() {
        this.loadingOption = "newGraph";
        this.jDialogProgress.setTitle("Open");
        this.jLabelPress.setText("Loading network...");
        this.ioFileType = "nodesAndEdges";
        this.openFile();
    }

    public void openEdges() {
        this.loadingOption = "newGraph";
        this.jDialogProgress.setTitle("Import");
        this.jLabelPress.setText("Loading network...");
        this.ioFileType = "edges";
        this.openFile();
    }

    public void openNodes() {
        this.loadingOption = "newGraph";
        this.jDialogProgress.setTitle("Import");
        this.jLabelPress.setText("Loading nodes...");
        this.ioFileType = "nodes";
        this.openFile();
    }

    public void openXgmml() {
        this.loadingOption = "newGraph";
        this.jDialogProgress.setTitle("Import");
        this.jLabelPress.setText("Loading network...");
        this.ioFileType = "xgmml";
        this.openFile();
    }

    public void openSif() {
        this.loadingOption = "newGraph";
        this.jDialogProgress.setTitle("Import");
        this.jLabelPress.setText("Loading network...");
        this.ioFileType = "sif";
        this.openFile();
    }

    private void openFile() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        FileOpen arquivo = new FileOpen();
        arquivo.inputAndGo(this.ioFileType);
        if (arquivo.getBandeira()) {
            if (!isSystemOpened) {
                this.openSystem();
            }
            openAddress = arquivo.getArquivo();
            this.taskOpen = new TarefaOpen();
            this.taskOpen.execute();
            this.startProgress();
        }
    }

    public void saveDefault() {
        int rede = NodeList.size() * 4 + EdgeList.size();
        if (rede > 150000) {
            int b = JOptionPane.showOptionDialog(drawpanel, "This network may be too large to save all layout details!!\nSave only basic layout?", "Large network!", 0, 2, null, null, null);
            this.ioFileType = b == 0 ? "nodesAndEdges" : "default";
            this.jDialogProgress.setTitle("Save");
            this.jLabelPress.setText("Packing and saving network...");
            this.saveFile();
        } else {
            this.ioFileType = "default";
            this.jDialogProgress.setTitle("Save");
            this.jLabelPress.setText("Packing and saving network...");
            this.saveFile();
        }
    }

    public void saveXgmml() {
        int rede = NodeList.size() * 12 + EdgeList.size() * 3;
        if (rede > 150000) {
            int b = JOptionPane.showOptionDialog(drawpanel, "This network may be too large to save all layout details!!\nDo you want to continue?", "Large network!", 0, 2, null, null, null);
            if (b == 0) {
                this.ioFileType = "xgmml";
                this.jDialogProgress.setTitle("Export");
                this.jLabelPress.setText("Saving network...");
                this.saveFile();
            }
        } else {
            this.ioFileType = "xgmml";
            this.jDialogProgress.setTitle("Export");
            this.jLabelPress.setText("Saving network...");
            this.saveFile();
        }
    }

    public void saveSif() {
        this.ioFileType = "sif";
        this.jDialogProgress.setTitle("Export");
        this.jLabelPress.setText("Exporting network...");
        this.saveFile();
    }

    public void saveEdges() {
        this.ioFileType = "uniqueEdges";
        this.jDialogProgress.setTitle("Export");
        this.jLabelPress.setText("Exporting edges...");
        this.saveFile();
    }

    public void saveNodes() {
        this.ioFileType = "uniqueNodes";
        this.jDialogProgress.setTitle("Export");
        this.jLabelPress.setText("Exporting nodes...");
        this.saveFile();
    }

    public void saveNodesAndEdges() {
        this.ioFileType = "nodesAndEdges";
        this.jDialogProgress.setTitle("Export");
        this.jLabelPress.setText("Exporting network...");
        this.saveFile();
    }

    public void saveFile() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        FileSave arquivo = new FileSave();
        arquivo.inputAndGo(this.ioFileType);
        if (arquivo.getBandeira()) {
            saveAddress = arquivo.getArquivo();
            this.taskSave = new TarefaSave();
            this.taskSave.execute();
            this.startProgress();
        }
    }

    public void printImage() {
        PrintImage print = new PrintImage(drawpanel);
        print.actionPerformed();
    }

    public void exportImage(String ioftype) {
        this.ioFileType = ioftype;
        this.jDialogExportImage.setTitle("Export " + ioftype.toUpperCase());
        Dimension tamanhoDialogo = this.jDialogExportImage.getPreferredSize();
        Dimension tamanhoFrame = this.getSize();
        Point loc = this.getLocation();
        this.jDialogExportImage.setLocation((tamanhoFrame.width - tamanhoDialogo.width) / 2 + loc.x, (tamanhoFrame.height - tamanhoDialogo.height) / 2 + loc.y);
        this.jDialogExportImage.pack();
        this.jDialogExportImage.setModal(true);
        this.jDialogExportImage.setVisible(true);
    }

    public void exportPDF() {
        float jversion = preferences.getJavaVersion();
        if (jversion < 11.0f) {
            String jv = jversion < 5.0f ? String.valueOf(jversion) : String.valueOf((int)jversion);
            JOptionPane.showMessageDialog(this.jPanelInicial, "The RedeR application requires Java>=11,\nbut this system seems to be running Java " + jv + ";\n...the PDF printer is not compatible\n...with this earlier Java version.", "This option is not available for Java " + jv, 2);
        } else {
            this.ioFileType = "pdf";
            this.jDialogProgress.setTitle("Export PDF");
            this.jLabelPress.setText("Exporting pdf...");
            this.exportFile();
        }
    }

    public void exportSVG() {
        float jversion = preferences.getJavaVersion();
        if (jversion < 11.0f) {
            String jv = jversion < 5.0f ? String.valueOf(jversion) : String.valueOf((int)jversion);
            JOptionPane.showMessageDialog(this.jPanelInicial, "The RedeR application requires Java>=11,\nbut this system seems to be running Java " + jv + ";\n...the SVG printer is not compatible\n...with this earlier Java version.", "This option is not available for Java " + jv, 2);
        } else {
            this.ioFileType = "svg";
            this.jDialogProgress.setTitle("Export SVG");
            this.jLabelPress.setText("Exporting svg...");
            this.exportFile();
        }
    }

    public void exportFile() {
        this.setSpotsHided(true);
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        FileSave arquivo = new FileSave();
        arquivo.inputAndGo(this.ioFileType);
        if (arquivo.getBandeira()) {
            saveAddress = arquivo.getArquivo();
            this.taskExport = new TarefaExport();
            this.taskExport.execute();
            this.startProgress();
        }
    }

    private void actionLayoutGrid(int nc, float gx, float gy) {
        this.ncolgrid = nc;
        this.gapxgrid = gx;
        this.gapygrid = gy;
        this.graphType = 0;
        this.selectLayout();
    }

    public void actionLayoutCircle() {
        this.graphType = 1;
        this.selectLayout();
    }

    public void actionLayoutRandom() {
        this.graphType = 2;
        this.selectLayout();
    }

    private void selectLayout() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.taskLayout = new TarefaLayout();
        this.taskLayout.execute();
        this.jDialogProgress.setTitle("Layout");
        this.jLabelPress.setText("Running layout...");
        this.startProgress();
    }

    public Point2D[] layoutGrid(ArrayList<Integer> listaMarcados, int gridcols, float interx, float intery) {
        Point2D[] pontos = new Point2D[listaMarcados.size()];
        Float[] data = new Float[listaMarcados.size()];
        for (int i = 0; i < listaMarcados.size(); ++i) {
            this.nodeAccount = NodeList.get(listaMarcados.get(i));
            data[i] = Float.valueOf(this.nodeAccount.getNodeSizeScale());
        }
        Integer[] idx = this.getSortIndex(data, true);
        Float[] xx = new Float[gridcols];
        float refw = 0.0f;
        float newx = 0.0f;
        float refh = 0.0f;
        float newy = 0.0f;
        int j = 0;
        boolean refrow = true;
        for (Integer i : idx) {
            this.nodeAccount = NodeList.get(listaMarcados.get(i));
            float zrs = (float)(zoomInOut * this.nodeAccount.getRelativeSize());
            if (j == 0) {
                newy = newy + refh / 2.0f + this.nodeAccount.getH() * zrs / 2.0f + intery * zrs;
                refh = this.nodeAccount.getH() * zrs;
            }
            if (refrow) {
                newx = newx + refw / 2.0f + this.nodeAccount.getW() * zrs / 2.0f + interx * zrs;
                refw = this.nodeAccount.getW() * zrs;
                xx[j] = Float.valueOf(newx);
            }
            pontos[i.intValue()] = new Point2D.Double(xx[j].floatValue(), newy);
            if (++j != gridcols) continue;
            if (refrow) {
                refrow = false;
            }
            j = 0;
        }
        return pontos;
    }

    private Point2D[] layoutCircle(ArrayList<Integer> listaMarcados, double width, double height, double escala) {
        Point2D[] pontos1 = this.layoutCircle(listaMarcados.size(), width, height, escala);
        Float[] data = new Float[listaMarcados.size()];
        for (int i = 0; i < listaMarcados.size(); ++i) {
            this.nodeAccount = NodeList.get(listaMarcados.get(i));
            data[i] = Float.valueOf(this.nodeAccount.getNumParceiros());
        }
        Integer[] idx = this.getSortIndex(data, true);
        Point2D[] pontos2 = new Point2D[listaMarcados.size()];
        int j = 0;
        for (Integer i : idx) {
            pontos2[i.intValue()] = pontos1[j];
            ++j;
        }
        return pontos2;
    }

    private Point2D[] layoutCircle(int sizeArrayNode, double width, double height, double escala) {
        Point2D[] ponto = new Point2D[sizeArrayNode];
        double xMax = 0.0;
        double yMax = 0.0;
        double xMin = 1.0E8;
        double yMin = 1.0E8;
        double radius = Math.min(width, height) / 2.0 * escala;
        double center_x = 0.0;
        double center_y = 0.0;
        for (int i = 0; i < sizeArrayNode; ++i) {
            double theta = (double)i / (double)sizeArrayNode * 2.0 * Math.PI;
            double x = radius * Math.cos(theta) + center_x;
            double y = radius * Math.sin(theta) + center_y;
            ponto[i] = new Point2D.Double(x, y);
            if (x > xMax) {
                xMax = x;
            }
            if (y > yMax) {
                yMax = y;
            }
            if (x < xMin) {
                xMin = x;
            }
            if (!(y < yMin)) continue;
            yMin = y;
        }
        return ponto;
    }

    private Point2D[] layoutRandom(int sizeArrayNode, double width, double height) {
        Point2D[] ponto = new Point2D[sizeArrayNode];
        for (int i = 0; i < sizeArrayNode; ++i) {
            double x = Math.random() * width;
            double y = Math.random() * height;
            ponto[i] = new Point2D.Double(x, y);
        }
        return ponto;
    }

    public void startProgress() {
        isInProgress = true;
        Dimension tamanhoDialogo = this.jDialogProgress.getPreferredSize();
        Dimension tamanhoFrame = this.getSize();
        Point loc = this.getLocation();
        this.jDialogProgress.setLocation((tamanhoFrame.width - tamanhoDialogo.width) / 2 + loc.x, (tamanhoFrame.height - tamanhoDialogo.height) / 3 + loc.y);
        this.jDialogProgress.pack();
        this.jDialogProgress.setModal(true);
        this.jDialogProgress.setVisible(true);
    }

    public void stopProgress() {
        isInProgress = false;
        this.jDialogProgress.dispose();
    }

    private void assignNetworkPartition() {
        Integer[] data = new Integer[NodeList.size()];
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            data[i] = this.nodeAccount.getParceiros().size();
            this.nodeAccount.resetPartition();
        }
        Integer[] idx = this.getSortIndex(data, true);
        int partition = 1;
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(idx[i]);
            if (this.nodeAccount.getPartition() > 0) continue;
            this.nodeAccount.assignNetworkPartition(partition);
            ++partition;
        }
    }

    public Integer[] getSortIndex(final Integer[] data, boolean isDescending) {
        Integer[] idx = new Integer[data.length];
        for (int i = 0; i < data.length; ++i) {
            idx[i] = i;
        }
        Arrays.sort(idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Float.compare(data[o1].intValue(), data[o2].intValue());
            }
        });
        Integer[] index = new Integer[idx.length];
        if (isDescending) {
            for (int i = 0; i < idx.length; ++i) {
                index[i] = idx[idx.length - 1 - i];
            }
        } else {
            index = idx;
        }
        return index;
    }

    public Integer[] getSortIndex(ArrayList<Integer> data, boolean isDescending) {
        Integer[] idx = new Integer[data.size()];
        for (int k = 0; k < data.size(); ++k) {
            idx[k] = data.get(k);
        }
        idx = this.getSortIndex(idx, isDescending);
        return idx;
    }

    public Integer[] getRank(Integer[] data, boolean isAscending) {
        Integer[] idx = this.getSortIndex(data, isAscending);
        Integer[] rank = new Integer[idx.length];
        block0: for (int i = 0; i < idx.length; ++i) {
            for (int j = 0; j < idx.length; ++j) {
                if (i != idx[j]) continue;
                rank[i] = j;
                continue block0;
            }
        }
        return rank;
    }

    public Integer[] getSortIndex(final Float[] data, boolean isDescending) {
        Integer[] idx = new Integer[data.length];
        for (int i = 0; i < data.length; ++i) {
            idx[i] = i;
        }
        Arrays.sort(idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Float.compare(data[o1].floatValue(), data[o2].floatValue());
            }
        });
        Integer[] index = new Integer[idx.length];
        if (isDescending) {
            for (int i = 0; i < idx.length; ++i) {
                index[i] = idx[idx.length - 1 - i];
            }
        } else {
            index = idx;
        }
        return index;
    }

    public Integer[] getRank(Float[] data, boolean isAscending) {
        Integer[] idx = this.getSortIndex(data, isAscending);
        Integer[] rank = new Integer[idx.length];
        block0: for (int i = 0; i < idx.length; ++i) {
            for (int j = 0; j < idx.length; ++j) {
                if (i != idx[j]) continue;
                rank[i] = j;
                continue block0;
            }
        }
        return rank;
    }

    public void updateRelaxPanel() {
        this.jLabeSeletorRelaxP1.setText(" p1: edge target length (>=1)");
        this.jSpinnerSeletorRelaxP1.setModel(new SpinnerNumberModel((Number)edgeTarget, Double.valueOf(1.0), null, (Number)1.0));
        this.jLabeSeletorRelaxP2.setText(" p2: edge stiffness (>=0)");
        this.jSpinnerSeletorRelaxP2.setModel(new SpinnerNumberModel((Number)stiffness, Double.valueOf(0.0), null, (Number)1.0));
        this.jLabeSeletorRelaxP3.setText(" p3: repulsion factor (>=0)");
        this.jSpinnerSeletorRelaxP3.setModel(new SpinnerNumberModel((Number)repulsionFactor, Double.valueOf(0.0), null, (Number)1.0));
        this.jLabeSeletorRelaxP4.setText(" p4: perimeter effect (>=0)");
        this.jSpinnerSeletorRelaxP4.setModel(new SpinnerNumberModel((Number)perimeterEffect, Double.valueOf(0.0), null, (Number)1.0));
        this.jLabeSeletorRelaxP5.setText(" p5: speed limit (>=0)");
        this.jSpinnerSeletorRelaxP5.setModel(new SpinnerNumberModel((Number)nodeSpeedLimit, Double.valueOf(0.0), null, (Number)1.0));
        this.jLabeSeletorRelaxP6.setText(" p6: repulsion radius (>=0)");
        this.jSpinnerSeletorRelaxP6.setModel(new SpinnerNumberModel((Number)repulsionRadius, Double.valueOf(0.0), null, (Number)1.0));
        this.jLabeSeletorRelaxP7.setText(" p7: central pull (>=0)");
        this.jSpinnerSeletorRelaxP7.setModel(new SpinnerNumberModel((Number)centralPull, Double.valueOf(0.0), null, (Number)1.0));
        this.jLabeSeletorRelaxP8.setText(" p8: edge target length (>=1)");
        this.jSpinnerSeletorRelaxP8.setModel(new SpinnerNumberModel((Number)outEdgeTarget, Double.valueOf(1.0), null, (Number)1.0));
        this.jLabeSeletorRelaxP9.setText(" p9: repulsion factor (>=0)");
        this.jSpinnerSeletorRelaxP9.setModel(new SpinnerNumberModel((Number)outRepulsionFactor, Double.valueOf(0.0), null, (Number)1.0));
        this.jLabeSeletorRelaxSlider.setText(" Degree:");
        this.jSpinnerSeletorRelaxSlider.setModel(new SpinnerNumberModel((Number)this.degreeThreshold, Double.valueOf(0.0), null, (Number)1.0));
        this.jSliderSeletorRelax.setValue((int)this.bufferByK);
    }

    private void updateRelaxSettings() {
        edgeTarget = (Double)this.jSpinnerSeletorRelaxP1.getValue();
        stiffness = (Double)this.jSpinnerSeletorRelaxP2.getValue();
        repulsionFactor = (Double)this.jSpinnerSeletorRelaxP3.getValue();
        perimeterEffect = (Double)this.jSpinnerSeletorRelaxP4.getValue();
        nodeSpeedLimit = (Double)this.jSpinnerSeletorRelaxP5.getValue();
        repulsionRadius = (Double)this.jSpinnerSeletorRelaxP6.getValue();
        centralPull = (Double)this.jSpinnerSeletorRelaxP7.getValue();
        outEdgeTarget = (Double)this.jSpinnerSeletorRelaxP8.getValue();
        outRepulsionFactor = (Double)this.jSpinnerSeletorRelaxP9.getValue();
        this.degreeThreshold = (Double)this.jSpinnerSeletorRelaxSlider.getValue();
        this.bufferByK = Integer.valueOf(this.jSliderSeletorRelax.getValue()).intValue();
        this.resetCooling();
    }

    private void resetRelaxSettings() {
        this.resetCooling();
        repulsionRadius = 10.0;
        edgeTarget = 100.0;
        outEdgeTarget = 100.0;
        repulsionFactor = 100.0;
        outRepulsionFactor = 10.0;
        stiffness = 100.0;
        nodeSpeedLimit = 100.0;
        perimeterEffect = 100.0;
        this.degreeThreshold = 1.0;
        centralPull = 10.0;
        this.bufferByK = 0.0;
        coolingFactor = 1.0;
        this.updateRelaxPanel();
        this.jCheckBoxCoolingN.setSelected(true);
        this.jCheckBoxPartitionEffect.setSelected(false);
        this.jCheckBoxOverrideEdges.setSelected(false);
        overrideEdges = false;
        this.jCheckBoxOptimizeRendering.setSelected(false);
        this.updateRelaxRendering();
    }

    public void startRelax() {
        this.contMeanR = 100.0;
        this.treeMaxSz = 1.0;
        temperature = 1.0;
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.resetCooling();
        methods.updateContainerTree();
        if (!NodeList.isEmpty()) {
            this.updateKK();
            if (this.jCheckBoxPartitionEffect.isSelected()) {
                this.assignNetworkPartition();
            }
            this.mapVirtualOutEdge();
            this.taskRelax = new TarefaRelax();
            isRelaxActive = true;
            this.taskRelax.execute();
            UIManager.put("ProgressBar.repaintInterval", 50);
            UIManager.put("ProgressBar.cycleTime", 10000);
            this.jProgressBarRelax.setIndeterminate(true);
            this.jToggleButtonRederLayout.setSelected(true);
        } else {
            this.jToggleButtonRederLayout.setSelected(false);
        }
    }

    public void resetCooling() {
        temperature = 1.0;
    }

    public void stopRelax() {
        isRelaxActive = false;
        activateRelaxDcall = false;
        lockDragAndZoom = false;
        this.jProgressBarRelax.setIndeterminate(false);
        this.jToggleButtonRederLayout.setSelected(false);
        this.updateRelaxRendering();
    }

    public void updateKK() {
        this.kMax = 0.0f;
        this.kMed = 0.0;
        this.contMeanR = 0.0;
        if (!NodeList.isEmpty()) {
            double cr = 0.0;
            int cont = 0;
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                int k = this.nodeAccount.getNumParceiros();
                if ((float)k > this.kMax) {
                    this.kMax = k;
                }
                this.kMed += (double)k;
                if (this.nodeAccount.isContainer()) {
                    cr += (double)((this.nodeAccount.getH() + this.nodeAccount.getW()) / 4.0f);
                    ++cont;
                    double csz = this.nodeAccount.getTreeSize();
                    if (csz > this.treeMaxSz) {
                        this.treeMaxSz = csz;
                    }
                }
                this.nodeAccount.resetVirtualEdgeCount();
            }
            this.kMed /= (double)NodeList.size();
            this.contMeanR = cr / (double)cont;
        }
    }

    public void updateRelaxRendering() {
        optimizeRendering = this.jCheckBoxOptimizeRendering.isSelected();
        RederMainFrame.updateGraph();
    }

    public static boolean isOptimizeRendering() {
        return optimizeRendering;
    }

    private void resetDeltaXY() {
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            this.nodeAccount.setDX(0.0);
            this.nodeAccount.setDY(0.0);
            this.nodeAccount.resetVeloxy();
        }
    }

    private void mapVirtualOutEdge() {
        int i;
        int i2;
        ArrayList<OutEdgesMap> candidatos = new ArrayList<OutEdgesMap>();
        candidatos.clear();
        VirtualOutEdges.clear();
        for (i2 = 0; i2 < EdgeList.size(); ++i2) {
            this.edgeAccount = EdgeList.get(i2);
            if (!this.edgeAccount.getEdgeAssociationType().equals("edgeTree")) {
                this.edgeDensity += 1.0;
                int a = this.edgeAccount.getA();
                int b = this.edgeAccount.getB();
                NodeBank nodeAccountA = NodeList.get(a);
                NodeBank nodeAccountB = NodeList.get(b);
                if (nodeAccountA.isNodeNested() || nodeAccountB.isNodeNested()) {
                    if (!nodeAccountA.getNestedAssignment().equals(nodeAccountB.getNestedAssignment())) {
                        this.edgeAccount.setOutEdge(true);
                        int nn = a;
                        if (nodeAccountA.getNodeLevel() > nodeAccountB.getNodeLevel()) {
                            nn = b;
                            b = a;
                            a = nn;
                        }
                        NodeBank account1 = NodeList.get(a);
                        boolean flag1 = false;
                        while (!flag1) {
                            NodeBank account2 = NodeList.get(b);
                            boolean flag2 = false;
                            while (!flag2) {
                                int r2 = keyNodeArray.indexOf(account2.getNestedAssignment());
                                if (r2 == -1) {
                                    flag2 = true;
                                    continue;
                                }
                                account2 = NodeList.get(r2);
                                candidatos.add(new OutEdgesMap(nn, r2));
                            }
                            int r1 = keyNodeArray.indexOf(account1.getNestedAssignment());
                            if (r1 == -1) {
                                flag1 = true;
                                continue;
                            }
                            account1 = NodeList.get(r1);
                            nn = r1;
                        }
                        continue;
                    }
                    this.edgeAccount.setOutEdge(false);
                    continue;
                }
                this.edgeAccount.setOutEdge(false);
                continue;
            }
            this.edgeAccount.setOutEdge(false);
        }
        for (i2 = 0; i2 < candidatos.size(); ++i2) {
            OutEdgesMap cd = (OutEdgesMap)candidatos.get(i2);
            int a = cd.getA();
            int b = cd.getB();
            boolean flag = false;
            for (OutEdgesMap e : VirtualOutEdges) {
                if ((a != e.getA() || b != e.getB()) && (a != e.getB() || b != e.getA())) continue;
                flag = true;
                e.addOneEdge();
                break;
            }
            if (flag || a == b) continue;
            NodeBank nodeAccountA = NodeList.get(a);
            NodeBank nodeAccountB = NodeList.get(b);
            if (nodeAccountA.getNodeLevel() != nodeAccountB.getNodeLevel()) continue;
            if (nodeAccountA.getNestedAssignment().equals(nodeAccountB.getNestedAssignment())) {
                VirtualOutEdges.add(new OutEdgesMap(a, b));
                nodeAccountA.countVirtualEdge();
                nodeAccountB.countVirtualEdge();
                continue;
            }
            if (!nodeAccountA.isContainer() || !nodeAccountB.isContainer()) continue;
            VirtualOutEdges.add(new OutEdgesMap(a, b));
            nodeAccountA.countVirtualEdge();
            nodeAccountB.countVirtualEdge();
        }
        int maxEdges = 0;
        for (i = 0; i < VirtualOutEdges.size(); ++i) {
            OutEdgesMap outedge = VirtualOutEdges.get(i);
            if (outedge.getNumOutEdges() <= maxEdges) continue;
            maxEdges = outedge.getNumOutEdges();
        }
        maxEdges = Math.max(maxEdges, 1);
        for (i = 0; i < VirtualOutEdges.size(); ++i) {
            OutEdgesMap outedge = VirtualOutEdges.get(i);
            double weight = (double)outedge.getNumOutEdges() / (double)maxEdges;
            outedge.setEdgeWeight(weight);
        }
        this.edgeDensity /= (double)Math.max(NodeList.size(), 1);
    }

    public void relax() {
        int distanciaBorda = 15;
        if (!this.jCheckBoxOverrideEdges.isSelected()) {
            this.springAttract();
        }
        if (VirtualOutEdges.size() > 0) {
            this.springVirtualOutEdgesAttract();
        }
        this.globalNodeRepel();
        this.centralPullEffect();
        this.moveNode(distanciaBorda);
        if (isPaintActive) {
            this.repaint();
        }
        if (this.jCheckBoxCoolingN.isSelected()) {
            temperature -= 0.005 / coolingFactor;
            temperature = Math.max(temperature, 0.0);
        } else if (temperature > 1.0) {
            temperature -= 0.005 / coolingFactor;
            temperature = Math.max(temperature, 0.0);
        }
    }

    protected void springAttract() {
        for (int i = 0; i < EdgeList.size(); ++i) {
            double target;
            boolean anyContainer;
            this.edgeAccount = EdgeList.get(i);
            int a = this.edgeAccount.getA();
            int b = this.edgeAccount.getB();
            NodeBank nodeAccountA = NodeList.get(a);
            NodeBank nodeAccountB = NodeList.get(b);
            boolean bl = anyContainer = nodeAccountA.isContainer() || nodeAccountB.isContainer();
            if (nodeAccountA.isAnchored() && nodeAccountB.isAnchored()) continue;
            double n1x = nodeAccountA.getX();
            double n1y = nodeAccountA.getY();
            double n2x = nodeAccountB.getX();
            double n2y = nodeAccountB.getY();
            double vx = n2x - n1x;
            double vy = n2y - n1y;
            double len = Math.sqrt(vx * vx + vy * vy);
            double rz = (nodeAccountA.getRelativeSize() + nodeAccountB.getRelativeSize()) / 2.0;
            double raioA = (nodeAccountA.getH() + nodeAccountA.getW()) / 4.0f;
            double raioB = (nodeAccountB.getH() + nodeAccountB.getW()) / 4.0f;
            String rootA = nodeAccountA.getNestedAssignment();
            String rootB = nodeAccountB.getNestedAssignment();
            int ra = keyNodeArray.indexOf(rootA);
            int rb = keyNodeArray.indexOf(rootB);
            boolean isNestedA = nodeAccountA.isNodeNested();
            boolean isNestedB = nodeAccountB.isNodeNested();
            if (len > 0.0 && a != rb) {
                target = edgeTarget;
                double stiff = stiffness;
                double diffKA = 1.0;
                double diffKB = 1.0;
                if (isNestedA || isNestedB) {
                    if (rootA.equals(rootB)) {
                        int posB;
                        int posA = nodeAccountA.getNestedPosition();
                        if (posA != (posB = nodeAccountB.getNestedPosition())) {
                            stiff *= 1.1;
                        }
                        target /= 2.0;
                        target += target / Math.sqrt(Math.max(NodeList.get(ra).getNumComponents(), 1));
                        target /= (double)(1 + nodeAccountA.getNodeLevel());
                    } else if (!rootA.equals(rootB)) {
                        boolean b2;
                        stiff = stiff * 0.2 * zoomInOut * rz;
                        if (isNestedA) {
                            boolean b1 = NodeList.get(ra).isAnchored();
                            b2 = true;
                            if (isNestedB) {
                                boolean bl2 = b2 = !rootA.equals(NodeList.get(rb).getNestedAssignment());
                            }
                            if (b1 && b2) {
                                diffKA = 0.0;
                            }
                        }
                        if (isNestedB) {
                            boolean b1 = NodeList.get(rb).isAnchored();
                            b2 = true;
                            if (isNestedA) {
                                boolean bl3 = b2 = !rootB.equals(NodeList.get(ra).getNestedAssignment());
                            }
                            if (b1 && b2) {
                                diffKB = 0.0;
                            }
                        }
                    }
                }
                if (anyContainer && !this.edgeAccount.isDefaultEdgeAssignmet()) {
                    target = outEdgeTarget;
                    if (nodeAccountA.isContainer() && nodeAccountB.isContainer()) {
                        stiff *= 0.3;
                        target += this.contMeanR / 2.0;
                    } else {
                        if (len < target) {
                            stiff *= 10.0;
                        }
                        if (nodeAccountA.isContainer()) {
                            diffKA = diffKA * 0.01 / (double)nodeAccountA.getTreeSize();
                        } else {
                            diffKB = diffKB * 0.01 / (double)nodeAccountB.getTreeSize();
                        }
                    }
                }
                target = target + raioA + raioB;
                double ew = this.edgeAccount.getMeanWeight();
                target -= Math.min(target * 0.9, ew);
                target = target * zoomInOut * rz;
                double l = (target - len) / len;
                double k = 0.0015 * (stiff += ew * 0.5 * this.edgeDensity);
                double f = k * l;
                double dx = f * vx;
                double dy = f * vy;
                nodeAccountA.setDX(nodeAccountA.getDX() + -dx * diffKA);
                nodeAccountA.setDY(nodeAccountA.getDY() + -dy * diffKA);
                nodeAccountB.setDX(nodeAccountB.getDX() + dx * diffKB);
                nodeAccountB.setDY(nodeAccountB.getDY() + dy * diffKB);
                if (len > target * 2.0) {
                    double sr;
                    double veloxy = len / target;
                    double plusva = 1.0;
                    double plusvb = 1.0;
                    if (isNestedA) {
                        if (nodeAccountA.getNestedPosition() == 1) {
                            plusva = 4.0;
                        } else {
                            sr = Math.sqrt(NodeList.get(ra).getNumComponents());
                            plusva = 0.5 + 0.5 * (plusva / (1.0 + sr));
                            plusva = Math.max(0.5, plusva);
                        }
                    }
                    if (isNestedB) {
                        if (nodeAccountB.getNestedPosition() == 1) {
                            plusvb = 4.0;
                        } else {
                            sr = Math.sqrt(NodeList.get(rb).getNumComponents());
                            plusvb = 0.5 + 0.5 * (plusvb / (1.0 + sr));
                            plusvb = Math.max(0.5, plusvb);
                        }
                    }
                    nodeAccountA.addVeloxy(veloxy * plusva);
                    nodeAccountB.addVeloxy(veloxy * plusvb);
                    continue;
                }
                nodeAccountA.addVeloxy(1.0);
                nodeAccountB.addVeloxy(1.0);
                continue;
            }
            target = (raioA - raioB) * zoomInOut * rz;
            if (!(len > 0.0)) continue;
            double k = repulsionFactor * (double)(1 + NodeList.get(a).getContainerComponents().size());
            if (len < target) {
                NodeList.get(b).setNestedPosition(0);
                NodeList.get(b).setNestedVelox(len / Math.max(target, 1.0));
                k = k * len / target;
            } else {
                NodeList.get(b).setNestedPosition(1);
                NodeList.get(b).setNestedVelox(len / Math.max(target, 1.0));
                k *= len;
            }
            double q1 = 1.0 * zoomInOut * rz;
            double q2 = -1.0 * zoomInOut * rz;
            double f = k * (q1 * q2 / (len * len));
            double dx = f * vx;
            double dy = f * vy;
            if (!NodeList.get(b).isContainer()) {
                NodeList.get(b).setDX(NodeList.get(b).getDX() + dx);
                NodeList.get(b).setDY(NodeList.get(b).getDY() + dy);
                continue;
            }
            if (!(len > target)) continue;
            k = k * len * (double)(1 + NodeList.get(a).getTreeSize());
            f = k * (q1 * q2 / (len * len));
            dx = f * vx;
            dy = f * vy;
            NodeList.get(b).setDX(NodeList.get(b).getDX() + dx);
            NodeList.get(b).setDY(NodeList.get(b).getDY() + dy);
        }
    }

    protected void springVirtualOutEdgesAttract() {
        for (int i = 0; i < VirtualOutEdges.size(); ++i) {
            OutEdgesMap outedge = VirtualOutEdges.get(i);
            int a = outedge.getA();
            int b = outedge.getB();
            NodeBank nodeAccountA = NodeList.get(a);
            NodeBank nodeAccountB = NodeList.get(b);
            double n1x = nodeAccountA.getX();
            double n1y = nodeAccountA.getY();
            double n2x = nodeAccountB.getX();
            double n2y = nodeAccountB.getY();
            double vx = n2x - n1x;
            double vy = n2y - n1y;
            double len = Math.sqrt(vx * vx + vy * vy);
            double raioA = (double)(nodeAccountA.getH() + nodeAccountA.getW()) / 4.0;
            double raioB = (double)(nodeAccountB.getH() + nodeAccountB.getW()) / 4.0;
            double rz = (nodeAccountA.getRelativeSize() + nodeAccountB.getRelativeSize()) / 2.0;
            double k = 0.0015 * (stiffness * (stiffness / 50.0));
            double target = edgeTarget;
            if (nodeAccountA.isContainer() && nodeAccountB.isContainer()) {
                target = outEdgeTarget * 10.0;
                target += this.contMeanR / 2.0;
            }
            double diffKA = 1.0;
            double diffKB = 1.0;
            if (nodeAccountA.isContainer() && !nodeAccountB.isContainer()) {
                diffKA = diffKA * 0.01 / Math.pow(nodeAccountA.getTreeSize(), 2.0);
            } else if (!nodeAccountA.isContainer() && nodeAccountB.isContainer()) {
                diffKB = diffKB * 0.01 / Math.pow(nodeAccountB.getTreeSize(), 2.0);
            }
            target = (target + raioA + raioB) * zoomInOut * rz * (1.0 / (1.0 + outedge.getEdgeWeight()));
            target = Math.max(target, 1.0);
            if (len <= target) continue;
            double f = k * ((target - len) / len);
            double dx = f * vx;
            double dy = f * vy;
            nodeAccountA.setDX(nodeAccountA.getDX() + -dx * diffKA);
            nodeAccountA.setDY(nodeAccountA.getDY() + -dy * diffKA);
            nodeAccountB.setDX(nodeAccountB.getDX() + dx * diffKB);
            nodeAccountB.setDY(nodeAccountB.getDY() + dy * diffKB);
            if (len > target * 2.0) {
                double veloxya = len / target;
                double veloxyb = len / target;
                if (nodeAccountA.getTreeLevels() < nodeAccountB.getTreeLevels()) {
                    veloxya *= (double)nodeAccountB.getTreeLevels();
                } else if (nodeAccountB.getTreeLevels() < nodeAccountA.getTreeLevels()) {
                    veloxyb *= (double)nodeAccountA.getTreeLevels();
                }
                veloxya = 1.0 + veloxya / (1.0 + veloxya);
                veloxyb = 1.0 + veloxyb / (1.0 + veloxyb);
                nodeAccountA.addVeloxy(veloxya);
                nodeAccountB.addVeloxy(veloxyb);
                continue;
            }
            nodeAccountA.addVeloxy(1.0);
            nodeAccountB.addVeloxy(1.0);
        }
    }

    protected void globalNodeRepel() {
        for (int i = 0; i < NodeList.size(); ++i) {
            NodeBank nodeAccount1 = NodeList.get(i);
            for (int j = 0; j < NodeList.size(); ++j) {
                double llen;
                double per;
                boolean c4;
                boolean c2;
                boolean st2;
                NodeBank nodeAccount2 = NodeList.get(j);
                boolean isSpot = nodeAccount1.isSpot() || nodeAccount2.isSpot();
                boolean anyContainer = nodeAccount1.isContainer() || nodeAccount2.isContainer();
                boolean allowAccount1 = true;
                boolean allowAccount2 = true;
                if (nodeAccount1.equals(nodeAccount2) || nodeAccount1.isAnchored() && nodeAccount2.isAnchored() || nodeAccount1.isSpot() && nodeAccount2.isSpot() || nodeAccount2.getNestedAssignment().equals(nodeAccount1.getNodeID()) || !isSpot && !nodeAccount1.getNestedAssignment().equals(nodeAccount2.getNestedAssignment())) continue;
                boolean st1 = nodeAccount1.getNestedPosition() == 1 || nodeAccount2.getNestedPosition() == 1;
                boolean bl = st2 = nodeAccount1.isAnchored() || nodeAccount2.isAnchored();
                if (st1 && !st2) continue;
                double k = repulsionFactor;
                boolean c1 = nodeAccount1.isContainer() && nodeAccount2.isContainer();
                boolean bl2 = c2 = nodeAccount1.getTreeLevels() == nodeAccount2.getTreeLevels();
                if (c1) {
                    k = outRepulsionFactor;
                    double f1 = (double)nodeAccount1.getTreeSize() / this.treeMaxSz;
                    f1 = (double)nodeAccount1.getNodeSizeScale() / Math.max(1.0, f1);
                    double f2 = (double)nodeAccount2.getTreeSize() / this.treeMaxSz;
                    f2 = (double)nodeAccount2.getNodeSizeScale() / Math.max(1.0, f2);
                    k = c2 ? (k *= 1.0 + f1 + f2) : (nodeAccount1.getTreeSize() > nodeAccount2.getTreeSize() ? (k *= 1.0 + f2) : (k *= 1.0 + f1));
                }
                c1 = nodeAccount1.isContainer() && !nodeAccount2.isContainer();
                c2 = !nodeAccount1.getNodeID().equals(nodeAccount2.getNestedAssignment());
                boolean c3 = nodeAccount2.isContainer() && !nodeAccount1.isContainer();
                boolean bl3 = c4 = !nodeAccount2.getNodeID().equals(nodeAccount1.getNestedAssignment());
                if (c1 && c2 || c3 && c4) {
                    k = outRepulsionFactor * 100.0;
                    if (c1 && c2) {
                        allowAccount1 = false;
                        k /= 1.0 + Math.pow(nodeAccount2.getNodeLevel(), 2.0);
                    }
                    if (c3 && c4) {
                        allowAccount2 = false;
                        k /= 1.0 + Math.pow(nodeAccount1.getNodeLevel(), 2.0);
                    }
                }
                double rz = (nodeAccount1.getRelativeSize() + nodeAccount2.getRelativeSize()) / 2.0;
                double vx = nodeAccount1.getX() - nodeAccount2.getX();
                double vy = nodeAccount1.getY() - nodeAccount2.getY();
                if (vx == 0.0) {
                    vx += Math.random() * zoomInOut * rz;
                }
                if (vy == 0.0) {
                    vy += Math.random() * zoomInOut * rz;
                }
                double len = Math.sqrt(vx * vx + vy * vy);
                if (!isSpot && !anyContainer && len > repulsionRadius * edgeTarget * zoomInOut * rz) continue;
                if (!isSpot && perimeterEffect > 0.0) {
                    double raio1 = (nodeAccount1.getH() + nodeAccount1.getW()) / 4.0f;
                    double raio2 = (nodeAccount2.getH() + nodeAccount2.getW()) / 4.0f;
                    double rr_nodes = (raio1 + raio2) * zoomInOut * rz;
                    double pe = perimeterEffect;
                    boolean b2 = !nodeAccount1.getNestedAssignment().equals(nodeAccount2.getNestedAssignment());
                    boolean b3 = nodeAccount1.isPartner(nodeAccount2.getFinalID());
                    if ((anyContainer || b2 || b3) && pe > 100.0) {
                        pe = 100.0;
                    }
                    if ((rr_nodes = rr_nodes * pe / 100.0) > len && !anyContainer) {
                        nodeAccount1.setOverlapStatus(true);
                        nodeAccount2.setOverlapStatus(true);
                        k *= 1.0 + rr_nodes;
                    }
                }
                if (len <= 1.0) {
                    len = Math.max(len, Math.min(nodeSpeedLimit / 100.0, 1.0));
                }
                if (this.jCheckBoxPartitionEffect.isSelected() && !isSpot && nodeAccount1.getPartition() != nodeAccount2.getPartition()) {
                    if (len > edgeTarget * zoomInOut * rz) continue;
                    if (len > edgeTarget / 2.0 * zoomInOut * rz) {
                        k = k * 0.5 * Math.random();
                    }
                }
                if (nodeAccount1.isSpot()) {
                    per = nodeAccount1.getSpotRange() * edgeTarget * zoomInOut * rz;
                    llen = Math.sqrt(vx * vx + vy * vy) / zoomInOut;
                    allowAccount1 = false;
                    if (per > len) {
                        k = nodeAccount1.getSpotDirection() == 1 ? nodeAccount1.getSpotEffect() * llen : -nodeAccount1.getSpotEffect() * llen;
                        k /= 1.0 + Math.pow(nodeAccount2.getNodeLevel(), 2.0);
                    } else {
                        k = 0.0;
                    }
                } else if (nodeAccount2.isSpot()) {
                    per = nodeAccount2.getSpotRange() * edgeTarget * zoomInOut * rz;
                    llen = Math.sqrt(vx * vx + vy * vy) / zoomInOut;
                    allowAccount2 = false;
                    if (per > len) {
                        k = nodeAccount2.getSpotDirection() == 1 ? nodeAccount2.getSpotEffect() * llen : -nodeAccount2.getSpotEffect() * llen;
                        k /= 1.0 + Math.pow(nodeAccount1.getNodeLevel(), 2.0);
                    } else {
                        k = 0.0;
                    }
                }
                double ndegree = Math.min(nodeAccount1.getDegree(), nodeAccount2.getDegree());
                if (ndegree <= this.degreeThreshold) {
                    k = k * 1.0 / (1.0 + this.bufferByK * 0.5);
                }
                double q1 = 1.0 * zoomInOut * rz;
                double q2 = 1.0 * zoomInOut * rz;
                double f = k * (q1 * q2 / (len * len));
                double dx = f * vx;
                double dy = f * vy;
                if (allowAccount1) {
                    nodeAccount1.setDX(nodeAccount1.getDX() + dx);
                    nodeAccount1.setDY(nodeAccount1.getDY() + dy);
                }
                if (!allowAccount2) continue;
                nodeAccount2.setDX(nodeAccount2.getDX() + -dx);
                nodeAccount2.setDY(nodeAccount2.getDY() + -dy);
            }
        }
    }

    protected void centralPullEffect() {
        double xcentro = (double)drawpanel.getWidth() / 2.0;
        double ycentro = (double)drawpanel.getHeight() / 2.0;
        for (int j = 0; j < NodeList.size(); ++j) {
            this.nodeAccount = NodeList.get(j);
            if (this.nodeAccount.getDestaque() || this.nodeAccount.isAnchored() || this.nodeAccount.isDragged() || this.nodeAccount.isNodeNested() || this.nodeAccount.isSpot()) continue;
            double rz = this.nodeAccount.getRelativeSize();
            double vx = (double)this.nodeAccount.getX() - xcentro;
            double vy = (double)this.nodeAccount.getY() - ycentro;
            double len = Math.sqrt(vx * vx + vy * vy);
            len = Math.max(len, 1.0);
            double target = Math.min(xcentro, ycentro) * zoomInOut * rz;
            this.nodeAccount.addVeloxy(len / target);
            double k = centralPull;
            double q1 = 1.0 * zoomInOut * rz;
            double q2 = -1.0 * zoomInOut * rz;
            double f = (k *= Math.pow(Math.PI * (len / target), 2.0)) * (q1 * q2 / (len * len));
            double dx = f * vx;
            double dy = f * vy;
            this.nodeAccount.setDX(this.nodeAccount.getDX() + dx);
            this.nodeAccount.setDY(this.nodeAccount.getDY() + dy);
        }
    }

    protected void moveNode(int distanciaBorda) {
        for (int i = 0; i < NodeList.size(); ++i) {
            int root;
            this.nodeAccount = NodeList.get(i);
            if (this.nodeAccount.getDestaque() || this.nodeAccount.getDestaqueTree() || this.nodeAccount.isAnchored()) {
                this.nodeAccount.setDX(0.0);
                this.nodeAccount.setDY(0.0);
                continue;
            }
            if (this.nodeAccount.isDragged() || this.nodeAccount.isNodeNested() && !NodeList.get(root = keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment())).getDestaque() && !NodeList.get(root).isAnchored()) continue;
            double rz = this.nodeAccount.getRelativeSize();
            if (this.jCheckBoxCoolingN.isSelected()) {
                this.nodeAccount.setDX(this.nodeAccount.getDX() * temperature);
                this.nodeAccount.setDY(this.nodeAccount.getDY() * temperature);
            }
            double dx = this.nodeAccount.getDX();
            double dy = this.nodeAccount.getDY();
            double speedl = nodeSpeedLimit;
            speedl /= Math.max(1.0, this.edgeDensity);
            if (this.nodeAccount.isContainer() && this.nodeAccount.getTreeSize() > 0) {
                speedl /= (double)this.nodeAccount.getTreeLevels();
            }
            speedl = speedl * (zoomInOut * rz) * this.nodeAccount.getVeloxy() * (100.0 / (1.0 + stiffness));
            double dlen = Math.sqrt(dx * dx + dy * dy);
            dlen = Math.max(dlen, 1.0);
            if (this.nodeAccount.isOverlapped()) {
                speedl /= Math.min(dlen, 2.0);
                this.nodeAccount.setOverlapStatus(false);
            }
            if (dlen > speedl) {
                dy = dy * speedl / dlen;
                dx = dx * speedl / dlen;
                dlen = Math.sqrt(dx * dx + dy * dy);
            }
            if (dlen > (double)this.nodeAccount.getW()) {
                dy = dy * (double)this.nodeAccount.getW() / dlen;
                dx = dx * (double)this.nodeAccount.getW() / dlen;
            }
            if (this.nodeAccount.isContainer()) {
                this.nodeAccount.moveTree(this.nodeAccount.getX() + (float)dx, this.nodeAccount.getY() + (float)dy);
            } else {
                this.nodeAccount.setNode(this.nodeAccount.getX() + (float)dx, this.nodeAccount.getY() + (float)dy);
            }
            this.nodeAccount.setDX(this.nodeAccount.getDX() / 2.0);
            this.nodeAccount.setDY(this.nodeAccount.getDY() / 2.0);
            this.nodeAccount.resetVeloxy();
        }
    }

    public void forwardNode() {
        this.changeOrder("forward");
    }

    public void backwardNode() {
        this.changeOrder("backward");
    }

    private void changeOrder(String moveType) {
        int i;
        int i2;
        ArrayList<NodeBank> clone;
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList passingKeysArray = new ArrayList();
        HashMap passingKeyHash = new HashMap();
        passingKeysArray.clear();
        passingKeyHash.clear();
        if (moveType.equals("backward")) {
            if (!this.nodeAccountFound.getDestaque()) {
                clone = new ArrayList(1);
                clone.add(0, this.nodeAccountFound);
                NodeList.remove(this.nodeAccountFound);
                NodeList.add(0, (NodeBank)clone.get(0));
                clone.clear();
            } else {
                clone = new ArrayList<NodeBank>();
                for (i2 = 0; i2 < NodeList.size(); ++i2) {
                    this.nodeAccount = NodeList.get(i2);
                    if (this.nodeAccount.getDestaque() || this.nodeAccount.getContainerTreeMark()) continue;
                    clone.add(this.nodeAccount);
                    NodeList.remove(this.nodeAccount);
                    --i2;
                }
                for (i2 = 0; i2 < clone.size(); ++i2) {
                    NodeList.add((NodeBank)clone.get(i2));
                }
                clone.clear();
            }
        } else if (!this.nodeAccountFound.getDestaque()) {
            clone = new ArrayList(1);
            clone.add(0, this.nodeAccountFound);
            NodeList.remove(this.nodeAccountFound);
            NodeList.add((NodeBank)clone.get(0));
            clone.clear();
        } else {
            clone = new ArrayList();
            for (i2 = 0; i2 < NodeList.size(); ++i2) {
                this.nodeAccount = NodeList.get(i2);
                if (!this.nodeAccount.getDestaque() && !this.nodeAccount.getContainerTreeMark()) continue;
                clone.add(this.nodeAccount);
                NodeList.remove(this.nodeAccount);
                --i2;
            }
            for (i2 = 0; i2 < clone.size(); ++i2) {
                NodeList.add((NodeBank)clone.get(i2));
            }
            clone.clear();
        }
        passingKeysArray = (ArrayList)keyNodeArray.clone();
        passingKeyHash = (HashMap)keyNodeHash.clone();
        keyNodeArray.clear();
        keyNodeHash.clear();
        for (i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            String name = this.nodeAccount.getNodeID();
            keyNodeArray.add(name);
            keyNodeHash.put(name, i);
        }
        for (i = 0; i < EdgeList.size(); ++i) {
            this.edgeAccount = EdgeList.get(i);
            String name = (String)passingKeysArray.get(this.edgeAccount.getA());
            Integer number = (Integer)keyNodeHash.get(name);
            if (number != null) {
                this.edgeAccount.setA(number);
            }
            if ((number = (Integer)keyNodeHash.get(name = (String)passingKeysArray.get(this.edgeAccount.getB()))) == null) continue;
            this.edgeAccount.setB(number);
        }
        passingKeysArray.clear();
        passingKeyHash.clear();
        methods.updateBanks();
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalChangeOrder(String moveType) {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        methods.globalChangeOrder(moveType);
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void transformeNodes() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                return;
            }
            this.nodeAccountFound.setTransformed(true);
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (this.nodeAccount.isContainer() || !this.nodeAccount.getDestaque()) continue;
                this.nodeAccount.setTransformed(true);
            }
        }
        methods.updateNodeTransform(false, false, false, false);
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void nestNodes() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (!this.nodeAccount.getDestaque()) continue;
            listaMarcados.add(i);
        }
        String res = "Done!";
        if (listaMarcados.size() > 0) {
            res = methods.aninhar(listaMarcados, RederMainFrame.HexToColor("E6E6FFFF"), false, false, false, false);
            if (isPaintActive) {
                this.repaint();
            }
        }
        if (!res.equals("Done!") && !res.startsWith("N")) {
            JOptionPane.showMessageDialog(this.jPanelInicial, res, "Error", 1);
        }
    }

    public void duplicateContainer() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.nodeAccountFound == null) {
            return;
        }
        if (!this.nodeAccountFound.isContainer()) {
            return;
        }
        lockMouse = true;
        originalMarcados = new ArrayList();
        newMarcados = new ArrayList();
        originalMarcados.clear();
        newMarcados.clear();
        int refcon = this.nodeAccountFound.duplicateContainer(this.nodeAccountFound.getNestedAssignment(), true);
        if (refcon == -1) {
            lockMouse = false;
            return;
        }
        for (int i = 0; i < EdgeList.size(); ++i) {
            EdgeBank originalAccount = EdgeList.get(i);
            int a = originalAccount.getA();
            int b = originalAccount.getB();
            int testa = originalMarcados.indexOf(a);
            int testb = originalMarcados.indexOf(b);
            if (testa == -1 || testb == -1) continue;
            testa = newMarcados.get(testa);
            testb = newMarcados.get(testb);
            EdgeList.add(new EdgeBank(testa, testb, EdgeList.size()));
            EdgeBank copyAccount = EdgeList.get(EdgeList.size() - 1);
            methods.transferEdgeAttribs(originalAccount, copyAccount);
        }
        methods.updateBanks();
        NodeBank newContainer = NodeList.get(refcon);
        float newX = newContainer.getX() + newContainer.getW() * (float)zoomInOut * (float)newContainer.getRelativeSize();
        newContainer.moveTree(newX, newContainer.getY());
        newContainer.setAnchored(true);
        if (isPaintActive) {
            this.repaint();
        }
        this.deSelectNodes();
        this.deSelectEdges();
        lockMouse = false;
    }

    public void duplicateNetwork() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        methods.duplicateNetwork(true, true);
        this.fitToWindow(0.85);
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void mergeOutEdges() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.nodeAccountFound.isContainer() && !this.nodeAccountFound.getDestaque()) {
            this.deSelectNodes();
            this.deSelectEdges();
            this.nodeAccountFound.setDestaqueTree(true);
            int nest = (Integer)keyNodeHash.get(this.nodeAccountFound.getNodeID());
            ArrayList<Integer> components = this.nodeAccountFound.getContainerComponents();
            for (int i = 0; i < components.size(); ++i) {
                this.nodeAccount = NodeList.get(components.get(i));
                int oneComponent = (Integer)keyNodeHash.get(this.nodeAccount.getNodeID());
                ArrayList<Integer> parceiros = this.nodeAccount.getParceiros();
                for (int j = 0; j < parceiros.size(); ++j) {
                    boolean c2;
                    boolean c1;
                    EdgeBank ref;
                    int k;
                    EdgeBank merge2;
                    EdgeBank merge1;
                    int umParceiro = parceiros.get(j);
                    if (NodeList.get(umParceiro).getDestaqueTree()) continue;
                    boolean deposito = this.nodeAccountFound.addParceiro(umParceiro);
                    if (deposito) {
                        EdgeList.add(new EdgeBank(nest, umParceiro, EdgeList.size()));
                        merge1 = EdgeList.get(EdgeList.size() - 1);
                        merge2 = null;
                        for (k = 0; k < EdgeList.size(); ++k) {
                            ref = EdgeList.get(k);
                            c1 = ref.getA() == oneComponent && ref.getB() == umParceiro;
                            boolean bl = c2 = ref.getB() == oneComponent && ref.getA() == umParceiro;
                            if (!c1 && !c2) continue;
                            merge2 = ref;
                            break;
                        }
                        if (merge2 == null) continue;
                        merge1.setLineWidth(merge2.getWidth());
                        merge1.setWeight(merge2.getWeight());
                        merge1.addUnit(merge2.getUnit() - 1);
                        merge1.setDefaultEdgeAssignment(false);
                        merge2.setDestaque(true);
                        continue;
                    }
                    merge1 = null;
                    merge2 = null;
                    for (k = EdgeList.size() - 1; k >= 0; --k) {
                        ref = EdgeList.get(k);
                        c1 = ref.getA() == nest && ref.getB() == umParceiro;
                        boolean bl = c2 = ref.getB() == nest && ref.getA() == umParceiro;
                        if (c1 || c2) {
                            merge1 = ref;
                            if (merge2 != null) break;
                        }
                        c1 = ref.getA() == oneComponent && ref.getB() == umParceiro;
                        boolean bl2 = c2 = ref.getB() == oneComponent && ref.getA() == umParceiro;
                        if (!c1 && !c2) continue;
                        merge2 = ref;
                        if (merge1 != null) break;
                    }
                    if (merge1 == null || merge2 == null) continue;
                    merge1.setLineWidth(merge1.getWidth() + merge2.getWidth());
                    merge1.setWeight(merge1.getWeight() + merge2.getWeight());
                    merge1.addUnit(merge2.getUnit());
                    merge1.setDefaultEdgeAssignment(false);
                    merge2.setDestaque(true);
                }
            }
            this.globalActionDeleteEdge(true);
            methods.updateBanks();
            if (isPaintActive) {
                this.repaint();
            }
        } else {
            ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
            listaMarcados.clear();
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                listaMarcados.add(i);
            }
            if (listaMarcados.size() > 0) {
                methods.mergeContainerOutEdges(listaMarcados);
                methods.correctOutEdgeWidth(0.75);
                if (isPaintActive) {
                    this.repaint();
                }
            }
        }
    }

    public void globalMergeOutEdges() {
        this.doGlobalMergeOutEdges(false);
    }

    public void globalMergeOutEdgesNorm() {
        this.doGlobalMergeOutEdges(true);
    }

    public void doGlobalMergeOutEdges(boolean isNormalized) {
        int i;
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        for (i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
            listaMarcados.add(i);
        }
        if (listaMarcados.size() > 0) {
            methods.mergeContainerOutEdges(listaMarcados);
            if (isNormalized) {
                methods.correctOutEdgeWidth(0.75);
            }
        } else {
            for (i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.isContainer()) continue;
                listaMarcados.add(i);
            }
            if (listaMarcados.size() > 0) {
                methods.mergeContainerOutEdges(listaMarcados);
                if (isNormalized) {
                    methods.correctOutEdgeWidth(0.75);
                }
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalUpdateNestSize() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Integer[] data = new Integer[NodeList.size()];
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            data[i] = this.nodeAccount.getNodeLevel();
        }
        Integer[] idx = this.getSortIndex(data, true);
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(idx[i]);
            if (!this.nodeAccount.isContainer() || this.nodeAccount.getContainerComponents().size() <= 0) continue;
            this.nodeAccount.updateContainer();
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void updateNestSize() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Integer[] data = new Integer[NodeList.size()];
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            data[i] = this.nodeAccount.getNodeLevel();
        }
        Integer[] idx = this.getSortIndex(data, true);
        if (this.nodeAccountFound.isContainer()) {
            if (this.nodeAccountFound.getDestaque()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    boolean c3;
                    this.nodeAccount = NodeList.get(idx[i]);
                    boolean c1 = this.nodeAccount.isContainer();
                    boolean c2 = this.nodeAccount.getDestaque();
                    boolean bl = c3 = this.nodeAccount.getContainerComponents().size() > 0;
                    if (!c1 || !c2 || !c3) continue;
                    this.nodeAccount.updateContainer();
                }
            } else {
                boolean c;
                boolean bl = c = this.nodeAccountFound.getContainerComponents().size() > 0;
                if (c) {
                    this.nodeAccountFound.updateContainer();
                }
            }
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void updateNestedPositions() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.nodeAccountFound.isContainer()) {
            if (this.nodeAccountFound.getDestaque()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    boolean c3;
                    this.nodeAccount = NodeList.get(i);
                    boolean c1 = this.nodeAccount.isContainer();
                    boolean c2 = this.nodeAccount.getDestaque();
                    boolean bl = c3 = this.nodeAccount.getContainerComponents().size() > 0;
                    if (!c1 || !c2 || !c3) continue;
                    this.nodeAccount.updateContent();
                }
            } else {
                boolean c;
                boolean bl = c = this.nodeAccountFound.getContainerComponents().size() > 0;
                if (c) {
                    this.nodeAccountFound.updateContent();
                }
            }
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void hideContainer() {
        if (this.nodeAccountFound.isContainer()) {
            if (this.nodeAccountFound.getDestaque()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    boolean c2;
                    this.nodeAccount = NodeList.get(i);
                    boolean c1 = !this.nodeAccount.isContainer();
                    boolean bl = c2 = !this.nodeAccount.getDestaque();
                    if (c1 || c2) continue;
                    this.nodeAccount.setContainerHided(true);
                    this.nodeAccount.setAnchored(true);
                    this.nodeAccount.setContainerTransparent(false);
                }
            } else {
                this.nodeAccountFound.setContainerHided(true);
                this.nodeAccountFound.setAnchored(true);
                this.nodeAccountFound.setContainerTransparent(false);
            }
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void transparentContainer() {
        if (this.nodeAccountFound.isContainer()) {
            if (this.nodeAccountFound.getDestaque()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    boolean c2;
                    this.nodeAccount = NodeList.get(i);
                    boolean c1 = !this.nodeAccount.isContainer();
                    boolean bl = c2 = !this.nodeAccount.getDestaque();
                    if (c1 || c2) continue;
                    this.nodeAccount.setContainerTransparent(true);
                    this.nodeAccount.setContainerHided(false);
                    this.nodeAccount.setAnchored(false);
                }
            } else {
                this.nodeAccountFound.setContainerTransparent(true);
                this.nodeAccountFound.setContainerHided(false);
                this.nodeAccountFound.setAnchored(false);
            }
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void plainContainer() {
        if (this.nodeAccountFound.isContainer()) {
            if (this.nodeAccountFound.getDestaque()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    boolean c2;
                    this.nodeAccount = NodeList.get(i);
                    boolean c1 = !this.nodeAccount.isContainer();
                    boolean bl = c2 = !this.nodeAccount.getDestaque();
                    if (c1 || c2) continue;
                    this.nodeAccount.setContainerHided(false);
                    this.nodeAccount.setAnchored(false);
                    this.nodeAccount.setContainerTransparent(false);
                }
            } else {
                this.nodeAccountFound.setContainerHided(false);
                this.nodeAccountFound.setAnchored(false);
                this.nodeAccountFound.setContainerTransparent(false);
            }
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void anchorNodeContainer() {
        if (this.nodeAccountFound.getDestaque()) {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque()) continue;
                this.nodeAccount.setAnchored(true);
            }
        } else {
            this.nodeAccountFound.setAnchored(true);
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void unanchorNodeContainer() {
        if (this.nodeAccountFound.getDestaque()) {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque()) continue;
                this.nodeAccount.setAnchored(false);
            }
        } else {
            this.nodeAccountFound.setAnchored(false);
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void assignTreePermanently() {
        if (methods.isToAssignTree()) {
            JOptionPane.showMessageDialog(this.jPanelInicial, "Tree is already assigned!", "Assign tree", 1);
            return;
        }
        int b = JOptionPane.showOptionDialog(drawpanel, "This option assigns container names to nodes!\nFor example, node 'A1' in nest 'N1' will be renamed to 'A1.$N1'.\nNOTE: this is a permanent change!\nDo you want to continue?", "Assign tree", 0, 2, null, null, null);
        if (b == 0) {
            this.assignTree();
            methods.assignTreePermanently();
        }
    }

    private void assignTree() {
        int i;
        for (i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (!this.nodeAccount.isContainer() || this.nodeAccount.isNodeNested()) continue;
            this.nodeAccount.assignTree();
        }
        keyNodeArray.clear();
        keyNodeHash.clear();
        for (i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            String name = this.nodeAccount.getNodeID();
            keyNodeArray.add(name);
            keyNodeHash.put(name, i);
        }
        methods.updateBanks();
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalUpdateNestedSize() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 0; i < NodeList.size(); ++i) {
            boolean c2;
            this.nodeAccount = NodeList.get(i);
            boolean c1 = this.nodeAccount.isContainer();
            boolean bl = c2 = this.nodeAccount.getContainerComponents().size() > 0;
            if (!(c1 & c2)) continue;
            this.nodeAccount.updateContainer();
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void downGradeTree() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isNodeNested()) {
                this.globalActionNoSelect();
                this.nodeAccountFound.setDestaque(true);
                int numeroRoot = keyNodeArray.indexOf(this.nodeAccountFound.getNestedAssignment());
                for (int j = 0; j < EdgeList.size(); ++j) {
                    this.edgeAccount = EdgeList.get(j);
                    int nA = this.edgeAccount.getA();
                    int nB = this.edgeAccount.getB();
                    if (!NodeList.get(nA).getNodeID().equals(NodeList.get(numeroRoot).getNodeID()) || !NodeList.get(nB).getNodeID().equals(this.nodeAccountFound.getNodeID())) continue;
                    this.edgeAccount.setDestaque(true);
                    break;
                }
                this.globalActionDeleteEdge(false);
                if (isPaintActive) {
                    this.repaint();
                }
            }
        } else {
            this.deSelectEdges();
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                boolean c1 = this.nodeAccount.getDestaque();
                boolean c2 = this.nodeAccount.isNodeNested();
                if (!c1 || !c2) continue;
                int numeroRoot = keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment());
                for (int j = 0; j < EdgeList.size(); ++j) {
                    this.edgeAccount = EdgeList.get(j);
                    int nA = this.edgeAccount.getA();
                    int nB = this.edgeAccount.getB();
                    boolean c3 = !NodeList.get(numeroRoot).getDestaque();
                    boolean c4 = NodeList.get(nA).getNodeID().equals(NodeList.get(numeroRoot).getNodeID());
                    boolean c5 = NodeList.get(nB).getNodeID().equals(this.nodeAccount.getNodeID());
                    if (!c3 || !c4 || !c5) continue;
                    this.edgeAccount.setDestaque(true);
                }
            }
            this.globalActionDeleteEdge(false);
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void breakTree() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.nodeAccountFound.getDestaque()) {
            this.globalActionNoSelect();
            this.nodeAccountFound.setDestaque(true);
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isNodeNested()) continue;
                int numeroRoot = keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment());
                for (int j = 0; j < EdgeList.size(); ++j) {
                    this.edgeAccount = EdgeList.get(j);
                    if (!this.edgeAccount.isAorBContainer()) continue;
                    int nA = this.edgeAccount.getA();
                    int nB = this.edgeAccount.getB();
                    if (!NodeList.get(nA).getNodeID().equals(NodeList.get(numeroRoot).getNodeID()) || !NodeList.get(nB).getNodeID().equals(this.nodeAccount.getNodeID())) continue;
                    this.edgeAccount.setDestaque(true);
                }
                this.nodeAccount.resetNestedAssignment();
            }
            this.globalActionDeleteEdge(false);
            if (isPaintActive) {
                this.repaint();
            }
        } else {
            int i;
            this.deSelectEdges();
            for (i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque()) continue;
                this.nodeAccount.setDestaque(true);
            }
            for (i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isNodeNested()) continue;
                int numeroRoot = keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment());
                for (int j = 0; j < EdgeList.size(); ++j) {
                    this.edgeAccount = EdgeList.get(j);
                    if (!this.edgeAccount.isAorBContainer()) continue;
                    int nA = this.edgeAccount.getA();
                    int nB = this.edgeAccount.getB();
                    if (!NodeList.get(nA).getNodeID().equals(NodeList.get(numeroRoot).getNodeID()) || !NodeList.get(nB).getNodeID().equals(this.nodeAccount.getNodeID())) continue;
                    this.edgeAccount.setDestaque(true);
                }
                this.nodeAccount.resetNestedAssignment();
            }
            this.globalActionDeleteEdge(false);
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void mergeNodes() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        boolean flag = false;
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (!this.nodeAccount.getDestaque()) continue;
            if (!flag && (this.nodeAccount.isNodeNested() || this.nodeAccount.isContainer())) {
                flag = true;
                JOptionPane.showMessageDialog(this.jPanelInicial, "Groups can no be created with nested objects!", "Error", 1);
                continue;
            }
            listaMarcados.add(i);
        }
        if (listaMarcados.size() > 1 && !flag) {
            methods.combinar(listaMarcados, new Color(255, 102, 102));
            if (isPaintActive) {
                this.repaint();
            }
        }
        listaMarcados.clear();
    }

    public void migrateNodes() {
        int nc;
        String parentname = this.nodeAccountFound.getNodeID();
        ArrayList<String> listaMarcados = new ArrayList<String>();
        listaMarcados.clear();
        int totalmove = 0;
        int migrated = 0;
        for (int i = 0; i < NodeList.size(); ++i) {
            int rt;
            this.nodeAccount = NodeList.get(i);
            if (this.nodeAccount.isContainer() || !this.nodeAccount.getDestaque()) continue;
            ++totalmove;
            if (this.nodeAccount.getNestedAssignment().equals(parentname) || this.nodeAccount.isNodeNested() && NodeList.get(rt = this.nodeAccount.getNestedAssignmentIndx()).getDestaque()) continue;
            listaMarcados.add(this.nodeAccount.getNodeID());
        }
        if (listaMarcados.size() > 0 && (nc = methods.reAssigments(parentname, listaMarcados, false)) > 0) {
            migrated = nc;
            this.nodeAccountFound.updateContainer();
            RederMainFrame.updateGraph();
        }
        if (totalmove > 0) {
            String text = " nodes";
            if (listaMarcados.size() == 1) {
                text = " node";
            }
            this.jMenuItemText1.setEnabled(false);
            this.jMenuItemText2.setEnabled(false);
            this.jMenuItemText1.setText("..selected: " + String.valueOf(totalmove) + text);
            text = " nodes";
            if (migrated == 1) {
                text = " node";
            }
            this.jMenuItemText2.setText("..migrated: " + String.valueOf(migrated) + text);
            this.jPopupMenuGeneralText.show(drawpanel, this.scrollX, this.scrollY);
        }
    }

    public void actionDeleteNode() {
        String name;
        int i;
        lockMouse = true;
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<String> nodosRetirados = new ArrayList<String>();
        ArrayList passingKeysArray = new ArrayList();
        HashMap passingKeyHash = new HashMap();
        nodosRetirados.clear();
        passingKeysArray.clear();
        passingKeyHash.clear();
        if (!this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                this.nodeAccountFound.setDestaque(true);
            }
            nodosRetirados.add(this.nodeAccountFound.getNodeID());
            NodeList.remove(this.nodeAccountFound);
            if (this.nodeAccountFound.isContainer()) {
                for (i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque()) continue;
                    nodosRetirados.add(this.nodeAccount.getNodeID());
                    NodeList.remove(this.nodeAccount);
                    --i;
                }
            }
        } else {
            for (i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                this.nodeAccount.setDestaque(true);
            }
            for (i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque()) continue;
                nodosRetirados.add(this.nodeAccount.getNodeID());
                NodeList.remove(this.nodeAccount);
                --i;
            }
        }
        passingKeysArray = (ArrayList)keyNodeArray.clone();
        passingKeyHash = (HashMap)keyNodeHash.clone();
        keyNodeArray.clear();
        keyNodeHash.clear();
        for (i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            name = this.nodeAccount.getNodeID();
            keyNodeArray.add(name);
            keyNodeHash.put(name, i);
        }
        for (i = 0; i < nodosRetirados.size(); ++i) {
            Integer numero = (Integer)passingKeyHash.get(nodosRetirados.get(i));
            for (int j = 0; j < EdgeList.size(); ++j) {
                this.edgeAccount = EdgeList.get(j);
                int a = this.edgeAccount.getA();
                int b = this.edgeAccount.getB();
                if (numero != a && numero != b) continue;
                EdgeList.remove(this.edgeAccount);
                --j;
            }
        }
        for (i = 0; i < EdgeList.size(); ++i) {
            this.edgeAccount = EdgeList.get(i);
            name = (String)passingKeysArray.get(this.edgeAccount.getA());
            Integer number = (Integer)keyNodeHash.get(name);
            if (number != null) {
                this.edgeAccount.setA(number);
            }
            if ((number = (Integer)keyNodeHash.get(name = (String)passingKeysArray.get(this.edgeAccount.getB()))) == null) continue;
            this.edgeAccount.setB(number);
        }
        passingKeysArray.clear();
        passingKeyHash.clear();
        nodosRetirados.clear();
        methods.updateBanks();
        if (isPaintActive) {
            this.repaint();
        }
        lockMouse = false;
        this.nodeAccountFound = null;
    }

    public void globalActionDeleteNode() {
        lockMouse = true;
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        methods.globalActionDeleteNode();
        lockMouse = false;
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void actionDeleteEdge() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.edgeAccountFound.getDestaque()) {
            boolean c3;
            NodeBank nodeAccoutA = NodeList.get(this.edgeAccountFound.getA());
            NodeBank nodeAccoutB = NodeList.get(this.edgeAccountFound.getB());
            boolean c1 = nodeAccoutA.isContainer();
            boolean c2 = nodeAccoutA.isNodeNested();
            boolean bl = c3 = !nodeAccoutA.getNestedAssignment().equals(nodeAccoutB.getNestedAssignment());
            if (c1 && c2 && c3) {
                int number = keyNodeArray.indexOf(nodeAccoutA.getNestedAssignment());
                this.edgeAccountFound.setA(number);
                this.edgeAccount.setEdgeColor(NodeList.get(number).getNodeFillColor());
            } else {
                EdgeList.remove(this.edgeAccountFound);
            }
        } else {
            for (int i = 0; i < EdgeList.size(); ++i) {
                boolean c3;
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getEdgeAssociationType().equals(this.edgeAccountFound.getEdgeAssociationType()) || !this.edgeAccount.getDestaque()) continue;
                NodeBank nodeAccoutA = NodeList.get(this.edgeAccount.getA());
                NodeBank nodeAccoutB = NodeList.get(this.edgeAccount.getB());
                boolean c1 = nodeAccoutA.isContainer();
                boolean c2 = nodeAccoutA.isNodeNested();
                boolean bl = c3 = !nodeAccoutA.getNestedAssignment().equals(nodeAccoutB.getNestedAssignment());
                if (c1 && c2 && c3) {
                    int number = keyNodeArray.indexOf(nodeAccoutA.getNestedAssignment());
                    this.edgeAccount.setA(number);
                    this.edgeAccount.setEdgeColor(NodeList.get(number).getNodeFillColor());
                    continue;
                }
                EdgeList.remove(this.edgeAccount);
                --i;
            }
        }
        methods.updateBanks();
        this.edgeAccountFound = null;
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalActionDeleteEdge(boolean destaqueEdgesOrNodes) {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        methods.deleteSelectedEdges(destaqueEdgesOrNodes);
        if (isPaintActive) {
            this.repaint();
        }
    }

    private void setViewNodePanelAttributes() {
        this.jTextFieldLegendREF.setText(this.nodeAccountFound.getNodeID());
        this.jTextFieldLegend.setText(this.nodeAccountFound.getAliases());
    }

    private void resetViewNodePanelAttributes() {
        this.jTextFieldLegendREF.setText("");
        this.jTextFieldLegend.setText("");
    }

    public void resetNodeAttributeSettings() {
        this.stop_casting_to_updates = true;
        this.jSliderNodeBend.setValue(50);
        this.jSpinnerNodeSize.setValue(Float.valueOf(20.0f));
        this.jSpinnerNodeLineWidth.setValue(Float.valueOf(1.0f));
        this.jCheckBoxScaleNodeLines.setSelected(false);
        this.jCheckBoxScaleNodes.setSelected(false);
        this.jPanelNodeFillColorView.setBackground(RederMainFrame.HexToColor("#FFFFFFFF"));
        this.jFormattedTextFieldHexaNodeFill.setText("FFFFFFFF");
        this.jPanelNodeLineColorView.setBackground(RederMainFrame.HexToColor("#9393ACFF"));
        this.jFormattedTextFieldHexaNodeLine.setText("9393ACFF");
        this.stop_casting_to_updates = false;
        this.enableNodePanel(false);
    }

    public void enableNodePanel(boolean enable) {
        this.jButtonEllipse.setEnabled(enable);
        this.jButtonRectangle.setEnabled(enable);
        this.jButtonRoundedRec.setEnabled(enable);
        this.jButtonTriangle.setEnabled(enable);
        this.jButtonDiamond.setEnabled(enable);
        this.jButtonGradientSurface.setEnabled(enable);
        this.jButtonFlatSurface.setEnabled(enable);
        this.jSliderNodeBend.setEnabled(enable);
        this.NodeLineSolid.setEnabled(enable);
        this.NodeLineDotted.setEnabled(enable);
        this.NodeLineDashed.setEnabled(enable);
        this.NodeLineDashedLong.setEnabled(enable);
        this.jSpinnerNodeSize.setEnabled(enable);
        this.jCheckBoxScaleNodes.setEnabled(enable);
        this.jSpinnerNodeLineWidth.setEnabled(enable);
        this.jCheckBoxScaleNodeLines.setEnabled(enable);
        this.jFormattedTextFieldHexaNodeFill.setEnabled(enable);
        this.jButtonNodeFillColorPicker.setEnabled(enable);
        this.jFormattedTextFieldHexaNodeLine.setEnabled(enable);
        this.jButtonNodeLineColorPicker.setEnabled(enable);
    }

    public void castNodeAttributesToSettings() {
        float nodeBend = 0.0f;
        float nodeSize = 0.0f;
        float nodeLineWith = 0.0f;
        int n_count = 0;
        String hexfill = "FFFFFFFF";
        String hexline = "9393ACFF";
        Color n_fillcolor = RederMainFrame.HexToColor(hexfill);
        Color n_linecolor = RederMainFrame.HexToColor(hexline);
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                    nodeBend += this.nodeAccount.getNodeBend();
                    nodeSize += this.nodeAccount.getNodeSize();
                    nodeLineWith += this.nodeAccount.getNodeLineWidth();
                    ++n_count;
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                    nodeBend += this.nodeAccount.getNodeBend();
                    nodeSize += this.nodeAccount.getNodeSize();
                    nodeLineWith += this.nodeAccount.getNodeLineWidth();
                    ++n_count;
                }
            }
            n_fillcolor = this.nodeAccountFound.getNodeFillColor();
            hexfill = RederMainFrame.ColorToHex(n_fillcolor, true);
            n_linecolor = this.nodeAccountFound.getNodeLineColor();
            hexline = RederMainFrame.ColorToHex(n_linecolor, true);
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                nodeBend += this.nodeAccount.getNodeBend();
                nodeSize += this.nodeAccount.getNodeSize();
                nodeLineWith += this.nodeAccount.getNodeLineWidth();
                ++n_count;
            }
        }
        if (n_count > 0) {
            nodeBend /= (float)n_count;
            nodeSize /= (float)n_count;
            nodeLineWith /= (float)n_count;
            this.enableNodePanel(true);
        } else {
            nodeBend = 50.0f;
            nodeSize = 20.0f;
            nodeLineWith = 1.0f;
            this.enableNodePanel(false);
        }
        this.stop_casting_to_updates = true;
        this.jSliderNodeBend.setValue((int)nodeBend);
        this.jSpinnerNodeSize.setValue(Float.valueOf(nodeSize));
        this.jSpinnerNodeLineWidth.setValue(Float.valueOf(nodeLineWith));
        this.jCheckBoxScaleNodeLines.setSelected(false);
        this.jCheckBoxScaleNodes.setSelected(false);
        this.jPanelNodeFillColorView.setBackground(n_fillcolor);
        this.jFormattedTextFieldHexaNodeFill.setText(hexfill);
        this.jPanelNodeLineColorView.setBackground(n_linecolor);
        this.jFormattedTextFieldHexaNodeLine.setText(hexline);
        this.stop_casting_to_updates = false;
    }

    private void updateNodeAttribs1(Boolean setBend, Boolean setSize, Boolean setLineWith) {
        if (this.stop_casting_to_updates) {
            return;
        }
        float nodeBend = this.jSliderNodeBend.getValue();
        float nodeSize = ((Float)this.jSpinnerNodeSize.getValue()).floatValue();
        float nodeLineWith = ((Float)this.jSpinnerNodeLineWidth.getValue()).floatValue();
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                    if (setBend.booleanValue()) {
                        this.nodeAccount.setNodeBend(nodeBend);
                    }
                    if (setSize.booleanValue()) {
                        if (this.jCheckBoxScaleNodes.isSelected()) {
                            this.nodeAccount.setNodeSizeRescale(nodeSize);
                        } else {
                            this.nodeAccount.setNodeSize(nodeSize);
                        }
                    }
                    if (!setLineWith.booleanValue()) continue;
                    if (this.jCheckBoxScaleNodeLines.isSelected()) {
                        this.nodeAccount.setNodeLineWithScale(nodeLineWith);
                        continue;
                    }
                    this.nodeAccount.setNodeLineWidth(nodeLineWith);
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                    if (setBend.booleanValue()) {
                        this.nodeAccount.setNodeBend(nodeBend);
                    }
                    if (setSize.booleanValue()) {
                        if (this.jCheckBoxScaleNodes.isSelected()) {
                            this.nodeAccount.setNodeSizeRescale(nodeSize);
                        } else {
                            this.nodeAccount.setNodeSize(nodeSize);
                        }
                    }
                    if (!setLineWith.booleanValue()) continue;
                    if (this.jCheckBoxScaleNodeLines.isSelected()) {
                        this.nodeAccount.setNodeLineWithScale(nodeLineWith);
                        continue;
                    }
                    this.nodeAccount.setNodeLineWidth(nodeLineWith);
                }
            }
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                if (setBend.booleanValue()) {
                    this.nodeAccount.setNodeBend(nodeBend);
                }
                if (setSize.booleanValue()) {
                    if (this.jCheckBoxScaleNodes.isSelected()) {
                        this.nodeAccount.setNodeSizeRescale(nodeSize);
                    } else {
                        this.nodeAccount.setNodeSize(nodeSize);
                    }
                }
                if (!setLineWith.booleanValue()) continue;
                if (this.jCheckBoxScaleNodeLines.isSelected()) {
                    this.nodeAccount.setNodeLineWithScale(nodeLineWith);
                    continue;
                }
                this.nodeAccount.setNodeLineWidth(nodeLineWith);
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    private void updateNodeAttribs2(String nodeShape, String nodeLine, Boolean nodeGradient) {
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                    if (nodeShape != null) {
                        this.nodeAccount.setNodeShape(nodeShape);
                    }
                    if (nodeLine != null) {
                        this.nodeAccount.setNodeLineType(nodeLine);
                    }
                    if (nodeGradient == null) continue;
                    this.nodeAccount.setNodeGradient(nodeGradient);
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                    if (nodeShape != null) {
                        this.nodeAccount.setNodeShape(nodeShape);
                    }
                    if (nodeLine != null) {
                        this.nodeAccount.setNodeLineType(nodeLine);
                    }
                    if (nodeGradient == null) continue;
                    this.nodeAccount.setNodeGradient(nodeGradient);
                }
            }
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                if (nodeShape != null) {
                    this.nodeAccount.setNodeShape(nodeShape);
                }
                if (nodeLine != null) {
                    this.nodeAccount.setNodeLineType(nodeLine);
                }
                if (nodeGradient == null) continue;
                this.nodeAccount.setNodeGradient(nodeGradient);
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalActionNodeColor(Color newColor) {
        if (newColor == null) {
            return;
        }
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                    this.nodeAccount.setNodeColor(newColor);
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                    this.nodeAccount.setNodeColor(newColor);
                }
            }
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                this.nodeAccount.setNodeColor(newColor);
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalActionNodeLineColor(Color newColor) {
        if (newColor == null) {
            return;
        }
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                    this.nodeAccount.setNodeLineColor(newColor);
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                    this.nodeAccount.setNodeLineColor(newColor);
                }
            }
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                this.nodeAccount.setNodeLineColor(newColor);
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void resetEdgeAttributeSettings() {
        this.stop_casting_to_updates = true;
        this.jSpinnerEdgeWidth.setValue(Float.valueOf(1.0f));
        this.jSpinnerArrowLength.setValue(Float.valueOf(2.0f));
        this.jSpinnerArrowAngle.setValue(Float.valueOf(45.0f));
        this.jSpinnerEdgeWeight.setValue(0.0);
        this.jCheckBoxScaleEdgeWidth.setSelected(false);
        this.jCheckBoxScaleArrowLen.setSelected(false);
        this.jCheckBoxScaleArrowAngle.setSelected(false);
        this.jCheckBoxScaleEdgeWeight.setSelected(false);
        this.jPanelEdgeLineColorView.setBackground(RederMainFrame.HexToColor("#9393ACFF"));
        this.jFormattedTextFieldHexaEdgeLine.setText("9393ACFF");
        this.jCheckBoxMenuItemShowTree.setSelected(showTree);
        this.stop_casting_to_updates = false;
        this.enableEdgePanel(false);
    }

    public void enableEdgePanel(boolean enable) {
        this.jButtonArrow0.setEnabled(enable);
        this.jButtonArrow1.setEnabled(enable);
        this.jButtonArrow2.setEnabled(enable);
        this.jButtonArrow3.setEnabled(enable);
        this.jButtonArrow4.setEnabled(enable);
        this.jButtonArrow5.setEnabled(enable);
        this.jButtonArrow6.setEnabled(enable);
        this.jButtonArrow7.setEnabled(enable);
        this.jButtonArrow8.setEnabled(enable);
        this.EdgeLineSolid.setEnabled(enable);
        this.EdgeLineDotted.setEnabled(enable);
        this.EdgeLineDashed.setEnabled(enable);
        this.EdgeLineDashedLong.setEnabled(enable);
        this.jSpinnerEdgeWidth.setEnabled(enable);
        this.jCheckBoxScaleEdgeWidth.setEnabled(enable);
        this.jSpinnerEdgeWeight.setEnabled(enable);
        this.jCheckBoxScaleEdgeWeight.setEnabled(enable);
        this.jSpinnerArrowLength.setEnabled(enable);
        this.jCheckBoxScaleEdgeWeight.setEnabled(enable);
        this.jSpinnerArrowLength.setEnabled(enable);
        this.jCheckBoxScaleArrowLen.setEnabled(enable);
        this.jSpinnerArrowAngle.setEnabled(enable);
        this.jCheckBoxScaleArrowAngle.setEnabled(enable);
        this.jFormattedTextFieldHexaEdgeLine.setEnabled(enable);
        this.jButtonEdgeLineColorPicker.setEnabled(enable);
    }

    public void castEdgeAttributesToSettings() {
        float edgeWidth = 0.0f;
        float arrowLength = 0.0f;
        float arrowAngle = 0.0f;
        double edgeWeight = 0.0;
        int e_count = 0;
        String hexcol = "9393ACFF";
        Color ecolor = RederMainFrame.HexToColor(hexcol);
        if (this.edgeAccountFound != null && this.edgeAccountFound.getDestaque()) {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getEdgeAssociationType().equals(this.edgeAccountFound.getEdgeAssociationType()) || !this.edgeAccount.getDestaque()) continue;
                edgeWidth += this.edgeAccount.getWidth();
                arrowLength += this.edgeAccount.getArrowLength();
                arrowAngle += this.edgeAccount.getArrowAngle();
                edgeWeight += this.edgeAccount.getMeanWeight();
                ++e_count;
            }
            ecolor = this.edgeAccountFound.getEdgeColor();
            hexcol = RederMainFrame.ColorToHex(ecolor, true);
        } else {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getDestaque()) continue;
                edgeWidth += this.edgeAccount.getWidth();
                arrowLength += this.edgeAccount.getArrowLength();
                arrowAngle += this.edgeAccount.getArrowAngle();
                edgeWeight += this.edgeAccount.getMeanWeight();
                ++e_count;
            }
        }
        if (e_count > 0) {
            edgeWidth /= (float)e_count;
            arrowLength /= (float)e_count;
            arrowAngle /= (float)e_count;
            edgeWeight /= (double)e_count;
            this.enableEdgePanel(true);
        } else {
            edgeWidth = 1.0f;
            arrowLength = 2.0f;
            arrowAngle = 45.0f;
            edgeWeight = 0.0;
            this.enableEdgePanel(false);
        }
        this.stop_casting_to_updates = true;
        this.jSpinnerEdgeWidth.setValue(Float.valueOf(edgeWidth));
        this.jSpinnerArrowLength.setValue(Float.valueOf(arrowLength));
        this.jSpinnerArrowAngle.setValue(Float.valueOf(arrowAngle));
        this.jSpinnerEdgeWeight.setValue(edgeWeight);
        this.jCheckBoxScaleEdgeWidth.setSelected(false);
        this.jCheckBoxScaleArrowLen.setSelected(false);
        this.jCheckBoxScaleArrowAngle.setSelected(false);
        this.jCheckBoxScaleEdgeWeight.setSelected(false);
        this.jPanelEdgeLineColorView.setBackground(ecolor);
        this.jFormattedTextFieldHexaEdgeLine.setText(hexcol);
        this.stop_casting_to_updates = false;
    }

    public void updateEdgeAttribs1(Boolean setLineWidth, Boolean setArrowLen, Boolean setArrowAngle, Boolean setEdgeWeight) {
        if (this.stop_casting_to_updates) {
            return;
        }
        float linewidth = ((Float)this.jSpinnerEdgeWidth.getValue()).floatValue();
        float arrowlen = ((Float)this.jSpinnerArrowLength.getValue()).floatValue();
        float arrowangle = ((Float)this.jSpinnerArrowAngle.getValue()).floatValue();
        double edgeweight = (Double)this.jSpinnerEdgeWeight.getValue();
        if (this.edgeAccountFound != null && this.edgeAccountFound.getDestaque()) {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getEdgeAssociationType().equals(this.edgeAccountFound.getEdgeAssociationType()) || !this.edgeAccount.getDestaque()) continue;
                if (setLineWidth.booleanValue()) {
                    if (this.jCheckBoxScaleEdgeWidth.isSelected()) {
                        this.edgeAccount.setEdgeWidthScale(linewidth);
                    } else {
                        this.edgeAccount.setLineWidth(linewidth);
                    }
                    arrowlen = this.edgeAccount.getArrowLength();
                    this.jSpinnerArrowLength.setValue(Float.valueOf(arrowlen));
                }
                if (setArrowLen.booleanValue()) {
                    if (this.jCheckBoxScaleArrowLen.isSelected()) {
                        this.edgeAccount.setArrowLengthScale(arrowlen);
                    } else {
                        this.edgeAccount.setArrowLength(arrowlen);
                    }
                }
                if (setArrowAngle.booleanValue()) {
                    if (this.jCheckBoxScaleArrowAngle.isSelected()) {
                        this.edgeAccount.setArrowAngleScale(arrowangle);
                    } else {
                        this.edgeAccount.setArrowAngle(arrowangle);
                    }
                }
                if (!setEdgeWeight.booleanValue()) continue;
                if (this.jCheckBoxScaleEdgeWeight.isSelected()) {
                    this.edgeAccount.setWeightScale(edgeweight);
                    continue;
                }
                this.edgeAccount.setWeight(edgeweight);
            }
        } else {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getDestaque()) continue;
                if (setLineWidth.booleanValue()) {
                    if (this.jCheckBoxScaleEdgeWidth.isSelected()) {
                        this.edgeAccount.setEdgeWidthScale(linewidth);
                    } else {
                        this.edgeAccount.setLineWidth(linewidth);
                    }
                    arrowlen = this.edgeAccount.getArrowLength();
                    this.jSpinnerArrowLength.setValue(Float.valueOf(arrowlen));
                }
                if (setArrowLen.booleanValue()) {
                    if (this.jCheckBoxScaleArrowLen.isSelected()) {
                        this.edgeAccount.setArrowLengthScale(arrowlen);
                    } else {
                        this.edgeAccount.setArrowLength(arrowlen);
                    }
                }
                if (setArrowAngle.booleanValue()) {
                    if (this.jCheckBoxScaleArrowAngle.isSelected()) {
                        this.edgeAccount.setArrowAngleScale(arrowangle);
                    } else {
                        this.edgeAccount.setArrowAngle(arrowangle);
                    }
                }
                if (!setEdgeWeight.booleanValue()) continue;
                if (this.jCheckBoxScaleEdgeWeight.isSelected()) {
                    this.edgeAccount.setWeightScale(edgeweight);
                    continue;
                }
                this.edgeAccount.setWeight(edgeweight);
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void updateEdgeAttribs2(String lineType, Integer arrowType) {
        if (this.edgeAccountFound != null && this.edgeAccountFound.getDestaque()) {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getEdgeAssociationType().equals(this.edgeAccountFound.getEdgeAssociationType()) || !this.edgeAccount.getDestaque()) continue;
                if (lineType != null) {
                    this.edgeAccount.setLineType(lineType);
                }
                if (arrowType == null) continue;
                this.edgeAccount.setArrowDirection(arrowType);
            }
        } else {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getDestaque()) continue;
                if (lineType != null) {
                    this.edgeAccount.setLineType(lineType);
                }
                if (arrowType == null) continue;
                this.edgeAccount.setArrowDirection(arrowType);
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalActionEdgeColor(Color newColor) {
        if (newColor == null) {
            return;
        }
        if (this.edgeAccountFound != null && this.edgeAccountFound.getDestaque()) {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getEdgeAssociationType().equals(this.edgeAccountFound.getEdgeAssociationType()) || !this.edgeAccount.getDestaque()) continue;
                this.edgeAccount.setEdgeColor(newColor);
            }
        } else {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getDestaque()) continue;
                this.edgeAccount.setEdgeColor(newColor);
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void resetNodeLabelAttributeSettings() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String font : ge.getAvailableFontFamilyNames()) {
            this.jComboBoxFontType.addItem(font);
        }
        this.stop_casting_to_updates = true;
        this.jComboBoxFontType.setSelectedItem("SansSerif");
        this.jComboBoxFontStyle.setSelectedItem("Plain");
        this.jPanelFontColorView.setBackground(RederMainFrame.HexToColor("9393ACFF"));
        this.jFormattedTextFieldHexaFont.setText("9393ACFF");
        this.jSpinnerFontSize.setValue(12);
        this.jSpinnerFontOffsetX.setValue(Float.valueOf(0.0f));
        this.jSpinnerFontOffsetY.setValue(Float.valueOf(0.0f));
        this.stop_casting_to_updates = false;
        this.enableLabelPanel(false);
    }

    public void enableLabelPanel(boolean enable) {
        this.jSpinnerFontSize.setEnabled(enable);
        this.jComboBoxFontStyle.setEnabled(enable);
        this.jComboBoxFontType.setEnabled(enable);
        this.jButtonLabelLeft.setEnabled(enable);
        this.jButtonLabelCenter.setEnabled(enable);
        this.jButtonLabelRight.setEnabled(enable);
        this.jButtonLabelTop.setEnabled(enable);
        this.jButtonLabelMiddle.setEnabled(enable);
        this.jButtonLabelBottom.setEnabled(enable);
        this.jSpinnerFontOffsetX.setEnabled(enable);
        this.jSpinnerFontOffsetY.setEnabled(enable);
        this.jButtonFitNodeToLabel.setEnabled(enable);
        this.jButtonHideLabels.setEnabled(enable);
        this.jButtonShowLabels.setEnabled(enable);
        this.jFormattedTextFieldHexaFont.setEnabled(enable);
        this.jButtonFontColorPicker.setEnabled(enable);
    }

    public void castNodeLabelAttributesToSettings() {
        String style;
        int i;
        Integer size = 0;
        String type = "SansSerif";
        int int_style = 4;
        float fontPX = 0.0f;
        float fontPY = 0.0f;
        String hexcol = "9393ACFF";
        Color lcolor = RederMainFrame.HexToColor(hexcol);
        int n_count = 0;
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                    size = size + this.nodeAccount.getFontSize();
                    fontPX += this.nodeAccount.getFontOffsetX();
                    fontPY += this.nodeAccount.getFontOffsetY();
                    ++n_count;
                }
            } else {
                for (i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                    size = size + this.nodeAccount.getFontSize();
                    fontPX += this.nodeAccount.getFontOffsetX();
                    fontPY += this.nodeAccount.getFontOffsetY();
                    ++n_count;
                }
            }
            lcolor = this.nodeAccountFound.getNodeFontColor();
            hexcol = RederMainFrame.ColorToHex(lcolor, true);
            int_style = this.nodeAccountFound.getFont().getStyle();
            type = this.nodeAccountFound.getFont().getName();
        } else {
            for (i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                size = size + this.nodeAccount.getFontSize();
                fontPX += this.nodeAccount.getFontOffsetX();
                fontPY += this.nodeAccount.getFontOffsetY();
                ++n_count;
            }
        }
        switch (int_style) {
            case 1: {
                style = "Bold";
                break;
            }
            case 2: {
                style = "Italic";
                break;
            }
            case 3: {
                style = "Bold.Italic";
                break;
            }
            default: {
                style = "Plain";
            }
        }
        if (n_count > 0) {
            size = size / n_count;
            fontPX /= (float)n_count;
            fontPY /= (float)n_count;
            this.enableLabelPanel(true);
        } else {
            size = 12;
            fontPX = 0.0f;
            fontPY = 11.0f;
            this.enableLabelPanel(false);
        }
        this.stop_casting_to_updates = true;
        this.jComboBoxFontType.setSelectedItem(type);
        this.jComboBoxFontStyle.setSelectedItem(style);
        this.jSpinnerFontSize.setValue(size);
        this.jSpinnerFontOffsetX.setValue(Float.valueOf(fontPX));
        this.jSpinnerFontOffsetY.setValue(Float.valueOf(fontPY));
        this.jFormattedTextFieldHexaFont.setText(hexcol);
        this.jPanelFontColorView.setBackground(lcolor);
        this.stop_casting_to_updates = false;
    }

    private void updateNodeLabelAttribs(boolean setSize, boolean setType, boolean setStyle, boolean offsetX, boolean offsetY, boolean setLeft, boolean setRight, boolean setTop, boolean setBottom, boolean CenterX, boolean CenterY) {
        if (this.stop_casting_to_updates) {
            return;
        }
        Integer size = (Integer)this.jSpinnerFontSize.getValue();
        String type = (String)this.jComboBoxFontType.getSelectedItem();
        String style = (String)this.jComboBoxFontStyle.getSelectedItem();
        float fontPX = ((Float)this.jSpinnerFontOffsetX.getValue()).floatValue();
        float fontPY = ((Float)this.jSpinnerFontOffsetY.getValue()).floatValue();
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                    if (setSize) {
                        this.nodeAccount.setFontSize(size);
                    }
                    if (setType) {
                        this.nodeAccount.setFontName(type);
                    }
                    if (setStyle) {
                        this.nodeAccount.setFontStyle(style);
                    }
                    if (offsetX) {
                        this.nodeAccount.setFontOffsetX(fontPX);
                    }
                    if (offsetY) {
                        this.nodeAccount.setFontOffsetY(fontPY);
                    }
                    if (setLeft) {
                        this.nodeAccount.setFontPositionX("left");
                    }
                    if (setRight) {
                        this.nodeAccount.setFontPositionX("right");
                    }
                    if (setTop) {
                        this.nodeAccount.setFontPositionY("top");
                    }
                    if (setBottom) {
                        this.nodeAccount.setFontPositionY("bottom");
                    }
                    if (CenterX) {
                        this.nodeAccount.setFontPositionX("center");
                    }
                    if (!CenterY) continue;
                    this.nodeAccount.setFontPositionY("center");
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                    if (setSize) {
                        this.nodeAccount.setFontSize(size);
                    }
                    if (setType) {
                        this.nodeAccount.setFontName(type);
                    }
                    if (setStyle) {
                        this.nodeAccount.setFontStyle(style);
                    }
                    if (offsetX) {
                        this.nodeAccount.setFontOffsetX(fontPX);
                    }
                    if (offsetY) {
                        this.nodeAccount.setFontOffsetY(fontPY);
                    }
                    if (setLeft) {
                        this.nodeAccount.setFontPositionX("left");
                    }
                    if (setRight) {
                        this.nodeAccount.setFontPositionX("right");
                    }
                    if (setTop) {
                        this.nodeAccount.setFontPositionY("top");
                    }
                    if (setBottom) {
                        this.nodeAccount.setFontPositionY("bottom");
                    }
                    if (CenterX) {
                        this.nodeAccount.setFontPositionX("center");
                    }
                    if (!CenterY) continue;
                    this.nodeAccount.setFontPositionY("center");
                }
            }
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                if (setSize) {
                    this.nodeAccount.setFontSize(size);
                }
                if (setType) {
                    this.nodeAccount.setFontName(type);
                }
                if (setStyle) {
                    this.nodeAccount.setFontStyle(style);
                }
                if (offsetX) {
                    this.nodeAccount.setFontOffsetX(fontPX);
                }
                if (offsetY) {
                    this.nodeAccount.setFontOffsetY(fontPY);
                }
                if (setLeft) {
                    this.nodeAccount.setFontPositionX("left");
                }
                if (setRight) {
                    this.nodeAccount.setFontPositionX("right");
                }
                if (setTop) {
                    this.nodeAccount.setFontPositionY("top");
                }
                if (setBottom) {
                    this.nodeAccount.setFontPositionY("bottom");
                }
                if (CenterX) {
                    this.nodeAccount.setFontPositionX("center");
                }
                if (!CenterY) continue;
                this.nodeAccount.setFontPositionY("center");
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalActionLabelColor(Color newColor) {
        if (newColor == null) {
            return;
        }
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
                    this.nodeAccount.setFontColor(newColor);
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                    this.nodeAccount.setFontColor(newColor);
                }
            }
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque() || this.nodeAccount.isContainer()) continue;
                this.nodeAccount.setFontColor(newColor);
            }
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void actionNodeLegend() {
        Point loc = this.getLocation();
        this.jDialogNodeID.setLocation(this.clickedX + loc.x, this.clickedY + loc.y);
        this.jDialogNodeID.pack();
        this.jTextFieldLegendREF.setText(this.nodeAccountFound.getNodeID());
        this.jTextFieldLegend.setText(this.nodeAccountFound.getAliases());
        this.jDialogNodeID.setAlwaysOnTop(true);
        this.jDialogNodeID.setModal(false);
        this.jDialogNodeID.pack();
        this.jDialogNodeID.setVisible(true);
    }

    public void globalShowLabels() {
        boolean anySelected = methods.anyNodeSelected();
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (anySelected && !this.nodeAccount.getDestaque()) continue;
            this.nodeAccount.setLegendOn();
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalHideLabels() {
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (!this.nodeAccount.getDestaque()) continue;
            this.nodeAccount.setLegendOff();
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    private void FitNodeToLabel() {
        boolean anySelected = methods.anyNodeSelected();
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (this.nodeAccount.isContainer() || anySelected && !this.nodeAccount.getDestaque()) continue;
            FontMetrics fm = drawpanel.getFontMetrics(this.nodeAccount.getFont());
            float font_h = fm.getHeight();
            float font_w = fm.stringWidth(this.nodeAccount.getAliases());
            float node_h = this.nodeAccount.getH();
            float node_w = this.nodeAccount.getW();
            float expand = 1.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            if (this.nodeAccount.getNodeShape().equals("DIAMOND")) {
                expand = 1.3f;
            } else if (this.nodeAccount.getNodeShape().equals("TRIANGLE")) {
                expand = 1.4f;
            }
            float h = node_h * font_h / node_h * expand + font_h / 2.0f;
            float w = node_w * font_w / node_w * expand + font_h;
            this.nodeAccount.setNodeWH(w, h);
            this.nodeAccount.setFontPositionX("center");
            this.nodeAccount.setFontPositionY("center");
            if (this.nodeAccount.getNodeShape().equals("TRIANGLE")) {
                offsetY = -this.nodeAccount.getH() / 4.0f;
            }
            this.nodeAccount.setFontOffsetX(offsetX);
            this.nodeAccount.setFontOffsetY(offsetY);
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void startDialogs(String dialog) {
        Dimension tamanhoFrame = this.getSize();
        int x_start = 0;
        int y_start = (int)(tamanhoFrame.getHeight() - (double)this.jScrollMainPane.getHeight());
        int dl_slot = 0;
        int x_offset = this.menuBar.getHeight();
        int y_offset = y_start - this.menuBar.getHeight();
        if (dialog.equals("globalActionFindNode") || this.jDialogModelFindNodeLabel.isVisible()) {
            this.globalActionFindNode(dl_slot, x_offset, y_offset, x_start, y_start);
            ++dl_slot;
        }
        if (dialog.equals("rotateNetworkPanel") || this.jDialogModelRotate.isVisible()) {
            this.rotateNetworkPanel(dl_slot, x_offset, y_offset, x_start, y_start);
            ++dl_slot;
        }
        if (dialog.equals("layoutGridPanel") || this.jDialogModelGrid.isVisible()) {
            this.layoutGridPanel(dl_slot, x_offset, y_offset, x_start, y_start);
        }
    }

    public void globalActionFindNode(int dl_slot, int x_offset, int y_offset, int x_start, int y_start) {
        this.nodeAccount = null;
        this.jTextFieldFindNode.setText("");
        this.jDialogModelFindNodeLabel.setTitle("Find");
        int offset_x = x_start + dl_slot * x_offset;
        int offset_y = y_start + dl_slot * y_offset;
        Point loc = this.getLocation();
        this.jDialogModelFindNodeLabel.setLocation(loc.x + offset_x, loc.y + offset_y);
        this.jDialogModelFindNodeLabel.setAlwaysOnTop(true);
        this.jDialogModelFindNodeLabel.pack();
        this.jDialogModelFindNodeLabel.setModal(false);
        this.jDialogModelFindNodeLabel.setVisible(true);
    }

    public void rotateNetworkPanel(int dl_slot, int x_offset, int y_offset, int x_start, int y_start) {
        this.jDialogModelRotate.setTitle("Rotate");
        int offset_x = x_start + dl_slot * x_offset;
        int offset_y = y_start + dl_slot * y_offset;
        Point loc = this.getLocation();
        this.jDialogModelRotate.setLocation(loc.x + offset_x, loc.y + offset_y);
        this.jDialogModelRotate.setAlwaysOnTop(true);
        this.jDialogModelRotate.pack();
        this.jDialogModelRotate.setModal(false);
        this.jDialogModelRotate.setVisible(true);
    }

    public void layoutGridPanel(int dl_slot, int x_offset, int y_offset, int x_start, int y_start) {
        this.jDialogModelGrid.setTitle("Grid layout");
        int offset_x = x_start + dl_slot * x_offset;
        int offset_y = y_start + dl_slot * y_offset;
        Point loc = this.getLocation();
        int ncol = methods.nNodesSelected();
        if (ncol > 0) {
            ncol = (int)Math.round(Math.sqrt(ncol));
        } else {
            ncol = methods.nUnNestedNodes();
            ncol = (int)Math.round(Math.sqrt(ncol));
        }
        this.jSpinnerGrid.setValue(ncol);
        this.jDialogModelGrid.setLocation(loc.x + offset_x, loc.y + offset_y);
        this.jDialogModelGrid.setAlwaysOnTop(true);
        this.jDialogModelGrid.pack();
        this.jDialogModelGrid.setModal(false);
        this.jDialogModelGrid.setVisible(true);
    }

    public void ZoomOut() {
        requesting_zoom_and_flips = true;
        double flip = 1.0;
        double focoX = drawpanel.getWidth() / 2;
        double focoY = drawpanel.getHeight() / 2;
        this.actionZoom(flip, focoX, focoY);
    }

    public void ZoomIn() {
        requesting_zoom_and_flips = true;
        double flip = -1.0;
        double focoX = drawpanel.getWidth() / 2;
        double focoY = drawpanel.getHeight() / 2;
        this.actionZoom(flip, focoX, focoY);
        requesting_zoom_and_flips = false;
    }

    public void resetZoom() {
        if (zoomInOut != 1.0) {
            requesting_zoom_and_flips = true;
            double flip = 0.0;
            double focoX = drawpanel.getWidth() / 2;
            double focoY = drawpanel.getHeight() / 2;
            this.actionZoom(flip, focoX, focoY);
            requesting_zoom_and_flips = false;
        }
    }

    private void actionZoom(double flip, double focoX, double focoY) {
        double fator = 0.1;
        zoomInOut -= flip * (zoomInOut * fator);
        int size = NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        if (flip != 0.0) {
            pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        } else {
            pontos = zm.resetZoom(pontos, zoomInOut, focoX, focoY);
            zoomInOut = 1.0;
        }
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = NodeList.get(i);
            if (this.nodeAccount.isSpot()) continue;
            this.nodeAccount.setNode(x, y);
        }
        drawpanel.setZoom((float)zoomInOut);
        RederMainFrame.updateGraph();
    }

    public void resetZoomContainer() {
        if (this.nodeAccountFound != null && this.nodeAccountFound.isContainer()) {
            this.zoomContainer(0.0, 0.0, this.nodeAccountFound);
        }
    }

    private void zoomContainer(double flip, double fator, NodeBank containerAccount) {
        if (containerAccount == null) {
            return;
        }
        if (!containerAccount.isContainer() || containerAccount.isSpot()) {
            return;
        }
        double focoX = containerAccount.getX();
        double focoY = containerAccount.getY();
        double rsz = containerAccount.getRelativeSize();
        if (rsz < 0.25 && flip == 1.0) {
            return;
        }
        rsz -= flip * (rsz * fator);
        ArrayList<Integer> cc = containerAccount.getTreeComponents();
        Point2D[] pontos = new Point2D[cc.size()];
        for (int i = 0; i < cc.size(); ++i) {
            this.nodeAccount = NodeList.get(cc.get(i));
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        if (flip != 0.0) {
            pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        } else {
            pontos = zm.resetZoom(pontos, rsz, focoX, focoY);
            rsz = 1.0;
        }
        for (int i = 0; i < cc.size(); ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = NodeList.get(cc.get(i));
            this.nodeAccount.setNode(x, y);
        }
        containerAccount.setRelativeSize(rsz);
        if (isPaintActive) {
            this.repaint();
        }
    }

    private void zeraZoom() {
        double focoX = drawpanel.getWidth() / 2;
        double focoY = drawpanel.getHeight() / 2;
        int size = NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.resetZoom(pontos, zoomInOut, focoX, focoY);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = NodeList.get(i);
            this.nodeAccount.setNodeToSave(x, y);
        }
    }

    private void redoZoomScale() {
        double flip = 0.0;
        double fator = 0.0;
        if (zoomInOut < 1.0) {
            flip = 1.0;
            fator = 1.0 - zoomInOut;
        } else if (zoomInOut > 1.0) {
            flip = -1.0;
            fator = zoomInOut - 1.0;
        }
        if (flip == 0.0) {
            return;
        }
        double focoX = drawpanel.getWidth() / 2;
        double focoY = drawpanel.getHeight() / 2;
        int size = NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
    }

    private void fitToWindow(double fitscale) {
        methods.fitToWindow(fitscale);
    }

    public void rotateAndFlip(boolean rotate, boolean flipH, boolean flipV, double angle) {
        RedHandler dr = new RedHandler();
        ArrayList<Integer> lm = dr.getNodeStackPosition("container", "selected");
        if (!lm.isEmpty()) {
            for (int i = 0; i < lm.size(); ++i) {
                int cIn = lm.get(i);
                NodeBank containerAccount = NodeList.get(cIn);
                if (!containerAccount.isContainer() || containerAccount.getContainerComponents().isEmpty()) continue;
                double centerX = containerAccount.getX();
                double centerY = containerAccount.getY();
                if (rotate) {
                    this.actionRotate(containerAccount.getContainerComponents(), centerX, centerY, angle, true);
                    continue;
                }
                if (flipH) {
                    this.flipHorizontal(containerAccount.getContainerComponents(), centerX, true);
                    continue;
                }
                if (!flipV) continue;
                this.flipVertical(containerAccount.getContainerComponents(), centerY, true);
            }
            if (isPaintActive) {
                this.repaint();
            }
            lm.clear();
        } else {
            lm = dr.getNodeStackPosition("node", "selected");
            if (lm.isEmpty()) {
                double centerX = drawpanel.getWidth() / 2;
                double centerY = drawpanel.getHeight() / 2;
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    lm.add(i);
                }
                if (lm.size() > 1) {
                    if (rotate) {
                        this.actionRotate(lm, centerX, centerY, angle, false);
                    } else if (flipH) {
                        this.flipHorizontal(lm, centerX, false);
                    } else if (flipV) {
                        this.flipVertical(lm, centerY, false);
                    }
                    if (isPaintActive) {
                        this.repaint();
                    }
                    lm.clear();
                }
            } else if (lm.size() > 1) {
                double centerY;
                double centerX;
                if (this.lastDragArea == null) {
                    double xMax = 0.0;
                    double yMax = 0.0;
                    double xMin = 1.0E8;
                    double yMin = 1.0E8;
                    for (int j = 0; j < lm.size(); ++j) {
                        this.nodeAccount = NodeList.get(lm.get(j));
                        double x = this.nodeAccount.getX();
                        double y = this.nodeAccount.getY();
                        if (x > xMax) {
                            xMax = x;
                        }
                        if (y > yMax) {
                            yMax = y;
                        }
                        if (x < xMin) {
                            xMin = x;
                        }
                        if (!(y < yMin)) continue;
                        yMin = y;
                    }
                    double ww = xMax - xMin;
                    double hh = yMax - yMin;
                    centerX = xMin + ww / 2.0;
                    centerY = yMin + hh / 2.0;
                } else {
                    centerX = this.lastDragArea.getCenterX();
                    centerY = this.lastDragArea.getCenterY();
                }
                if (rotate) {
                    this.actionRotate(lm, centerX, centerY, angle, false);
                } else if (flipH) {
                    this.flipHorizontal(lm, centerX, false);
                } else if (flipV) {
                    this.flipVertical(lm, centerY, false);
                }
                if (isPaintActive) {
                    this.repaint();
                }
                lm.clear();
            }
        }
    }

    private void actionRotate(ArrayList<Integer> listaMarcados, double focoX, double focoY, double dAngle, boolean movetree) {
        for (int i = 0; i < listaMarcados.size(); ++i) {
            double ddy;
            double ddx;
            double dy;
            this.nodeAccount = NodeList.get(listaMarcados.get(i));
            double dx = (double)this.nodeAccount.getX() - focoX;
            double len = Math.sqrt(dx * dx + (dy = (double)this.nodeAccount.getY() - focoY) * dy);
            if (len == 0.0) continue;
            if (dx == 0.0) {
                dx = 0.01;
            }
            double q = Math.atan(dy / dx);
            double dq = q + Math.toRadians(dAngle);
            if ((double)this.nodeAccount.getX() >= focoX) {
                ddx = focoX + len * Math.cos(dq);
                ddy = focoY + len * Math.sin(dq);
            } else {
                ddx = focoX - len * Math.cos(dq);
                ddy = focoY - len * Math.sin(dq);
            }
            if (this.nodeAccount.isContainer()) {
                if (movetree) {
                    this.nodeAccount.moveTree((float)ddx, (float)ddy);
                    continue;
                }
                this.nodeAccount.setNode((float)ddx, (float)ddy);
                continue;
            }
            this.nodeAccount.setNode((float)ddx, (float)ddy);
        }
    }

    public void flipVertical(ArrayList<Integer> listaMarcados, double focoY, boolean movetree) {
        for (int i = 0; i < listaMarcados.size(); ++i) {
            this.nodeAccount = NodeList.get(listaMarcados.get(i));
            float y = this.nodeAccount.getY();
            float x = this.nodeAccount.getX();
            if ((double)this.nodeAccount.getY() > focoY) {
                y = (float)focoY - (this.nodeAccount.getY() - (float)focoY);
            } else if ((double)this.nodeAccount.getY() < focoY) {
                y = (float)focoY + ((float)focoY - this.nodeAccount.getY());
            }
            if (this.nodeAccount.isContainer()) {
                if (movetree) {
                    this.nodeAccount.moveTree(x, y);
                    continue;
                }
                this.nodeAccount.setNode(x, y);
                continue;
            }
            this.nodeAccount.setNode(x, y);
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void flipHorizontal(ArrayList<Integer> listaMarcados, double focoX, boolean movetree) {
        for (int i = 0; i < listaMarcados.size(); ++i) {
            this.nodeAccount = NodeList.get(listaMarcados.get(i));
            float x = this.nodeAccount.getX();
            float y = this.nodeAccount.getY();
            if ((double)this.nodeAccount.getX() > focoX) {
                x = (float)focoX - (this.nodeAccount.getX() - (float)focoX);
            } else if ((double)this.nodeAccount.getX() < focoX) {
                x = (float)focoX + ((float)focoX - this.nodeAccount.getX());
            }
            if (this.nodeAccount.isContainer()) {
                if (movetree) {
                    this.nodeAccount.moveTree(x, y);
                    continue;
                }
                this.nodeAccount.setNode(x, y);
                continue;
            }
            this.nodeAccount.setNode(x, y);
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void selectNeighbourhood() {
        if (this.nodeAccountFound.getDestaque()) {
            int i;
            ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
            listaMarcados.clear();
            for (i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (!this.nodeAccount.getDestaque()) continue;
                listaMarcados.add(i);
            }
            for (i = 0; i < listaMarcados.size(); ++i) {
                this.nodeAccount = NodeList.get((Integer)listaMarcados.get(i));
                methods.selectNeighbours(this.nodeAccount.getNodeID());
            }
            listaMarcados.clear();
        } else {
            methods.selectNeighbours(this.nodeAccountFound.getNodeID());
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalActionSelectGraph(boolean nodes, boolean edges) {
        if (nodes && edges) {
            methods.selectGraph();
            this.castNodeAttributesToSettings();
            this.castEdgeAttributesToSettings();
            this.castNodeLabelAttributesToSettings();
        } else if (nodes) {
            methods.selectAllNodes();
            this.castNodeAttributesToSettings();
            this.castNodeLabelAttributesToSettings();
        } else if (edges) {
            methods.selectAllEdges();
            this.castEdgeAttributesToSettings();
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalActionSelect() {
        boolean flag = false;
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            this.globalActionSelectNodes();
            this.castNodeAttributesToSettings();
            this.castNodeLabelAttributesToSettings();
            flag = true;
        }
        if (this.edgeAccountFound != null && this.edgeAccountFound.getDestaque()) {
            this.globalActionSelectEdges();
            this.castEdgeAttributesToSettings();
            flag = true;
        }
        if (!flag) {
            this.globalActionSelectNodes();
            this.globalActionSelectEdges();
            this.castNodeAttributesToSettings();
            this.castNodeLabelAttributesToSettings();
            this.castEdgeAttributesToSettings();
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void globalActionSelectNodes() {
        if (this.nodeAccountFound != null && this.nodeAccountFound.getDestaque()) {
            if (this.nodeAccountFound.isContainer()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.isContainer() || this.nodeAccount.isContainerHided()) continue;
                    this.nodeAccount.setDestaqueUnico(true);
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    if (this.nodeAccount.isContainer()) continue;
                    this.nodeAccount.setDestaqueUnico(true);
                }
            }
        } else {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (this.nodeAccount.isContainerHided()) continue;
                this.nodeAccount.setDestaque(true);
            }
        }
    }

    public void globalActionSelectEdges() {
        if (this.edgeAccountFound != null && this.edgeAccountFound.getDestaque()) {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!this.edgeAccount.getEdgeAssociationType().equals(this.edgeAccountFound.getEdgeAssociationType()) || !RederMainFrame.isToShowTree() && this.edgeAccount.isDefaultEdgeAssignmet() && NodeList.get(this.edgeAccount.getA()).isContainer()) continue;
                this.edgeAccount.setDestaque(true);
            }
        } else {
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                if (!RederMainFrame.isToShowTree() && this.edgeAccount.isDefaultEdgeAssignmet() && NodeList.get(this.edgeAccount.getA()).isContainer()) continue;
                this.edgeAccount.setDestaque(true);
            }
        }
    }

    public void globalActionNoSelect() {
        this.deSelectNodes();
        this.deSelectEdges();
        this.resetEdgeAttributeSettings();
        this.resetNodeAttributeSettings();
        this.resetNodeLabelAttributeSettings();
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void deSelectNodes() {
        methods.deSelectNodes();
    }

    public void deSelectEdges() {
        methods.deSelectEdges();
    }

    public void actionFindObject(int eventX, int eventY) {
        int i;
        this.nodeAccountFound = null;
        this.edgeAccountFound = null;
        this.objectFound = "nada";
        int flag = 0;
        for (i = NodeList.size() - 1; i >= 0 && flag < 2; --i) {
            Shape node;
            this.nodeAccount = NodeList.get(i);
            double zoom_ct = zoomInOut;
            double rz = this.nodeAccount.getRelativeSize();
            if (this.nodeAccount.isSpot()) {
                rz = 1.0;
                zoom_ct = 1.0;
            }
            if (!(node = drawpanel.getNode(this.nodeAccount.getNodeShape(), this.nodeAccount.getX(), this.nodeAccount.getY(), this.nodeAccount.getW(), this.nodeAccount.getH(), (float)rz, (float)zoom_ct)).contains(eventX, eventY)) continue;
            if (flag == 0 && (!this.nodeAccount.isContainer() || this.nodeAccount.isSpot())) {
                this.objectFound = "nodo";
                this.nodeAccountFound = this.nodeAccount;
                flag = 2;
            } else if (flag == 0 && RederMainFrame.getViewArea().contains(this.nodeAccount.getX(), this.nodeAccount.getY())) {
                this.objectFound = "nodo";
                this.nodeAccountFound = this.nodeAccount;
                flag = 1;
            }
            if (flag != 1 || this.nodeAccount.isContainer() && !this.nodeAccount.isSpot()) continue;
            this.objectFound = "nodo";
            this.nodeAccountFound = this.nodeAccount;
            flag = 2;
        }
        if (flag < 2) {
            for (i = EdgeList.size() - 1; i >= 0 && flag < 2; --i) {
                boolean taVendo;
                this.edgeAccount = EdgeList.get(i);
                int p1 = this.edgeAccount.getA();
                int p2 = this.edgeAccount.getB();
                float p1x = NodeList.get(p1).getX();
                float p1y = NodeList.get(p1).getY();
                float p2x = NodeList.get(p2).getX();
                float p2y = NodeList.get(p2).getY();
                Rectangle2D fakeNode = RederMainFrame.rectangle(eventX, eventY, 5.0f, 5.0f);
                Line2D.Float edgeline = new Line2D.Float();
                edgeline.setLine(p1x, p1y, p2x, p2y);
                boolean bl = taVendo = RederMainFrame.getViewArea().contains(p1x, p1y) && RederMainFrame.getViewArea().contains(p2x, p2y);
                if (!edgeline.intersects(fakeNode) || !taVendo) continue;
                if (!NodeList.get(p1).isContainer() && this.edgeAccount.isDefaultEdgeAssignmet()) {
                    this.objectFound = "edge";
                    this.edgeAccountFound = this.edgeAccount;
                    flag = 2;
                    continue;
                }
                if (this.edgeAccount.getEdgeAssociationType().equals("edgeContainer")) {
                    if (flag == 0) {
                        this.objectFound = "edge";
                        this.edgeAccountFound = this.edgeAccount;
                        flag = 2;
                        continue;
                    }
                    if (flag != 1 || NodeList.get(p1).getNodeLevel() <= this.nodeAccountFound.getNodeLevel()) continue;
                    this.objectFound = "edge";
                    this.edgeAccountFound = this.edgeAccount;
                    flag = 2;
                    continue;
                }
                if (!showTree || !this.edgeAccount.getEdgeAssociationType().equals("edgeTree")) continue;
                this.objectFound = "edge";
                this.edgeAccountFound = this.edgeAccount;
                flag = 2;
            }
        }
    }

    public void actionFindContainer(int eventX, int eventY) {
        this.nodeAccountFound = null;
        boolean flag = false;
        for (int i = NodeList.size() - 1; i >= 0 && !flag; --i) {
            this.nodeAccount = NodeList.get(i);
            double rz = this.nodeAccount.getRelativeSize();
            Shape node = drawpanel.getNode(this.nodeAccount.getNodeShape(), this.nodeAccount.getX(), this.nodeAccount.getY(), this.nodeAccount.getW(), this.nodeAccount.getH(), (float)rz, (float)zoomInOut);
            if (!node.contains(eventX, eventY) || !this.nodeAccount.isContainer()) continue;
            this.nodeAccountFound = this.nodeAccount;
            flag = true;
        }
    }

    public void updateDestaques() {
        if (areaSelect != null) {
            this.stopRelax();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean flag_node_found = false;
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                if (this.nodeAccount.isSpot()) continue;
                double rz = this.nodeAccount.getRelativeSize();
                Rectangle2D node = RederMainFrame.rectangle(this.nodeAccount.getX(), this.nodeAccount.getY(), this.nodeAccount.getW() * (float)(zoomInOut * rz), this.nodeAccount.getH() * (float)(zoomInOut * rz));
                if (!areaSelect.intersects(node)) continue;
                if (this.nodeAccount.isContainer()) {
                    if (!areaSelect.contains(node)) continue;
                    this.nodeAccount.setDestaque(true);
                    flag_node_found = true;
                    continue;
                }
                this.nodeAccount.setDestaque(true);
                flag_node_found = true;
            }
            boolean flag_edge_found = false;
            for (int i = 0; i < EdgeList.size(); ++i) {
                this.edgeAccount = EdgeList.get(i);
                int a = this.edgeAccount.getA();
                this.nodeAccount = NodeList.get(a);
                Point2D ponto1 = this.nodeAccount.getPoint();
                int b = this.edgeAccount.getB();
                this.nodeAccount = NodeList.get(b);
                Point2D ponto2 = this.nodeAccount.getPoint();
                boolean b1 = areaSelect.contains(ponto1.getX(), ponto1.getY());
                boolean b2 = areaSelect.contains(ponto2.getX(), ponto2.getY());
                if (!b1 || !b2) continue;
                if (!NodeList.get(a).isContainer()) {
                    this.edgeAccount.setDestaque(true);
                    flag_edge_found = true;
                    continue;
                }
                if (showTree) {
                    this.edgeAccount.setDestaque(true);
                    flag_edge_found = true;
                    continue;
                }
                if (this.edgeAccount.isDefaultEdgeAssignmet()) continue;
                this.edgeAccount.setDestaque(true);
                flag_edge_found = true;
            }
            if (flag_edge_found) {
                this.castEdgeAttributesToSettings();
            }
            if (flag_node_found) {
                this.castNodeAttributesToSettings();
            }
            if (flag_node_found) {
                this.castNodeLabelAttributesToSettings();
            }
            this.saveDragArea(areaSelect);
            areaSelect = null;
        }
    }

    private void saveDragArea(Rectangle2D box) {
        if (this.lastDragArea == null) {
            this.lastDragArea = (Rectangle2D)box.clone();
        } else {
            this.lastDragArea.add(box);
        }
    }

    public void actionDragNodo(int dragX, int dragY) {
        movendoNodos = true;
        if (drawpanel.contains(dragX, dragY)) {
            if (this.nodeAccountFound.getDestaque()) {
                for (int i = 0; i < NodeList.size(); ++i) {
                    int c;
                    this.nodeAccount = NodeList.get(i);
                    if (!this.nodeAccount.getDestaque() || this.nodeAccount.isNodeNested() && NodeList.get(c = this.nodeAccount.getNestedAssignmentIndx()).getDestaque()) continue;
                    if (this.nodeAccount.isContainer()) {
                        this.actionDragContainer(this.nodeAccount, dragX, dragY);
                        continue;
                    }
                    float locx = this.nodeAccount.getX() + (float)(dragX - this.scrollX);
                    float locy = this.nodeAccount.getY() + (float)(dragY - this.scrollY);
                    if (this.nodeAccount.isNodeNested()) {
                        int r = keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment());
                        if (NodeList.get(r).getDestaque()) continue;
                        this.nodeAccount.setNode(locx, locy);
                        continue;
                    }
                    this.nodeAccount.setNode(locx, locy);
                }
            } else if (this.nodeAccountFound.isContainer()) {
                this.actionDragContainer(this.nodeAccountFound, dragX, dragY);
            } else {
                float locx = this.nodeAccountFound.getX() + (float)(dragX - this.scrollX);
                float locy = this.nodeAccountFound.getY() + (float)(dragY - this.scrollY);
                this.nodeAccountFound.setNode(locx, locy);
            }
            this.scrollY = dragY;
            this.scrollX = dragX;
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void actionDragBox(int dragX, int dragY) {
        if (drawpanel.contains(dragX, dragY)) {
            areaSelect = RederMainFrame.rectangle(this.pressedX, this.pressedY, 1.0f, 1.0f);
            areaSelect.add(dragX, dragY);
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public static Rectangle2D getDragArea() {
        return areaSelect;
    }

    private static Rectangle2D rectangle(float x, float y, float w, float h) {
        Rectangle2D.Double node = new Rectangle2D.Double(x - w / 2.0f, y - h / 2.0f, w, h);
        return node;
    }

    public void actionDragWindow(int dragX, int dragY) {
        if (drawpanel.contains(dragX, dragY)) {
            if (isRelaxActive && !this.jCheckBoxCoolingN.isSelected()) {
                float gear = 1.0f;
                if (NodeList.size() > 50) {
                    gear = 2.0f;
                }
                if (NodeList.size() > 250) {
                    gear = 3.0f;
                }
                if (NodeList.size() > 500) {
                    gear = 4.0f;
                }
                if (NodeList.size() > 1000) {
                    gear = 5.0f;
                }
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    double rz = this.nodeAccount.getRelativeSize();
                    float k = this.nodeAccount.getNumParceiros();
                    float kMaxAdj = this.kMax;
                    if (kMaxAdj < 1.0f) {
                        kMaxAdj = 1.0f;
                    }
                    float z = k / kMaxAdj * 0.5f;
                    z = z * (float)(zoomInOut * rz) * gear;
                    float fx = 0.4f + z;
                    float fy = 0.4f + z;
                    if (this.nodeAccount.getDestaque()) {
                        fx = 1.0f;
                        fy = 1.0f;
                    }
                    float x3 = this.nodeAccount.getX() + (float)(dragX - this.scrollX) * fx;
                    float y3 = this.nodeAccount.getY() + (float)(dragY - this.scrollY) * fy;
                    this.nodeAccount.setNode(x3, y3);
                }
            } else {
                for (int i = 0; i < NodeList.size(); ++i) {
                    this.nodeAccount = NodeList.get(i);
                    float x3 = this.nodeAccount.getX() + (float)(dragX - this.scrollX);
                    float y3 = this.nodeAccount.getY() + (float)(dragY - this.scrollY);
                    this.nodeAccount.setNode(x3, y3);
                }
            }
            this.scrollY = dragY;
            this.scrollX = dragX;
            drawpanel.setCursor(Cursor.getPredefinedCursor(13));
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    public void actionDragContainer(NodeBank container, int dragX, int dragY) {
        if (drawpanel.contains(dragX, dragY)) {
            boolean c2;
            boolean c1 = !container.isAnchored();
            boolean bl = c2 = !container.getDestaque();
            if (isRelaxActive && c1 && c2) {
                double rz = container.getRelativeSize();
                float k = container.getTreeSize();
                float kMaxAdj = this.kMax;
                if (kMaxAdj < 1.0f) {
                    kMaxAdj = 1.0f;
                }
                float z = k / kMaxAdj * 0.5f;
                float fx = 0.4f + (z *= (float)(zoomInOut * rz));
                float fy = 0.4f + z;
                float locx = container.getX() + (float)(dragX - this.scrollX) * fx;
                float locy = container.getY() + (float)(dragY - this.scrollY) * fy;
                container.moveTree(locx, locy);
            } else {
                float locx = container.getX() + (float)(dragX - this.scrollX);
                float locy = container.getY() + (float)(dragY - this.scrollY);
                container.moveTree(locx, locy);
            }
        }
    }

    public void taskFilterZoom() {
        if (this.taskFilterZoom != null && !this.taskFilterZoom.isCancelled()) {
            this.taskFilterZoom.cancel(true);
        }
        this.taskFilterZoom = new TarefaFilterZoom();
        this.taskFilterZoom.execute();
    }

    private void setFilterZoom(double flip, double focoX, double focoY, double vlox) {
        if (flip == 0.0) {
            return;
        }
        double fator = vlox;
        zoomInOut -= flip * (zoomInOut * fator);
        int size = NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
        drawpanel.setZoom((float)zoomInOut);
    }

    public void addSpotNode() {
        Dimension tamanhoDialogo = this.jDialogSpotEffect.getPreferredSize();
        Dimension tamanhoFrame = this.getSize();
        Point loc = this.getLocation();
        int jScrollMainPaneWith = this.jScrollMainPane.getWidth();
        this.jDialogSpotEffect.setLocation((jScrollMainPaneWith - tamanhoDialogo.width) / 2 + loc.x, (tamanhoFrame.height - tamanhoDialogo.height) / 2 + loc.y);
        this.jDialogSpotEffect.setTitle("Guide to repel/attract nodes");
        this.jSpinnerSpotEffect1.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(1.0), null, (Number)1.0));
        this.jLabeSpotEffect1.setText("Effect size (>=1):");
        this.jSpinnerSpotEffect2.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(1.0), null, (Number)1.0));
        this.jLabeSpotEffect2.setText("Range (>=1):");
        this.jSpinnerSpotEffect3.setModel(new SpinnerNumberModel(1, -1, 1, 2));
        this.jLabeSpotEffect3.setText("Direction (-1 or 1):");
        this.jButtonUpdateSpotEffect.setVisible(false);
        this.jTextAreaSpotEffect.setText("Note: this option will add a \"spot\" object at the upper left corner of the graph panel. This \"spot\" is only used to guide the RedeR's layout process, acting to attract or repel subsections of the network.");
        this.jTextAreaSpotEffect.setForeground(new Color(181, 36, 0));
        this.jButtonAddSpot.setVisible(true);
        this.jDialogSpotEffect.pack();
        this.jDialogSpotEffect.setModal(true);
        this.jDialogSpotEffect.setVisible(true);
    }

    public void addSpotNode(float x, float y, double spotEffect, double spotPerimeter, int spotDirection) {
        Object spot = "$PT";
        int n = 0;
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (!this.nodeAccount.isSpot()) continue;
            ++n;
        }
        spot = (String)spot + n + "$";
        methods.addEdgesAndNodes((String)spot, "", true);
        this.nodeAccount = NodeList.get(NodeList.size() - 1);
        this.nodeAccount.setNode(x, y);
        this.nodeAccount.setFontSize(0);
        this.nodeAccount.setNodeSizeScale(3.0f);
        this.nodeAccount.setNodeLineType("DOTTED");
        this.nodeAccount.setNodeLineWidth(2.0f);
        this.nodeAccount.setNodeColor(new Color(255, 220, 0));
        this.nodeAccount.setNodeLineColor(new Color(255, 0, 0));
        this.nodeAccount.setContainerTransparent(true);
        this.nodeAccount.setAsSpot();
        this.nodeAccount.setContainer(true);
        this.nodeAccount.setAnchored(true);
        this.nodeAccount.setSpotEffect(spotEffect);
        this.nodeAccount.setSpotRange(spotPerimeter);
        this.nodeAccount.setSpotDirection(spotDirection);
        if (isPaintActive) {
            this.repaint();
        }
    }

    public void setSpotEffect() {
        Dimension tamanhoDialogo = this.jDialogSpotEffect.getPreferredSize();
        Dimension tamanhoFrame = this.getSize();
        Point loc = this.getLocation();
        int jScrollMainPaneWith = this.jScrollMainPane.getWidth();
        this.jDialogSpotEffect.setLocation((jScrollMainPaneWith - tamanhoDialogo.width) / 2 + loc.x, (tamanhoFrame.height - tamanhoDialogo.height) / 2 + loc.y);
        this.jDialogSpotEffect.setTitle("Guide to repel/attract nodes");
        this.jSpinnerSpotEffect1.setModel(new SpinnerNumberModel((Number)this.nodeAccountFound.getSpotEffect(), Double.valueOf(1.0), null, (Number)1.0));
        this.jLabeSpotEffect1.setText("Effect size (>=1):");
        this.jSpinnerSpotEffect2.setModel(new SpinnerNumberModel((Number)this.nodeAccountFound.getSpotRange(), Double.valueOf(1.0), null, (Number)1.0));
        this.jLabeSpotEffect2.setText("Range (>=1):");
        this.jSpinnerSpotEffect3.setModel(new SpinnerNumberModel(this.nodeAccountFound.getSpotDirection(), -1, 1, 2));
        this.jLabeSpotEffect3.setText("Direction (-1 or 1):");
        this.jButtonAddSpot.setVisible(false);
        this.jTextAreaSpotEffect.setText("Note: This object is not part of the network and it is only used to guide the RedeR's layout process. The user can drag the \"spot\" to attract/repel subsections of the network.");
        this.jTextAreaSpotEffect.setForeground(new Color(1, 120, 20));
        this.jButtonUpdateSpotEffect.setVisible(true);
        this.jDialogSpotEffect.pack();
        this.jDialogSpotEffect.setModal(true);
        this.jDialogSpotEffect.setVisible(true);
    }

    public void setSpotsHided(boolean hide) {
        for (int i = 0; i < NodeList.size(); ++i) {
            this.nodeAccount = NodeList.get(i);
            if (!this.nodeAccount.isSpot()) continue;
            this.nodeAccount.setContainerHided(hide);
        }
    }

    public void actionAbout() {
        Dimension tamanhoDialogo = this.jDialogAbout.getPreferredSize();
        Dimension tamanhoFrame = this.getSize();
        Point loc = this.getLocation();
        int jScrollMainPaneWith = this.jScrollMainPane.getWidth();
        this.jDialogAbout.setLocation((jScrollMainPaneWith - tamanhoDialogo.width) / 2 + loc.x, (tamanhoFrame.height - tamanhoDialogo.height) / 2 + loc.y);
        this.jDialogAbout.pack();
        this.jDialogAbout.setModal(true);
        this.jDialogAbout.setVisible(true);
    }

    public static Color HexToColor(String hex) {
        hex = hex.replace("#", "");
        switch (hex.length()) {
            case 6: {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            case 8: {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        return null;
    }

    public static String ColorToHex(Color color, boolean colorWithAlpha) {
        String hex = colorWithAlpha ? String.format("%02x%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()) : String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        return hex;
    }

    private void exitRedeR() {
        System.exit(0);
    }

    public void setAlwaysOnTopDialogs(boolean setOnTop) {
        if (setOnTop) {
            if (!this.jDialogNodeID.isAlwaysOnTop()) {
                this.jDialogNodeID.setAlwaysOnTop(setOnTop);
            }
            if (!this.jDialogModelFindNodeLabel.isAlwaysOnTop()) {
                this.jDialogModelFindNodeLabel.setAlwaysOnTop(setOnTop);
            }
            if (!this.jDialogModelRotate.isAlwaysOnTop()) {
                this.jDialogModelRotate.setAlwaysOnTop(setOnTop);
            }
            if (!this.jDialogAddNodeEdge.isAlwaysOnTop()) {
                this.jDialogAddNodeEdge.setAlwaysOnTop(setOnTop);
            }
            if (!this.jDialogModelGrid.isAlwaysOnTop()) {
                this.jDialogModelGrid.setAlwaysOnTop(setOnTop);
            }
        } else {
            if (this.jDialogNodeID.isAlwaysOnTop()) {
                this.jDialogNodeID.setAlwaysOnTop(setOnTop);
            }
            if (this.jDialogModelFindNodeLabel.isAlwaysOnTop()) {
                this.jDialogModelFindNodeLabel.setAlwaysOnTop(setOnTop);
            }
            if (this.jDialogModelRotate.isAlwaysOnTop()) {
                this.jDialogModelRotate.setAlwaysOnTop(setOnTop);
            }
            if (this.jDialogAddNodeEdge.isAlwaysOnTop()) {
                this.jDialogAddNodeEdge.setAlwaysOnTop(setOnTop);
            }
            if (this.jDialogModelGrid.isAlwaysOnTop()) {
                this.jDialogModelGrid.setAlwaysOnTop(setOnTop);
            }
        }
    }

    public void setVisibleDialogs(boolean setVisible) {
        if (setVisible) {
            if (this.jDialogNodeID.isDisplayable() && !this.jDialogNodeID.isVisible()) {
                this.jDialogNodeID.setVisible(true);
            }
            if (this.jDialogModelFindNodeLabel.isDisplayable() && !this.jDialogModelFindNodeLabel.isVisible()) {
                this.jDialogModelFindNodeLabel.setVisible(true);
            }
            if (this.jDialogModelRotate.isDisplayable() && !this.jDialogModelRotate.isVisible()) {
                this.jDialogModelRotate.setVisible(true);
            }
            if (this.jDialogAbout.isDisplayable() && !this.jDialogAbout.isVisible()) {
                this.jDialogAbout.setVisible(true);
            }
            if (this.jDialogAddNodeEdge.isDisplayable() && !this.jDialogAddNodeEdge.isVisible()) {
                this.jDialogAddNodeEdge.setVisible(true);
            }
            if (this.jDialogModelGrid.isDisplayable() && !this.jDialogModelGrid.isVisible()) {
                this.jDialogModelGrid.setVisible(true);
            }
        } else {
            this.jDialogNodeID.setVisible(false);
            this.jDialogModelFindNodeLabel.setVisible(false);
            this.jDialogModelRotate.setVisible(false);
            this.jDialogAbout.setVisible(false);
            this.jDialogAddNodeEdge.setVisible(false);
            this.jDialogModelGrid.setVisible(false);
        }
    }

    private void jButtonUpdateSpotEffect() {
        this.nodeAccountFound.setSpotEffect((Double)this.jSpinnerSpotEffect1.getValue());
        this.nodeAccountFound.setSpotRange((Double)this.jSpinnerSpotEffect2.getValue());
        this.nodeAccountFound.setSpotDirection((Integer)this.jSpinnerSpotEffect3.getValue());
        this.jDialogSpotEffect.dispose();
    }

    private void jButtonExportImage() {
        scale = (Double)this.jSpinnerImageResolution.getValue();
        scale /= 2.0;
        this.jDialogProgress.setTitle("Exporting image");
        this.jLabelPress.setText("Exporting image...");
        this.jDialogExportImage.dispose();
        this.exportFile();
    }

    private void jButtonFindNode() {
        String labelPattern = this.jTextFieldFindNode.getText();
        boolean perfect = this.jRadioButtonPerfectMatch.isSelected();
        methods.deSelectNodes();
        if (perfect) {
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccountFound = NodeList.get(i);
                boolean matchID = labelPattern.equals(this.nodeAccountFound.getNodeID());
                boolean matchAlias = labelPattern.equals(this.nodeAccountFound.getAliases());
                if (!matchID && !matchAlias) continue;
                if (this.nodeAccountFound.isContainer() && this.nodeAccountFound.getRelativeSize() != 1.0) {
                    this.zoomContainer(0.0, 0.0, this.nodeAccountFound);
                }
                this.taskFilterZoom();
                break;
            }
        } else {
            Pattern filter = Pattern.compile(labelPattern);
            for (int i = 0; i < NodeList.size(); ++i) {
                this.nodeAccount = NodeList.get(i);
                Matcher matchID = filter.matcher(this.nodeAccount.getNodeID());
                Matcher matchAlias = filter.matcher(this.nodeAccount.getAliases());
                if (!matchID.find() && !matchAlias.find()) continue;
                this.nodeAccount.setDestaqueSimples(true, false);
            }
            methods.globalChangeOrder("forward");
            methods.taskHighlight();
        }
        if (isPaintActive) {
            this.repaint();
        }
    }

    private void jButtonAddNodes() {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String nodeA = this.jTextFieldAddNodeA.getText();
        String nodeB = this.jTextFieldAddNodeB.getText();
        boolean nestedCondition = this.jCheckBoxDefaultNestingOption.isSelected();
        int in = NodeList.size();
        methods.addEdgesAndNodes(nodeA, nodeB, nestedCondition);
        int out = NodeList.size();
        int d = out - in;
        if (d == 1) {
            this.nodeAccount = NodeList.get(out - 1);
            this.nodeAccount.setNode(this.clickedX, this.clickedY);
        } else if (d == 2) {
            this.nodeAccount = NodeList.get(out - 1);
            this.nodeAccount.setNode(this.clickedX - 10, this.clickedY + 10);
            this.nodeAccount = NodeList.get(out - 2);
            this.nodeAccount.setNode(this.clickedX + 10, this.clickedY - 10);
        }
        if (isPaintActive) {
            this.repaint();
        }
        this.jDialogAddNodeEdge.dispose();
    }

    private void contractJFrame() {
        double h = 795.0;
        double w = 1091.0;
        double pfactor = this.getScreenFactor();
        preferences.setMainPaneExpanded(false);
        this.jButtonExpandJFrame.setVisible(true);
        this.jButtonContractJFrame.setVisible(false);
        RedeR.mf.setPreferredSize(new Dimension((int)(w *= pfactor), (int)(h *= pfactor)));
        RedeR.mf.pack();
        RederMainFrame.updateGraph();
    }

    private void expandJFrame() {
        double h = 795.0;
        double w = 1335.0;
        double pfactor = this.getScreenFactor();
        preferences.setMainPaneExpanded(true);
        this.jButtonExpandJFrame.setVisible(false);
        this.jButtonContractJFrame.setVisible(true);
        RedeR.mf.setPreferredSize(new Dimension((int)(w *= pfactor), (int)(h *= pfactor)));
        RedeR.mf.pack();
        RederMainFrame.updateGraph();
    }

    /*
     * Opcode count of 16251 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initComponents() {
        this.jColorChooser = new JColorChooser();
        this.jDialogProgress = new JDialog();
        this.jProgressBar = new JProgressBar();
        this.jLabelPress = new JLabel();
        this.jButton1 = new JButton();
        this.jDialogExportImage = new JDialog();
        this.jPanel2 = new JPanel();
        this.jButtonExportImageCancel = new JButton();
        this.jButtonExportImageOK = new JButton();
        this.jLabel18 = new JLabel();
        this.jSpinnerImageResolution = new JSpinner();
        this.jDialogNodeID = new JDialog();
        this.jLabel1 = new JLabel();
        this.jTextFieldLegendREF = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldLegend = new JTextField();
        this.jButtonAliasesUpdate = new JButton();
        this.jButtonAliasesExit = new JButton();
        this.jDialogModelFindNodeLabel = new JDialog();
        this.jPanel1 = new JPanel();
        this.jRadioButtonRegEx = new JRadioButton();
        this.jRadioButtonPerfectMatch = new JRadioButton();
        this.jTextFieldFindNode = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonExitFindNode = new JButton();
        this.jButtonFindNode = new JButton();
        this.buttonGroupFind = new ButtonGroup();
        this.jDialogModelGrid = new JDialog();
        this.jPanel3 = new JPanel();
        this.jButtonExitGrid = new JButton();
        this.jButtonUpdateGrid = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSpinnerGrid = new JSpinner();
        this.jSpinnerGapx = new JSpinner();
        this.jSpinnerGapy = new JSpinner();
        this.jDialogModelRotate = new JDialog();
        this.jPanel4 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jSpinnerRotate = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jButtonExitRotate = new JButton();
        this.jButtonUpdateRotate = new JButton();
        this.jDialogAddNodeEdge = new JDialog();
        this.jPanel5 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jTextFieldAddNodeA = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextFieldAddNodeB = new JTextField();
        this.jLabel11 = new JLabel();
        this.jCheckBoxDefaultNestingOption = new JCheckBox();
        this.jButtonAddNodesOK = new JButton();
        this.jButtonAddNodesCancel = new JButton();
        this.jDialogSpotEffect = new JDialog();
        this.jPanel6 = new JPanel();
        this.jSpinnerSpotEffect1 = new JSpinner();
        this.jSpinnerSpotEffect2 = new JSpinner();
        this.jSpinnerSpotEffect3 = new JSpinner();
        this.jLabeSpotEffect1 = new JLabel();
        this.jLabeSpotEffect2 = new JLabel();
        this.jLabeSpotEffect3 = new JLabel();
        this.jButtonAddSpot = new JButton();
        this.jButtonUpdateSpotEffect = new JButton();
        this.jButtonCancelSpotEffect = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaSpotEffect = new JTextArea();
        this.jDialogAbout = new JDialog();
        this.jPanel7 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel14 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jLabel15 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jToggleButtonOKabout = new JButton();
        this.jPanel8 = new JPanel();
        this.jLabel19 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel16 = new JLabel();
        this.popNodeChanges = new JPopupMenu();
        this.jMenuItemNodeID = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuNestObjects = new JMenu();
        this.jMenuItemNestNodes = new JMenuItem();
        this.jMenuItemTransform = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.jMenuItemUpdateNestSize = new JMenuItem();
        this.jMenuItemUpdateNestedPosition = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.jMenuItemMergeOutEdges = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jMenuItemHide = new JMenuItem();
        this.jMenuItemTransparent = new JMenuItem();
        this.jMenuItemPlainNest = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.jMenuItemBreakTree = new JMenuItem();
        this.jMenuItemDownGradeTree = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.jMenuItemResetZoom = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.jMenuItemDuplicate = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemAnchor = new JMenuItem();
        this.jMenuItemUnanchor = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemMergeNodes = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItemNeighbourhood = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.jMenuItemBackward = new JMenuItem();
        this.jMenuItemForward = new JMenuItem();
        this.jMenuNodeDelete = new JMenuItem();
        this.popEdgeChanges = new JPopupMenu();
        this.jMenuEdgeDelete = new JMenuItem();
        this.popSpotChanges = new JPopupMenu();
        this.jMenuISetSpotEffect = new JMenuItem();
        this.jMenuSpotDelete = new JMenuItem();
        this.jPopupMenuMigrate = new JPopupMenu();
        this.jMenuItemMove = new JMenuItem();
        this.jMenuItemMigrate = new JMenuItem();
        this.jPopupMenuGeneralText = new JPopupMenu();
        this.jMenuItemText1 = new JMenuItem();
        this.jMenuItemText2 = new JMenuItem();
        this.jPanelInicial = new JPanel();
        this.jToolBarMainBar = new JToolBar();
        this.jToolBarFile = new JToolBar();
        this.jButtonIconOpen = new JButton();
        this.jButtonIconSave = new JButton();
        this.jButtonIconPDF = new JButton();
        this.jToolBarSelect = new JToolBar();
        this.jButtonIconZoomIn = new JButton();
        this.jButtonIconZoomOut = new JButton();
        this.jButtonIconZoomReset = new JButton();
        this.jButtonIconFind = new JButton();
        this.jButtonIconSelectAll = new JButton();
        this.jToolBarEdit = new JToolBar();
        this.jButtonIconRotateLeft = new JButton();
        this.jButtonIconRotateRigth = new JButton();
        this.jButtonFlipVer = new JButton();
        this.jButtonFlipHor = new JButton();
        this.jButtonIconFit = new JButton();
        this.jToolBarLayout = new JToolBar();
        this.jToggleButtonRederLayout = new JToggleButton();
        this.jButtonGridLayout = new JButton();
        this.jButtonCircularLayout = new JButton();
        this.jButtonRandomLayout = new JButton();
        this.jToolBarExpandPanel = new JToolBar();
        this.jButtonContractJFrame = new JButton();
        this.jButtonExpandJFrame = new JButton();
        this.jToolBarMinorBar = new JToolBar();
        this.jButtonCollapseRigthTabs = new JButton();
        this.jButtonExpandRigthTabs = new JButton();
        this.jSplitPane = new JSplitPane();
        this.jScrollMainPane = new JScrollPane();
        this.jTabbedPaneAttribs = new JTabbedPane();
        this.jScrollPaneLayout = new JScrollPane();
        this.jPanelJtabbedLayout = new JPanel();
        this.jLabel20 = new JLabel();
        this.jPanelLayout1 = new JPanel();
        this.jSpinnerSeletorRelaxP1 = new JSpinner();
        this.jSpinnerSeletorRelaxP2 = new JSpinner();
        this.jSpinnerSeletorRelaxP3 = new JSpinner();
        this.jSpinnerSeletorRelaxP4 = new JSpinner();
        this.jSpinnerSeletorRelaxP5 = new JSpinner();
        this.jSpinnerSeletorRelaxP6 = new JSpinner();
        this.jLabeSeletorRelaxP1 = new JLabel();
        this.jLabeSeletorRelaxP2 = new JLabel();
        this.jLabeSeletorRelaxP3 = new JLabel();
        this.jLabeSeletorRelaxP4 = new JLabel();
        this.jLabeSeletorRelaxP5 = new JLabel();
        this.jLabeSeletorRelaxP6 = new JLabel();
        this.jSpinnerSeletorRelaxP7 = new JSpinner();
        this.jLabeSeletorRelaxP7 = new JLabel();
        this.jPanelLayout2 = new JPanel();
        this.jSpinnerSeletorRelaxP8 = new JSpinner();
        this.jLabeSeletorRelaxP8 = new JLabel();
        this.jLabeSeletorRelaxP9 = new JLabel();
        this.jSpinnerSeletorRelaxP9 = new JSpinner();
        this.jPanelLayout3 = new JPanel();
        this.jSliderSeletorRelax = new JSlider();
        this.jSpinnerSeletorRelaxSlider = new JSpinner();
        this.jLabeSeletorRelaxSlider = new JLabel();
        this.jPanel11 = new JPanel();
        this.jCheckBoxCoolingN = new JCheckBox();
        this.jCheckBoxPartitionEffect = new JCheckBox();
        this.jCheckBoxOverrideEdges = new JCheckBox();
        this.jCheckBoxOptimizeRendering = new JCheckBox();
        this.jPanel12 = new JPanel();
        this.jButtonStartRelax = new JButton();
        this.jButtonStopRelax = new JButton();
        this.jButtonResetRelax = new JButton();
        this.jButtonAddGuide = new JButton();
        this.jProgressBarRelax = new JProgressBar();
        this.jScrollPaneNodes = new JScrollPane();
        this.jPanelJtabbedNodes = new JPanel();
        this.jLabel21 = new JLabel();
        this.jPanelNodes1 = new JPanel();
        this.jPanel30 = new JPanel();
        this.jButtonEllipse = new JButton();
        this.jButtonRectangle = new JButton();
        this.jButtonRoundedRec = new JButton();
        this.jButtonTriangle = new JButton();
        this.jButtonDiamond = new JButton();
        JButtonGradient JButtonGradient2 = new JButtonGradient();
        JButtonGradient2.setColors(Color.decode("#9393AC"), Color.WHITE);
        this.jButtonGradientSurface = JButtonGradient2;
        JButtonGradient JButtonFlat = new JButtonGradient();
        JButtonFlat.setColors(Color.decode("#9393AC"), Color.decode("#9393AC"));
        this.jButtonFlatSurface = JButtonFlat;
        this.jPanelNodes2 = new JPanel();
        this.jSliderNodeBend = new JSlider();
        this.jPanelNodes3 = new JPanel();
        this.jPanel31 = new JPanel();
        this.NodeLineSolid = new JButton();
        this.NodeLineDotted = new JButton();
        this.NodeLineDashed = new JButton();
        this.NodeLineDashedLong = new JButton();
        this.jPanelNodes4 = new JPanel();
        this.jSpinnerNodeSize = new JSpinner();
        this.jSpinnerNodeLineWidth = new JSpinner();
        this.jCheckBoxScaleNodes = new JCheckBox();
        this.jCheckBoxScaleNodeLines = new JCheckBox();
        this.jLabelSize = new JLabel();
        this.jLabelLineWith = new JLabel();
        this.jPanelNodes5 = new JPanel();
        this.jPanelNodeFillColorView = new JPanel();
        this.jFormattedTextFieldHexaNodeFill = new JFormattedTextField();
        this.jButtonNodeFillColorPicker = new JButton();
        this.jPanelNodes6 = new JPanel();
        this.jPanelNodeLineColorView = new JPanel();
        this.jButtonNodeLineColorPicker = new JButton();
        this.jFormattedTextFieldHexaNodeLine = new JFormattedTextField();
        this.jScrollPaneEdges = new JScrollPane();
        this.jPanelJtabbedEdges = new JPanel();
        this.jLabel22 = new JLabel();
        this.jPanelEdges1 = new JPanel();
        this.jPanel29 = new JPanel();
        this.EdgeLineSolid = new JButton();
        this.EdgeLineDotted = new JButton();
        this.EdgeLineDashed = new JButton();
        this.EdgeLineDashedLong = new JButton();
        this.jPanelEdges2 = new JPanel();
        this.jPanel27 = new JPanel();
        this.jButtonArrow6 = new JButton();
        this.jButtonArrow3 = new JButton();
        this.jButtonArrow0 = new JButton();
        this.jButtonArrow1 = new JButton();
        this.jButtonArrow2 = new JButton();
        this.jButtonArrow4 = new JButton();
        this.jButtonArrow5 = new JButton();
        this.jButtonArrow7 = new JButton();
        this.jButtonArrow8 = new JButton();
        this.jPanelEdges3 = new JPanel();
        this.jSpinnerEdgeWidth = new JSpinner();
        this.jSpinnerArrowLength = new JSpinner();
        this.jSpinnerArrowAngle = new JSpinner();
        this.jCheckBoxScaleEdgeWidth = new JCheckBox();
        this.jCheckBoxScaleArrowLen = new JCheckBox();
        this.jCheckBoxScaleArrowAngle = new JCheckBox();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jSpinnerEdgeWeight = new JSpinner();
        this.jCheckBoxScaleEdgeWeight = new JCheckBox();
        this.jLabel29 = new JLabel();
        this.jPanelEdges4 = new JPanel();
        this.jPanelEdgeLineColorView = new JPanel();
        this.jButtonEdgeLineColorPicker = new JButton();
        this.jFormattedTextFieldHexaEdgeLine = new JFormattedTextField();
        this.jScrollPaneLabels = new JScrollPane();
        this.jPanelJtabbedLabels = new JPanel();
        this.jLabel23 = new JLabel();
        this.jPanelLabels1 = new JPanel();
        this.jSpinnerFontSize = new JSpinner();
        this.jComboBoxFontStyle = new JComboBox();
        this.jComboBoxFontType = new JComboBox();
        this.jPanelLabels2 = new JPanel();
        this.jPanel14 = new JPanel();
        this.jButtonLabelLeft = new JButton();
        this.jButtonLabelCenter = new JButton();
        this.jButtonLabelRight = new JButton();
        this.jPanel13 = new JPanel();
        this.jButtonLabelTop = new JButton();
        this.jButtonLabelMiddle = new JButton();
        this.jButtonLabelBottom = new JButton();
        this.jLabel27 = new JLabel();
        this.jSpinnerFontOffsetX = new JSpinner();
        this.jLabel28 = new JLabel();
        this.jSpinnerFontOffsetY = new JSpinner();
        this.jButtonFitNodeToLabel = new JButton();
        this.jPanelLabels3 = new JPanel();
        this.jPanel28 = new JPanel();
        this.jButtonHideLabels = new JButton();
        this.jButtonShowLabels = new JButton();
        this.jPanelLabels4 = new JPanel();
        this.jPanelFontColorView = new JPanel();
        this.jButtonFontColorPicker = new JButton();
        this.jFormattedTextFieldHexaFont = new JFormattedTextField();
        this.menuBar = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu6 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenu7 = new JMenu();
        this.jMenu9 = new JMenu();
        this.jMenuItem13 = new JMenuItem();
        this.jMenuItem14 = new JMenuItem();
        this.jMenuItem15 = new JMenuItem();
        this.jMenuItem16 = new JMenuItem();
        this.jMenuItem17 = new JMenuItem();
        this.jMenu10 = new JMenu();
        this.jMenuItem11 = new JMenuItem();
        this.jMenuItem12 = new JMenuItem();
        this.jMenu12 = new JMenu();
        this.jMenuItem18 = new JMenuItem();
        this.jMenuItem19 = new JMenuItem();
        this.jMenuItem20 = new JMenuItem();
        this.jMenu8 = new JMenu();
        this.jMenuItem9 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jMenu11 = new JMenu();
        this.jMenuItem21 = new JMenuItem();
        this.jMenuItem22 = new JMenuItem();
        this.jMenuItem23 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem24 = new JMenuItem();
        this.jMenuItem34 = new JMenuItem();
        this.jMenuItem40 = new JMenuItem();
        this.jMenuItem26 = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem27 = new JMenuItem();
        this.jMenuItem28 = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem29 = new JMenuItem();
        this.jMenuItem30 = new JMenuItem();
        this.jMenuItem31 = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem32 = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem33 = new JMenuItem();
        this.jCheckBoxMenuItemShowTree = new JCheckBoxMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem35 = new JMenuItem();
        this.jMenuItem36 = new JMenuItem();
        this.jMenuItem37 = new JMenuItem();
        this.jMenuItem38 = new JMenuItem();
        this.jMenuItem39 = new JMenuItem();
        this.jMenu13 = new JMenu();
        this.jMenuItemAspectF1 = new JMenuItem();
        this.jMenuItemAspectF2 = new JMenuItem();
        this.jMenu14 = new JMenu();
        this.jMenuItem42 = new JMenuItem();
        this.jMenuItem43 = new JMenuItem();
        this.jMenuItem44 = new JMenuItem();
        this.jMenu15 = new JMenu();
        this.jCheckBoxToolbarsFile = new JCheckBoxMenuItem();
        this.jCheckBoxToolbarsSelect = new JCheckBoxMenuItem();
        this.jCheckBoxToolbarsEdit = new JCheckBoxMenuItem();
        this.jCheckBoxToolbarsLayout = new JCheckBoxMenuItem();
        this.jMenu5 = new JMenu();
        this.jMenuItem45 = new JMenuItem();
        this.jLabelPress.setFont(new Font("SansSerif", 0, 15));
        this.jLabelPress.setText("Running...");
        this.jButton1.setFont(new Font("SansSerif", 0, 15));
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jDialogProgressLayout = new GroupLayout(this.jDialogProgress.getContentPane());
        this.jDialogProgress.getContentPane().setLayout(jDialogProgressLayout);
        jDialogProgressLayout.setHorizontalGroup(jDialogProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogProgressLayout.createSequentialGroup().addContainerGap().addGroup(jDialogProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar, -1, 376, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jDialogProgressLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton1, -2, 99, -2)).addComponent(this.jLabelPress, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jDialogProgressLayout.setVerticalGroup(jDialogProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogProgressLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jLabelPress).addGap(12, 12, 12).addComponent(this.jProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1).addContainerGap(23, Short.MAX_VALUE)));
        this.jButtonExportImageCancel.setFont(new Font("SansSerif", 0, 15));
        this.jButtonExportImageCancel.setText("Cancel");
        this.jButtonExportImageCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonExportImageCancelActionPerformed(evt);
            }
        });
        this.jButtonExportImageOK.setFont(new Font("SansSerif", 0, 15));
        this.jButtonExportImageOK.setText("OK");
        this.jButtonExportImageOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonExportImageOKActionPerformed(evt);
            }
        });
        this.jLabel18.setFont(new Font("SansSerif", 1, 15));
        this.jLabel18.setText("Resolution:");
        this.jSpinnerImageResolution.setFont(new Font("SansSerif", 0, 12));
        this.jSpinnerImageResolution.setModel(new SpinnerNumberModel((Number)3.0, Double.valueOf(0.0), null, (Number)1.0));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonExportImageOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExportImageCancel, -1, -1, Short.MAX_VALUE))).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel18, -1, 146, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerImageResolution, -2, 94, -2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerImageResolution).addComponent(this.jLabel18, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 54, Short.MAX_VALUE).addComponent(this.jButtonExportImageOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExportImageCancel).addContainerGap()));
        GroupLayout jDialogExportImageLayout = new GroupLayout(this.jDialogExportImage.getContentPane());
        this.jDialogExportImage.getContentPane().setLayout(jDialogExportImageLayout);
        jDialogExportImageLayout.setHorizontalGroup(jDialogExportImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogExportImageLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jDialogExportImageLayout.setVerticalGroup(jDialogExportImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogExportImageLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jLabel1.setFont(new Font("SansSerif", 1, 18));
        this.jLabel1.setText("Node ID:");
        this.jTextFieldLegendREF.setEditable(false);
        this.jTextFieldLegendREF.setFont(new Font("SansSerif", 1, 14));
        this.jLabel2.setFont(new Font("SansSerif", 0, 15));
        this.jLabel2.setText("Node Alias:");
        this.jTextFieldLegend.setFont(new Font("SansSerif", 0, 14));
        this.jButtonAliasesUpdate.setFont(new Font("SansSerif", 0, 15));
        this.jButtonAliasesUpdate.setText("Update Alias");
        this.jButtonAliasesUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonAliasesUpdateActionPerformed(evt);
            }
        });
        this.jButtonAliasesExit.setFont(new Font("SansSerif", 0, 15));
        this.jButtonAliasesExit.setText("Exit");
        this.jButtonAliasesExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonAliasesExitActionPerformed(evt);
            }
        });
        GroupLayout jDialogNodeIDLayout = new GroupLayout(this.jDialogNodeID.getContentPane());
        this.jDialogNodeID.getContentPane().setLayout(jDialogNodeIDLayout);
        jDialogNodeIDLayout.setHorizontalGroup(jDialogNodeIDLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogNodeIDLayout.createSequentialGroup().addContainerGap().addGroup(jDialogNodeIDLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldLegendREF).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldLegend).addComponent(this.jButtonAliasesUpdate, -1, 200, Short.MAX_VALUE).addComponent(this.jButtonAliasesExit, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jDialogNodeIDLayout.setVerticalGroup(jDialogNodeIDLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogNodeIDLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldLegendREF, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldLegend, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 45, Short.MAX_VALUE).addComponent(this.jButtonAliasesUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAliasesExit).addGap(9, 9, 9)));
        this.buttonGroupFind.add(this.jRadioButtonRegEx);
        this.jRadioButtonRegEx.setFont(new Font("SansSerif", 0, 15));
        this.jRadioButtonRegEx.setText("Regex");
        this.buttonGroupFind.add(this.jRadioButtonPerfectMatch);
        this.jRadioButtonPerfectMatch.setFont(new Font("SansSerif", 0, 15));
        this.jRadioButtonPerfectMatch.setSelected(true);
        this.jRadioButtonPerfectMatch.setText("Perfect match");
        this.jTextFieldFindNode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jTextFieldFindNodeKeyPressed(evt);
            }
        });
        this.jLabel3.setFont(new Font("SansSerif", 1, 15));
        this.jLabel3.setText("Node name or ID:");
        this.jButtonExitFindNode.setText("Exit");
        this.jButtonExitFindNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonExitFindNodeActionPerformed(evt);
            }
        });
        this.jButtonFindNode.setText("Search");
        this.jButtonFindNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonFindNodeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFindNode, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -1, 252, Short.MAX_VALUE).addComponent(this.jRadioButtonPerfectMatch, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonRegEx, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonFindNode, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExitFindNode, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFindNode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonPerfectMatch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonRegEx).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonFindNode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExitFindNode).addContainerGap()));
        GroupLayout jDialogModelFindNodeLabelLayout = new GroupLayout(this.jDialogModelFindNodeLabel.getContentPane());
        this.jDialogModelFindNodeLabel.getContentPane().setLayout(jDialogModelFindNodeLabelLayout);
        jDialogModelFindNodeLabelLayout.setHorizontalGroup(jDialogModelFindNodeLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogModelFindNodeLabelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jDialogModelFindNodeLabelLayout.setVerticalGroup(jDialogModelFindNodeLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogModelFindNodeLabelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jButtonExitGrid.setFont(new Font("SansSerif", 0, 15));
        this.jButtonExitGrid.setText("Exit");
        this.jButtonExitGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonExitGridActionPerformed(evt);
            }
        });
        this.jButtonUpdateGrid.setFont(new Font("SansSerif", 0, 15));
        this.jButtonUpdateGrid.setText("Update");
        this.jButtonUpdateGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonUpdateGridActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("SansSerif", 1, 15));
        this.jLabel4.setText("Col. number:");
        this.jLabel5.setFont(new Font("SansSerif", 1, 15));
        this.jLabel5.setText("X gap:");
        this.jLabel6.setFont(new Font("SansSerif", 1, 15));
        this.jLabel6.setText("Y gap:");
        this.jSpinnerGrid.setFont(new Font("SansSerif", 0, 12));
        this.jSpinnerGrid.setModel(new SpinnerNumberModel((Number)4, Integer.valueOf(1), null, (Number)1));
        this.jSpinnerGapx.setFont(new Font("SansSerif", 0, 12));
        this.jSpinnerGapx.setModel(new SpinnerNumberModel(Float.valueOf(30.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f)));
        this.jSpinnerGapy.setFont(new Font("SansSerif", 0, 12));
        this.jSpinnerGapy.setModel(new SpinnerNumberModel(Float.valueOf(30.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonExitGrid, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonUpdateGrid, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 164, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerGapy).addComponent(this.jSpinnerGrid, -1, 75, Short.MAX_VALUE).addComponent(this.jSpinnerGapx)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerGrid).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerGapx).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerGapy).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 46, Short.MAX_VALUE).addComponent(this.jButtonUpdateGrid).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExitGrid).addContainerGap()));
        GroupLayout jDialogModelGridLayout = new GroupLayout(this.jDialogModelGrid.getContentPane());
        this.jDialogModelGrid.getContentPane().setLayout(jDialogModelGridLayout);
        jDialogModelGridLayout.setHorizontalGroup(jDialogModelGridLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogModelGridLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jDialogModelGridLayout.setVerticalGroup(jDialogModelGridLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogModelGridLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jLabel7.setFont(new Font("SansSerif", 1, 15));
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("Rotate the network panel");
        this.jSpinnerRotate.setFont(new Font("SansSerif", 0, 12));
        this.jSpinnerRotate.setModel(new SpinnerNumberModel(45.0, -360.0, 360.0, 5.0));
        this.jSpinnerRotate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerRotateKeyPressed(evt);
            }
        });
        this.jLabel8.setFont(new Font("SansSerif", 0, 15));
        this.jLabel8.setText("Angle (degrees):");
        this.jButtonExitRotate.setFont(new Font("SansSerif", 0, 15));
        this.jButtonExitRotate.setText("Exit");
        this.jButtonExitRotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonExitRotateActionPerformed(evt);
            }
        });
        this.jButtonUpdateRotate.setFont(new Font("SansSerif", 0, 15));
        this.jButtonUpdateRotate.setText("Update");
        this.jButtonUpdateRotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonUpdateRotateActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonExitRotate, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel8, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerRotate, -1, 90, Short.MAX_VALUE)).addComponent(this.jButtonUpdateRotate, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerRotate).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 49, Short.MAX_VALUE).addComponent(this.jButtonUpdateRotate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExitRotate).addContainerGap()));
        ((JSpinner.DefaultEditor)this.jSpinnerRotate.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerRotateKeyPressed(evt);
            }
        });
        GroupLayout jDialogModelRotateLayout = new GroupLayout(this.jDialogModelRotate.getContentPane());
        this.jDialogModelRotate.getContentPane().setLayout(jDialogModelRotateLayout);
        jDialogModelRotateLayout.setHorizontalGroup(jDialogModelRotateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogModelRotateLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jDialogModelRotateLayout.setVerticalGroup(jDialogModelRotateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogModelRotateLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jLabel9.setFont(new Font("SansSerif", 1, 15));
        this.jLabel9.setText("Add nodes / edges:");
        this.jTextFieldAddNodeA.setFont(new Font("SansSerif", 0, 15));
        this.jLabel10.setFont(new Font("SansSerif", 0, 15));
        this.jLabel10.setText("Node A:");
        this.jTextFieldAddNodeB.setFont(new Font("SansSerif", 0, 15));
        this.jLabel11.setFont(new Font("SansSerif", 0, 15));
        this.jLabel11.setText("Node B:");
        this.jCheckBoxDefaultNestingOption.setFont(new Font("SansSerif", 0, 15));
        this.jCheckBoxDefaultNestingOption.setSelected(true);
        this.jCheckBoxDefaultNestingOption.setText("Default nesting option");
        this.jButtonAddNodesOK.setFont(new Font("SansSerif", 0, 15));
        this.jButtonAddNodesOK.setText("OK");
        this.jButtonAddNodesOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonAddNodesOKActionPerformed(evt);
            }
        });
        this.jButtonAddNodesCancel.setFont(new Font("SansSerif", 0, 15));
        this.jButtonAddNodesCancel.setText("Cancel");
        this.jButtonAddNodesCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonAddNodesCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxDefaultNestingOption, -1, 252, Short.MAX_VALUE).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel11, -1, 93, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAddNodeB, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldAddNodeA))).addComponent(this.jButtonAddNodesOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddNodesCancel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldAddNodeA).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldAddNodeB).addComponent(this.jLabel11, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDefaultNestingOption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 35, Short.MAX_VALUE).addComponent(this.jButtonAddNodesOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddNodesCancel).addContainerGap()));
        GroupLayout jDialogAddNodeEdgeLayout = new GroupLayout(this.jDialogAddNodeEdge.getContentPane());
        this.jDialogAddNodeEdge.getContentPane().setLayout(jDialogAddNodeEdgeLayout);
        jDialogAddNodeEdgeLayout.setHorizontalGroup(jDialogAddNodeEdgeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogAddNodeEdgeLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jDialogAddNodeEdgeLayout.setVerticalGroup(jDialogAddNodeEdgeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogAddNodeEdgeLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jSpinnerSpotEffect1.setFont(new Font("SansSerif", 0, 12));
        this.jSpinnerSpotEffect1.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(1.0), null, (Number)1.0));
        this.jSpinnerSpotEffect2.setFont(new Font("SansSerif", 0, 12));
        this.jSpinnerSpotEffect2.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(1.0), null, (Number)1.0));
        this.jSpinnerSpotEffect3.setFont(new Font("SansSerif", 0, 12));
        this.jSpinnerSpotEffect3.setModel(new SpinnerNumberModel(1, -1, 1, 2));
        this.jLabeSpotEffect1.setFont(new Font("SansSerif", 0, 15));
        this.jLabeSpotEffect1.setText("Text 1:");
        this.jLabeSpotEffect2.setFont(new Font("SansSerif", 0, 15));
        this.jLabeSpotEffect2.setText("Text 2:");
        this.jLabeSpotEffect3.setFont(new Font("SansSerif", 0, 15));
        this.jLabeSpotEffect3.setText("Text 3:");
        this.jButtonAddSpot.setFont(new Font("SansSerif", 0, 15));
        this.jButtonAddSpot.setText("Add");
        this.jButtonAddSpot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonAddSpotActionPerformed(evt);
            }
        });
        this.jButtonUpdateSpotEffect.setFont(new Font("SansSerif", 0, 15));
        this.jButtonUpdateSpotEffect.setText("Update");
        this.jButtonUpdateSpotEffect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonUpdateSpotEffectActionPerformed(evt);
            }
        });
        this.jButtonCancelSpotEffect.setFont(new Font("SansSerif", 0, 15));
        this.jButtonCancelSpotEffect.setText("Cancel");
        this.jButtonCancelSpotEffect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonCancelSpotEffectActionPerformed(evt);
            }
        });
        this.jTextAreaSpotEffect.setEditable(false);
        this.jTextAreaSpotEffect.setColumns(16);
        this.jTextAreaSpotEffect.setFont(new Font("SansSerif", 0, 11));
        this.jTextAreaSpotEffect.setLineWrap(true);
        this.jTextAreaSpotEffect.setRows(5);
        this.jTextAreaSpotEffect.setWrapStyleWord(true);
        this.jTextAreaSpotEffect.setAutoscrolls(false);
        this.jTextAreaSpotEffect.setPreferredSize(new Dimension(176, 90));
        this.jScrollPane1.setViewportView(this.jTextAreaSpotEffect);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAddSpot, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabeSpotEffect1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabeSpotEffect2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabeSpotEffect3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerSpotEffect1).addComponent(this.jSpinnerSpotEffect2).addComponent(this.jSpinnerSpotEffect3, -1, 81, Short.MAX_VALUE))).addComponent(this.jButtonUpdateSpotEffect, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancelSpotEffect, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 262, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerSpotEffect1).addComponent(this.jLabeSpotEffect1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerSpotEffect2).addComponent(this.jLabeSpotEffect2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabeSpotEffect3, -1, -1, Short.MAX_VALUE).addComponent(this.jSpinnerSpotEffect3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddSpot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUpdateSpotEffect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancelSpotEffect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 96, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jDialogSpotEffectLayout = new GroupLayout(this.jDialogSpotEffect.getContentPane());
        this.jDialogSpotEffect.getContentPane().setLayout(jDialogSpotEffectLayout);
        jDialogSpotEffectLayout.setHorizontalGroup(jDialogSpotEffectLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogSpotEffectLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jDialogSpotEffectLayout.setVerticalGroup(jDialogSpotEffectLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogSpotEffectLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jDialogAbout.setTitle("About");
        this.jLabel12.setFont(new Font("SansSerif", 1, 14));
        this.jLabel12.setHorizontalAlignment(0);
        this.jLabel12.setText("RedeR V3.1 (2023-11-04)");
        this.jLabel13.setFont(new Font("SansSerif", 0, 12));
        this.jLabel13.setHorizontalAlignment(0);
        this.jLabel13.setText("Copyright (C) 2011-2023  CRUK-CI");
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(new Color(245, 246, 247));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("SansSerif", 0, 10));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.\n\n********************************************\nAcknowledgments\n********************************************\n\n\"RedeR V3\" uses the Apache Maven Packages listed below, available from the Maven Central Repository (http://maven.apache.org).\n\n1) flatlaf, Version 2.0.2, distributed under the Apache License, Version 2. \nLicense URL: \"https://opensource.org/licenses/Apache-2.0\".\nApache Maven Descriptors:\n<groupId>com.formdev</groupId>\n<artifactId>flatlaf</artifactId>\n<version>2.0.2</version>\n\n2) ikonli-swing, Version 12.3.0, distributed under the Apache License, Version 2. \nLicense URL: \"https://opensource.org/licenses/Apache-2.0\".\nApache Maven Descriptors:\n<groupId>org.kordamp.ikonli</groupId>\n<artifactId>ikonli-swing</artifactId>\n<version>12.3.0</version>\n\n3) ikonli-bootstrapicons-pack, Version 12.3.0, distributed under the MIT License. \nLicense URL: \"https://opensource.org/licenses/MIT\".\nApache Maven Descriptors:\n<groupId>org.kordamp.ikonli</groupId>\n<artifactId>ikonli-bootstrapicons-pack</artifactId>\n<version>12.3.0</version>\n\n4) ikonli-boxicons-pack, Version 12.3.0, distributed under the MIT License. \nLicense URL: \"https://opensource.org/licenses/MIT\".\nApache Maven Descriptors:\n<groupId>org.kordamp.ikonli</groupId>\n<artifactId>ikonli-boxicons-pack</artifactId>\n<version>12.3.0</version>\n\n5) org.jfree.pdf, Version 2.0, distributed under the GNU GPL, Version 3. \nLicense URL: \"https://www.gnu.org/licenses/gpl-3.0.txt\".\nApache Maven Descriptors:\n<groupId>org.jfree</groupId>\n<artifactId>org.jfree.pdf</artifactId>\n<version>2.0</version>\n\n6) org.jfree.svg, Version 5.0.2, distributed under the GNU GPL, Version 3.\nLicense URL: \"https://www.gnu.org/licenses/gpl-3.0.txt\".\nApache Maven Descriptors:\n<groupId>org.jfree</groupId>\n<artifactId>org.jfree.svg</artifactId>\n<version>5.0.2</version>\n\n7) xmlrpc-server, Version 3.1.3, distributed under the Apache License, Version 2. \nLicense URL: \"https://opensource.org/licenses/Apache-2.0\".\nApache Maven Descriptors:\n<groupId>org.apache.xmlrpc</groupId>\n<artifactId>xmlrpc-server</artifactId>\n<version>3.1.3</version>\n\n9) jdom2, Version 2.0.6.1, distributed under the license available at the URL below, requesting the following acknowledgement:\n\"This software includes a library developed by the JDOM Project (http://www.jdom.org/)\".\nLicense URL: \"https://raw.githubusercontent.com/hunterhacker/jdom/master/LICENSE.txt\".\nApache Maven Descriptors:\n<groupId>org.jdom</groupId>\n<artifactId>jdom2</artifactId>\n<version>2.0.6.1</version>\n");
        this.jTextArea1.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.jLabel14.setFont(new Font("SansSerif", 1, 14));
        this.jLabel14.setHorizontalAlignment(0);
        this.jLabel14.setText("Citation:");
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setBackground(new Color(245, 246, 247));
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setFont(new Font("SansSerif", 0, 12));
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setRows(5);
        this.jTextArea2.setText("Castro MA, Wang X, Fletcher MN, Meyer KB, Markowetz F. \nRedeR: R/Bioconductor package for representing modular structures, nested networks and multiple levels of hierarchical associations. Genome Biology, 13(4):R29, 2012. Doi:10.1186/gb-2012-13-4-r29\n");
        this.jTextArea2.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView(this.jTextArea2);
        this.jLabel15.setFont(new Font("SansSerif", 1, 14));
        this.jLabel15.setHorizontalAlignment(0);
        this.jLabel15.setText("Documentation and contact:");
        this.jTextField1.setEditable(false);
        this.jTextField1.setFont(new Font("SansSerif", 0, 12));
        this.jTextField1.setHorizontalAlignment(0);
        this.jTextField1.setText("https://www.bioconductor.org/packages/RedeR/");
        this.jTextField2.setEditable(false);
        this.jTextField2.setFont(new Font("SansSerif", 0, 12));
        this.jTextField2.setHorizontalAlignment(0);
        this.jTextField2.setText("Mauro Castro < mauro.a.castro@gmail.com >");
        this.jToggleButtonOKabout.setText("OK");
        this.jToggleButtonOKabout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jToggleButtonOKaboutActionPerformed(evt);
            }
        });
        this.jLabel19.setFont(new Font("SansSerif", 1, 12));
        this.jLabel19.setHorizontalAlignment(0);
        this.jLabel19.setText("University of Cambridge");
        this.jLabel17.setFont(new Font("SansSerif", 1, 12));
        this.jLabel17.setHorizontalAlignment(0);
        this.jLabel17.setText("Cambridge Institute");
        this.jLabel16.setFont(new Font("SansSerif", 1, 12));
        this.jLabel16.setHorizontalAlignment(0);
        this.jLabel16.setText("Cancer Research UK");
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel17, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel19, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel19)));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel14, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane3).addComponent(this.jLabel15, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 462, Short.MAX_VALUE).addComponent(this.jTextField2).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jToggleButtonOKabout, -2, 99, -2)).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 141, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel8, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jToggleButtonOKabout).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jDialogAboutLayout = new GroupLayout(this.jDialogAbout.getContentPane());
        this.jDialogAbout.getContentPane().setLayout(jDialogAboutLayout);
        jDialogAboutLayout.setHorizontalGroup(jDialogAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogAboutLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jDialogAboutLayout.setVerticalGroup(jDialogAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogAboutLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jMenuItemNodeID.setText("NodeID");
        this.jMenuItemNodeID.setHorizontalTextPosition(2);
        this.jMenuItemNodeID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemNodeIDActionPerformed(evt);
            }
        });
        this.popNodeChanges.add(this.jMenuItemNodeID);
        this.popNodeChanges.add(this.jSeparator5);
        this.jMenuNestObjects.setText("Nest");
        this.jMenuNestObjects.setHorizontalTextPosition(2);
        this.jMenuItemNestNodes.setText("Nest objects");
        this.jMenuItemNestNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemNestNodesActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemNestNodes);
        this.jMenuItemTransform.setText("Transform");
        this.jMenuItemTransform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemTransformActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemTransform);
        this.jMenuNestObjects.add(this.jSeparator10);
        this.jMenuItemUpdateNestSize.setText("Update size");
        this.jMenuItemUpdateNestSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemUpdateNestSizeActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemUpdateNestSize);
        this.jMenuItemUpdateNestedPosition.setText("Update positions");
        this.jMenuItemUpdateNestedPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemUpdateNestedPositionActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemUpdateNestedPosition);
        this.jMenuNestObjects.add(this.jSeparator15);
        this.jMenuItemMergeOutEdges.setText("Merge out-edges");
        this.jMenuItemMergeOutEdges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemMergeOutEdgesActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemMergeOutEdges);
        this.jMenuNestObjects.add(this.jSeparator11);
        this.jMenuItemHide.setText("Hide");
        this.jMenuItemHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemHideActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemHide);
        this.jMenuItemTransparent.setText("Transparent");
        this.jMenuItemTransparent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemTransparentActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemTransparent);
        this.jMenuItemPlainNest.setText("Plain");
        this.jMenuItemPlainNest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemPlainNestActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemPlainNest);
        this.jMenuNestObjects.add(this.jSeparator12);
        this.jMenuItemBreakTree.setText("Break tree");
        this.jMenuItemBreakTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemBreakTreeActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemBreakTree);
        this.jMenuItemDownGradeTree.setText("Downgrade tree");
        this.jMenuItemDownGradeTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemDownGradeTreeActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemDownGradeTree);
        this.jMenuNestObjects.add(this.jSeparator13);
        this.jMenuItemResetZoom.setText("Reset zoom");
        this.jMenuItemResetZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemResetZoomActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemResetZoom);
        this.jMenuNestObjects.add(this.jSeparator14);
        this.jMenuItemDuplicate.setText("Duplicate nest");
        this.jMenuItemDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemDuplicateActionPerformed(evt);
            }
        });
        this.jMenuNestObjects.add(this.jMenuItemDuplicate);
        this.popNodeChanges.add(this.jMenuNestObjects);
        this.popNodeChanges.add(this.jSeparator6);
        this.jMenuItemAnchor.setText("Anchor");
        this.jMenuItemAnchor.setHorizontalTextPosition(2);
        this.jMenuItemAnchor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemAnchorActionPerformed(evt);
            }
        });
        this.popNodeChanges.add(this.jMenuItemAnchor);
        this.jMenuItemUnanchor.setText("Unanchor");
        this.jMenuItemUnanchor.setHorizontalTextPosition(2);
        this.jMenuItemUnanchor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemUnanchorActionPerformed(evt);
            }
        });
        this.popNodeChanges.add(this.jMenuItemUnanchor);
        this.popNodeChanges.add(this.jSeparator7);
        this.jMenuItemMergeNodes.setText("Merge");
        this.jMenuItemMergeNodes.setHorizontalTextPosition(2);
        this.jMenuItemMergeNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemMergeNodesActionPerformed(evt);
            }
        });
        this.popNodeChanges.add(this.jMenuItemMergeNodes);
        this.popNodeChanges.add(this.jSeparator8);
        this.jMenuItemNeighbourhood.setText("Neighbours");
        this.jMenuItemNeighbourhood.setHorizontalTextPosition(2);
        this.jMenuItemNeighbourhood.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemNeighbourhoodActionPerformed(evt);
            }
        });
        this.popNodeChanges.add(this.jMenuItemNeighbourhood);
        this.popNodeChanges.add(this.jSeparator9);
        this.jMenuItemBackward.setText("Backward");
        this.jMenuItemBackward.setHorizontalTextPosition(2);
        this.jMenuItemBackward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemBackwardActionPerformed(evt);
            }
        });
        this.popNodeChanges.add(this.jMenuItemBackward);
        this.jMenuItemForward.setText("Forward");
        this.jMenuItemForward.setHorizontalTextPosition(2);
        this.jMenuItemForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemForwardActionPerformed(evt);
            }
        });
        this.popNodeChanges.add(this.jMenuItemForward);
        this.jMenuNodeDelete.setText("Delete");
        this.jMenuNodeDelete.setHorizontalTextPosition(2);
        this.jMenuNodeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuNodeDeleteActionPerformed(evt);
            }
        });
        this.popNodeChanges.add(this.jMenuNodeDelete);
        this.jMenuEdgeDelete.setText("Delete");
        this.jMenuEdgeDelete.setHorizontalTextPosition(2);
        this.jMenuEdgeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuEdgeDeleteActionPerformed(evt);
            }
        });
        this.popEdgeChanges.add(this.jMenuEdgeDelete);
        this.jMenuISetSpotEffect.setText("Set guide");
        this.jMenuISetSpotEffect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuISetSpotEffectActionPerformed(evt);
            }
        });
        this.popSpotChanges.add(this.jMenuISetSpotEffect);
        this.jMenuSpotDelete.setText("Delete");
        this.jMenuSpotDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuSpotDeleteActionPerformed(evt);
            }
        });
        this.popSpotChanges.add(this.jMenuSpotDelete);
        this.jMenuItemMove.setText("..only move?");
        this.jPopupMenuMigrate.add(this.jMenuItemMove);
        this.jMenuItemMigrate.setText("..migrate?");
        this.jMenuItemMigrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemMigrateActionPerformed(evt);
            }
        });
        this.jPopupMenuMigrate.add(this.jMenuItemMigrate);
        this.jMenuItemText1.setText("Text1");
        this.jPopupMenuGeneralText.add(this.jMenuItemText1);
        this.jMenuItemText2.setText("Text2");
        this.jPopupMenuGeneralText.add(this.jMenuItemText2);
        this.setDefaultCloseOperation(3);
        this.setTitle("RedeR");
        this.setBackground(new Color(243, 243, 243));
        this.setMinimumSize(new Dimension(800, 600));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                RederMainFrame.this.formComponentResized(evt);
            }
        });
        this.jPanelInicial.setBackground(new Color(245, 245, 245));
        this.jPanelInicial.setMinimumSize(new Dimension(718, 572));
        this.jPanelInicial.setPreferredSize(new Dimension(1091, 767));
        this.jToolBarMainBar.setBackground(new Color(245, 245, 245));
        this.jToolBarMainBar.setBorder(null);
        this.jToolBarMainBar.setMinimumSize(new Dimension(643, 40));
        this.jToolBarMainBar.setPreferredSize(new Dimension(991, 40));
        this.jToolBarFile.setBackground(new Color(245, 245, 245));
        this.jToolBarFile.setBorder(null);
        this.jToolBarFile.setRollover(true);
        this.jToolBarFile.setOpaque(false);
        this.jButtonIconOpen.setBackground(new Color(245, 245, 245));
        this.jButtonIconOpen.setText("ik1");
        this.jButtonIconOpen.setToolTipText("Open network");
        this.jButtonIconOpen.setFocusable(false);
        this.jButtonIconOpen.setHorizontalTextPosition(0);
        this.jButtonIconOpen.setVerticalTextPosition(3);
        this.jButtonIconOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconOpenActionPerformed(evt);
            }
        });
        this.jToolBarFile.add(this.jButtonIconOpen);
        this.jButtonIconSave.setBackground(new Color(245, 245, 245));
        this.jButtonIconSave.setText("ik2");
        this.jButtonIconSave.setToolTipText("Save network");
        this.jButtonIconSave.setFocusable(false);
        this.jButtonIconSave.setHorizontalTextPosition(0);
        this.jButtonIconSave.setVerticalTextPosition(3);
        this.jButtonIconSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconSaveActionPerformed(evt);
            }
        });
        this.jToolBarFile.add(this.jButtonIconSave);
        this.jButtonIconPDF.setBackground(new Color(245, 245, 245));
        this.jButtonIconPDF.setText("ik3");
        this.jButtonIconPDF.setToolTipText("Export graph to a PDF file");
        this.jButtonIconPDF.setFocusable(false);
        this.jButtonIconPDF.setHorizontalTextPosition(0);
        this.jButtonIconPDF.setVerticalTextPosition(3);
        this.jButtonIconPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconPDFActionPerformed(evt);
            }
        });
        this.jToolBarFile.add(this.jButtonIconPDF);
        this.jToolBarMainBar.add(this.jToolBarFile);
        this.jToolBarSelect.setBackground(new Color(245, 245, 245));
        this.jToolBarSelect.setBorder(null);
        this.jToolBarSelect.setRollover(true);
        this.jToolBarSelect.setOpaque(false);
        this.jButtonIconZoomIn.setBackground(new Color(245, 245, 245));
        this.jButtonIconZoomIn.setText("ik1");
        this.jButtonIconZoomIn.setToolTipText("Zoom-in");
        this.jButtonIconZoomIn.setFocusable(false);
        this.jButtonIconZoomIn.setHorizontalTextPosition(0);
        this.jButtonIconZoomIn.setVerticalTextPosition(3);
        this.jButtonIconZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconZoomInActionPerformed(evt);
            }
        });
        this.jToolBarSelect.add(this.jButtonIconZoomIn);
        this.jButtonIconZoomOut.setBackground(new Color(245, 245, 245));
        this.jButtonIconZoomOut.setText("ik2");
        this.jButtonIconZoomOut.setToolTipText("Zoom-out");
        this.jButtonIconZoomOut.setFocusable(false);
        this.jButtonIconZoomOut.setHorizontalTextPosition(0);
        this.jButtonIconZoomOut.setVerticalTextPosition(3);
        this.jButtonIconZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconZoomOutActionPerformed(evt);
            }
        });
        this.jToolBarSelect.add(this.jButtonIconZoomOut);
        this.jButtonIconZoomReset.setBackground(new Color(245, 245, 245));
        this.jButtonIconZoomReset.setText("ik3");
        this.jButtonIconZoomReset.setToolTipText("Reset zoom");
        this.jButtonIconZoomReset.setFocusable(false);
        this.jButtonIconZoomReset.setHorizontalTextPosition(0);
        this.jButtonIconZoomReset.setVerticalTextPosition(3);
        this.jButtonIconZoomReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconZoomResetActionPerformed(evt);
            }
        });
        this.jToolBarSelect.add(this.jButtonIconZoomReset);
        this.jButtonIconFind.setBackground(new Color(245, 245, 245));
        this.jButtonIconFind.setText("ik1");
        this.jButtonIconFind.setToolTipText("Search nodes using regex ");
        this.jButtonIconFind.setFocusable(false);
        this.jButtonIconFind.setHorizontalTextPosition(0);
        this.jButtonIconFind.setVerticalTextPosition(3);
        this.jButtonIconFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconFindActionPerformed(evt);
            }
        });
        this.jToolBarSelect.add(this.jButtonIconFind);
        this.jButtonIconSelectAll.setBackground(new Color(245, 245, 245));
        this.jButtonIconSelectAll.setText("ik2");
        this.jButtonIconSelectAll.setToolTipText("Select nodes and edges");
        this.jButtonIconSelectAll.setFocusable(false);
        this.jButtonIconSelectAll.setHorizontalTextPosition(0);
        this.jButtonIconSelectAll.setVerticalTextPosition(3);
        this.jButtonIconSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconSelectAllActionPerformed(evt);
            }
        });
        this.jToolBarSelect.add(this.jButtonIconSelectAll);
        this.jToolBarMainBar.add(this.jToolBarSelect);
        this.jToolBarEdit.setBackground(new Color(245, 245, 245));
        this.jToolBarEdit.setBorder(null);
        this.jToolBarEdit.setRollover(true);
        this.jToolBarEdit.setOpaque(false);
        this.jButtonIconRotateLeft.setBackground(new Color(245, 245, 245));
        this.jButtonIconRotateLeft.setText("ik1");
        this.jButtonIconRotateLeft.setToolTipText("Rotate left");
        this.jButtonIconRotateLeft.setFocusable(false);
        this.jButtonIconRotateLeft.setHorizontalTextPosition(0);
        this.jButtonIconRotateLeft.setVerticalTextPosition(3);
        this.jButtonIconRotateLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconRotateLeftActionPerformed(evt);
            }
        });
        this.jToolBarEdit.add(this.jButtonIconRotateLeft);
        this.jButtonIconRotateRigth.setBackground(new Color(245, 245, 245));
        this.jButtonIconRotateRigth.setText("ik2");
        this.jButtonIconRotateRigth.setToolTipText("Rotate rigth");
        this.jButtonIconRotateRigth.setFocusable(false);
        this.jButtonIconRotateRigth.setHorizontalTextPosition(0);
        this.jButtonIconRotateRigth.setVerticalTextPosition(3);
        this.jButtonIconRotateRigth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconRotateRigthActionPerformed(evt);
            }
        });
        this.jToolBarEdit.add(this.jButtonIconRotateRigth);
        this.jButtonFlipVer.setBackground(new Color(245, 245, 245));
        this.jButtonFlipVer.setText("ik1");
        this.jButtonFlipVer.setToolTipText("Flip vertically");
        this.jButtonFlipVer.setFocusable(false);
        this.jButtonFlipVer.setHorizontalTextPosition(0);
        this.jButtonFlipVer.setVerticalTextPosition(3);
        this.jButtonFlipVer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonFlipVerActionPerformed(evt);
            }
        });
        this.jToolBarEdit.add(this.jButtonFlipVer);
        this.jButtonFlipHor.setBackground(new Color(245, 245, 245));
        this.jButtonFlipHor.setText("ik2");
        this.jButtonFlipHor.setToolTipText("Flip horizontally");
        this.jButtonFlipHor.setFocusable(false);
        this.jButtonFlipHor.setHorizontalTextPosition(0);
        this.jButtonFlipHor.setVerticalTextPosition(3);
        this.jButtonFlipHor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonFlipHorActionPerformed(evt);
            }
        });
        this.jToolBarEdit.add(this.jButtonFlipHor);
        this.jButtonIconFit.setBackground(new Color(245, 245, 245));
        this.jButtonIconFit.setText("ik3");
        this.jButtonIconFit.setToolTipText("Fit network to window");
        this.jButtonIconFit.setFocusable(false);
        this.jButtonIconFit.setHorizontalTextPosition(0);
        this.jButtonIconFit.setVerticalTextPosition(3);
        this.jButtonIconFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonIconFitActionPerformed(evt);
            }
        });
        this.jToolBarEdit.add(this.jButtonIconFit);
        this.jToolBarMainBar.add(this.jToolBarEdit);
        this.jToolBarLayout.setBackground(new Color(245, 245, 245));
        this.jToolBarLayout.setBorder(null);
        this.jToolBarLayout.setRollover(true);
        this.jToolBarLayout.setOpaque(false);
        this.jToggleButtonRederLayout.setBackground(new Color(245, 245, 245));
        this.jToggleButtonRederLayout.setText("ik1");
        this.jToggleButtonRederLayout.setToolTipText("RedeR's interactive layout");
        this.jToggleButtonRederLayout.setFocusable(false);
        this.jToggleButtonRederLayout.setHorizontalTextPosition(0);
        this.jToggleButtonRederLayout.setVerticalTextPosition(3);
        this.jToggleButtonRederLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jToggleButtonRederLayoutActionPerformed(evt);
            }
        });
        this.jToolBarLayout.add(this.jToggleButtonRederLayout);
        this.jButtonGridLayout.setBackground(new Color(245, 245, 245));
        this.jButtonGridLayout.setText("ik2");
        this.jButtonGridLayout.setToolTipText("Grid layout");
        this.jButtonGridLayout.setFocusable(false);
        this.jButtonGridLayout.setHorizontalTextPosition(0);
        this.jButtonGridLayout.setVerticalTextPosition(3);
        this.jButtonGridLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonGridLayoutActionPerformed(evt);
            }
        });
        this.jToolBarLayout.add(this.jButtonGridLayout);
        this.jButtonCircularLayout.setBackground(new Color(245, 245, 245));
        this.jButtonCircularLayout.setText("ik3");
        this.jButtonCircularLayout.setToolTipText("Circular layout");
        this.jButtonCircularLayout.setFocusable(false);
        this.jButtonCircularLayout.setHorizontalTextPosition(0);
        this.jButtonCircularLayout.setVerticalTextPosition(3);
        this.jButtonCircularLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonCircularLayoutActionPerformed(evt);
            }
        });
        this.jToolBarLayout.add(this.jButtonCircularLayout);
        this.jButtonRandomLayout.setBackground(new Color(245, 245, 245));
        this.jButtonRandomLayout.setText("ik4");
        this.jButtonRandomLayout.setToolTipText("Random layout");
        this.jButtonRandomLayout.setFocusable(false);
        this.jButtonRandomLayout.setHorizontalTextPosition(0);
        this.jButtonRandomLayout.setVerticalTextPosition(3);
        this.jButtonRandomLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonRandomLayoutActionPerformed(evt);
            }
        });
        this.jToolBarLayout.add(this.jButtonRandomLayout);
        this.jToolBarMainBar.add(this.jToolBarLayout);
        this.jToolBarExpandPanel.setBackground(new Color(245, 245, 245));
        this.jToolBarExpandPanel.setBorder(null);
        this.jToolBarExpandPanel.setRollover(true);
        this.jToolBarExpandPanel.setOpaque(false);
        this.jButtonContractJFrame.setBackground(new Color(245, 245, 245));
        this.jButtonContractJFrame.setText("ik1");
        this.jButtonContractJFrame.setToolTipText("Reduce main panel");
        this.jButtonContractJFrame.setFocusable(false);
        this.jButtonContractJFrame.setHorizontalAlignment(4);
        this.jButtonContractJFrame.setHorizontalTextPosition(0);
        this.jButtonContractJFrame.setVerticalTextPosition(3);
        this.jButtonContractJFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonContractJFrameActionPerformed(evt);
            }
        });
        this.jToolBarExpandPanel.add(this.jButtonContractJFrame);
        this.jButtonExpandJFrame.setBackground(new Color(245, 245, 245));
        this.jButtonExpandJFrame.setText("ik2");
        this.jButtonExpandJFrame.setToolTipText("Expand main panel");
        this.jButtonExpandJFrame.setFocusable(false);
        this.jButtonExpandJFrame.setHorizontalAlignment(4);
        this.jButtonExpandJFrame.setHorizontalTextPosition(0);
        this.jButtonExpandJFrame.setVerticalTextPosition(3);
        this.jButtonExpandJFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonExpandJFrameActionPerformed(evt);
            }
        });
        this.jToolBarExpandPanel.add(this.jButtonExpandJFrame);
        this.jToolBarMainBar.add(this.jToolBarExpandPanel);
        this.jToolBarMinorBar.setBackground(new Color(245, 245, 245));
        this.jToolBarMinorBar.setBorder(null);
        this.jToolBarMinorBar.setRollover(true);
        this.jToolBarMinorBar.setMinimumSize(new Dimension(100, 28));
        this.jToolBarMinorBar.setPreferredSize(new Dimension(100, 28));
        this.jButtonCollapseRigthTabs.setBackground(new Color(245, 245, 245));
        this.jButtonCollapseRigthTabs.setText("ik1");
        this.jButtonCollapseRigthTabs.setToolTipText("Collapse rigth tabs");
        this.jButtonCollapseRigthTabs.setBorder(null);
        this.jButtonCollapseRigthTabs.setFocusable(false);
        this.jButtonCollapseRigthTabs.setHorizontalAlignment(4);
        this.jButtonCollapseRigthTabs.setHorizontalTextPosition(4);
        this.jButtonCollapseRigthTabs.setMaximumSize(new Dimension(28, 26));
        this.jButtonCollapseRigthTabs.setMinimumSize(new Dimension(28, 26));
        this.jButtonCollapseRigthTabs.setPreferredSize(new Dimension(28, 26));
        this.jButtonCollapseRigthTabs.setVerticalTextPosition(3);
        this.jButtonCollapseRigthTabs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonCollapseRigthTabsActionPerformed(evt);
            }
        });
        this.jToolBarMinorBar.add(this.jButtonCollapseRigthTabs);
        this.jButtonExpandRigthTabs.setBackground(new Color(245, 245, 245));
        this.jButtonExpandRigthTabs.setText("ik2");
        this.jButtonExpandRigthTabs.setToolTipText("Expand rigth tabs");
        this.jButtonExpandRigthTabs.setBorder(null);
        this.jButtonExpandRigthTabs.setFocusable(false);
        this.jButtonExpandRigthTabs.setHorizontalAlignment(4);
        this.jButtonExpandRigthTabs.setHorizontalTextPosition(4);
        this.jButtonExpandRigthTabs.setMaximumSize(new Dimension(28, 26));
        this.jButtonExpandRigthTabs.setMinimumSize(new Dimension(28, 26));
        this.jButtonExpandRigthTabs.setPreferredSize(new Dimension(28, 26));
        this.jButtonExpandRigthTabs.setVerticalTextPosition(3);
        this.jButtonExpandRigthTabs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonExpandRigthTabsActionPerformed(evt);
            }
        });
        this.jToolBarMinorBar.add(this.jButtonExpandRigthTabs);
        this.jToolBarMainBar.add(this.jToolBarMinorBar);
        this.jSplitPane.setBackground(new Color(245, 245, 245));
        this.jSplitPane.setDividerLocation(726);
        this.jSplitPane.setResizeWeight(1.0);
        this.jSplitPane.setLastDividerLocation(725);
        this.jSplitPane.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jSplitPane.setMinimumSize(new Dimension(718, 532));
        this.jSplitPane.setPreferredSize(new Dimension(1091, 727));
        this.jScrollMainPane.setBackground(Color.white);
        this.jScrollMainPane.setBorder(BorderFactory.createLineBorder(new Color(245, 245, 245)));
        this.jScrollMainPane.setForeground(Color.white);
        this.jScrollMainPane.setAlignmentX(0.0f);
        this.jScrollMainPane.setAlignmentY(0.0f);
        this.jScrollMainPane.setFocusable(false);
        this.jScrollMainPane.setMinimumSize(new Dimension(353, 532));
        this.jScrollMainPane.setPreferredSize(new Dimension(726, 726));
        this.jScrollMainPane.setWheelScrollingEnabled(false);
        this.jScrollMainPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                RederMainFrame.this.jScrollMainPaneMouseDragged(evt);
            }
        });
        this.jScrollMainPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                RederMainFrame.this.jScrollMainPaneMouseWheelMoved(evt);
            }
        });
        this.jScrollMainPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RederMainFrame.this.jScrollMainPaneMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                RederMainFrame.this.jScrollMainPaneMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                RederMainFrame.this.jScrollMainPaneMouseReleased(evt);
            }
        });
        this.jSplitPane.setLeftComponent(this.jScrollMainPane);
        this.jTabbedPaneAttribs.setBackground(new Color(245, 245, 245));
        this.jTabbedPaneAttribs.setFont(new Font("SansSerif", 0, 12));
        this.jTabbedPaneAttribs.setMinimumSize(new Dimension(365, 532));
        this.jTabbedPaneAttribs.setPreferredSize(new Dimension(365, 726));
        this.jTabbedPaneAttribs.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                RederMainFrame.this.jTabbedPaneAttribsComponentResized(evt);
            }
        });
        this.jScrollPaneLayout.setBorder(null);
        this.jScrollPaneLayout.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneLayout.setVerticalScrollBarPolicy(22);
        this.jScrollPaneLayout.setPreferredSize(new Dimension(355, 693));
        this.jScrollPaneLayout.setViewportView(null);
        this.jPanelJtabbedLayout.setBackground(new Color(245, 245, 245));
        this.jLabel20.setBackground(new Color(245, 245, 245));
        this.jLabel20.setFont(new Font("SansSerif", 1, 15));
        this.jLabel20.setHorizontalAlignment(0);
        this.jLabel20.setText("RedeR's force-directed layout");
        this.jLabel20.setMaximumSize(new Dimension(Short.MAX_VALUE, 18));
        this.jLabel20.setPreferredSize(new Dimension(332, 18));
        this.jPanelLayout1.setBackground(new Color(245, 245, 245));
        this.jPanelLayout1.setBorder(BorderFactory.createTitledBorder(null, "Main force-directed parameters", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelLayout1.setPreferredSize(new Dimension(333, 245));
        this.jSpinnerSeletorRelaxP1.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP1.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(1.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP1.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP1.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP1StateChanged(evt);
            }
        });
        this.jSpinnerSeletorRelaxP2.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP2.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP2.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP2.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP2StateChanged(evt);
            }
        });
        this.jSpinnerSeletorRelaxP3.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP3.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP3.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP3.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP3StateChanged(evt);
            }
        });
        this.jSpinnerSeletorRelaxP4.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP4.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP4.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP4.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP4StateChanged(evt);
            }
        });
        this.jSpinnerSeletorRelaxP5.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP5.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP5.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP5.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP5.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP5StateChanged(evt);
            }
        });
        this.jSpinnerSeletorRelaxP6.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP6.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP6.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP6.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP6.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP6StateChanged(evt);
            }
        });
        this.jLabeSeletorRelaxP1.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP1.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP1.setText("p1:");
        this.jLabeSeletorRelaxP2.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP2.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP2.setText("p2:");
        this.jLabeSeletorRelaxP3.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP3.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP3.setText("p3:");
        this.jLabeSeletorRelaxP4.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP4.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP4.setText("p4:");
        this.jLabeSeletorRelaxP5.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP5.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP5.setText("p5:");
        this.jLabeSeletorRelaxP6.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP6.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP6.setText("p6:");
        this.jSpinnerSeletorRelaxP7.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP7.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP7.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP7.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP7.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP7StateChanged(evt);
            }
        });
        this.jLabeSeletorRelaxP7.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP7.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP7.setText("p7:");
        GroupLayout jPanelLayout1Layout = new GroupLayout(this.jPanelLayout1);
        this.jPanelLayout1.setLayout(jPanelLayout1Layout);
        jPanelLayout1Layout.setHorizontalGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout1Layout.createSequentialGroup().addContainerGap().addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout1Layout.createSequentialGroup().addComponent(this.jLabeSeletorRelaxP1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerSeletorRelaxP1, -1, -1, Short.MAX_VALUE)).addGroup(jPanelLayout1Layout.createSequentialGroup().addComponent(this.jLabeSeletorRelaxP2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerSeletorRelaxP2, -1, -1, Short.MAX_VALUE)).addGroup(jPanelLayout1Layout.createSequentialGroup().addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabeSeletorRelaxP3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabeSeletorRelaxP4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabeSeletorRelaxP5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabeSeletorRelaxP6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabeSeletorRelaxP7, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerSeletorRelaxP3, -1, -1, Short.MAX_VALUE).addComponent(this.jSpinnerSeletorRelaxP4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jSpinnerSeletorRelaxP5, -1, -1, Short.MAX_VALUE).addComponent(this.jSpinnerSeletorRelaxP6, -1, -1, Short.MAX_VALUE).addComponent(this.jSpinnerSeletorRelaxP7, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanelLayout1Layout.linkSize(0, this.jSpinnerSeletorRelaxP1, this.jSpinnerSeletorRelaxP2, this.jSpinnerSeletorRelaxP3, this.jSpinnerSeletorRelaxP4, this.jSpinnerSeletorRelaxP5, this.jSpinnerSeletorRelaxP6, this.jSpinnerSeletorRelaxP7);
        jPanelLayout1Layout.setVerticalGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout1Layout.createSequentialGroup().addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerSeletorRelaxP1, -2, -1, -2).addGroup(jPanelLayout1Layout.createSequentialGroup().addComponent(this.jLabeSeletorRelaxP1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabeSeletorRelaxP2, -2, 25, -2).addComponent(this.jSpinnerSeletorRelaxP2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabeSeletorRelaxP3, -2, 25, -2).addComponent(this.jSpinnerSeletorRelaxP3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabeSeletorRelaxP4, -2, 25, -2).addComponent(this.jSpinnerSeletorRelaxP4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabeSeletorRelaxP5, -2, 25, -2).addComponent(this.jSpinnerSeletorRelaxP5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabeSeletorRelaxP6, -2, 25, -2).addComponent(this.jSpinnerSeletorRelaxP6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerSeletorRelaxP7, -2, -1, -2).addComponent(this.jLabeSeletorRelaxP7, -2, 25, -2)))).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanelLayout2.setBackground(new Color(245, 245, 245));
        this.jPanelLayout2.setBorder(BorderFactory.createTitledBorder(null, "Nesting force-directed parameters", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelLayout2.setPreferredSize(new Dimension(333, 90));
        this.jSpinnerSeletorRelaxP8.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP8.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(1.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP8.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP8.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP8.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP8StateChanged(evt);
            }
        });
        this.jLabeSeletorRelaxP8.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP8.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP8.setText("p8:");
        this.jLabeSeletorRelaxP9.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxP9.setFont(new Font("SansSerif", 0, 11));
        this.jLabeSeletorRelaxP9.setText("p9:");
        this.jSpinnerSeletorRelaxP9.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxP9.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxP9.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP9.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxP9.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxP9StateChanged(evt);
            }
        });
        GroupLayout jPanelLayout2Layout = new GroupLayout(this.jPanelLayout2);
        this.jPanelLayout2.setLayout(jPanelLayout2Layout);
        jPanelLayout2Layout.setHorizontalGroup(jPanelLayout2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout2Layout.createSequentialGroup().addContainerGap().addGroup(jPanelLayout2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabeSeletorRelaxP8, -1, -1, Short.MAX_VALUE).addComponent(this.jLabeSeletorRelaxP9, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinnerSeletorRelaxP9, -1, -1, Short.MAX_VALUE).addComponent(this.jSpinnerSeletorRelaxP8, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelLayout2Layout.linkSize(0, this.jSpinnerSeletorRelaxP8, this.jSpinnerSeletorRelaxP9);
        jPanelLayout2Layout.setVerticalGroup(jPanelLayout2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout2Layout.createSequentialGroup().addGroup(jPanelLayout2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerSeletorRelaxP8, -2, -1, -2).addComponent(this.jLabeSeletorRelaxP8, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabeSeletorRelaxP9, -2, 25, -2).addComponent(this.jSpinnerSeletorRelaxP9, -2, -1, -2)).addGap(0, 12, Short.MAX_VALUE)));
        this.jPanelLayout3.setBackground(new Color(245, 245, 245));
        this.jPanelLayout3.setBorder(BorderFactory.createTitledBorder(null, "Damping, repulsion factor (p3)", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelLayout3.setPreferredSize(new Dimension(333, 90));
        this.jSliderSeletorRelax.setFont(new Font("SansSerif", 0, 8));
        this.jSliderSeletorRelax.setMajorTickSpacing(20);
        this.jSliderSeletorRelax.setMinorTickSpacing(2);
        this.jSliderSeletorRelax.setPaintLabels(true);
        this.jSliderSeletorRelax.setPaintTicks(true);
        this.jSliderSeletorRelax.setSnapToTicks(true);
        this.jSliderSeletorRelax.setValue(0);
        this.jSliderSeletorRelax.setPreferredSize(new Dimension(211, 62));
        this.jSliderSeletorRelax.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSliderSeletorRelaxStateChanged(evt);
            }
        });
        this.jSpinnerSeletorRelaxSlider.setFont(new Font("SansSerif", 0, 10));
        this.jSpinnerSeletorRelaxSlider.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerSeletorRelaxSlider.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxSlider.setPreferredSize(new Dimension(75, 25));
        this.jSpinnerSeletorRelaxSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerSeletorRelaxSliderStateChanged(evt);
            }
        });
        this.jLabeSeletorRelaxSlider.setBackground(new Color(245, 245, 245));
        this.jLabeSeletorRelaxSlider.setFont(new Font("SansSerif", 0, 13));
        this.jLabeSeletorRelaxSlider.setText(" Degree:");
        GroupLayout jPanelLayout3Layout = new GroupLayout(this.jPanelLayout3);
        this.jPanelLayout3.setLayout(jPanelLayout3Layout);
        jPanelLayout3Layout.setHorizontalGroup(jPanelLayout3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelLayout3Layout.createSequentialGroup().addContainerGap().addComponent(this.jSliderSeletorRelax, -1, -1, Short.MAX_VALUE).addGroup(jPanelLayout3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelLayout3Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabeSeletorRelaxSlider, -2, 72, -2)).addGroup(jPanelLayout3Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jSpinnerSeletorRelaxSlider, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanelLayout3Layout.linkSize(0, this.jLabeSeletorRelaxSlider, this.jSpinnerSeletorRelaxSlider);
        jPanelLayout3Layout.setVerticalGroup(jPanelLayout3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout3Layout.createSequentialGroup().addGroup(jPanelLayout3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderSeletorRelax, -2, -1, -2).addGroup(jPanelLayout3Layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jLabeSeletorRelaxSlider).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerSeletorRelaxSlider, -2, -1, -2))).addGap(0, 6, Short.MAX_VALUE)));
        this.jPanel11.setBackground(new Color(245, 245, 245));
        this.jCheckBoxCoolingN.setBackground(new Color(245, 245, 245));
        this.jCheckBoxCoolingN.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxCoolingN.setSelected(true);
        this.jCheckBoxCoolingN.setText("Cooling");
        this.jCheckBoxCoolingN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxCoolingNActionPerformed(evt);
            }
        });
        this.jCheckBoxPartitionEffect.setBackground(new Color(245, 245, 245));
        this.jCheckBoxPartitionEffect.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxPartitionEffect.setText("Partition effect");
        this.jCheckBoxPartitionEffect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxPartitionEffectActionPerformed(evt);
            }
        });
        this.jCheckBoxOverrideEdges.setBackground(new Color(245, 245, 245));
        this.jCheckBoxOverrideEdges.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxOverrideEdges.setText("Override edges");
        this.jCheckBoxOverrideEdges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxOverrideEdgesActionPerformed(evt);
            }
        });
        this.jCheckBoxOptimizeRendering.setBackground(new Color(245, 245, 245));
        this.jCheckBoxOptimizeRendering.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxOptimizeRendering.setText("Optimize rendering");
        this.jCheckBoxOptimizeRendering.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxOptimizeRenderingActionPerformed(evt);
            }
        });
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxCoolingN, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxPartitionEffect, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxOverrideEdges, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxOptimizeRendering, -1, -1, Short.MAX_VALUE))));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxCoolingN, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxPartitionEffect, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxOverrideEdges, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxOptimizeRendering, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jPanel12.setBackground(new Color(245, 245, 245));
        this.jButtonStartRelax.setFont(new Font("SansSerif", 0, 12));
        this.jButtonStartRelax.setText("Start Relax");
        this.jButtonStartRelax.setMaximumSize(new Dimension(150, 24));
        this.jButtonStartRelax.setPreferredSize(new Dimension(126, 26));
        this.jButtonStartRelax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonStartRelaxActionPerformed(evt);
            }
        });
        this.jButtonStopRelax.setFont(new Font("SansSerif", 0, 12));
        this.jButtonStopRelax.setText("Stop Relax");
        this.jButtonStopRelax.setMaximumSize(new Dimension(150, 24));
        this.jButtonStopRelax.setMinimumSize(new Dimension(72, 24));
        this.jButtonStopRelax.setPreferredSize(new Dimension(126, 26));
        this.jButtonStopRelax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonStopRelaxActionPerformed(evt);
            }
        });
        this.jButtonResetRelax.setFont(new Font("SansSerif", 0, 12));
        this.jButtonResetRelax.setText("Reset");
        this.jButtonResetRelax.setMaximumSize(new Dimension(150, 24));
        this.jButtonResetRelax.setMinimumSize(new Dimension(72, 24));
        this.jButtonResetRelax.setPreferredSize(new Dimension(126, 26));
        this.jButtonResetRelax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonResetRelaxActionPerformed(evt);
            }
        });
        this.jButtonAddGuide.setFont(new Font("SansSerif", 0, 12));
        this.jButtonAddGuide.setText("Add Guide");
        this.jButtonAddGuide.setMaximumSize(new Dimension(150, 24));
        this.jButtonAddGuide.setMinimumSize(new Dimension(72, 24));
        this.jButtonAddGuide.setPreferredSize(new Dimension(126, 26));
        this.jButtonAddGuide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonAddGuideActionPerformed(evt);
            }
        });
        this.jProgressBarRelax.setMinimumSize(new Dimension(10, 10));
        this.jProgressBarRelax.setPreferredSize(new Dimension(126, 12));
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonStopRelax, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonResetRelax, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddGuide, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jProgressBarRelax, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonStartRelax, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel12Layout.createSequentialGroup().addComponent(this.jProgressBarRelax, -2, -1, -2).addGap(4, 4, 4).addComponent(this.jButtonStartRelax, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jButtonStopRelax, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jButtonResetRelax, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jButtonAddGuide, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelJtabbedLayoutLayout = new GroupLayout(this.jPanelJtabbedLayout);
        this.jPanelJtabbedLayout.setLayout(jPanelJtabbedLayoutLayout);
        jPanelJtabbedLayoutLayout.setHorizontalGroup(jPanelJtabbedLayoutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelJtabbedLayoutLayout.createSequentialGroup().addGroup(jPanelJtabbedLayoutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel20, -1, -1, Short.MAX_VALUE).addGroup(jPanelJtabbedLayoutLayout.createSequentialGroup().addComponent(this.jPanel11, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel12, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanelLayout1, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelLayout2, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelLayout3, -1, 344, Short.MAX_VALUE)).addContainerGap()));
        jPanelJtabbedLayoutLayout.setVerticalGroup(jPanelJtabbedLayoutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelJtabbedLayoutLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel20, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelLayout1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelLayout2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelLayout3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelJtabbedLayoutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel11, -2, -1, -2).addComponent(this.jPanel12, -2, -1, -2)).addGap(0, 84, Short.MAX_VALUE)));
        this.jScrollPaneLayout.setViewportView(this.jPanelJtabbedLayout);
        this.jTabbedPaneAttribs.addTab("Layout", this.jScrollPaneLayout);
        this.jScrollPaneNodes.setBorder(null);
        this.jScrollPaneNodes.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneNodes.setVerticalScrollBarPolicy(22);
        this.jScrollPaneNodes.setPreferredSize(new Dimension(355, 693));
        this.jScrollPaneNodes.setViewportView(null);
        this.jPanelJtabbedNodes.setBackground(new Color(245, 245, 245));
        this.jLabel21.setBackground(new Color(245, 245, 245));
        this.jLabel21.setFont(new Font("SansSerif", 1, 15));
        this.jLabel21.setHorizontalAlignment(0);
        this.jLabel21.setText("Node Attributes");
        this.jLabel21.setMaximumSize(new Dimension(Short.MAX_VALUE, 18));
        this.jLabel21.setPreferredSize(new Dimension(332, 18));
        this.jPanelNodes1.setBackground(new Color(245, 245, 245));
        this.jPanelNodes1.setBorder(BorderFactory.createTitledBorder(null, "Node shape", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelNodes1.setPreferredSize(new Dimension(332, 74));
        this.jPanel30.setMinimumSize(new Dimension(0, 0));
        this.jPanel30.setLayout(new GridLayout(1, 0));
        this.jButtonEllipse.setFont(new Font("SansSerif", 0, 10));
        this.jButtonEllipse.setText("b1");
        this.jButtonEllipse.setToolTipText("Ellipse");
        this.jButtonEllipse.setMaximumSize(new Dimension(45, 35));
        this.jButtonEllipse.setMinimumSize(new Dimension(20, 20));
        this.jButtonEllipse.setPreferredSize(new Dimension(35, 35));
        this.jButtonEllipse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonEllipseActionPerformed(evt);
            }
        });
        this.jPanel30.add(this.jButtonEllipse);
        this.jButtonRectangle.setFont(new Font("SansSerif", 0, 10));
        this.jButtonRectangle.setText("b2");
        this.jButtonRectangle.setToolTipText("Rectangle");
        this.jButtonRectangle.setMaximumSize(new Dimension(45, 35));
        this.jButtonRectangle.setMinimumSize(new Dimension(20, 20));
        this.jButtonRectangle.setPreferredSize(new Dimension(35, 35));
        this.jButtonRectangle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonRectangleActionPerformed(evt);
            }
        });
        this.jPanel30.add(this.jButtonRectangle);
        this.jButtonRoundedRec.setFont(new Font("SansSerif", 0, 10));
        this.jButtonRoundedRec.setText("b3");
        this.jButtonRoundedRec.setToolTipText("Rounded rectangle");
        this.jButtonRoundedRec.setMaximumSize(new Dimension(45, 35));
        this.jButtonRoundedRec.setMinimumSize(new Dimension(20, 20));
        this.jButtonRoundedRec.setPreferredSize(new Dimension(35, 35));
        this.jButtonRoundedRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonRoundedRecActionPerformed(evt);
            }
        });
        this.jPanel30.add(this.jButtonRoundedRec);
        this.jButtonTriangle.setFont(new Font("SansSerif", 0, 10));
        this.jButtonTriangle.setText("b4");
        this.jButtonTriangle.setToolTipText("Triangle");
        this.jButtonTriangle.setMaximumSize(new Dimension(45, 35));
        this.jButtonTriangle.setMinimumSize(new Dimension(20, 20));
        this.jButtonTriangle.setPreferredSize(new Dimension(35, 35));
        this.jButtonTriangle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonTriangleActionPerformed(evt);
            }
        });
        this.jPanel30.add(this.jButtonTriangle);
        this.jButtonDiamond.setFont(new Font("SansSerif", 0, 10));
        this.jButtonDiamond.setText("b5");
        this.jButtonDiamond.setToolTipText("Diamond");
        this.jButtonDiamond.setMaximumSize(new Dimension(45, 35));
        this.jButtonDiamond.setMinimumSize(new Dimension(20, 20));
        this.jButtonDiamond.setPreferredSize(new Dimension(35, 35));
        this.jButtonDiamond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonDiamondActionPerformed(evt);
            }
        });
        this.jPanel30.add(this.jButtonDiamond);
        this.jButtonGradientSurface.setFont(new Font("SansSerif", 0, 10));
        this.jButtonGradientSurface.setText("b6");
        this.jButtonGradientSurface.setToolTipText("Gradient");
        this.jButtonGradientSurface.setMaximumSize(new Dimension(45, 35));
        this.jButtonGradientSurface.setMinimumSize(new Dimension(20, 20));
        this.jButtonGradientSurface.setPreferredSize(new Dimension(35, 35));
        this.jButtonGradientSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonGradientSurfaceActionPerformed(evt);
            }
        });
        this.jPanel30.add(this.jButtonGradientSurface);
        this.jButtonFlatSurface.setFont(new Font("SansSerif", 0, 10));
        this.jButtonFlatSurface.setText("b7");
        this.jButtonFlatSurface.setToolTipText("Flat");
        this.jButtonFlatSurface.setMaximumSize(new Dimension(45, 35));
        this.jButtonFlatSurface.setMinimumSize(new Dimension(20, 20));
        this.jButtonFlatSurface.setPreferredSize(new Dimension(35, 35));
        this.jButtonFlatSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonFlatSurfaceActionPerformed(evt);
            }
        });
        this.jPanel30.add(this.jButtonFlatSurface);
        GroupLayout jPanelNodes1Layout = new GroupLayout(this.jPanelNodes1);
        this.jPanelNodes1.setLayout(jPanelNodes1Layout);
        jPanelNodes1Layout.setHorizontalGroup(jPanelNodes1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelNodes1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel30, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelNodes1Layout.setVerticalGroup(jPanelNodes1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodes1Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jPanel30, -2, -1, -2).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanelNodes2.setBackground(new Color(245, 245, 245));
        this.jPanelNodes2.setBorder(BorderFactory.createTitledBorder(null, "<-- width | height -->", 2, 0, new Font("SansSerif", 0, 12)));
        this.jPanelNodes2.setPreferredSize(new Dimension(332, 90));
        this.jSliderNodeBend.setFont(new Font("SansSerif", 0, 10));
        this.jSliderNodeBend.setMajorTickSpacing(25);
        this.jSliderNodeBend.setMinorTickSpacing(2);
        this.jSliderNodeBend.setPaintLabels(true);
        this.jSliderNodeBend.setPaintTicks(true);
        this.jSliderNodeBend.setToolTipText("Eccentricity: bend node shape");
        this.jSliderNodeBend.setPreferredSize(new Dimension(202, 56));
        this.jSliderNodeBend.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSliderNodeBendStateChanged(evt);
            }
        });
        GroupLayout jPanelNodes2Layout = new GroupLayout(this.jPanelNodes2);
        this.jPanelNodes2.setLayout(jPanelNodes2Layout);
        jPanelNodes2Layout.setHorizontalGroup(jPanelNodes2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodes2Layout.createSequentialGroup().addContainerGap().addComponent(this.jSliderNodeBend, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelNodes2Layout.setVerticalGroup(jPanelNodes2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderNodeBend, -2, -1, -2));
        this.jPanelNodes3.setBackground(new Color(245, 245, 245));
        this.jPanelNodes3.setBorder(BorderFactory.createTitledBorder(null, "Line type", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelNodes3.setPreferredSize(new Dimension(332, 74));
        this.jPanel31.setMinimumSize(new Dimension(0, 0));
        this.jPanel31.setLayout(new GridLayout(1, 0, 2, 0));
        this.NodeLineSolid.setFont(new Font("SansSerif", 0, 12));
        this.NodeLineSolid.setText("----");
        this.NodeLineSolid.setToolTipText("Solid line");
        this.NodeLineSolid.setIconTextGap(0);
        this.NodeLineSolid.setMaximumSize(new Dimension(110, 35));
        this.NodeLineSolid.setMinimumSize(new Dimension(30, 20));
        this.NodeLineSolid.setPreferredSize(new Dimension(60, 30));
        this.NodeLineSolid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.NodeLineSolidActionPerformed(evt);
            }
        });
        this.jPanel31.add(this.NodeLineSolid);
        this.NodeLineDotted.setFont(new Font("SansSerif", 0, 12));
        this.NodeLineDotted.setText("---");
        this.NodeLineDotted.setToolTipText("Dotted line");
        this.NodeLineDotted.setMaximumSize(new Dimension(110, 35));
        this.NodeLineDotted.setMinimumSize(new Dimension(30, 20));
        this.NodeLineDotted.setPreferredSize(new Dimension(60, 30));
        this.NodeLineDotted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.NodeLineDottedActionPerformed(evt);
            }
        });
        this.jPanel31.add(this.NodeLineDotted);
        this.NodeLineDashed.setFont(new Font("SansSerif", 0, 12));
        this.NodeLineDashed.setText("----");
        this.NodeLineDashed.setToolTipText(" Dashed line");
        this.NodeLineDashed.setMaximumSize(new Dimension(110, 35));
        this.NodeLineDashed.setMinimumSize(new Dimension(30, 20));
        this.NodeLineDashed.setPreferredSize(new Dimension(60, 30));
        this.NodeLineDashed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.NodeLineDashedActionPerformed(evt);
            }
        });
        this.jPanel31.add(this.NodeLineDashed);
        this.NodeLineDashedLong.setFont(new Font("SansSerif", 0, 12));
        this.NodeLineDashedLong.setText("---");
        this.NodeLineDashedLong.setToolTipText("Long-dashed line");
        this.NodeLineDashedLong.setMaximumSize(new Dimension(110, 35));
        this.NodeLineDashedLong.setMinimumSize(new Dimension(30, 20));
        this.NodeLineDashedLong.setPreferredSize(new Dimension(60, 30));
        this.NodeLineDashedLong.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.NodeLineDashedLongActionPerformed(evt);
            }
        });
        this.jPanel31.add(this.NodeLineDashedLong);
        GroupLayout jPanelNodes3Layout = new GroupLayout(this.jPanelNodes3);
        this.jPanelNodes3.setLayout(jPanelNodes3Layout);
        jPanelNodes3Layout.setHorizontalGroup(jPanelNodes3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodes3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel31, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelNodes3Layout.setVerticalGroup(jPanelNodes3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodes3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jPanel31, -2, -1, -2).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanelNodes4.setBackground(new Color(245, 245, 245));
        this.jPanelNodes4.setBorder(BorderFactory.createTitledBorder(null, "Other attributes", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelNodes4.setPreferredSize(new Dimension(332, 90));
        this.jSpinnerNodeSize.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerNodeSize.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), null, Float.valueOf(0.1f)));
        this.jSpinnerNodeSize.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerNodeSize.setPreferredSize(new Dimension(75, 26));
        this.jSpinnerNodeSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerNodeSizeStateChanged(evt);
            }
        });
        this.jSpinnerNodeSize.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerNodeSizeKeyPressed(evt);
            }
        });
        this.jSpinnerNodeLineWidth.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerNodeLineWidth.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), null, Float.valueOf(0.1f)));
        this.jSpinnerNodeLineWidth.setMinimumSize(new Dimension(75, 25));
        this.jSpinnerNodeLineWidth.setPreferredSize(new Dimension(75, 26));
        this.jSpinnerNodeLineWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerNodeLineWidthStateChanged(evt);
            }
        });
        this.jSpinnerNodeLineWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerNodeLineWidthKeyPressed(evt);
            }
        });
        this.jCheckBoxScaleNodes.setBackground(new Color(245, 245, 245));
        this.jCheckBoxScaleNodes.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxScaleNodes.setText("rescale");
        this.jCheckBoxScaleNodes.setHorizontalAlignment(4);
        this.jCheckBoxScaleNodes.setPreferredSize(new Dimension(68, 26));
        this.jCheckBoxScaleNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxScaleNodesActionPerformed(evt);
            }
        });
        this.jCheckBoxScaleNodeLines.setBackground(new Color(245, 245, 245));
        this.jCheckBoxScaleNodeLines.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxScaleNodeLines.setText("rescale");
        this.jCheckBoxScaleNodeLines.setHorizontalAlignment(4);
        this.jCheckBoxScaleNodeLines.setPreferredSize(new Dimension(68, 26));
        this.jCheckBoxScaleNodeLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxScaleNodeLinesActionPerformed(evt);
            }
        });
        this.jLabelSize.setBackground(new Color(245, 245, 245));
        this.jLabelSize.setFont(new Font("SansSerif", 0, 11));
        this.jLabelSize.setText("Node size (>=0):");
        this.jLabelSize.setPreferredSize(new Dimension(59, 26));
        this.jLabelLineWith.setBackground(new Color(245, 245, 245));
        this.jLabelLineWith.setFont(new Font("SansSerif", 0, 11));
        this.jLabelLineWith.setText("Line width (>=0):");
        this.jLabelLineWith.setPreferredSize(new Dimension(61, 26));
        GroupLayout jPanelNodes4Layout = new GroupLayout(this.jPanelNodes4);
        this.jPanelNodes4.setLayout(jPanelNodes4Layout);
        jPanelNodes4Layout.setHorizontalGroup(jPanelNodes4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelNodes4Layout.createSequentialGroup().addContainerGap().addGroup(jPanelNodes4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSize, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelLineWith, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNodes4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxScaleNodes, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxScaleNodeLines, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNodes4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerNodeLineWidth, GroupLayout.Alignment.TRAILING, -2, 75, -2).addComponent(this.jSpinnerNodeSize, GroupLayout.Alignment.TRAILING, -2, 75, -2)).addContainerGap()));
        jPanelNodes4Layout.linkSize(0, this.jSpinnerNodeLineWidth, this.jSpinnerNodeSize);
        jPanelNodes4Layout.setVerticalGroup(jPanelNodes4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodes4Layout.createSequentialGroup().addGroup(jPanelNodes4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelSize, -2, -1, -2).addComponent(this.jCheckBoxScaleNodes, -2, -1, -2).addComponent(this.jSpinnerNodeSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNodes4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jSpinnerNodeLineWidth, -2, -1, -2).addComponent(this.jCheckBoxScaleNodeLines, -2, -1, -2).addComponent(this.jLabelLineWith, -2, -1, -2)).addContainerGap(10, Short.MAX_VALUE)));
        ((JSpinner.DefaultEditor)this.jSpinnerNodeSize.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerNodeSizeKeyPressed(evt);
            }
        });
        ((JSpinner.DefaultEditor)this.jSpinnerNodeLineWidth.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerNodeLineWidthKeyPressed(evt);
            }
        });
        this.jPanelNodes5.setBackground(new Color(245, 245, 245));
        this.jPanelNodes5.setBorder(BorderFactory.createTitledBorder(null, "Fill color", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelNodes5.setPreferredSize(new Dimension(333, 90));
        this.jPanelNodeFillColorView.setBackground(Color.white);
        this.jPanelNodeFillColorView.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.jPanelNodeFillColorView.setMinimumSize(new Dimension(0, 0));
        this.jPanelNodeFillColorView.setPreferredSize(new Dimension(152, 61));
        GroupLayout jPanelNodeFillColorViewLayout = new GroupLayout(this.jPanelNodeFillColorView);
        this.jPanelNodeFillColorView.setLayout(jPanelNodeFillColorViewLayout);
        jPanelNodeFillColorViewLayout.setHorizontalGroup(jPanelNodeFillColorViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelNodeFillColorViewLayout.setVerticalGroup(jPanelNodeFillColorViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 59, Short.MAX_VALUE));
        this.jFormattedTextFieldHexaNodeFill.setForeground(Color.magenta);
        try {
            this.jFormattedTextFieldHexaNodeFill.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("HHHHHHHH")));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.jFormattedTextFieldHexaNodeFill.setHorizontalAlignment(0);
        this.jFormattedTextFieldHexaNodeFill.setText("FFFFFFFF");
        this.jFormattedTextFieldHexaNodeFill.setToolTipText("Hexadecimal color code");
        this.jFormattedTextFieldHexaNodeFill.setFont(new Font("SansSerif", 0, 13));
        this.jFormattedTextFieldHexaNodeFill.setMinimumSize(new Dimension(70, 28));
        this.jFormattedTextFieldHexaNodeFill.setPreferredSize(new Dimension(140, 28));
        this.jFormattedTextFieldHexaNodeFill.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jFormattedTextFieldHexaNodeFillKeyPressed(evt);
            }
        });
        this.jButtonNodeFillColorPicker.setFont(new Font("SansSerif", 0, 13));
        this.jButtonNodeFillColorPicker.setText("Color picker");
        this.jButtonNodeFillColorPicker.setPreferredSize(new Dimension(140, 27));
        this.jButtonNodeFillColorPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonNodeFillColorPickerActionPerformed(evt);
            }
        });
        GroupLayout jPanelNodes5Layout = new GroupLayout(this.jPanelNodes5);
        this.jPanelNodes5.setLayout(jPanelNodes5Layout);
        jPanelNodes5Layout.setHorizontalGroup(jPanelNodes5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelNodes5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelNodeFillColorView, -1, 176, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNodes5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFormattedTextFieldHexaNodeFill, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonNodeFillColorPicker, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelNodes5Layout.setVerticalGroup(jPanelNodes5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodes5Layout.createSequentialGroup().addGroup(jPanelNodes5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelNodeFillColorView, -2, -1, -2).addGroup(jPanelNodes5Layout.createSequentialGroup().addComponent(this.jFormattedTextFieldHexaNodeFill, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodeFillColorPicker, -2, -1, -2))).addContainerGap()));
        this.jPanelNodes6.setBackground(new Color(245, 245, 245));
        this.jPanelNodes6.setBorder(BorderFactory.createTitledBorder(null, "Line color", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelNodes6.setPreferredSize(new Dimension(332, 90));
        this.jPanelNodeLineColorView.setBackground(new Color(147, 147, 172));
        this.jPanelNodeLineColorView.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.jPanelNodeLineColorView.setPreferredSize(new Dimension(152, 61));
        GroupLayout jPanelNodeLineColorViewLayout = new GroupLayout(this.jPanelNodeLineColorView);
        this.jPanelNodeLineColorView.setLayout(jPanelNodeLineColorViewLayout);
        jPanelNodeLineColorViewLayout.setHorizontalGroup(jPanelNodeLineColorViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelNodeLineColorViewLayout.setVerticalGroup(jPanelNodeLineColorViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 59, Short.MAX_VALUE));
        this.jButtonNodeLineColorPicker.setFont(new Font("SansSerif", 0, 13));
        this.jButtonNodeLineColorPicker.setText("Color picker");
        this.jButtonNodeLineColorPicker.setPreferredSize(new Dimension(140, 27));
        this.jButtonNodeLineColorPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonNodeLineColorPickerActionPerformed(evt);
            }
        });
        this.jFormattedTextFieldHexaNodeLine.setForeground(Color.magenta);
        try {
            this.jFormattedTextFieldHexaNodeLine.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("HHHHHHHH")));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.jFormattedTextFieldHexaNodeLine.setHorizontalAlignment(0);
        this.jFormattedTextFieldHexaNodeLine.setText("9393ACFF");
        this.jFormattedTextFieldHexaNodeLine.setToolTipText("Hexadecimal color code");
        this.jFormattedTextFieldHexaNodeLine.setFont(new Font("SansSerif", 0, 13));
        this.jFormattedTextFieldHexaNodeLine.setMinimumSize(new Dimension(70, 28));
        this.jFormattedTextFieldHexaNodeLine.setPreferredSize(new Dimension(140, 28));
        this.jFormattedTextFieldHexaNodeLine.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jFormattedTextFieldHexaNodeLineKeyPressed(evt);
            }
        });
        GroupLayout jPanelNodes6Layout = new GroupLayout(this.jPanelNodes6);
        this.jPanelNodes6.setLayout(jPanelNodes6Layout);
        jPanelNodes6Layout.setHorizontalGroup(jPanelNodes6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodes6Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelNodeLineColorView, -1, 176, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNodes6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFormattedTextFieldHexaNodeLine, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonNodeLineColorPicker, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelNodes6Layout.setVerticalGroup(jPanelNodes6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelNodes6Layout.createSequentialGroup().addGroup(jPanelNodes6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelNodes6Layout.createSequentialGroup().addComponent(this.jFormattedTextFieldHexaNodeLine, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodeLineColorPicker, -2, -1, -2)).addComponent(this.jPanelNodeLineColorView, -2, -1, -2)).addContainerGap()));
        GroupLayout jPanelJtabbedNodesLayout = new GroupLayout(this.jPanelJtabbedNodes);
        this.jPanelJtabbedNodes.setLayout(jPanelJtabbedNodesLayout);
        jPanelJtabbedNodesLayout.setHorizontalGroup(jPanelJtabbedNodesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelJtabbedNodesLayout.createSequentialGroup().addGroup(jPanelJtabbedNodesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel21, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelNodes6, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelNodes5, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelNodes4, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelNodes3, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelNodes2, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelNodes1, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE)).addContainerGap()));
        jPanelJtabbedNodesLayout.setVerticalGroup(jPanelJtabbedNodesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelJtabbedNodesLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel21, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelNodes1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelNodes2, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelNodes3, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelNodes4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelNodes5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelNodes6, -2, -1, -2).addContainerGap(141, Short.MAX_VALUE)));
        this.jScrollPaneNodes.setViewportView(this.jPanelJtabbedNodes);
        this.jTabbedPaneAttribs.addTab("Nodes", this.jScrollPaneNodes);
        this.jScrollPaneEdges.setBorder(null);
        this.jScrollPaneEdges.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneEdges.setVerticalScrollBarPolicy(22);
        this.jScrollPaneEdges.setPreferredSize(new Dimension(355, 693));
        this.jScrollPaneEdges.setViewportView(null);
        this.jPanelJtabbedEdges.setBackground(new Color(245, 245, 245));
        this.jLabel22.setBackground(new Color(245, 245, 245));
        this.jLabel22.setFont(new Font("SansSerif", 1, 15));
        this.jLabel22.setHorizontalAlignment(0);
        this.jLabel22.setText("Edge Attributes");
        this.jLabel22.setMaximumSize(new Dimension(Short.MAX_VALUE, 18));
        this.jLabel22.setPreferredSize(new Dimension(332, 18));
        this.jPanelEdges1.setBackground(new Color(245, 245, 245));
        this.jPanelEdges1.setBorder(BorderFactory.createTitledBorder(null, "Edge type", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelEdges1.setPreferredSize(new Dimension(332, 74));
        this.jPanel29.setMinimumSize(new Dimension(0, 0));
        this.jPanel29.setLayout(new GridLayout(1, 0, 2, 0));
        this.EdgeLineSolid.setFont(new Font("SansSerif", 0, 12));
        this.EdgeLineSolid.setText("---");
        this.EdgeLineSolid.setToolTipText(" Solid line");
        this.EdgeLineSolid.setMaximumSize(new Dimension(110, 35));
        this.EdgeLineSolid.setMinimumSize(new Dimension(30, 20));
        this.EdgeLineSolid.setPreferredSize(new Dimension(60, 30));
        this.EdgeLineSolid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.EdgeLineSolidActionPerformed(evt);
            }
        });
        this.jPanel29.add(this.EdgeLineSolid);
        this.EdgeLineDotted.setFont(new Font("SansSerif", 0, 12));
        this.EdgeLineDotted.setText("---");
        this.EdgeLineDotted.setToolTipText("Dotted line");
        this.EdgeLineDotted.setMaximumSize(new Dimension(110, 35));
        this.EdgeLineDotted.setMinimumSize(new Dimension(30, 20));
        this.EdgeLineDotted.setPreferredSize(new Dimension(60, 30));
        this.EdgeLineDotted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.EdgeLineDottedActionPerformed(evt);
            }
        });
        this.jPanel29.add(this.EdgeLineDotted);
        this.EdgeLineDashed.setFont(new Font("SansSerif", 0, 12));
        this.EdgeLineDashed.setText("---");
        this.EdgeLineDashed.setToolTipText("Dashed line");
        this.EdgeLineDashed.setMaximumSize(new Dimension(110, 35));
        this.EdgeLineDashed.setMinimumSize(new Dimension(30, 20));
        this.EdgeLineDashed.setPreferredSize(new Dimension(60, 30));
        this.EdgeLineDashed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.EdgeLineDashedActionPerformed(evt);
            }
        });
        this.jPanel29.add(this.EdgeLineDashed);
        this.EdgeLineDashedLong.setFont(new Font("SansSerif", 0, 12));
        this.EdgeLineDashedLong.setText("---");
        this.EdgeLineDashedLong.setToolTipText("Long-dashed line");
        this.EdgeLineDashedLong.setMaximumSize(new Dimension(110, 35));
        this.EdgeLineDashedLong.setMinimumSize(new Dimension(30, 20));
        this.EdgeLineDashedLong.setPreferredSize(new Dimension(60, 30));
        this.EdgeLineDashedLong.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.EdgeLineDashedLongActionPerformed(evt);
            }
        });
        this.jPanel29.add(this.EdgeLineDashedLong);
        GroupLayout jPanelEdges1Layout = new GroupLayout(this.jPanelEdges1);
        this.jPanelEdges1.setLayout(jPanelEdges1Layout);
        jPanelEdges1Layout.setHorizontalGroup(jPanelEdges1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEdges1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel29, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelEdges1Layout.setVerticalGroup(jPanelEdges1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEdges1Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jPanel29, -2, -1, -2).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanelEdges2.setBackground(new Color(245, 245, 245));
        this.jPanelEdges2.setBorder(BorderFactory.createTitledBorder(null, "Arrow direction", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelEdges2.setPreferredSize(new Dimension(332, 146));
        this.jPanel27.setBackground(new Color(245, 245, 245));
        this.jPanel27.setMinimumSize(new Dimension(0, 0));
        this.jPanel27.setLayout(new GridBagLayout());
        this.jButtonArrow6.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow6.setText("A --| B");
        this.jButtonArrow6.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow6ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 6, 0, 0);
        this.jPanel27.add((Component)this.jButtonArrow6, gridBagConstraints);
        this.jButtonArrow3.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow3.setText("A |-> B");
        this.jButtonArrow3.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 6, 0, 0);
        this.jPanel27.add((Component)this.jButtonArrow3, gridBagConstraints);
        this.jButtonArrow0.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow0.setText("A --- B");
        this.jButtonArrow0.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow0ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        this.jPanel27.add((Component)this.jButtonArrow0, gridBagConstraints);
        this.jButtonArrow1.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow1.setText("A --> B");
        this.jButtonArrow1.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel27.add((Component)this.jButtonArrow1, gridBagConstraints);
        this.jButtonArrow2.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow2.setText("A <-- B");
        this.jButtonArrow2.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel27.add((Component)this.jButtonArrow2, gridBagConstraints);
        this.jButtonArrow4.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow4.setText("A <-| B");
        this.jButtonArrow4.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel27.add((Component)this.jButtonArrow4, gridBagConstraints);
        this.jButtonArrow5.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow5.setText("A <-> B");
        this.jButtonArrow5.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel27.add((Component)this.jButtonArrow5, gridBagConstraints);
        this.jButtonArrow7.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow7.setText("A |-- B");
        this.jButtonArrow7.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow7ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel27.add((Component)this.jButtonArrow7, gridBagConstraints);
        this.jButtonArrow8.setFont(new Font("Monospaced", 0, 10));
        this.jButtonArrow8.setText("A |-| B");
        this.jButtonArrow8.setPreferredSize(new Dimension(75, 23));
        this.jButtonArrow8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonArrow8ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel27.add((Component)this.jButtonArrow8, gridBagConstraints);
        GroupLayout jPanelEdges2Layout = new GroupLayout(this.jPanelEdges2);
        this.jPanelEdges2.setLayout(jPanelEdges2Layout);
        jPanelEdges2Layout.setHorizontalGroup(jPanelEdges2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel27, -1, -1, Short.MAX_VALUE));
        jPanelEdges2Layout.setVerticalGroup(jPanelEdges2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel27, -1, 118, Short.MAX_VALUE));
        this.jPanelEdges3.setBackground(new Color(245, 245, 245));
        this.jPanelEdges3.setBorder(BorderFactory.createTitledBorder(null, "Other attributes", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelEdges3.setPreferredSize(new Dimension(332, 140));
        this.jSpinnerEdgeWidth.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerEdgeWidth.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), null, Float.valueOf(0.1f)));
        this.jSpinnerEdgeWidth.setMinimumSize(new Dimension(52, 26));
        this.jSpinnerEdgeWidth.setPreferredSize(new Dimension(73, 26));
        this.jSpinnerEdgeWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerEdgeWidthStateChanged(evt);
            }
        });
        this.jSpinnerEdgeWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerEdgeWidthKeyPressed(evt);
            }
        });
        this.jSpinnerArrowLength.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerArrowLength.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), null, Float.valueOf(0.1f)));
        this.jSpinnerArrowLength.setMinimumSize(new Dimension(52, 26));
        this.jSpinnerArrowLength.setPreferredSize(new Dimension(73, 26));
        this.jSpinnerArrowLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerArrowLengthStateChanged(evt);
            }
        });
        this.jSpinnerArrowLength.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerArrowLengthKeyPressed(evt);
            }
        });
        this.jSpinnerArrowAngle.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerArrowAngle.setModel(new SpinnerNumberModel(Float.valueOf(30.0f), Float.valueOf(0.0f), Float.valueOf(90.0f), Float.valueOf(0.1f)));
        this.jSpinnerArrowAngle.setMinimumSize(new Dimension(63, 26));
        this.jSpinnerArrowAngle.setPreferredSize(new Dimension(73, 26));
        this.jSpinnerArrowAngle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerArrowAngleStateChanged(evt);
            }
        });
        this.jSpinnerArrowAngle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerArrowAngleKeyPressed(evt);
            }
        });
        this.jCheckBoxScaleEdgeWidth.setBackground(new Color(245, 245, 245));
        this.jCheckBoxScaleEdgeWidth.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxScaleEdgeWidth.setText("rescale");
        this.jCheckBoxScaleEdgeWidth.setHorizontalAlignment(4);
        this.jCheckBoxScaleEdgeWidth.setMaximumSize(new Dimension(68, 28));
        this.jCheckBoxScaleEdgeWidth.setPreferredSize(new Dimension(68, 26));
        this.jCheckBoxScaleEdgeWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxScaleEdgeWidthActionPerformed(evt);
            }
        });
        this.jCheckBoxScaleArrowLen.setBackground(new Color(245, 245, 245));
        this.jCheckBoxScaleArrowLen.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxScaleArrowLen.setText("rescale");
        this.jCheckBoxScaleArrowLen.setHorizontalAlignment(4);
        this.jCheckBoxScaleArrowLen.setMaximumSize(new Dimension(68, 28));
        this.jCheckBoxScaleArrowLen.setPreferredSize(new Dimension(68, 26));
        this.jCheckBoxScaleArrowLen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxScaleArrowLenActionPerformed(evt);
            }
        });
        this.jCheckBoxScaleArrowAngle.setBackground(new Color(245, 245, 245));
        this.jCheckBoxScaleArrowAngle.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxScaleArrowAngle.setText("rescale");
        this.jCheckBoxScaleArrowAngle.setHorizontalAlignment(4);
        this.jCheckBoxScaleArrowAngle.setMaximumSize(new Dimension(68, 28));
        this.jCheckBoxScaleArrowAngle.setPreferredSize(new Dimension(68, 26));
        this.jCheckBoxScaleArrowAngle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxScaleArrowAngleActionPerformed(evt);
            }
        });
        this.jLabel24.setBackground(new Color(245, 245, 245));
        this.jLabel24.setFont(new Font("SansSerif", 0, 11));
        this.jLabel24.setText("Edge width (>=0):");
        this.jLabel24.setMaximumSize(new Dimension(94, 28));
        this.jLabel24.setPreferredSize(new Dimension(94, 26));
        this.jLabel25.setBackground(new Color(245, 245, 245));
        this.jLabel25.setFont(new Font("SansSerif", 0, 11));
        this.jLabel25.setText("Arrow length (>=0):");
        this.jLabel25.setMaximumSize(new Dimension(104, 28));
        this.jLabel25.setPreferredSize(new Dimension(104, 26));
        this.jLabel26.setBackground(new Color(245, 245, 245));
        this.jLabel26.setFont(new Font("SansSerif", 0, 11));
        this.jLabel26.setText("Arrow angle (10-90):");
        this.jLabel26.setMaximumSize(new Dimension(116, 28));
        this.jLabel26.setPreferredSize(new Dimension(116, 26));
        this.jSpinnerEdgeWeight.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerEdgeWeight.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jSpinnerEdgeWeight.setMinimumSize(new Dimension(52, 26));
        this.jSpinnerEdgeWeight.setPreferredSize(new Dimension(73, 26));
        this.jSpinnerEdgeWeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerEdgeWeightStateChanged(evt);
            }
        });
        this.jSpinnerEdgeWeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerEdgeWeightKeyPressed(evt);
            }
        });
        this.jCheckBoxScaleEdgeWeight.setBackground(new Color(245, 245, 245));
        this.jCheckBoxScaleEdgeWeight.setFont(new Font("SansSerif", 0, 11));
        this.jCheckBoxScaleEdgeWeight.setText("rescale");
        this.jCheckBoxScaleEdgeWeight.setHorizontalAlignment(4);
        this.jCheckBoxScaleEdgeWeight.setMaximumSize(new Dimension(68, 28));
        this.jCheckBoxScaleEdgeWeight.setPreferredSize(new Dimension(68, 26));
        this.jCheckBoxScaleEdgeWeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxScaleEdgeWeightActionPerformed(evt);
            }
        });
        this.jLabel29.setBackground(new Color(245, 245, 245));
        this.jLabel29.setFont(new Font("SansSerif", 0, 11));
        this.jLabel29.setText("Edge weight (>=0):");
        this.jLabel29.setMaximumSize(new Dimension(116, 28));
        this.jLabel29.setPreferredSize(new Dimension(116, 26));
        GroupLayout jPanelEdges3Layout = new GroupLayout(this.jPanelEdges3);
        this.jPanelEdges3.setLayout(jPanelEdges3Layout);
        jPanelEdges3Layout.setHorizontalGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEdges3Layout.createSequentialGroup().addContainerGap().addGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel26, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel25, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel24, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel29, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBoxScaleArrowAngle, -2, 88, -2).addComponent(this.jCheckBoxScaleEdgeWidth, GroupLayout.Alignment.LEADING, -2, 88, -2).addComponent(this.jCheckBoxScaleArrowLen, GroupLayout.Alignment.LEADING, -2, 88, -2).addComponent(this.jCheckBoxScaleEdgeWeight, -2, 88, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerArrowLength, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerEdgeWidth, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerArrowAngle, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerEdgeWeight, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap()));
        jPanelEdges3Layout.setVerticalGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEdges3Layout.createSequentialGroup().addGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel24, -2, -1, -2).addComponent(this.jCheckBoxScaleEdgeWidth, -2, 25, -2).addComponent(this.jSpinnerEdgeWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel29, -2, -1, -2).addComponent(this.jCheckBoxScaleEdgeWeight, -2, 28, -2).addComponent(this.jSpinnerEdgeWeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel25, -2, -1, -2).addComponent(this.jCheckBoxScaleArrowLen, -2, 28, -2).addComponent(this.jSpinnerArrowLength, -2, -1, -2)).addGap(5, 5, 5).addGroup(jPanelEdges3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel26, -2, -1, -2).addComponent(this.jCheckBoxScaleArrowAngle, -2, 28, -2).addComponent(this.jSpinnerArrowAngle, -2, -1, -2)).addContainerGap(8, Short.MAX_VALUE)));
        ((JSpinner.DefaultEditor)this.jSpinnerEdgeWidth.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerEdgeWidthKeyPressed(evt);
            }
        });
        ((JSpinner.DefaultEditor)this.jSpinnerArrowLength.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerArrowLengthKeyPressed(evt);
            }
        });
        ((JSpinner.DefaultEditor)this.jSpinnerArrowAngle.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerArrowAngleKeyPressed(evt);
            }
        });
        ((JSpinner.DefaultEditor)this.jSpinnerArrowAngle.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerArrowAngleKeyPressed(evt);
            }
        });
        this.jPanelEdges4.setBackground(new Color(245, 245, 245));
        this.jPanelEdges4.setBorder(BorderFactory.createTitledBorder(null, "Line color", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelEdges4.setPreferredSize(new Dimension(332, 90));
        this.jPanelEdgeLineColorView.setBackground(new Color(147, 147, 172));
        this.jPanelEdgeLineColorView.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.jPanelEdgeLineColorView.setPreferredSize(new Dimension(152, 61));
        GroupLayout jPanelEdgeLineColorViewLayout = new GroupLayout(this.jPanelEdgeLineColorView);
        this.jPanelEdgeLineColorView.setLayout(jPanelEdgeLineColorViewLayout);
        jPanelEdgeLineColorViewLayout.setHorizontalGroup(jPanelEdgeLineColorViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelEdgeLineColorViewLayout.setVerticalGroup(jPanelEdgeLineColorViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 59, Short.MAX_VALUE));
        this.jButtonEdgeLineColorPicker.setFont(new Font("SansSerif", 0, 13));
        this.jButtonEdgeLineColorPicker.setText("Color picker");
        this.jButtonEdgeLineColorPicker.setPreferredSize(new Dimension(140, 27));
        this.jButtonEdgeLineColorPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonEdgeLineColorPickerActionPerformed(evt);
            }
        });
        this.jFormattedTextFieldHexaEdgeLine.setForeground(Color.magenta);
        try {
            this.jFormattedTextFieldHexaEdgeLine.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("HHHHHHHH")));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.jFormattedTextFieldHexaEdgeLine.setHorizontalAlignment(0);
        this.jFormattedTextFieldHexaEdgeLine.setText("9393ACFF");
        this.jFormattedTextFieldHexaEdgeLine.setToolTipText("Hexadecimal color code");
        this.jFormattedTextFieldHexaEdgeLine.setFont(new Font("SansSerif", 0, 13));
        this.jFormattedTextFieldHexaEdgeLine.setMinimumSize(new Dimension(70, 28));
        this.jFormattedTextFieldHexaEdgeLine.setPreferredSize(new Dimension(140, 28));
        this.jFormattedTextFieldHexaEdgeLine.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jFormattedTextFieldHexaEdgeLineKeyPressed(evt);
            }
        });
        GroupLayout jPanelEdges4Layout = new GroupLayout(this.jPanelEdges4);
        this.jPanelEdges4.setLayout(jPanelEdges4Layout);
        jPanelEdges4Layout.setHorizontalGroup(jPanelEdges4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEdges4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelEdgeLineColorView, -1, 176, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEdges4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFormattedTextFieldHexaEdgeLine, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdgeLineColorPicker, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelEdges4Layout.setVerticalGroup(jPanelEdges4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEdges4Layout.createSequentialGroup().addGroup(jPanelEdges4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEdges4Layout.createSequentialGroup().addComponent(this.jFormattedTextFieldHexaEdgeLine, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdgeLineColorPicker, -2, -1, -2)).addComponent(this.jPanelEdgeLineColorView, -2, -1, -2)).addContainerGap()));
        GroupLayout jPanelJtabbedEdgesLayout = new GroupLayout(this.jPanelJtabbedEdges);
        this.jPanelJtabbedEdges.setLayout(jPanelJtabbedEdgesLayout);
        jPanelJtabbedEdgesLayout.setHorizontalGroup(jPanelJtabbedEdgesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelJtabbedEdgesLayout.createSequentialGroup().addGroup(jPanelJtabbedEdgesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel22, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelEdges4, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelEdges3, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelEdges1, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelEdges2, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE)).addContainerGap()));
        jPanelJtabbedEdgesLayout.setVerticalGroup(jPanelJtabbedEdgesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelJtabbedEdgesLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel22, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelEdges2, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelEdges1, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelEdges3, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelEdges4, -2, -1, -2).addContainerGap(188, Short.MAX_VALUE)));
        this.jScrollPaneEdges.setViewportView(this.jPanelJtabbedEdges);
        this.jTabbedPaneAttribs.addTab("Edges", this.jScrollPaneEdges);
        this.jScrollPaneLabels.setBorder(null);
        this.jScrollPaneLabels.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneLabels.setVerticalScrollBarPolicy(22);
        this.jScrollPaneLabels.setPreferredSize(new Dimension(355, 693));
        this.jScrollPaneLabels.setViewportView(null);
        this.jPanelJtabbedLabels.setBackground(new Color(245, 245, 245));
        this.jLabel23.setBackground(new Color(245, 245, 245));
        this.jLabel23.setFont(new Font("SansSerif", 1, 15));
        this.jLabel23.setHorizontalAlignment(0);
        this.jLabel23.setText("Label Attributes");
        this.jLabel23.setMaximumSize(new Dimension(Short.MAX_VALUE, 18));
        this.jLabel23.setPreferredSize(new Dimension(332, 18));
        this.jPanelLabels1.setBackground(new Color(245, 245, 245));
        this.jPanelLabels1.setBorder(BorderFactory.createTitledBorder(null, "Font size, style, and name", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelLabels1.setPreferredSize(new Dimension(332, 109));
        this.jSpinnerFontSize.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerFontSize.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jSpinnerFontSize.setMinimumSize(new Dimension(52, 28));
        this.jSpinnerFontSize.setPreferredSize(new Dimension(90, 28));
        this.jSpinnerFontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerFontSizeStateChanged(evt);
            }
        });
        this.jSpinnerFontSize.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerFontSizeKeyPressed(evt);
            }
        });
        this.jComboBoxFontStyle.setFont(new Font("SansSerif", 0, 12));
        this.jComboBoxFontStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Plain", "Bold", "Italic", "Bold.Italic"}));
        this.jComboBoxFontStyle.setMinimumSize(new Dimension(114, 28));
        this.jComboBoxFontStyle.setPreferredSize(new Dimension(202, 28));
        this.jComboBoxFontStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jComboBoxFontStyleActionPerformed(evt);
            }
        });
        this.jComboBoxFontType.setFont(new Font("SansSerif", 0, 12));
        this.jComboBoxFontType.setMinimumSize(new Dimension(58, 28));
        this.jComboBoxFontType.setPreferredSize(new Dimension(304, 28));
        this.jComboBoxFontType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jComboBoxFontTypeActionPerformed(evt);
            }
        });
        GroupLayout jPanelLabels1Layout = new GroupLayout(this.jPanelLabels1);
        this.jPanelLabels1.setLayout(jPanelLabels1Layout);
        jPanelLabels1Layout.setHorizontalGroup(jPanelLabels1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLabels1Layout.createSequentialGroup().addContainerGap().addGroup(jPanelLabels1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxFontType, 0, 0, Short.MAX_VALUE).addGroup(jPanelLabels1Layout.createSequentialGroup().addComponent(this.jSpinnerFontSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxFontStyle, 0, 1, Short.MAX_VALUE))).addContainerGap()));
        jPanelLabels1Layout.setVerticalGroup(jPanelLabels1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLabels1Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanelLabels1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxFontStyle, -1, -1, Short.MAX_VALUE).addComponent(this.jSpinnerFontSize, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFontType, -2, -1, -2).addContainerGap(11, Short.MAX_VALUE)));
        jPanelLabels1Layout.linkSize(1, this.jComboBoxFontStyle, this.jComboBoxFontType, this.jSpinnerFontSize);
        ((JSpinner.DefaultEditor)this.jSpinnerFontSize.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerFontSizeKeyPressed(evt);
            }
        });
        this.jPanelLabels2.setBackground(new Color(245, 245, 245));
        this.jPanelLabels2.setBorder(BorderFactory.createTitledBorder(null, "Alignment", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelLabels2.setPreferredSize(new Dimension(332, 108));
        this.jPanel14.setBackground(new Color(245, 245, 245));
        this.jPanel14.setMinimumSize(new Dimension(100, 35));
        this.jPanel14.setPreferredSize(new Dimension(160, 30));
        this.jPanel14.setLayout(new GridLayout(1, 0));
        this.jButtonLabelLeft.setFont(new Font("SansSerif", 0, 13));
        this.jButtonLabelLeft.setText("L");
        this.jButtonLabelLeft.setToolTipText("Left");
        this.jButtonLabelLeft.setMaximumSize(new Dimension(100, 27));
        this.jButtonLabelLeft.setMinimumSize(new Dimension(40, 27));
        this.jButtonLabelLeft.setPreferredSize(new Dimension(45, 30));
        this.jButtonLabelLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonLabelLeftActionPerformed(evt);
            }
        });
        this.jPanel14.add(this.jButtonLabelLeft);
        this.jButtonLabelCenter.setFont(new Font("SansSerif", 0, 13));
        this.jButtonLabelCenter.setText("CX");
        this.jButtonLabelCenter.setToolTipText("Center");
        this.jButtonLabelCenter.setMaximumSize(new Dimension(100, 27));
        this.jButtonLabelCenter.setMinimumSize(new Dimension(40, 27));
        this.jButtonLabelCenter.setPreferredSize(new Dimension(45, 30));
        this.jButtonLabelCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonLabelCenterActionPerformed(evt);
            }
        });
        this.jPanel14.add(this.jButtonLabelCenter);
        this.jButtonLabelRight.setFont(new Font("SansSerif", 0, 13));
        this.jButtonLabelRight.setText("R");
        this.jButtonLabelRight.setToolTipText("Right");
        this.jButtonLabelRight.setMaximumSize(new Dimension(100, 27));
        this.jButtonLabelRight.setMinimumSize(new Dimension(40, 27));
        this.jButtonLabelRight.setPreferredSize(new Dimension(45, 30));
        this.jButtonLabelRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonLabelRightActionPerformed(evt);
            }
        });
        this.jPanel14.add(this.jButtonLabelRight);
        this.jPanel13.setBackground(new Color(245, 245, 245));
        this.jPanel13.setMinimumSize(new Dimension(100, 35));
        this.jPanel13.setPreferredSize(new Dimension(160, 30));
        this.jPanel13.setLayout(new GridLayout(1, 0));
        this.jButtonLabelTop.setFont(new Font("SansSerif", 0, 13));
        this.jButtonLabelTop.setText("T");
        this.jButtonLabelTop.setToolTipText("Top");
        this.jButtonLabelTop.setMaximumSize(new Dimension(100, 27));
        this.jButtonLabelTop.setMinimumSize(new Dimension(40, 27));
        this.jButtonLabelTop.setPreferredSize(new Dimension(45, 30));
        this.jButtonLabelTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonLabelTopActionPerformed(evt);
            }
        });
        this.jPanel13.add(this.jButtonLabelTop);
        this.jButtonLabelMiddle.setFont(new Font("SansSerif", 0, 13));
        this.jButtonLabelMiddle.setText("CY");
        this.jButtonLabelMiddle.setToolTipText("Middle");
        this.jButtonLabelMiddle.setMaximumSize(new Dimension(100, 27));
        this.jButtonLabelMiddle.setMinimumSize(new Dimension(40, 27));
        this.jButtonLabelMiddle.setPreferredSize(new Dimension(45, 30));
        this.jButtonLabelMiddle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonLabelMiddleActionPerformed(evt);
            }
        });
        this.jPanel13.add(this.jButtonLabelMiddle);
        this.jButtonLabelBottom.setFont(new Font("SansSerif", 0, 13));
        this.jButtonLabelBottom.setText("B");
        this.jButtonLabelBottom.setToolTipText("Bottom");
        this.jButtonLabelBottom.setMaximumSize(new Dimension(100, 27));
        this.jButtonLabelBottom.setMinimumSize(new Dimension(40, 27));
        this.jButtonLabelBottom.setPreferredSize(new Dimension(45, 30));
        this.jButtonLabelBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonLabelBottomActionPerformed(evt);
            }
        });
        this.jPanel13.add(this.jButtonLabelBottom);
        this.jLabel27.setBackground(new Color(245, 245, 245));
        this.jLabel27.setFont(new Font("SansSerif", 0, 11));
        this.jLabel27.setHorizontalAlignment(4);
        this.jLabel27.setText("Offset X:");
        this.jLabel27.setMaximumSize(new Dimension(90, 14));
        this.jLabel27.setMinimumSize(new Dimension(55, 14));
        this.jLabel27.setPreferredSize(new Dimension(65, 26));
        this.jSpinnerFontOffsetX.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerFontOffsetX.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), null, null, Float.valueOf(1.0f)));
        this.jSpinnerFontOffsetX.setMinimumSize(new Dimension(55, 25));
        this.jSpinnerFontOffsetX.setPreferredSize(new Dimension(70, 26));
        this.jSpinnerFontOffsetX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerFontOffsetXStateChanged(evt);
            }
        });
        this.jSpinnerFontOffsetX.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerFontOffsetXKeyPressed(evt);
            }
        });
        this.jLabel28.setBackground(new Color(245, 245, 245));
        this.jLabel28.setFont(new Font("SansSerif", 0, 11));
        this.jLabel28.setHorizontalAlignment(4);
        this.jLabel28.setText("Offset Y:");
        this.jLabel28.setMaximumSize(new Dimension(90, 14));
        this.jLabel28.setMinimumSize(new Dimension(55, 14));
        this.jLabel28.setPreferredSize(new Dimension(65, 26));
        this.jSpinnerFontOffsetY.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerFontOffsetY.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), null, null, Float.valueOf(1.0f)));
        this.jSpinnerFontOffsetY.setMinimumSize(new Dimension(55, 25));
        this.jSpinnerFontOffsetY.setPreferredSize(new Dimension(70, 26));
        this.jSpinnerFontOffsetY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RederMainFrame.this.jSpinnerFontOffsetYStateChanged(evt);
            }
        });
        this.jSpinnerFontOffsetY.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerFontOffsetYKeyPressed(evt);
            }
        });
        this.jButtonFitNodeToLabel.setFont(new Font("SansSerif", 0, 13));
        this.jButtonFitNodeToLabel.setText("Fit node size to label");
        this.jButtonFitNodeToLabel.setMaximumSize(new Dimension(141, 30));
        this.jButtonFitNodeToLabel.setPreferredSize(new Dimension(141, 28));
        this.jButtonFitNodeToLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonFitNodeToLabelActionPerformed(evt);
            }
        });
        GroupLayout jPanelLabels2Layout = new GroupLayout(this.jPanelLabels2);
        this.jPanelLabels2.setLayout(jPanelLabels2Layout);
        jPanelLabels2Layout.setHorizontalGroup(jPanelLabels2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelLabels2Layout.createSequentialGroup().addContainerGap().addGroup(jPanelLabels2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonFitNodeToLabel, -1, -1, Short.MAX_VALUE).addGroup(jPanelLabels2Layout.createSequentialGroup().addGroup(jPanelLabels2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel14, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel13, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLabels2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel27, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel28, -2, 59, -2)).addGroup(jPanelLabels2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerFontOffsetY, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerFontOffsetX, GroupLayout.Alignment.TRAILING, -2, -1, -2)))).addContainerGap()));
        jPanelLabels2Layout.setVerticalGroup(jPanelLabels2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLabels2Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanelLabels2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jPanel14, -2, -1, -2).addComponent(this.jLabel27, -2, -1, -2).addComponent(this.jSpinnerFontOffsetX, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLabels2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jPanel13, -2, -1, -2).addComponent(this.jLabel28, -2, -1, -2).addComponent(this.jSpinnerFontOffsetY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFitNodeToLabel, -2, -1, -2).addContainerGap(11, Short.MAX_VALUE)));
        ((JSpinner.DefaultEditor)this.jSpinnerFontOffsetX.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerFontOffsetXKeyPressed(evt);
            }
        });
        ((JSpinner.DefaultEditor)this.jSpinnerFontOffsetY.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jSpinnerFontOffsetYKeyPressed(evt);
            }
        });
        this.jPanelLabels3.setBackground(new Color(245, 245, 245));
        this.jPanelLabels3.setBorder(BorderFactory.createTitledBorder(null, "Hide/show labels of selected nodes", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelLabels3.setPreferredSize(new Dimension(332, 67));
        this.jPanel28.setMinimumSize(new Dimension(0, 0));
        this.jButtonHideLabels.setFont(new Font("SansSerif", 0, 13));
        this.jButtonHideLabels.setText("Hide");
        this.jButtonHideLabels.setMaximumSize(new Dimension(44, 27));
        this.jButtonHideLabels.setPreferredSize(new Dimension(145, 28));
        this.jButtonHideLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonHideLabelsActionPerformed(evt);
            }
        });
        this.jButtonShowLabels.setFont(new Font("SansSerif", 0, 13));
        this.jButtonShowLabels.setText("Show");
        this.jButtonShowLabels.setMinimumSize(new Dimension(39, 27));
        this.jButtonShowLabels.setPreferredSize(new Dimension(145, 28));
        this.jButtonShowLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonShowLabelsActionPerformed(evt);
            }
        });
        GroupLayout jPanel28Layout = new GroupLayout(this.jPanel28);
        this.jPanel28.setLayout(jPanel28Layout);
        jPanel28Layout.setHorizontalGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel28Layout.createSequentialGroup().addComponent(this.jButtonHideLabels, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonShowLabels, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2)));
        jPanel28Layout.setVerticalGroup(jPanel28Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonHideLabels, -2, -1, -2).addComponent(this.jButtonShowLabels, -2, -1, -2));
        GroupLayout jPanelLabels3Layout = new GroupLayout(this.jPanelLabels3);
        this.jPanelLabels3.setLayout(jPanelLabels3Layout);
        jPanelLabels3Layout.setHorizontalGroup(jPanelLabels3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLabels3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel28, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanelLabels3Layout.setVerticalGroup(jPanelLabels3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLabels3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jPanel28, -2, -1, -2).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanelLabels4.setBackground(new Color(245, 245, 245));
        this.jPanelLabels4.setBorder(BorderFactory.createTitledBorder(null, "Font color", 0, 0, new Font("SansSerif", 0, 12)));
        this.jPanelLabels4.setPreferredSize(new Dimension(332, 90));
        this.jPanelFontColorView.setBackground(new Color(147, 147, 172));
        this.jPanelFontColorView.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.jPanelFontColorView.setPreferredSize(new Dimension(152, 61));
        GroupLayout jPanelFontColorViewLayout = new GroupLayout(this.jPanelFontColorView);
        this.jPanelFontColorView.setLayout(jPanelFontColorViewLayout);
        jPanelFontColorViewLayout.setHorizontalGroup(jPanelFontColorViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelFontColorViewLayout.setVerticalGroup(jPanelFontColorViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 59, Short.MAX_VALUE));
        this.jButtonFontColorPicker.setFont(new Font("SansSerif", 0, 13));
        this.jButtonFontColorPicker.setText("Color picker");
        this.jButtonFontColorPicker.setPreferredSize(new Dimension(140, 27));
        this.jButtonFontColorPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jButtonFontColorPickerActionPerformed(evt);
            }
        });
        this.jFormattedTextFieldHexaFont.setForeground(Color.magenta);
        try {
            this.jFormattedTextFieldHexaFont.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("HHHHHHHH")));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.jFormattedTextFieldHexaFont.setHorizontalAlignment(0);
        this.jFormattedTextFieldHexaFont.setText("9393ACFF");
        this.jFormattedTextFieldHexaFont.setToolTipText("Hexadecimal color code");
        this.jFormattedTextFieldHexaFont.setFont(new Font("SansSerif", 0, 13));
        this.jFormattedTextFieldHexaFont.setMinimumSize(new Dimension(70, 28));
        this.jFormattedTextFieldHexaFont.setPreferredSize(new Dimension(140, 28));
        this.jFormattedTextFieldHexaFont.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RederMainFrame.this.jFormattedTextFieldHexaFontKeyPressed(evt);
            }
        });
        GroupLayout jPanelLabels4Layout = new GroupLayout(this.jPanelLabels4);
        this.jPanelLabels4.setLayout(jPanelLabels4Layout);
        jPanelLabels4Layout.setHorizontalGroup(jPanelLabels4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLabels4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelFontColorView, -1, 176, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLabels4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFormattedTextFieldHexaFont, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonFontColorPicker, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelLabels4Layout.setVerticalGroup(jPanelLabels4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLabels4Layout.createSequentialGroup().addGroup(jPanelLabels4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLabels4Layout.createSequentialGroup().addComponent(this.jFormattedTextFieldHexaFont, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFontColorPicker, -2, -1, -2)).addComponent(this.jPanelFontColorView, -2, -1, -2)).addContainerGap()));
        GroupLayout jPanelJtabbedLabelsLayout = new GroupLayout(this.jPanelJtabbedLabels);
        this.jPanelJtabbedLabels.setLayout(jPanelJtabbedLabelsLayout);
        jPanelJtabbedLabelsLayout.setHorizontalGroup(jPanelJtabbedLabelsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelJtabbedLabelsLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanelJtabbedLabelsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel23, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelLabels4, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelLabels3, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelLabels2, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addComponent(this.jPanelLabels1, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE)).addContainerGap()));
        jPanelJtabbedLabelsLayout.setVerticalGroup(jPanelJtabbedLabelsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelJtabbedLabelsLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel23, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelLabels1, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelLabels2, -2, 138, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelLabels3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelLabels4, -2, -1, -2).addContainerGap(246, Short.MAX_VALUE)));
        this.jScrollPaneLabels.setViewportView(this.jPanelJtabbedLabels);
        this.jTabbedPaneAttribs.addTab("Labels", this.jScrollPaneLabels);
        this.jSplitPane.setRightComponent(this.jTabbedPaneAttribs);
        GroupLayout jPanelInicialLayout = new GroupLayout(this.jPanelInicial);
        this.jPanelInicial.setLayout(jPanelInicialLayout);
        jPanelInicialLayout.setHorizontalGroup(jPanelInicialLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSplitPane, -1, -1, Short.MAX_VALUE).addComponent(this.jToolBarMainBar, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE));
        jPanelInicialLayout.setVerticalGroup(jPanelInicialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelInicialLayout.createSequentialGroup().addComponent(this.jToolBarMainBar, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jSplitPane, -1, -1, Short.MAX_VALUE)));
        this.menuBar.setBackground(new Color(245, 245, 245));
        this.menuBar.setBorder(new LineBorder(new Color(238, 238, 238), 1, true));
        this.menuBar.setMaximumSize(new Dimension(32768, 32768));
        this.menuBar.setMinimumSize(new Dimension(150, 28));
        this.menuBar.setPreferredSize(new Dimension(250, 28));
        this.jMenu1.setBackground(new Color(240, 240, 240));
        this.jMenu1.setText("File");
        this.jMenu6.setText("New");
        this.jMenu6.setHorizontalTextPosition(2);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.jMenuItem1.setText("Clear graph");
        this.jMenuItem1.setHorizontalTextPosition(2);
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItem1);
        this.jMenuItem6.setText("Example #1");
        this.jMenuItem6.setHorizontalTextPosition(2);
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItem6);
        this.jMenuItem7.setText("Example #2");
        this.jMenuItem7.setHorizontalTextPosition(2);
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItem7);
        this.jMenuItem8.setText("Example #3");
        this.jMenuItem8.setHorizontalTextPosition(2);
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItem8);
        this.jMenu1.add(this.jMenu6);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.jMenuItem2.setText("Open");
        this.jMenuItem2.setToolTipText("Open a 'reder' xgmml file");
        this.jMenuItem2.setHorizontalTextPosition(2);
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.jMenuItem3.setText("Save");
        this.jMenuItem3.setToolTipText("Save a 'reder' xgmml file");
        this.jMenuItem3.setHorizontalTextPosition(2);
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.jMenuItem4.setText("Print");
        this.jMenuItem4.setHorizontalTextPosition(2);
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenu7.setText("Export");
        this.jMenu7.setHorizontalTextPosition(2);
        this.jMenu9.setText("Image");
        this.jMenu9.setHorizontalTextPosition(2);
        this.jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(80, 64));
        this.jMenuItem13.setText("PDF");
        this.jMenuItem13.setHorizontalTextPosition(2);
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem13ActionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem13);
        this.jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(83, 64));
        this.jMenuItem14.setText("SVG");
        this.jMenuItem14.setHorizontalTextPosition(2);
        this.jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem14ActionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem14);
        this.jMenuItem15.setText("PNG");
        this.jMenuItem15.setHorizontalTextPosition(2);
        this.jMenuItem15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem15ActionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem15);
        this.jMenuItem16.setText("JPG");
        this.jMenuItem16.setHorizontalTextPosition(2);
        this.jMenuItem16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem16ActionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem16);
        this.jMenuItem17.setText("BMP");
        this.jMenuItem17.setHorizontalTextPosition(2);
        this.jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem17ActionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem17);
        this.jMenu7.add(this.jMenu9);
        this.jMenu10.setText("Network");
        this.jMenu10.setHorizontalTextPosition(2);
        this.jMenuItem11.setText("XGMML format");
        this.jMenuItem11.setHorizontalTextPosition(2);
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jMenuItem11);
        this.jMenuItem12.setText("SIF format");
        this.jMenuItem12.setHorizontalTextPosition(2);
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem12ActionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jMenuItem12);
        this.jMenu12.setText("Tab separated value");
        this.jMenu12.setHorizontalTextPosition(2);
        this.jMenuItem18.setText("Nodes");
        this.jMenuItem18.setToolTipText("Save node list in a tab-delimited text file");
        this.jMenuItem18.setHorizontalTextPosition(2);
        this.jMenuItem18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem18ActionPerformed(evt);
            }
        });
        this.jMenu12.add(this.jMenuItem18);
        this.jMenuItem19.setText("Edges");
        this.jMenuItem19.setToolTipText("Save edge list in a tab-delimited text file");
        this.jMenuItem19.setHorizontalTextPosition(2);
        this.jMenuItem19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem19ActionPerformed(evt);
            }
        });
        this.jMenu12.add(this.jMenuItem19);
        this.jMenuItem20.setText("Nodes and edges");
        this.jMenuItem20.setToolTipText("Save node and edge lists in a tab-delimited text file");
        this.jMenuItem20.setHorizontalTextPosition(2);
        this.jMenuItem20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem20ActionPerformed(evt);
            }
        });
        this.jMenu12.add(this.jMenuItem20);
        this.jMenu10.add(this.jMenu12);
        this.jMenu7.add(this.jMenu10);
        this.jMenu1.add(this.jMenu7);
        this.jMenu8.setText("Import");
        this.jMenu8.setHorizontalTextPosition(2);
        this.jMenuItem9.setText("XGMML format");
        this.jMenuItem9.setHorizontalTextPosition(2);
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jMenu8.add(this.jMenuItem9);
        this.jMenuItem10.setText("SIF format");
        this.jMenuItem10.setHorizontalTextPosition(2);
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem10ActionPerformed(evt);
            }
        });
        this.jMenu8.add(this.jMenuItem10);
        this.jMenu11.setText("Tab separared value");
        this.jMenu11.setHorizontalTextPosition(2);
        this.jMenuItem21.setText("Nodes");
        this.jMenuItem21.setToolTipText("A node list from a tab-delimited text file, for example:\n#node_id\nNode1\nNode2");
        this.jMenuItem21.setHorizontalTextPosition(2);
        this.jMenuItem21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem21ActionPerformed(evt);
            }
        });
        this.jMenu11.add(this.jMenuItem21);
        this.jMenuItem22.setText("Edges");
        this.jMenuItem22.setToolTipText("An edge list from a tab-delimited text file, for example:\n#node_a              node_b\nNode1                  Node2\nNode1                  Node3");
        this.jMenuItem22.setHorizontalTextPosition(2);
        this.jMenuItem22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem22ActionPerformed(evt);
            }
        });
        this.jMenu11.add(this.jMenuItem22);
        this.jMenuItem23.setText("Nodes and edges");
        this.jMenuItem23.setToolTipText("Node and edge lists from a tab-delimited text file, for example:\n#node_id \nNode1\nNode2\n#node_a              node_b\nNode1                  Node2\nNode1                  Node3");
        this.jMenuItem23.setHorizontalTextPosition(2);
        this.jMenuItem23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem23ActionPerformed(evt);
            }
        });
        this.jMenu11.add(this.jMenuItem23);
        this.jMenu8.add(this.jMenu11);
        this.jMenu1.add(this.jMenu8);
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.jMenuItem5.setText("Exit");
        this.jMenuItem5.setHorizontalTextPosition(2);
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.menuBar.add(this.jMenu1);
        this.jMenu2.setBackground(new Color(240, 240, 240));
        this.jMenu2.setText("Edit");
        this.jMenuItem24.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.jMenuItem24.setText("Find");
        this.jMenuItem24.setToolTipText("Search nodes using regex ");
        this.jMenuItem24.setHorizontalTextPosition(2);
        this.jMenuItem24.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem24ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem24);
        this.jMenuItem34.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.jMenuItem34.setText("Select nodes");
        this.jMenuItem34.setToolTipText("");
        this.jMenuItem34.setHorizontalTextPosition(2);
        this.jMenuItem34.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem34ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem34);
        this.jMenuItem40.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        this.jMenuItem40.setText("Select edges");
        this.jMenuItem40.setHorizontalTextPosition(2);
        this.jMenuItem40.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem40ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem40);
        this.jMenuItem26.setText("Deselect");
        this.jMenuItem26.setToolTipText("Deselect all nodes and edges");
        this.jMenuItem26.setHorizontalTextPosition(2);
        this.jMenuItem26.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem26ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem26);
        this.jMenu2.add(this.jSeparator1);
        this.jMenuItem27.setText("Delete nodes");
        this.jMenuItem27.setToolTipText("Delete selected nodes");
        this.jMenuItem27.setHorizontalTextPosition(2);
        this.jMenuItem27.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem27ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem27);
        this.jMenuItem28.setText("Delete edges");
        this.jMenuItem28.setToolTipText("Delete selected edges");
        this.jMenuItem28.setHorizontalTextPosition(2);
        this.jMenuItem28.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem28ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem28);
        this.jMenu2.add(this.jSeparator2);
        this.jMenuItem29.setText("Duplicate nodes");
        this.jMenuItem29.setToolTipText("Duplicate the network or selected nodes");
        this.jMenuItem29.setHorizontalTextPosition(2);
        this.jMenuItem29.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem29ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem29);
        this.jMenuItem30.setText("Merge nodes");
        this.jMenuItem30.setToolTipText("Merge selected nodes");
        this.jMenuItem30.setHorizontalTextPosition(2);
        this.jMenuItem30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem30ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem30);
        this.jMenuItem31.setText("Nest nodes");
        this.jMenuItem31.setToolTipText("Nest selected nodes");
        this.jMenuItem31.setHorizontalTextPosition(2);
        this.jMenuItem31.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem31ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem31);
        this.jMenu2.add(this.jSeparator4);
        this.jMenuItem32.setText("Merge out-edges");
        this.jMenuItem32.setToolTipText("Merge out-edges between containers");
        this.jMenuItem32.setHorizontalTextPosition(2);
        this.jMenuItem32.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem32ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem32);
        this.jMenu2.add(this.jSeparator3);
        this.jMenuItem33.setText("Assign tree");
        this.jMenuItem33.setToolTipText("Assign container names to nodes");
        this.jMenuItem33.setHorizontalTextPosition(2);
        this.jMenuItem33.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem33ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem33);
        this.jCheckBoxMenuItemShowTree.setText("Show nesting edges");
        this.jCheckBoxMenuItemShowTree.setToolTipText("Show nesting assignments in containers");
        this.jCheckBoxMenuItemShowTree.setHorizontalTextPosition(2);
        this.jCheckBoxMenuItemShowTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxMenuItemShowTreeActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jCheckBoxMenuItemShowTree);
        this.menuBar.add(this.jMenu2);
        this.jMenu3.setBackground(new Color(240, 240, 240));
        this.jMenu3.setText("View");
        this.jMenuItem35.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        this.jMenuItem35.setText("Fit to window");
        this.jMenuItem35.setToolTipText("Fit network to window");
        this.jMenuItem35.setHorizontalTextPosition(2);
        this.jMenuItem35.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem35ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem35);
        this.jMenuItem36.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.jMenuItem36.setText("Rotate");
        this.jMenuItem36.setHorizontalTextPosition(2);
        this.jMenuItem36.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem36ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem36);
        this.jMenuItem37.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.jMenuItem37.setText("Flip vertically");
        this.jMenuItem37.setHorizontalTextPosition(2);
        this.jMenuItem37.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem37ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem37);
        this.jMenuItem38.setAccelerator(KeyStroke.getKeyStroke(72, 128));
        this.jMenuItem38.setText("Flip horizontally");
        this.jMenuItem38.setHorizontalTextPosition(2);
        this.jMenuItem38.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem38ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem38);
        this.jMenuItem39.setText("Background");
        this.jMenuItem39.setHorizontalTextPosition(2);
        this.jMenuItem39.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem39ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem39);
        this.jMenu13.setText("Aspect ratio");
        this.jMenu13.setHorizontalTextPosition(2);
        this.jMenuItemAspectF1.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.jMenuItemAspectF1.setText("1:1");
        this.jMenuItemAspectF1.setHorizontalTextPosition(2);
        this.jMenuItemAspectF1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemAspectF1ActionPerformed(evt);
            }
        });
        this.jMenu13.add(this.jMenuItemAspectF1);
        this.jMenuItemAspectF2.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.jMenuItemAspectF2.setText("4:3");
        this.jMenuItemAspectF2.setHorizontalTextPosition(2);
        this.jMenuItemAspectF2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItemAspectF2ActionPerformed(evt);
            }
        });
        this.jMenu13.add(this.jMenuItemAspectF2);
        this.jMenu3.add(this.jMenu13);
        this.jMenu14.setText("Zoom");
        this.jMenu14.setToolTipText("Scroll up/down with the mouse");
        this.jMenu14.setHorizontalTextPosition(2);
        this.jMenuItem42.setAccelerator(KeyStroke.getKeyStroke(61, 128));
        this.jMenuItem42.setText("Zoom-in");
        this.jMenuItem42.setHorizontalTextPosition(2);
        this.jMenuItem42.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem42ActionPerformed(evt);
            }
        });
        this.jMenu14.add(this.jMenuItem42);
        this.jMenuItem43.setAccelerator(KeyStroke.getKeyStroke(45, 128));
        this.jMenuItem43.setText("Zoom-out");
        this.jMenuItem43.setHorizontalTextPosition(2);
        this.jMenuItem43.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem43ActionPerformed(evt);
            }
        });
        this.jMenu14.add(this.jMenuItem43);
        this.jMenuItem44.setAccelerator(KeyStroke.getKeyStroke(48, 128));
        this.jMenuItem44.setText("Reset");
        this.jMenuItem44.setHorizontalTextPosition(2);
        this.jMenuItem44.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem44ActionPerformed(evt);
            }
        });
        this.jMenu14.add(this.jMenuItem44);
        this.jMenu3.add(this.jMenu14);
        this.jMenu15.setText("Toolbars");
        this.jMenu15.setHorizontalTextPosition(2);
        this.jCheckBoxToolbarsFile.setSelected(true);
        this.jCheckBoxToolbarsFile.setText("File");
        this.jCheckBoxToolbarsFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxToolbarsFileActionPerformed(evt);
            }
        });
        this.jMenu15.add(this.jCheckBoxToolbarsFile);
        this.jCheckBoxToolbarsSelect.setSelected(true);
        this.jCheckBoxToolbarsSelect.setText("Select");
        this.jCheckBoxToolbarsSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxToolbarsSelectActionPerformed(evt);
            }
        });
        this.jMenu15.add(this.jCheckBoxToolbarsSelect);
        this.jCheckBoxToolbarsEdit.setSelected(true);
        this.jCheckBoxToolbarsEdit.setText("Edit");
        this.jCheckBoxToolbarsEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxToolbarsEditActionPerformed(evt);
            }
        });
        this.jMenu15.add(this.jCheckBoxToolbarsEdit);
        this.jCheckBoxToolbarsLayout.setSelected(true);
        this.jCheckBoxToolbarsLayout.setText("Layout");
        this.jCheckBoxToolbarsLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jCheckBoxToolbarsLayoutActionPerformed(evt);
            }
        });
        this.jMenu15.add(this.jCheckBoxToolbarsLayout);
        this.jMenu3.add(this.jMenu15);
        this.menuBar.add(this.jMenu3);
        this.jMenu5.setBackground(new Color(240, 240, 240));
        this.jMenu5.setText("Help");
        this.jMenuItem45.setText("About");
        this.jMenuItem45.setHorizontalTextPosition(2);
        this.jMenuItem45.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RederMainFrame.this.jMenuItem45ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem45);
        this.menuBar.add(this.jMenu5);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelInicial, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelInicial, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jScrollMainPaneMouseClicked(MouseEvent evt) {
        if (lockMouse) {
            System.out.println("Please, wait while loading data!");
            return;
        }
        this.jMenuItemTransform.setEnabled(true);
        this.jMenuItemUpdateNestSize.setEnabled(false);
        this.jMenuItemUpdateNestedPosition.setEnabled(false);
        this.jMenuItemDuplicate.setEnabled(false);
        this.jMenuItemDownGradeTree.setEnabled(false);
        this.jMenuItemBreakTree.setEnabled(false);
        this.jMenuItemMergeOutEdges.setEnabled(false);
        this.jMenuItemResetZoom.setEnabled(false);
        this.jMenuItemHide.setEnabled(false);
        this.jMenuItemTransparent.setEnabled(false);
        this.jMenuItemPlainNest.setEnabled(false);
        this.jMenuItemMergeNodes.setEnabled(false);
        this.jMenuItemAnchor.setEnabled(true);
        this.jMenuItemUnanchor.setEnabled(true);
        this.lastDragArea = null;
        if (isSystemOpened) {
            int buttonClicked = evt.getButton();
            if (this.shift && buttonClicked == 1) {
                buttonClicked = 3;
            }
            this.clickedX = evt.getX();
            this.clickedY = evt.getY();
            block0 : switch (buttonClicked) {
                case 1: {
                    int i;
                    this.actionFindObject(evt.getX(), evt.getY());
                    if (this.objectFound.equals("nodo") && !this.nodeAccountFound.isSpot()) {
                        if (evt.getClickCount() == 1) {
                            if (!this.nodeAccountFound.getDestaque()) {
                                this.nodeAccountFound.setDestaqueSimples(true, false);
                            } else {
                                this.nodeAccountFound.setDestaqueSimples(false, false);
                            }
                        } else if (evt.getClickCount() == 2) {
                            this.nodeAccountFound.setDestaqueSimples(true, true);
                            if (this.nodeAccountFound.isContainer()) {
                                for (int i2 = 0; i2 < EdgeList.size(); ++i2) {
                                    this.edgeAccount = EdgeList.get(i2);
                                    this.edgeAccount.setDestaqueInNest(this.nodeAccountFound.getNodeID());
                                }
                                this.nodeAccountFound.setContainerTreeMark(true);
                                this.castEdgeAttributesToSettings();
                            }
                            this.stopRelax();
                            this.forwardNode();
                        } else if (evt.getClickCount() > 2) {
                            this.nodeAccountFound.setDestaque(true);
                            if (!this.nodeAccountFound.isContainer()) {
                                this.nodeAccountFound.setDestaqueNeighbours(true);
                            }
                        }
                        this.setViewNodePanelAttributes();
                        this.castNodeAttributesToSettings();
                        this.castNodeLabelAttributesToSettings();
                        break;
                    }
                    if (this.objectFound.equals("edge")) {
                        this.edgeAccountFound.setDestaque();
                        this.castEdgeAttributesToSettings();
                        break;
                    }
                    this.resetViewNodePanelAttributes();
                    this.resetNodeAttributeSettings();
                    this.resetNodeLabelAttributeSettings();
                    this.resetEdgeAttributeSettings();
                    for (i = 0; i < NodeList.size(); ++i) {
                        NodeBank nodeCont = NodeList.get(i);
                        if (nodeCont.isContainer() && nodeCont.getDestaque()) {
                            nodeCont.setDestaque(false);
                            this.zoomContainer(0.0, 0.0, nodeCont);
                            continue;
                        }
                        nodeCont.setDestaqueSimples(false, false);
                    }
                    for (i = 0; i < EdgeList.size(); ++i) {
                        this.edgeAccount = EdgeList.get(i);
                        this.edgeAccount.setDestaque(false);
                    }
                    break;
                }
                case 3: {
                    this.key1 = -9999;
                    this.shift = false;
                    int x1 = this.clickedX - drawpanel.getX();
                    int y1 = this.clickedY - drawpanel.getY();
                    this.actionFindObject(this.clickedX, this.clickedY);
                    switch (this.objectFound) {
                        case "nodo": {
                            if (this.nodeAccountFound.isSpot()) {
                                this.popSpotChanges.show(drawpanel, x1, y1);
                                break block0;
                            }
                            if (this.nodeAccountFound.isContainer()) {
                                this.jMenuItemTransform.setEnabled(false);
                                this.jMenuItemUpdateNestSize.setEnabled(true);
                                this.jMenuItemUpdateNestedPosition.setEnabled(true);
                                this.jMenuItemDuplicate.setEnabled(true);
                                this.jMenuItemBreakTree.setEnabled(true);
                                this.jMenuItemMergeOutEdges.setEnabled(true);
                                this.jMenuItemResetZoom.setEnabled(true);
                                this.jMenuItemHide.setEnabled(true);
                                this.jMenuItemTransparent.setEnabled(true);
                                this.jMenuItemPlainNest.setEnabled(true);
                                this.jMenuItemAnchor.setEnabled(true);
                                this.jMenuItemUnanchor.setEnabled(true);
                            } else if (!this.nodeAccountFound.isNodeNested()) {
                                this.jMenuItemMergeNodes.setEnabled(true);
                            }
                            if (this.nodeAccountFound.isNodeNested()) {
                                this.jMenuItemBreakTree.setEnabled(true);
                                this.jMenuItemDownGradeTree.setEnabled(true);
                            }
                            this.popNodeChanges.show(drawpanel, x1, y1);
                            break block0;
                        }
                        case "edge": {
                            this.popEdgeChanges.show(drawpanel, x1, y1);
                            break block0;
                        }
                    }
                    Point loc = this.getLocation();
                    this.jDialogAddNodeEdge.setLocation(this.clickedX + loc.x, this.clickedY + loc.y);
                    this.jTextFieldAddNodeA.setText("");
                    this.jTextFieldAddNodeB.setText("");
                    this.jCheckBoxDefaultNestingOption.setSelected(true);
                    this.jDialogAddNodeEdge.setAlwaysOnTop(true);
                    this.jDialogAddNodeEdge.pack();
                    this.jDialogAddNodeEdge.setModal(false);
                    this.jDialogAddNodeEdge.setVisible(true);
                    break;
                }
            }
        }
    }

    private void jScrollMainPaneMousePressed(MouseEvent evt) {
        if (lockMouse) {
            return;
        }
        if (isSystemOpened) {
            this.mouseButtonPressed = evt.getButton();
            if (this.shift && this.mouseButtonPressed == 1) {
                this.mouseButtonPressed = 3;
            }
            int eventX = evt.getX() - drawpanel.getX();
            int eventY = evt.getY() - drawpanel.getY();
            this.pressedX = eventX;
            this.pressedY = eventY;
            this.scrollX = eventX;
            this.scrollY = eventY;
            this.actionFindObject(eventX, eventY);
        }
    }

    private void jScrollMainPaneMouseReleased(MouseEvent evt) {
        if (lockMouse) {
            return;
        }
        if (!isSystemOpened) {
            return;
        }
        drawpanel.setCursor(Cursor.getPredefinedCursor(0));
        this.updateDestaques();
        if (this.nodeAccountFound != null) {
            this.nodeAccountFound.setDragged(false);
            if (this.nodeAccountFound.isContainer()) {
                this.nodeAccountFound.setDestaqueTree(false);
            }
        }
        if (movendoNodos && evt.getButton() == 1 && this.nodeAccountFound != null && !this.nodeAccountFound.isContainer() && this.nodeAccountFound.getDestaque()) {
            String r1 = this.nodeAccountFound.getNestedAssignment();
            this.scrollX = evt.getX() - drawpanel.getX();
            this.scrollY = evt.getY() - drawpanel.getY();
            this.actionFindContainer(this.scrollX, this.scrollY);
            if (!(this.nodeAccountFound == null || this.nodeAccountFound.getDestaque() || this.nodeAccountFound.isSpot() || this.nodeAccountFound.getNodeID().equals(r1))) {
                this.jPopupMenuMigrate.show(drawpanel, this.scrollX, this.scrollY);
            }
        }
        movendoNodos = false;
        if (isPaintActive) {
            this.repaint();
        }
    }

    private void jScrollMainPaneMouseDragged(MouseEvent evt) {
        if (lockMouse) {
            return;
        }
        if (isSystemOpened) {
            int dragX = evt.getX() - drawpanel.getX();
            int dragY = evt.getY() - drawpanel.getY();
            switch (this.mouseButtonPressed) {
                case 1: {
                    if (this.objectFound.equals("nodo")) {
                        this.nodeAccountFound.setDragged(true);
                        movendoNodos = true;
                        this.actionDragNodo(dragX, dragY);
                        this.resetCooling();
                        break;
                    }
                    if (!this.objectFound.equals("nada")) break;
                    this.actionDragBox(dragX, dragY);
                    break;
                }
                case 3: {
                    if (!this.objectFound.equals("nada")) break;
                    if (lockDragAndZoom || isRelaxActive) {
                        return;
                    }
                    this.actionDragWindow(dragX, dragY);
                    break;
                }
            }
        }
    }

    private void jScrollMainPaneMouseWheelMoved(MouseWheelEvent evt) {
        requesting_zoom_and_flips = true;
        if (lockMouse) {
            return;
        }
        if (lockDragAndZoom) {
            return;
        }
        int flipEvent = evt.getWheelRotation();
        double flip = flipEvent > 0 ? 1.0 : -1.0;
        if (this.nodeAccountFound == null) {
            this.actionZoom(flip, evt.getX(), evt.getY());
        } else if (this.nodeAccountFound.isContainer() && this.nodeAccountFound.getDestaque()) {
            this.zoomContainer(flip, 0.1, this.nodeAccountFound);
        } else {
            this.actionZoom(flip, evt.getX(), evt.getY());
        }
        requesting_zoom_and_flips = false;
    }

    private void jButtonExpandRigthTabsActionPerformed(ActionEvent evt) {
        this.setVisibleRightSplitPane(true);
        RedeR.mf.revalidate();
        RederMainFrame.updateGraph();
    }

    private void jButtonCollapseRigthTabsActionPerformed(ActionEvent evt) {
        this.setVisibleRightSplitPane(false);
        RedeR.mf.revalidate();
        RederMainFrame.updateGraph();
    }

    private void jMenuItemAspectF1ActionPerformed(ActionEvent evt) {
        this.contractJFrame();
    }

    private void jMenuItemAspectF2ActionPerformed(ActionEvent evt) {
        this.expandJFrame();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        try {
            this.loadEmptyGraph();
        }
        catch (IOException ex) {
            Logger.getLogger(RederMainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        try {
            this.loadSample1Graph();
        }
        catch (IOException ex) {
            Logger.getLogger(RederMainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        this.loadSample2Xgmml();
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        this.loadSample3Xgmml();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.openDefault();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.saveDefault();
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.printImage();
    }

    private void jMenuItem13ActionPerformed(ActionEvent evt) {
        this.exportPDF();
    }

    private void jMenuItem14ActionPerformed(ActionEvent evt) {
        this.exportSVG();
    }

    private void jMenuItem15ActionPerformed(ActionEvent evt) {
        this.exportImage("png");
    }

    private void jMenuItem16ActionPerformed(ActionEvent evt) {
        this.exportImage("jpg");
    }

    private void jMenuItem17ActionPerformed(ActionEvent evt) {
        this.exportImage("bmp");
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        this.openXgmml();
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        this.openSif();
    }

    private void jMenuItem21ActionPerformed(ActionEvent evt) {
        this.openNodes();
    }

    private void jMenuItem22ActionPerformed(ActionEvent evt) {
        this.openEdges();
    }

    private void jMenuItem23ActionPerformed(ActionEvent evt) {
        this.openNodesAndEdges();
    }

    private void jMenuItem24ActionPerformed(ActionEvent evt) {
        this.startDialogs("globalActionFindNode");
    }

    private void jMenuItem26ActionPerformed(ActionEvent evt) {
        this.globalActionNoSelect();
    }

    private void jMenuItem27ActionPerformed(ActionEvent evt) {
        this.globalActionDeleteNode();
    }

    private void jMenuItem28ActionPerformed(ActionEvent evt) {
        this.globalActionDeleteEdge(true);
    }

    private void jMenuItem29ActionPerformed(ActionEvent evt) {
        this.duplicateNetwork();
    }

    private void jMenuItem30ActionPerformed(ActionEvent evt) {
        this.mergeNodes();
    }

    private void jMenuItem31ActionPerformed(ActionEvent evt) {
        this.nestNodes();
    }

    private void jMenuItem32ActionPerformed(ActionEvent evt) {
        this.globalMergeOutEdgesNorm();
    }

    private void jMenuItem33ActionPerformed(ActionEvent evt) {
        this.assignTreePermanently();
    }

    private void jMenuItem35ActionPerformed(ActionEvent evt) {
        this.fitToWindow(0.85);
    }

    private void jMenuItem36ActionPerformed(ActionEvent evt) {
        this.startDialogs("rotateNetworkPanel");
    }

    private void jMenuItem42ActionPerformed(ActionEvent evt) {
        this.ZoomIn();
    }

    private void jMenuItem43ActionPerformed(ActionEvent evt) {
        this.ZoomOut();
    }

    private void jMenuItem44ActionPerformed(ActionEvent evt) {
        this.resetZoom();
    }

    private void jMenuItem37ActionPerformed(ActionEvent evt) {
        this.rotateAndFlip(false, false, true, 0.0);
    }

    private void jMenuItem38ActionPerformed(ActionEvent evt) {
        this.rotateAndFlip(false, true, false, 0.0);
    }

    private void jMenuItem39ActionPerformed(ActionEvent evt) {
        this.actionBackgroundColor();
    }

    private void jButtonIconOpenActionPerformed(ActionEvent evt) {
        this.openDefault();
    }

    private void jButtonIconSaveActionPerformed(ActionEvent evt) {
        this.saveDefault();
    }

    private void jButtonIconPDFActionPerformed(ActionEvent evt) {
        this.exportPDF();
    }

    private void jButtonIconFindActionPerformed(ActionEvent evt) {
        this.startDialogs("globalActionFindNode");
    }

    private void jButtonIconSelectAllActionPerformed(ActionEvent evt) {
        this.globalActionSelect();
    }

    private void jButtonIconFitActionPerformed(ActionEvent evt) {
        this.stopRelax();
        requesting_zoom_and_flips = true;
        this.fitToWindow(0.85);
        requesting_zoom_and_flips = false;
    }

    private void jButtonFlipVerActionPerformed(ActionEvent evt) {
        this.stopRelax();
        requesting_zoom_and_flips = true;
        this.rotateAndFlip(false, false, true, 0.0);
        requesting_zoom_and_flips = false;
    }

    private void jButtonFlipHorActionPerformed(ActionEvent evt) {
        this.stopRelax();
        requesting_zoom_and_flips = true;
        this.rotateAndFlip(false, true, false, 0.0);
        requesting_zoom_and_flips = false;
    }

    private void jButtonIconRotateLeftActionPerformed(ActionEvent evt) {
        this.stopRelax();
        requesting_zoom_and_flips = true;
        this.rotateAndFlip(true, false, false, -10.0);
        requesting_zoom_and_flips = false;
    }

    private void jButtonIconRotateRigthActionPerformed(ActionEvent evt) {
        this.stopRelax();
        requesting_zoom_and_flips = true;
        this.rotateAndFlip(true, false, false, 10.0);
        requesting_zoom_and_flips = false;
        RederMainFrame.updateGraph();
    }

    private void jButtonIconZoomInActionPerformed(ActionEvent evt) {
        this.ZoomIn();
    }

    private void jButtonIconZoomOutActionPerformed(ActionEvent evt) {
        this.ZoomOut();
    }

    private void jButtonGridLayoutActionPerformed(ActionEvent evt) {
        this.startDialogs("layoutGridPanel");
    }

    private void jButtonCircularLayoutActionPerformed(ActionEvent evt) {
        this.actionLayoutCircle();
    }

    private void jButtonRandomLayoutActionPerformed(ActionEvent evt) {
        this.actionLayoutRandom();
    }

    private void jMenuItem45ActionPerformed(ActionEvent evt) {
        this.actionAbout();
    }

    private void jButtonStartRelaxActionPerformed(ActionEvent evt) {
        this.updateRelaxSettings();
        this.startRelax();
    }

    private void jButtonStopRelaxActionPerformed(ActionEvent evt) {
        this.stopRelax();
        this.resetCooling();
        RederMainFrame.updateGraph();
    }

    private void jButtonResetRelaxActionPerformed(ActionEvent evt) {
        this.resetRelaxSettings();
    }

    private void jButtonAddGuideActionPerformed(ActionEvent evt) {
        this.addSpotNode();
    }

    private void jSpinnerSeletorRelaxP1StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxP2StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxP3StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxP4StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxP5StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxP6StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxP7StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxP8StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxP9StateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSpinnerSeletorRelaxSliderStateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jSliderSeletorRelaxStateChanged(ChangeEvent evt) {
        this.updateRelaxSettings();
    }

    private void jToggleButtonRederLayoutActionPerformed(ActionEvent evt) {
        if (this.jToggleButtonRederLayout.isSelected()) {
            this.updateRelaxSettings();
            this.startRelax();
        } else {
            this.stopRelax();
            this.resetCooling();
            RederMainFrame.updateGraph();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cancelTasks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void jButtonAliasesUpdateActionPerformed(ActionEvent evt) {
        String texto = this.jTextFieldLegend.getText();
        this.nodeAccountFound.setAliases(texto);
        if (isPaintActive) {
            this.repaint();
        }
    }

    private void jButtonAliasesExitActionPerformed(ActionEvent evt) {
        this.jDialogNodeID.dispose();
    }

    private void jButtonFindNodeActionPerformed(ActionEvent evt) {
        this.jButtonFindNode();
    }

    private void jButtonExitFindNodeActionPerformed(ActionEvent evt) {
        this.jDialogModelFindNodeLabel.dispose();
        if (this.taskFilterZoom != null && !this.taskFilterZoom.isCancelled()) {
            this.taskFilterZoom.cancel(true);
        }
    }

    private void jButtonUpdateGridActionPerformed(ActionEvent evt) {
        Integer ncols = (Integer)this.jSpinnerGrid.getValue();
        float gapx = ((Float)this.jSpinnerGapx.getValue()).floatValue();
        float gapy = ((Float)this.jSpinnerGapy.getValue()).floatValue();
        this.actionLayoutGrid(ncols, gapx, gapy);
    }

    private void jButtonExitGridActionPerformed(ActionEvent evt) {
        this.jDialogModelGrid.dispose();
    }

    private void jButtonUpdateRotateActionPerformed(ActionEvent evt) {
        this.stopRelax();
        double dAngle = (Double)this.jSpinnerRotate.getValue();
        this.rotateAndFlip(true, false, false, dAngle);
    }

    private void jButtonExitRotateActionPerformed(ActionEvent evt) {
        this.jDialogModelRotate.dispose();
    }

    private void jButtonAddSpotActionPerformed(ActionEvent evt) {
        double spotEffect = (Double)this.jSpinnerSpotEffect1.getValue();
        double spotPerimeter = (Double)this.jSpinnerSpotEffect2.getValue();
        int spotDirection = (Integer)this.jSpinnerSpotEffect3.getValue();
        this.addSpotNode(38.0f, 38.0f, spotEffect, spotPerimeter, spotDirection);
        this.jDialogSpotEffect.dispose();
    }

    private void jButtonUpdateSpotEffectActionPerformed(ActionEvent evt) {
        this.jButtonUpdateSpotEffect();
    }

    private void jButtonCancelSpotEffectActionPerformed(ActionEvent evt) {
        this.jDialogSpotEffect.dispose();
    }

    private void jButtonExportImageOKActionPerformed(ActionEvent evt) {
        this.jButtonExportImage();
    }

    private void jButtonExportImageCancelActionPerformed(ActionEvent evt) {
        this.jDialogExportImage.dispose();
    }

    private void jToggleButtonOKaboutActionPerformed(ActionEvent evt) {
        this.jDialogAbout.dispose();
    }

    private void jButtonAddNodesOKActionPerformed(ActionEvent evt) {
        this.jButtonAddNodes();
    }

    private void jButtonAddNodesCancelActionPerformed(ActionEvent evt) {
        this.jDialogAddNodeEdge.dispose();
    }

    private void jMenuISetSpotEffectActionPerformed(ActionEvent evt) {
        this.setSpotEffect();
    }

    private void jMenuSpotDeleteActionPerformed(ActionEvent evt) {
        this.deSelectNodes();
        this.deSelectEdges();
        this.actionDeleteNode();
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        this.saveXgmml();
    }

    private void jMenuItem12ActionPerformed(ActionEvent evt) {
        this.saveSif();
    }

    private void jMenuItem18ActionPerformed(ActionEvent evt) {
        this.saveNodes();
    }

    private void jMenuItem19ActionPerformed(ActionEvent evt) {
        this.saveEdges();
    }

    private void jMenuItem20ActionPerformed(ActionEvent evt) {
        this.saveNodesAndEdges();
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.exitRedeR();
    }

    private void jCheckBoxMenuItemShowTreeActionPerformed(ActionEvent evt) {
        showTree = this.jCheckBoxMenuItemShowTree.isSelected();
        if (isPaintActive) {
            this.repaint();
        }
    }

    private void jMenuItemNodeIDActionPerformed(ActionEvent evt) {
        this.actionNodeLegend();
    }

    private void jMenuItemAnchorActionPerformed(ActionEvent evt) {
        this.anchorNodeContainer();
    }

    private void jMenuItemUnanchorActionPerformed(ActionEvent evt) {
        this.unanchorNodeContainer();
    }

    private void jMenuItemMergeNodesActionPerformed(ActionEvent evt) {
        this.mergeNodes();
    }

    private void jMenuItemNeighbourhoodActionPerformed(ActionEvent evt) {
        this.selectNeighbourhood();
    }

    private void jMenuItemBackwardActionPerformed(ActionEvent evt) {
        this.backwardNode();
    }

    private void jMenuItemForwardActionPerformed(ActionEvent evt) {
        this.forwardNode();
    }

    private void jMenuNodeDeleteActionPerformed(ActionEvent evt) {
        this.actionDeleteNode();
    }

    private void jMenuItemNestNodesActionPerformed(ActionEvent evt) {
        this.nestNodes();
    }

    private void jMenuItemTransformActionPerformed(ActionEvent evt) {
        this.transformeNodes();
    }

    private void jMenuItemUpdateNestSizeActionPerformed(ActionEvent evt) {
        this.updateNestSize();
    }

    private void jMenuItemUpdateNestedPositionActionPerformed(ActionEvent evt) {
        this.updateNestedPositions();
    }

    private void jMenuItemMergeOutEdgesActionPerformed(ActionEvent evt) {
        this.mergeOutEdges();
    }

    private void jMenuItemHideActionPerformed(ActionEvent evt) {
        this.hideContainer();
    }

    private void jMenuItemTransparentActionPerformed(ActionEvent evt) {
        this.transparentContainer();
    }

    private void jMenuItemPlainNestActionPerformed(ActionEvent evt) {
        this.plainContainer();
    }

    private void jMenuItemBreakTreeActionPerformed(ActionEvent evt) {
        this.breakTree();
    }

    private void jMenuItemDownGradeTreeActionPerformed(ActionEvent evt) {
        this.downGradeTree();
    }

    private void jMenuItemResetZoomActionPerformed(ActionEvent evt) {
        this.resetZoomContainer();
    }

    private void jMenuItemDuplicateActionPerformed(ActionEvent evt) {
        this.duplicateContainer();
    }

    private void jMenuEdgeDeleteActionPerformed(ActionEvent evt) {
        this.actionDeleteEdge();
    }

    private void jMenuItemMigrateActionPerformed(ActionEvent evt) {
        this.migrateNodes();
    }

    private void jCheckBoxOverrideEdgesActionPerformed(ActionEvent evt) {
        this.overrideEdges();
        this.updateRelaxSettings();
    }

    private void jCheckBoxOptimizeRenderingActionPerformed(ActionEvent evt) {
        this.updateRelaxRendering();
    }

    private void jCheckBoxPartitionEffectActionPerformed(ActionEvent evt) {
        this.stopRelax();
        this.updateRelaxSettings();
    }

    private void jCheckBoxCoolingNActionPerformed(ActionEvent evt) {
        this.updateRelaxSettings();
    }

    private void jButtonEllipseActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2("ELLIPSE", null, null);
    }

    private void jButtonRectangleActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2("RECTANGLE", null, null);
    }

    private void jButtonRoundedRecActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2("ROUNDED_RECTANGLE", null, null);
    }

    private void jButtonTriangleActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2("TRIANGLE", null, null);
    }

    private void jButtonDiamondActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2("DIAMOND", null, null);
    }

    private void jButtonGradientSurfaceActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2(null, null, true);
    }

    private void jButtonFlatSurfaceActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2(null, null, false);
    }

    private void jSliderNodeBendStateChanged(ChangeEvent evt) {
        this.updateNodeAttribs1(true, false, false);
    }

    private void NodeLineSolidActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2(null, "SOLID", null);
    }

    private void NodeLineDashedActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2(null, "DASHED", null);
    }

    private void NodeLineDottedActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2(null, "DOTTED", null);
    }

    private void NodeLineDashedLongActionPerformed(ActionEvent evt) {
        this.updateNodeAttribs2(null, "LONG_DASH", null);
    }

    private void jSpinnerNodeSizeStateChanged(ChangeEvent evt) {
        this.updateNodeAttribs1(false, true, false);
    }

    private void jSpinnerNodeSizeKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateNodeAttribs1(false, true, false);
        }
    }

    private void jCheckBoxScaleNodesActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxScaleNodes.isSelected()) {
            this.stop_casting_to_updates = true;
            this.jSpinnerNodeSize.setValue(Float.valueOf(1.0f));
            this.stop_casting_to_updates = false;
        } else {
            this.stop_casting_to_updates = true;
            this.jSpinnerNodeSize.setValue(Float.valueOf(20.0f));
            this.stop_casting_to_updates = false;
        }
    }

    private void jSpinnerNodeLineWidthStateChanged(ChangeEvent evt) {
        this.updateNodeAttribs1(false, false, true);
    }

    private void jSpinnerNodeLineWidthKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateNodeAttribs1(false, false, true);
        }
    }

    private void jCheckBoxScaleNodeLinesActionPerformed(ActionEvent evt) {
        this.stop_casting_to_updates = true;
        this.jSpinnerNodeLineWidth.setValue(Float.valueOf(1.0f));
        this.stop_casting_to_updates = false;
    }

    private void jFormattedTextFieldHexaNodeFillKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Object hex = this.jFormattedTextFieldHexaNodeFill.getText();
            if (((String)(hex = ((String)hex).replace(" ", ""))).length() > 0) {
                if (((String)hex).length() < 8) {
                    String plus = "000000FF";
                    hex = (String)hex + plus.substring(((String)hex).length(), plus.length());
                    this.jFormattedTextFieldHexaNodeFill.setText((String)hex);
                }
                Color newColor = RederMainFrame.HexToColor((String)hex);
                this.jPanelNodeFillColorView.setBackground(newColor);
                if (isPaintActive) {
                    this.repaint();
                }
                this.globalActionNodeColor(newColor);
            }
        }
    }

    private void jButtonNodeFillColorPickerActionPerformed(ActionEvent evt) {
        String hex = this.jFormattedTextFieldHexaNodeFill.getText();
        Color cl = RederMainFrame.HexToColor(hex);
        if ((cl = JColorChooser.showDialog(this, "Node fill color", cl)) != null) {
            hex = RederMainFrame.ColorToHex(cl, true);
            this.jFormattedTextFieldHexaNodeFill.setText(hex.toUpperCase());
            this.jPanelNodeFillColorView.setBackground(cl);
            this.globalActionNodeColor(cl);
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    private void jFormattedTextFieldHexaNodeLineKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Object hex = this.jFormattedTextFieldHexaNodeLine.getText();
            if (((String)(hex = ((String)hex).replace(" ", ""))).length() > 0) {
                if (((String)hex).length() < 8) {
                    String plus = "000000FF";
                    hex = (String)hex + plus.substring(((String)hex).length(), plus.length());
                    this.jFormattedTextFieldHexaNodeLine.setText((String)hex);
                }
                Color newColor = RederMainFrame.HexToColor((String)hex);
                this.jPanelNodeLineColorView.setBackground(newColor);
                if (isPaintActive) {
                    this.repaint();
                }
                this.globalActionNodeLineColor(newColor);
            }
        }
    }

    private void jButtonNodeLineColorPickerActionPerformed(ActionEvent evt) {
        String hex = this.jFormattedTextFieldHexaNodeLine.getText();
        Color cl = RederMainFrame.HexToColor(hex);
        if ((cl = JColorChooser.showDialog(this, "Node line color", cl)) != null) {
            hex = RederMainFrame.ColorToHex(cl, true);
            this.jFormattedTextFieldHexaNodeLine.setText(hex.toUpperCase());
            this.jPanelNodeLineColorView.setBackground(cl);
            this.globalActionNodeLineColor(cl);
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    private void EdgeLineSolidActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2("SOLID", null);
    }

    private void EdgeLineDashedActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2("DASHED", null);
    }

    private void EdgeLineDottedActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2("DOTTED", null);
    }

    private void EdgeLineDashedLongActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2("LONG_DASH", null);
    }

    private void jButtonArrow0ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, 0);
    }

    private void jButtonArrow1ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, 1);
    }

    private void jButtonArrow2ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, 2);
    }

    private void jButtonArrow3ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, 4);
    }

    private void jButtonArrow4ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, -4);
    }

    private void jButtonArrow5ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, 3);
    }

    private void jButtonArrow6ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, -1);
    }

    private void jButtonArrow7ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, -2);
    }

    private void jButtonArrow8ActionPerformed(ActionEvent evt) {
        this.updateEdgeAttribs2(null, -3);
    }

    private void jSpinnerEdgeWidthStateChanged(ChangeEvent evt) {
        this.updateEdgeAttribs1(true, false, false, false);
    }

    private void jSpinnerEdgeWidthKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateEdgeAttribs1(true, false, false, false);
        }
    }

    private void jSpinnerArrowLengthStateChanged(ChangeEvent evt) {
        this.updateEdgeAttribs1(false, true, false, false);
    }

    private void jSpinnerArrowLengthKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateEdgeAttribs1(false, true, false, false);
        }
    }

    private void jSpinnerArrowAngleStateChanged(ChangeEvent evt) {
        this.updateEdgeAttribs1(false, false, true, false);
    }

    private void jSpinnerArrowAngleKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateEdgeAttribs1(false, false, true, false);
        }
    }

    private void jCheckBoxScaleEdgeWidthActionPerformed(ActionEvent evt) {
        this.stop_casting_to_updates = true;
        this.jSpinnerEdgeWidth.setValue(Float.valueOf(1.0f));
        this.stop_casting_to_updates = false;
    }

    private void jCheckBoxScaleArrowLenActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxScaleArrowLen.isSelected()) {
            this.stop_casting_to_updates = true;
            this.jSpinnerArrowLength.setValue(Float.valueOf(1.0f));
            this.stop_casting_to_updates = false;
        } else {
            this.stop_casting_to_updates = true;
            this.jSpinnerArrowLength.setValue(Float.valueOf(2.0f));
            this.stop_casting_to_updates = false;
        }
    }

    private void jCheckBoxScaleArrowAngleActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxScaleArrowAngle.isSelected()) {
            this.stop_casting_to_updates = true;
            this.jSpinnerArrowAngle.setValue(Float.valueOf(1.0f));
            this.stop_casting_to_updates = false;
        } else {
            this.stop_casting_to_updates = true;
            this.jSpinnerArrowAngle.setValue(Float.valueOf(45.0f));
            this.stop_casting_to_updates = false;
        }
    }

    private void jFormattedTextFieldHexaEdgeLineKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Object hex = this.jFormattedTextFieldHexaEdgeLine.getText();
            if (((String)(hex = ((String)hex).replace(" ", ""))).length() > 0) {
                if (((String)hex).length() < 8) {
                    String plus = "000000FF";
                    hex = (String)hex + plus.substring(((String)hex).length(), plus.length());
                    this.jFormattedTextFieldHexaEdgeLine.setText((String)hex);
                }
                Color newColor = RederMainFrame.HexToColor((String)hex);
                this.jPanelEdgeLineColorView.setBackground(newColor);
                if (isPaintActive) {
                    this.repaint();
                }
                this.globalActionEdgeColor(newColor);
            }
        }
    }

    private void jButtonEdgeLineColorPickerActionPerformed(ActionEvent evt) {
        String hex = this.jFormattedTextFieldHexaEdgeLine.getText();
        Color cl = RederMainFrame.HexToColor(hex);
        if ((cl = JColorChooser.showDialog(this, "Edge color", cl)) != null) {
            hex = RederMainFrame.ColorToHex(cl, true);
            this.jFormattedTextFieldHexaEdgeLine.setText(hex.toUpperCase());
            this.jPanelEdgeLineColorView.setBackground(cl);
            this.globalActionEdgeColor(cl);
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    private void jSpinnerFontSizeStateChanged(ChangeEvent evt) {
        this.updateNodeLabelAttribs(true, false, false, false, false, false, false, false, false, false, false);
    }

    private void jSpinnerFontSizeKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateNodeLabelAttribs(true, false, false, false, false, false, false, false, false, false, false);
        }
    }

    private void jComboBoxFontStyleActionPerformed(ActionEvent evt) {
        this.updateNodeLabelAttribs(false, false, true, false, false, false, false, false, false, false, false);
    }

    private void jComboBoxFontTypeActionPerformed(ActionEvent evt) {
        this.updateNodeLabelAttribs(false, true, false, false, false, false, false, false, false, false, false);
    }

    private void jSpinnerFontOffsetXStateChanged(ChangeEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, true, false, false, false, false, false, false, false);
    }

    private void jSpinnerFontOffsetXKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateNodeLabelAttribs(false, false, false, true, false, false, false, false, false, false, false);
        }
    }

    private void jSpinnerFontOffsetYStateChanged(ChangeEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, false, true, false, false, false, false, false, false);
    }

    private void jSpinnerFontOffsetYKeyPressed(KeyEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, false, true, false, false, false, false, false, false);
    }

    private void jButtonHideLabelsActionPerformed(ActionEvent evt) {
        this.globalHideLabels();
    }

    private void jButtonShowLabelsActionPerformed(ActionEvent evt) {
        this.globalShowLabels();
    }

    private void jFormattedTextFieldHexaFontKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Object hex = this.jFormattedTextFieldHexaFont.getText();
            if (((String)(hex = ((String)hex).replace(" ", ""))).length() > 0) {
                if (((String)hex).length() < 8) {
                    String plus = "000000FF";
                    hex = (String)hex + plus.substring(((String)hex).length(), plus.length());
                    this.jFormattedTextFieldHexaFont.setText((String)hex);
                }
                Color newColor = RederMainFrame.HexToColor((String)hex);
                this.jPanelFontColorView.setBackground(newColor);
                if (isPaintActive) {
                    this.repaint();
                }
                this.globalActionLabelColor(newColor);
            }
        }
    }

    private void jButtonFontColorPickerActionPerformed(ActionEvent evt) {
        String hex = this.jFormattedTextFieldHexaFont.getText();
        Color cl = RederMainFrame.HexToColor(hex);
        if ((cl = JColorChooser.showDialog(this, "Font color", cl)) != null) {
            hex = RederMainFrame.ColorToHex(cl, true);
            this.jFormattedTextFieldHexaFont.setText(hex.toUpperCase());
            this.jPanelFontColorView.setBackground(cl);
            this.globalActionLabelColor(cl);
            if (isPaintActive) {
                this.repaint();
            }
        }
    }

    private void jCheckBoxToolbarsFileActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxToolbarsFile.isSelected()) {
            this.jToolBarFile.setVisible(true);
            preferences.setToolBarFileVisible(true);
        } else {
            this.jToolBarFile.setVisible(false);
            preferences.setToolBarFileVisible(false);
        }
    }

    private void jCheckBoxToolbarsSelectActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxToolbarsSelect.isSelected()) {
            this.jToolBarSelect.setVisible(true);
            preferences.setToolBarSelectVisible(true);
        } else {
            this.jToolBarSelect.setVisible(false);
            preferences.setToolBarSelectVisible(false);
        }
    }

    private void jCheckBoxToolbarsEditActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxToolbarsEdit.isSelected()) {
            this.jToolBarEdit.setVisible(true);
            preferences.setToolBarEditVisible(true);
        } else {
            this.jToolBarEdit.setVisible(false);
            preferences.setToolBarEditVisible(false);
        }
    }

    private void jCheckBoxToolbarsLayoutActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxToolbarsLayout.isSelected()) {
            this.jToolBarLayout.setVisible(true);
            preferences.setToolBarLayoutVisible(true);
        } else {
            this.jToolBarLayout.setVisible(false);
            preferences.setToolBarLayoutVisible(false);
        }
    }

    private void jSpinnerEdgeWeightStateChanged(ChangeEvent evt) {
        this.updateEdgeAttribs1(false, false, false, true);
        this.resetCooling();
    }

    private void jSpinnerEdgeWeightKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateEdgeAttribs1(false, false, false, true);
            this.resetCooling();
        }
    }

    private void jCheckBoxScaleEdgeWeightActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxScaleEdgeWeight.isSelected()) {
            this.stop_casting_to_updates = true;
            this.jSpinnerEdgeWeight.setValue(1.0);
            this.stop_casting_to_updates = false;
        } else {
            this.stop_casting_to_updates = true;
            this.jSpinnerEdgeWeight.setValue(0.0);
            this.stop_casting_to_updates = false;
        }
    }

    private void jButtonExpandJFrameActionPerformed(ActionEvent evt) {
        this.expandJFrame();
    }

    private void jButtonContractJFrameActionPerformed(ActionEvent evt) {
        this.contractJFrame();
    }

    private void jTabbedPaneAttribsComponentResized(ComponentEvent evt) {
        RederMainFrame.updateGraph();
    }

    private void formComponentResized(ComponentEvent evt) {
        RederMainFrame.updateGraph();
    }

    private void jButtonLabelLeftActionPerformed(ActionEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, false, false, true, false, false, false, false, false);
    }

    private void jButtonLabelRightActionPerformed(ActionEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, false, false, false, true, false, false, false, false);
    }

    private void jButtonLabelTopActionPerformed(ActionEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, false, false, false, false, true, false, false, false);
    }

    private void jButtonLabelBottomActionPerformed(ActionEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, false, false, false, false, false, true, false, false);
    }

    private void jButtonLabelMiddleActionPerformed(ActionEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, false, false, false, false, false, false, false, true);
    }

    private void jButtonLabelCenterActionPerformed(ActionEvent evt) {
        this.updateNodeLabelAttribs(false, false, false, false, false, false, false, false, false, true, false);
    }

    private void jButtonFitNodeToLabelActionPerformed(ActionEvent evt) {
        this.FitNodeToLabel();
    }

    private void jMenuItem34ActionPerformed(ActionEvent evt) {
        this.globalActionSelectGraph(true, false);
    }

    private void jMenuItem40ActionPerformed(ActionEvent evt) {
        this.globalActionSelectGraph(false, true);
    }

    private void jTextFieldFindNodeKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jButtonFindNode();
        }
    }

    private void jSpinnerRotateKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            double dAngle = (Double)this.jSpinnerRotate.getValue();
            this.rotateAndFlip(true, false, false, dAngle);
        }
    }

    private void jButtonIconZoomResetActionPerformed(ActionEvent evt) {
        this.resetZoom();
    }

    static {
        viewArea = null;
        scale = 1.0;
        movendoNodos = false;
    }

    class TarefaFilterZoom
    extends SwingWorker<Void, Void> {
        TarefaFilterZoom() {
        }

        @Override
        public Void doInBackground() throws InterruptedException {
            double nodsz = (double)RederMainFrame.this.nodeAccountFound.getW() * zoomInOut * RederMainFrame.this.nodeAccountFound.getRelativeSize();
            float targetpx = (float)drawpanel.getWidth() / 2.0f;
            float targetpy = (float)drawpanel.getHeight() / 2.0f;
            float targetsz = (targetpx + targetpy) / 30.0f;
            if (RederMainFrame.this.nodeAccountFound.isContainer()) {
                targetsz *= 7.0f;
            }
            float dx = targetpx - RederMainFrame.this.nodeAccountFound.getX();
            float dy = targetpy - RederMainFrame.this.nodeAccountFound.getY();
            double dz = (double)targetsz - nodsz;
            float speeds = (float)((double)(Math.abs(dx) + Math.abs(dy)) + Math.abs(dz));
            float evolx = Math.abs(dx) / speeds * speeds * 0.1f;
            float evoly = Math.abs(dy) / speeds * speeds * 0.1f;
            double evolz = Math.abs(dz) / (double)speeds * (double)speeds;
            boolean andaz = false;
            boolean andax = false;
            boolean anday = false;
            boolean anda = !andax || !anday || !andaz;
            double ksteps = 0.0;
            while (anda && ksteps < 500.0) {
                float flip;
                ksteps += 1.0;
                if (!andaz) {
                    flip = dz <= 0.0 ? 1.0f : (dz > 0.0 ? -1.0f : 0.0f);
                    evolz = Math.min(0.05, evolz);
                    RederMainFrame.this.setFilterZoom(flip, RederMainFrame.this.nodeAccountFound.getX(), RederMainFrame.this.nodeAccountFound.getY(), evolz);
                }
                if (Math.abs(dz = (double)targetsz - (nodsz = (double)RederMainFrame.this.nodeAccountFound.getW() * zoomInOut * RederMainFrame.this.nodeAccountFound.getRelativeSize())) <= (double)(targetsz / 20.0f)) {
                    andaz = true;
                }
                for (int i = 0; i < NodeList.size(); ++i) {
                    RederMainFrame.this.nodeAccount = NodeList.get(i);
                    if (!andax) {
                        flip = dx < 0.0f ? -1.0f : (dx > 0.0f ? 1.0f : 0.0f);
                        RederMainFrame.this.nodeAccount.setX(RederMainFrame.this.nodeAccount.getX() + evolx * flip);
                    }
                    if (anday) continue;
                    flip = dy < 0.0f ? -1.0f : (dy > 0.0f ? 1.0f : 0.0f);
                    RederMainFrame.this.nodeAccount.setY(RederMainFrame.this.nodeAccount.getY() + evoly * flip);
                }
                dx = targetpx - RederMainFrame.this.nodeAccountFound.getX();
                if (Math.abs(dx) <= 20.0f) {
                    andax = true;
                }
                if (Math.abs(dy = targetpy - RederMainFrame.this.nodeAccountFound.getY()) <= 20.0f) {
                    anday = true;
                }
                if (isPaintActive) {
                    RederMainFrame.this.repaint();
                }
                Thread.sleep(30L);
                speeds = (float)((double)(Math.abs(dx) + Math.abs(dy)) + Math.abs(dz));
                evolx = Math.abs(dx) / speeds * speeds * 0.1f;
                evoly = Math.abs(dy) / speeds * speeds * 0.1f;
                evolz = Math.abs(dz) / (double)speeds;
                boolean bl = anda = !andax || !anday || !andaz;
                if (RederMainFrame.this.nodeAccountFound != null) continue;
                anda = false;
            }
            return null;
        }

        @Override
        public void done() {
            if (RederMainFrame.this.nodeAccountFound != null) {
                RederMainFrame.this.nodeAccountFound.setDestaque(true);
                RederMainFrame.this.changeOrder("forward");
                if (RederMainFrame.this.nodeAccountFound.isContainer()) {
                    if (isPaintActive) {
                        drawpanel.repaint();
                    }
                } else {
                    methods.taskHighlight();
                }
            }
            if (RederMainFrame.this.taskFilterZoom != null && !RederMainFrame.this.taskFilterZoom.isCancelled()) {
                RederMainFrame.this.taskFilterZoom.cancel(true);
            }
        }
    }

    class TarefaRelax
    extends SwingWorker<Void, Void> {
        TarefaRelax() {
        }

        @Override
        public Void doInBackground() throws IOException, InterruptedException {
            RederMainFrame.this.resetDeltaXY();
            while (isRelaxActive) {
                if (!requesting_zoom_and_flips) {
                    lockDragAndZoom = true;
                    RederMainFrame.this.relax();
                } else {
                    lockDragAndZoom = false;
                    Thread.sleep(30L);
                    requesting_zoom_and_flips = false;
                }
                try {
                    if (!optimizeRendering) {
                        Thread.sleep(30L);
                    }
                }
                catch (InterruptedException ignore) {
                    RederMainFrame.this.stopRelax();
                }
                if (isRelaxActive && !lockMouse) continue;
                RederMainFrame.this.stopRelax();
            }
            return null;
        }

        @Override
        public void done() {
            RederMainFrame.this.stopRelax();
            RederMainFrame.this.taskRelax = null;
        }
    }

    class TarefaLayout
    extends SwingWorker<Void, Void> {
        RedHandler dr = new RedHandler();
        ArrayList<Integer> lm = this.dr.getNodeStackPosition("container", "selected");
        ArrayList<EdgeBank> subEdgeList = new ArrayList();
        NodeBank containerAccount;
        Zoom zm = new Zoom();

        TarefaLayout() {
        }

        @Override
        public Void doInBackground() throws IOException {
            double ww = drawpanel.getWidth();
            double hh = drawpanel.getHeight();
            if (!this.lm.isEmpty()) {
                for (int i = 0; i < this.lm.size(); ++i) {
                    Point2D[] pontos;
                    this.subEdgeList.clear();
                    int cIn = this.lm.get(i);
                    this.containerAccount = NodeList.get(cIn);
                    if (!this.containerAccount.isContainer() || this.containerAccount.getContainerComponents().isEmpty()) continue;
                    for (int j = 0; j < EdgeList.size(); ++j) {
                        RederMainFrame.this.edgeAccount = EdgeList.get(j);
                        int numeroA = RederMainFrame.this.edgeAccount.getA();
                        int numeroB = RederMainFrame.this.edgeAccount.getB();
                        int testA = this.containerAccount.getContainerComponents().indexOf(numeroA);
                        int testB = this.containerAccount.getContainerComponents().indexOf(numeroB);
                        if (testA == -1 || testB == -1) continue;
                        this.subEdgeList.add(new EdgeBank(testA, testB, this.subEdgeList.size()));
                    }
                    double rz = this.containerAccount.getRelativeSize();
                    ww = (double)this.containerAccount.getW() * zoomInOut * rz;
                    hh = (double)this.containerAccount.getH() * zoomInOut * rz;
                    double d = (ww + hh) / 4.0;
                    d *= 2.0 / Math.sqrt(2.0);
                    int ccsize = this.containerAccount.getContainerComponents().size();
                    switch (RederMainFrame.this.graphType) {
                        case 0: {
                            pontos = RederMainFrame.this.layoutGrid(this.containerAccount.getContainerComponents(), RederMainFrame.this.ncolgrid, RederMainFrame.this.gapxgrid, RederMainFrame.this.gapygrid);
                            pontos = this.zm.setCenter(pontos, this.containerAccount.getX(), this.containerAccount.getY());
                            break;
                        }
                        case 1: {
                            pontos = RederMainFrame.this.layoutCircle(this.containerAccount.getContainerComponents(), d, d, 0.92);
                            break;
                        }
                        default: {
                            pontos = RederMainFrame.this.layoutRandom(ccsize, d, d);
                        }
                    }
                    for (int j = 0; j < ccsize; ++j) {
                        float x = (float)pontos[j].getX();
                        float y = (float)pontos[j].getY();
                        RederMainFrame.this.nodeAccount = NodeList.get(this.containerAccount.getContainerComponents().get(j));
                        if (RederMainFrame.this.nodeAccount.isContainer()) {
                            RederMainFrame.this.nodeAccount.moveTree(x, y);
                            continue;
                        }
                        RederMainFrame.this.nodeAccount.setNode(x, y);
                    }
                    if (RederMainFrame.this.graphType == 0) continue;
                    this.containerAccount.updateContent();
                }
                if (isPaintActive) {
                    RederMainFrame.this.repaint();
                }
                this.lm.clear();
            } else {
                this.lm = this.dr.getNodeStackPosition("node", "selected");
                if (!this.lm.isEmpty()) {
                    Point2D[] pontos;
                    double centerY;
                    double centerX;
                    this.subEdgeList.clear();
                    for (int j = 0; j < EdgeList.size(); ++j) {
                        RederMainFrame.this.edgeAccount = EdgeList.get(j);
                        int numeroA = RederMainFrame.this.edgeAccount.getA();
                        int numeroB = RederMainFrame.this.edgeAccount.getB();
                        int testA = this.lm.indexOf(numeroA);
                        int testB = this.lm.indexOf(numeroB);
                        if (testA == -1 || testB == -1) continue;
                        this.subEdgeList.add(new EdgeBank(testA, testB, this.subEdgeList.size()));
                    }
                    if (RederMainFrame.this.lastDragArea == null) {
                        double xMax = 0.0;
                        double yMax = 0.0;
                        double xMin = 1.0E8;
                        double yMin = 1.0E8;
                        for (int j = 0; j < this.lm.size(); ++j) {
                            RederMainFrame.this.nodeAccount = NodeList.get(this.lm.get(j));
                            double x = RederMainFrame.this.nodeAccount.getX();
                            double y = RederMainFrame.this.nodeAccount.getY();
                            if (x > xMax) {
                                xMax = x;
                            }
                            if (y > yMax) {
                                yMax = y;
                            }
                            if (x < xMin) {
                                xMin = x;
                            }
                            if (!(y < yMin)) continue;
                            yMin = y;
                        }
                        ww = xMax - xMin;
                        hh = yMax - yMin;
                        centerX = xMin + ww / 2.0;
                        centerY = yMin + hh / 2.0;
                    } else {
                        centerX = RederMainFrame.this.lastDragArea.getCenterX();
                        centerY = RederMainFrame.this.lastDragArea.getCenterY();
                        ww = RederMainFrame.this.lastDragArea.getWidth();
                        hh = RederMainFrame.this.lastDragArea.getHeight();
                    }
                    switch (RederMainFrame.this.graphType) {
                        case 0: {
                            pontos = RederMainFrame.this.layoutGrid(this.lm, RederMainFrame.this.ncolgrid, RederMainFrame.this.gapxgrid, RederMainFrame.this.gapygrid);
                            break;
                        }
                        case 1: {
                            pontos = RederMainFrame.this.layoutCircle(this.lm, ww, hh, 0.92);
                            break;
                        }
                        default: {
                            pontos = RederMainFrame.this.layoutRandom(this.lm.size(), ww, hh);
                        }
                    }
                    pontos = this.zm.setCenter(pontos, centerX, centerY);
                    for (int j = 0; j < this.lm.size(); ++j) {
                        float x = (float)pontos[j].getX();
                        float y = (float)pontos[j].getY();
                        int nn = this.lm.get(j);
                        RederMainFrame.this.nodeAccount = NodeList.get(nn);
                        RederMainFrame.this.nodeAccount.setNode(x, y);
                    }
                    if (isPaintActive) {
                        RederMainFrame.this.repaint();
                    }
                    this.lm.clear();
                } else {
                    this.lm = this.dr.getNodeStackPosition("container", "all");
                    if (this.lm.isEmpty()) {
                        Point2D[] pontos;
                        if (NodeList.size() <= 1) {
                            return null;
                        }
                        this.lm = new ArrayList();
                        for (int i = 0; i < NodeList.size(); ++i) {
                            RederMainFrame.this.nodeAccount = NodeList.get(i);
                            if (RederMainFrame.this.nodeAccount.isSpot()) continue;
                            this.lm.add(i);
                        }
                        switch (RederMainFrame.this.graphType) {
                            case 0: {
                                pontos = RederMainFrame.this.layoutGrid(this.lm, RederMainFrame.this.ncolgrid, RederMainFrame.this.gapxgrid, RederMainFrame.this.gapygrid);
                                break;
                            }
                            case 1: {
                                pontos = RederMainFrame.this.layoutCircle(this.lm, ww, hh, 0.85);
                                break;
                            }
                            default: {
                                pontos = RederMainFrame.this.layoutRandom(this.lm.size(), ww, hh);
                            }
                        }
                        pontos = this.zm.setCenter(pontos, ww / 2.0, hh / 2.0);
                        int size = NodeList.size();
                        for (int i = 0; i < size; ++i) {
                            float x = (float)pontos[i].getX();
                            float y = (float)pontos[i].getY();
                            RederMainFrame.this.nodeAccount = NodeList.get(i);
                            RederMainFrame.this.nodeAccount.setNode(x, y);
                        }
                    } else {
                        Point2D[] pontos;
                        int j;
                        this.lm.clear();
                        this.subEdgeList.clear();
                        for (int i = 0; i < NodeList.size(); ++i) {
                            RederMainFrame.this.nodeAccount = NodeList.get(i);
                            if (RederMainFrame.this.nodeAccount.isNodeNested() || RederMainFrame.this.nodeAccount.isSpot()) continue;
                            this.lm.add(i);
                        }
                        if (this.lm.size() <= 1) {
                            return null;
                        }
                        for (j = 0; j < EdgeList.size(); ++j) {
                            RederMainFrame.this.edgeAccount = EdgeList.get(j);
                            int numeroA = RederMainFrame.this.edgeAccount.getA();
                            int numeroB = RederMainFrame.this.edgeAccount.getB();
                            int testA = this.lm.indexOf(numeroA);
                            int testB = this.lm.indexOf(numeroB);
                            if (testA == -1 || testB == -1) continue;
                            this.subEdgeList.add(new EdgeBank(testA, testB, this.subEdgeList.size()));
                        }
                        switch (RederMainFrame.this.graphType) {
                            case 0: {
                                pontos = RederMainFrame.this.layoutGrid(this.lm, RederMainFrame.this.ncolgrid, RederMainFrame.this.gapxgrid, RederMainFrame.this.gapygrid);
                                break;
                            }
                            case 1: {
                                pontos = RederMainFrame.this.layoutCircle(this.lm, ww, hh, 0.92);
                                break;
                            }
                            default: {
                                pontos = RederMainFrame.this.layoutRandom(this.lm.size(), ww, hh);
                            }
                        }
                        pontos = this.zm.setCenter(pontos, ww / 2.0, hh / 2.0);
                        for (j = 0; j < this.lm.size(); ++j) {
                            float x = (float)pontos[j].getX();
                            float y = (float)pontos[j].getY();
                            int nn = this.lm.get(j);
                            RederMainFrame.this.nodeAccount = NodeList.get(nn);
                            if (RederMainFrame.this.nodeAccount.isContainer()) {
                                RederMainFrame.this.nodeAccount.moveTree(x, y);
                                continue;
                            }
                            RederMainFrame.this.nodeAccount.setNode(x, y);
                        }
                        this.lm.clear();
                    }
                    if (isPaintActive) {
                        RederMainFrame.this.repaint();
                    }
                }
            }
            return null;
        }

        @Override
        public void done() {
            RederMainFrame.this.stopProgress();
            RederMainFrame.this.taskLayout = null;
        }
    }

    class TarefaExport
    extends SwingWorker<Void, Void> {
        TarefaExport() {
        }

        @Override
        public Void doInBackground() throws IOException {
            if (RederMainFrame.this.ioFileType.equals("pdf")) {
                ExportPDF exportPDF = new ExportPDF();
                exportPDF.inputAndGo(drawpanel, saveAddress, RederMainFrame.this.ioFileType);
            } else if (RederMainFrame.this.ioFileType.equals("svg")) {
                ExportSVG exportSVG = new ExportSVG();
                exportSVG.inputAndGo(drawpanel, saveAddress, RederMainFrame.this.ioFileType);
            } else {
                ExportImage export = new ExportImage();
                export.inputAndGo(drawpanel, scale, saveAddress, RederMainFrame.this.ioFileType);
            }
            return null;
        }

        @Override
        public void done() {
            RederMainFrame.this.stopProgress();
            RederMainFrame.this.taskExport = null;
            RederMainFrame.this.setSpotsHided(false);
        }
    }

    class TarefaSave
    extends SwingWorker<Void, Void> {
        SaveData salvar;

        TarefaSave() {
        }

        @Override
        public Void doInBackground() throws IOException {
            this.salvar = new SaveData();
            RederMainFrame.this.zeraZoom();
            this.salvar.inputAndGo(saveAddress, RederMainFrame.this.ioFileType, NodeList, EdgeList, LegendList, RederMainFrame.getCentroX(), RederMainFrame.getCentroY(), zoomInOut, backgroundColor, edgeTarget, outEdgeTarget, stiffness, repulsionFactor, outRepulsionFactor, nodeSpeedLimit, perimeterEffect, repulsionRadius, centralPull);
            return null;
        }

        @Override
        public void done() {
            if (!RederMainFrame.this.taskSave.isCancelled() && this.salvar.getProgress().equals("halt")) {
                JOptionPane.showMessageDialog(RederMainFrame.this.jPanelInicial, "Save error!", "ERROR!", 0);
            }
            RederMainFrame.this.stopProgress();
            RederMainFrame.this.taskSave = null;
        }
    }

    class TarefaOpen
    extends SwingWorker<Void, Void> {
        LoadData carregar;

        TarefaOpen() {
        }

        @Override
        public Void doInBackground() throws FileNotFoundException, IOException {
            this.carregar = new LoadData();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.carregar.inputAndGo(openAddress, RederMainFrame.this.ioFileType, RederMainFrame.getCentroX(), RederMainFrame.getCentroY());
            return null;
        }

        @Override
        public void done() {
            RederMainFrame.this.stopProgress();
            if (!RederMainFrame.this.taskOpen.isCancelled()) {
                if (this.carregar.getProgress().equals("endload")) {
                    if (RederMainFrame.this.loadingOption.equals("addGraph")) {
                        int i;
                        RederMainFrame.this.resetZoom();
                        for (i = 0; i < this.carregar.getNodeBank().size(); ++i) {
                            NodeBank newNodeAccount = this.carregar.getNodeBank().get(i);
                            String strNodeID = newNodeAccount.getNodeID();
                            boolean flag = false;
                            for (int j = 0; j < NodeList.size(); ++j) {
                                NodeBank node = NodeList.get(j);
                                if (!node.getNodeID().equals(strNodeID)) continue;
                                NodeList.set(j, newNodeAccount);
                                flag = true;
                                break;
                            }
                            if (flag) continue;
                            int intNodeID = NodeList.size();
                            NodeList.add(newNodeAccount);
                            keyNodeHash.put(strNodeID, intNodeID);
                            keyNodeArray.add(strNodeID);
                        }
                        for (i = 0; i < this.carregar.getEdgeBank().size(); ++i) {
                            EdgeBank newEdgeAccount = this.carregar.getEdgeBank().get(i);
                            NodeBank newnodea = this.carregar.getNodeBank().get(newEdgeAccount.getA());
                            NodeBank newnodeb = this.carregar.getNodeBank().get(newEdgeAccount.getB());
                            int na = (Integer)keyNodeHash.get(newnodea.getNodeID());
                            int nb = (Integer)keyNodeHash.get(newnodeb.getNodeID());
                            newEdgeAccount.setA(na);
                            newEdgeAccount.setB(nb);
                            boolean flag = false;
                            for (int j = 0; j < EdgeList.size(); ++j) {
                                EdgeBank edge = EdgeList.get(j);
                                NodeBank nodea = NodeList.get(edge.getA());
                                NodeBank nodeb = NodeList.get(edge.getB());
                                if ((!nodea.getNodeID().equals(newnodea.getNodeID()) || !nodeb.getNodeID().equals(newnodeb.getNodeID())) && (!nodea.getNodeID().equals(newnodeb.getNodeID()) || !nodeb.getNodeID().equals(newnodea.getNodeID()))) continue;
                                EdgeList.set(j, newEdgeAccount);
                                flag = true;
                                break;
                            }
                            if (flag) continue;
                            EdgeList.add(newEdgeAccount);
                        }
                        methods.updateBanks();
                    } else {
                        NodeList = this.carregar.getNodeBank();
                        EdgeList = this.carregar.getEdgeBank();
                        keyNodeHash = this.carregar.getKeyNodeHash();
                        keyNodeArray = this.carregar.getKeyNodeArray();
                        backgroundColor = this.carregar.getBackgroundColor();
                        drawpanel.setBackground(backgroundColor);
                        zoomInOut = this.carregar.getZoomInOut();
                        repulsionRadius = this.carregar.getRepulseRadius();
                        edgeTarget = this.carregar.getEdgeTarget();
                        outEdgeTarget = this.carregar.getOutedgeTarget();
                        stiffness = this.carregar.getStiffness();
                        repulsionFactor = this.carregar.getRepelFactor();
                        outRepulsionFactor = this.carregar.getOutsideRepelFactor();
                        nodeSpeedLimit = this.carregar.getNodeSpeedLimit();
                        perimeterEffect = this.carregar.getPerimeterEffect();
                        centralPull = this.carregar.getCentralPull();
                        drawpanel.setZoom((float)zoomInOut);
                        methods.updateBanks();
                        RederMainFrame.this.redoZoomScale();
                        RederMainFrame.this.updateRelaxPanel();
                        RederMainFrame.this.fitToWindow(0.85);
                        LegendList = this.carregar.getLegendBank();
                        methods.updateLegendOnLoad();
                    }
                }
            } else if (!RederMainFrame.this.taskOpen.isCancelled() && this.carregar.getProgress().equals("halt")) {
                JOptionPane.showMessageDialog(RederMainFrame.this.jPanelInicial, "Loading error!", "ERROR!", 0);
            }
            for (int j = 0; j < NodeList.size(); ++j) {
                RederMainFrame.this.nodeAccount = NodeList.get(j);
                RederMainFrame.this.nodeAccount.updateRelativeSize();
            }
            RederMainFrame.this.taskOpen = null;
        }
    }

    class TarefaListenerDcall
    extends SwingWorker<Void, Void> {
        TarefaListenerDcall() {
        }

        @Override
        public Void doInBackground() throws IOException, InterruptedException {
            String loop = "inf";
            while (loop.equals("inf")) {
                Thread.sleep(100L);
                if (updateRelaxPanel) {
                    RederMainFrame.this.updateRelaxPanel();
                    updateRelaxPanel = false;
                }
                if (!activateRelaxDcall) continue;
                RederMainFrame.this.updateRelaxPanel();
                if (!isRelaxActive) {
                    RederMainFrame.this.startRelax();
                }
                activateRelaxDcall = false;
            }
            return null;
        }
    }
}

