/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.internal;

import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.pdf.DefaultFontMapper;
import org.jfree.pdf.FontMapper;
import org.jfree.pdf.PDFDocument;
import org.jfree.pdf.Page;
import org.jfree.pdf.dictionary.Dictionary;
import org.jfree.pdf.internal.FontKey;
import org.jfree.pdf.internal.PDFFont;
import org.jfree.pdf.internal.PDFObject;
import org.jfree.pdf.util.Args;

public final class Pages
extends PDFObject {
    private final PDFDocument parent;
    private final List<Page> pages;
    private final List<PDFFont> fonts;
    private final Map<FontKey, PDFFont> fontMap;
    private int nextFont = 1;
    private final FontMapper fontMapper;

    public Pages(int number, int generation, PDFDocument parent) {
        super(number, generation);
        Args.nullNotPermitted(parent, "parent");
        this.parent = parent;
        this.pages = new ArrayList<Page>();
        this.fonts = new ArrayList<PDFFont>();
        this.fontMap = new HashMap<FontKey, PDFFont>();
        this.fontMapper = new DefaultFontMapper();
    }

    public PDFDocument getDocument() {
        return this.parent;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public List<PDFFont> getFonts() {
        return this.fonts;
    }

    public PDFFont getFont(String name) {
        for (PDFFont f : this.fonts) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public void add(Page page) {
        this.pages.add(page);
    }

    public String findOrCreateFontReference(Font f) {
        FontKey fontKey = FontKey.createFontKey(f);
        PDFFont pdfFont = this.fontMap.get(fontKey);
        if (pdfFont == null) {
            int number = this.parent.getNextNumber();
            String name = "/F" + this.nextFont + "-" + f.getFamily().replace(' ', '_');
            String baseFont = this.fontMapper.mapToBaseFont(f);
            ++this.nextFont;
            pdfFont = new PDFFont(number, 0, name, "/" + baseFont, "/MacRomanEncoding");
            this.fonts.add(pdfFont);
            this.fontMap.put(fontKey, pdfFont);
        }
        return pdfFont.getName();
    }

    private Dictionary createDictionary() {
        Dictionary dictionary = new Dictionary("/Pages");
        Page[] pagesArray = new Page[this.pages.size()];
        for (int i = 0; i < this.pages.size(); ++i) {
            pagesArray[i] = this.pages.get(i);
        }
        dictionary.put("/Kids", pagesArray);
        dictionary.put("/Count", this.pages.size());
        return dictionary;
    }

    @Override
    public byte[] getObjectBytes() {
        return this.createDictionary().toPDFBytes();
    }
}

