###################################################
### chunk number 1: setup
###################################################
options(width=40)


###################################################
### chunk number 2: findingnFCSfiles
###################################################
library(flowCore)
library(flowTrack)
library(flowViz)
library(flowStats)


###################################################
### chunk number 3: findingnFCSfiles
###################################################
library(flowCore)
library(flowTrack)
library(flowViz)

system.file("extdata", package = "flowTrack")


###################################################
### chunk number 4: ReadFlowSetReal
###################################################
pth <- system.file("extdata", package = "flowTrack")
flowData <- read.flowSet(path = pth, phenoData="annotation.txt", 
                transformation=FALSE)


###################################################
### chunk number 5: ReadFlowSetShow eval=FALSE
###################################################
## flowData <- read.flowSet( phenoData="annotation.txt",
##                 transformation=FALSE)


###################################################
### chunk number 6: readflow
###################################################
head(pData(flowData))
sampleNames(flowData) <- pData(flowData)[,"PatientID"]


###################################################
### chunk number 7: UpdateDescriptionFields
###################################################
for(i in seq_len(length(flowData))){
    pData(parameters(flowData[[i]]))[,"desc"] <- c(NA, NA, "CD8", "CD69",
                                                   "CD4","CD3", "HLADr","NA")
}


###################################################
### chunk number 8: xyplotFormula eval=FALSE
###################################################
## xyplot(y ~ x , data, xlab, ylab, main)
## densityplot( ~ x, data, xlab, ylab, main)     


###################################################
### chunk number 9: untransData
###################################################
myplot <- splom(flowData[[1]])


###################################################
### chunk number 10: untransDataP
###################################################
print(myplot)


###################################################
### chunk number 11: transformData
###################################################
tf <-  transformList(colnames(flowData)[3:7], asinh)
tData <- transform(flowData, tf)


###################################################
### chunk number 12: xyplotFITCPEA
###################################################
myplot <- xyplot( `FITC-A` ~ `PE-A`, tData, 
                    main=" My xyplot of FITC-A/PE-A")


###################################################
### chunk number 13: xyplotFITCPEAPrint
###################################################
print(myplot)


###################################################
### chunk number 14: densityplotFITC
###################################################
myplot <- densityplot( ~ `FITC-A`, tData,
                    main=" My density plot of FITC-A")


###################################################
### chunk number 15: densityplotFITCPrint
###################################################
print(myplot)


###################################################
### chunk number 16: basicworkFlow
###################################################
mw <- workFlow(tData, name ="myWork")
rg <- rectangleGate("FSC-A"=c(100, 600), "SSC-A"=c(100, 600),
        filterId="rectangle")
add(mw, rg, parent="base view")
mw


###################################################
### chunk number 17: rectGatePlot
###################################################
myplot <- xyplot(`FSC-A` ~ `SSC-A`, Data( mw[["rectangle+"]]))


###################################################
### chunk number 18: plotRectGate
###################################################
print(myplot)


###################################################
### chunk number 19: start the work flow
###################################################
colnames(flowData) <- c("FSC", "SSC","CD8","CD69", "CD4","CD3",
                        "HLADr", "Time")
wf <- workFlow(flowData, name="biocExample")


###################################################
### chunk number 20: Transform the data
###################################################
tf <- transformList(colnames(Data(wf[["base view"]]))[3:7], asinh,
                    transformationId="asinh")
add(wf, tf)
wf


###################################################
### chunk number 21: Boundary filter FSC SSC channels
###################################################
    boundFilt <- boundaryFilter(filterId="boundFilt", x=c("FSC","SSC"))
    add(wf,boundFilt,parent="asinh")



###################################################
### chunk number 22: lymphGate
###################################################
lg <- lymphGate(Data(wf[["boundFilt+"]]), channels=c("FSC", "SSC"),
                preselection="CD3", filterId="TCells", eval=FALSE,
                scale=2.5)
add(wf, lg$n2gate, parent="boundFilt+")
myplot <- xyplot(SSC ~ FSC| PatientID, wf[["TCells+"]],
      par.settings=list(gate=list(col="red",
         fill="red", alpha=0.3)))



###################################################
### chunk number 23: lymphGatePlot
###################################################
print(myplot)


###################################################
### chunk number 24: DataBeforeNormalization
###################################################
myplot <-densityplot(PatientID~., Data(wf[["TCells+"]]), 
            channels=c("CD3","CD4","CD8"), groups=GroupID,
            scales=list(y=list(draw=F)),
            filter=lapply(c("CD3","CD4","CD8"), curv1Filter),
            layout=c(3,1))


###################################################
### chunk number 25: beforeNormPlot
###################################################
print(myplot)


###################################################
### chunk number 26: Data after normalization
###################################################
pars <- colnames(Data(wf[["base view"]]))[c(3,4,5,6)]
norm <- normalization(normFun=function(x, parameters, ...)
                      warpSet(x, parameters,...),
                      parameters=pars,
                      normalizationId="Warping")
add(wf, norm, parent="TCells+")


###################################################
### chunk number 27: createNormalizedPlot
###################################################
myplot <- densityplot(PatientID~., Data(wf[["Warping"]]),
                  channels=c("CD3","CD4","CD8"), groups=GroupID,
                  scales=list(y=list(draw=F)),
                  filter=lapply(c("CD3","CD4","CD8"), curv1Filter),
                  layout=c(3,1))


###################################################
### chunk number 28: afterNormPlot
###################################################
print(myplot)


###################################################
### chunk number 29: QuadrantgateCD3+CD4+
###################################################
qgate <- quadrantGate(Data(wf[["Warping"]]), stains=c("CD3", "CD4"),
                      plot=FALSE, filterId="CD3CD4")
add(wf, qgate, parent="Warping")


###################################################
### chunk number 30: PlotQuadrantGateCD3+CD4+
###################################################
myplot <- xyplot(CD3 ~ CD4 | PatientID, wf[["CD3+CD4+"]] )


###################################################
### chunk number 31: CD3+CD4+quadPlot
###################################################
print(myplot)


###################################################
### chunk number 32: QuadrantGateCD3+CD8+
###################################################
qgate <- quadrantGate(Data(wf[["Warping"]]), stains=c("CD3", "CD8"),
                      plot=FALSE, filterId="CD3CD8")
add(wf, qgate, parent="Warping")


###################################################
### chunk number 33: PlotQuadrantGateCD3+CD8+
###################################################
myplot <- xyplot(CD3 ~ CD8 | PatientID, wf[["CD3+CD8+"]])


###################################################
### chunk number 34: CD3+CD8+quadPlot
###################################################
print(myplot)


###################################################
### chunk number 35: HLADrActivatedCD3+CD4+
###################################################
HLADr1 <- rangeGate(Data(wf[["CD3+CD4+"]]), stain="HLADr", plot=FALSE,
                    alpha=0.75, filterId="CD3+CD4+HLAct")
add(wf, HLADr1, parent="CD3+CD4+")


###################################################
### chunk number 36: PlotHLADrActivatedCD3+CD4+
###################################################
myplot <- densityplot(PatientID ~ HLADr, Data(wf[["CD3+CD4+"]]),
            refline=HLADr1@min)


###################################################
### chunk number 37: HLADrActivatedCD3+CD4+Plot
###################################################
print(myplot)


###################################################
### chunk number 38: HLADrActivatedCD3+CD8+
###################################################
HLADr2 <- rangeGate(Data(wf[["CD3+CD8+"]]), stain="HLADr", plot=FALSE,
                    alpha=0.75, filterId="CD3+CD8+HLAct")
add(wf, HLADr2, parent="CD3+CD8+")


###################################################
### chunk number 39: PlotHLADrActivatedCD3+CD8+
###################################################
myplot <- densityplot(PatientID ~ HLADr, Data(wf[["CD3+CD8+"]]), 
            refline=HLADr2@min)


###################################################
### chunk number 40: HLADrActivatedCD3+CD8+Plot
###################################################
print(myplot)


###################################################
### chunk number 41: SummaryHLADrActivatedCD3+CD4+
###################################################
pr <-fsApply(Data(wf[["CD3+CD4+HLAct-"]]),nrow)*100 /
        fsApply(Data(wf[["boundFilt+"]]),nrow)
res <- data.frame(pr, pData(Data(wf[["CD3+CD4+"]]))[c("GroupID","PatientID")])


###################################################
### chunk number 42: SummaryHLADrActivatedCD3+CD4+
###################################################
myplot <- barchart(reorder(PatientID, as.numeric(factor(GroupID))) ~ pr, 
            data=res, groups=GroupID,stack=TRUE, 
            auto.key=list(points = FALSE, rectangles = TRUE, space = "right"),
            main="Activated CD3+CD4+ T cells", 
            xlab="Percentage of activated cells")


###################################################
### chunk number 43: HLADrActivatedCD3+CD4+Summary
###################################################
print(myplot)


###################################################
### chunk number 44: SummaryHLADRrActivatedCD3+CD8+
###################################################
pr <- fsApply(Data(wf[["CD3+CD8+HLAct-"]]),nrow)*100 /
          fsApply(Data(wf[["boundFilt+"]]),nrow)
res <- data.frame(pr,pData(Data(wf[["CD3+CD8+"]]))[c("GroupID","PatientID")])


###################################################
### chunk number 45: PlotSummaryHLADRrActivatedCD3+CD8+
###################################################
myplot <- barchart(reorder(PatientID,as.numeric(factor(GroupID))) ~ pr,
            data=res, groups=GroupID, stack=TRUE,
            auto.key = list(points = FALSE, rectangles = TRUE, space = "right"),
            main="Activated  CD3+CD8+ T cells",
            xlab=" Percentage of activated cells")


###################################################
### chunk number 46: HLADrActivatedCD3+CD8+Summary
###################################################
print(myplot)


###################################################
### chunk number 47: sessionInfo
###################################################
toLatex(sessionInfo())


