## salloc -N 4 orterun -n 4 R --slave -f simd.R
sink("/dev/null") # don't capture output -- more care needed here
library(Rmpi)

TAGS = list(FROM_WORKER=1L)
.comm = 0L

## shared `work', here just determine rank and host
work = c(rank=mpi.comm.rank(.comm),
         host=system("hostname", intern=TRUE))
mpi.barrier(.comm)

if (0L != mpi.comm.rank(.comm)) {
    ## worker
    mpi.send.Robj(work, 0L, TAGS$FROM_WORKER, comm=.comm)
} else {
    ## manager
    nWorkers = mpi.comm.size(.comm)
    res = list(nWorkers)
    for (i in seq_len(nWorkers - 1L))
        res[[i]] <- mpi.recv.Robj(mpi.any.source(), TAGS$FROM_WORKER,
                                  comm=.comm)
    res[[nWorkers]] = work 
    sink() # start capturing output
    print(do.call(rbind, res)) 
}
mpi.quit()
