## salloc -N 8 orterun -n 1 R -f random.R
library(Rmpi)

nWorkers = mpi.universe.size() - 1L
mpi.spawn.Rslaves(nsl=nWorkers)
mpi.setup.rngstream()

mpi.parReplicate(20, mean(rnorm(1000)))

g = function(i)
    c(rank=mpi.comm.rank(), mean=mean(rnorm(1000)))
res = mpi.parSapply(1:20, g)
as.data.frame(t(res))

f = function() 
    c(rank=mpi.comm.rank(), mean=mean(rnorm(1000)))
mpi.bcast.Robj2slave(f)
res <- mpi.parReplicate(20, f())
as.data.frame(t(res))

mpi.close.Rslaves()
mpi.quit()
