### Name: GOMFPARENTS
### Title: Annotation of GO Identifiers to their Molecular Function Parents
### Aliases: GOMFPARENTS
### Keywords: datasets

### ** Examples

    require("GO", character.only = TRUE) || stop("GO unavailable")
    require("annotate", character.only = TRUE) || stop("annotate unavailable")
    # Convert the environment object to a list
    xx <- as.list(GOMFPARENTS)
    # Remove GO ids that do not have any parent
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # Get the parent GO ids for the first elents of xx
        goids <- xx[[1]]
        # Find out the GO terms for the first parent goid
        GOID(GOTERM[[goids[1]]])
        Term(GOTERM[[goids[1]]])
        Synonym(GOTERM[[goids[1]]])
        Secondary(GOTERM[[goids[1]]])
        Definition(GOTERM[[goids[1]]])
        Category(GOTERM[[goids[1]]])
    }



