/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;

public abstract class Z3Object {
    private final Context m_ctx;
    private final long m_n_obj;

    Z3Object(Context context, long l) {
        this.m_ctx = context;
        this.checkNativeObject(l);
        this.m_n_obj = l;
        this.incRef();
        this.addToReferenceQueue();
    }

    abstract void addToReferenceQueue();

    abstract void incRef();

    void checkNativeObject(long l) {
    }

    long getNativeObject() {
        return this.m_n_obj;
    }

    static long getNativeObject(Z3Object z3Object) {
        if (z3Object == null) {
            return 0L;
        }
        return z3Object.getNativeObject();
    }

    Context getContext() {
        return this.m_ctx;
    }

    public static long[] arrayToNative(Z3Object[] z3ObjectArray) {
        if (z3ObjectArray == null) {
            return null;
        }
        long[] lArray = new long[z3ObjectArray.length];
        for (int i = 0; i < z3ObjectArray.length; ++i) {
            lArray[i] = z3ObjectArray[i] == null ? 0L : z3ObjectArray[i].getNativeObject();
        }
        return lArray;
    }

    public static int arrayLength(Z3Object[] z3ObjectArray) {
        return z3ObjectArray == null ? 0 : z3ObjectArray.length;
    }
}

