/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

import com.j256.simplemagic.ContentInfoUtil;
import com.j256.simplemagic.endian.EndianConverter;
import com.j256.simplemagic.endian.EndianType;
import com.j256.simplemagic.entries.MagicEntry;
import com.j256.simplemagic.entries.MagicFormatter;
import com.j256.simplemagic.entries.MagicMatcher;
import com.j256.simplemagic.entries.MagicType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MagicEntryParser {
    public static final String UNKNOWN_NAME = "unknown";
    private static final String MIME_TYPE_LINE = "!:mime";
    private static final String OPTIONAL_LINE = "!:optional";
    private static final Pattern OFFSET_PATTERN = Pattern.compile("\\(([0-9a-fA-Fx]+)\\.?([bsilBSILm]?)([\\*\\+\\-]?)([0-9a-fA-Fx]*)\\)");

    public static MagicEntry parseLine(MagicEntry previous, String line, ContentInfoUtil.ErrorCallBack errorCallBack) {
        String name;
        MagicFormatter formatter;
        Object testValue;
        String testStr;
        MagicEntry.OffsetInfo offsetInfo;
        int offset;
        String offsetString;
        int level;
        if (line.startsWith("!:")) {
            if (previous != null) {
                MagicEntryParser.handleSpecial(previous, line, errorCallBack);
            }
            return null;
        }
        String[] parts = MagicEntryParser.splitLine(line, errorCallBack);
        if (parts == null) {
            return null;
        }
        int sindex = parts[0].lastIndexOf(62);
        if (sindex < 0) {
            level = 0;
            offsetString = parts[0];
        } else {
            level = sindex + 1;
            offsetString = parts[0].substring(sindex + 1);
        }
        String work = offsetString;
        if (work.length() == 0) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid offset number:" + offsetString, null);
            }
            return null;
        }
        boolean addOffset = false;
        if (work.charAt(0) == '&') {
            if (work.length() == 1) {
                if (errorCallBack != null) {
                    errorCallBack.error(line, "invalid offset number:" + offsetString, null);
                }
                return null;
            }
            addOffset = true;
            work = work.substring(1);
        }
        if (work.charAt(0) == '(') {
            offset = -1;
            offsetInfo = MagicEntryParser.parseOffset(work, line, errorCallBack);
            if (offsetInfo == null) {
                return null;
            }
        } else {
            try {
                offset = Integer.decode(work);
                offsetInfo = null;
            }
            catch (NumberFormatException e) {
                if (errorCallBack != null) {
                    errorCallBack.error(line, "invalid offset number:" + offsetString, e);
                }
                return null;
            }
        }
        String typeStr = parts[1];
        sindex = typeStr.indexOf(38);
        Long andValue = null;
        if (sindex >= 0) {
            String andStr = typeStr.substring(sindex + 1);
            try {
                andValue = Long.decode(andStr);
            }
            catch (NumberFormatException e) {
                if (errorCallBack != null) {
                    errorCallBack.error(line, "invalid type AND-number: " + andStr, e);
                }
                return null;
            }
            typeStr = typeStr.substring(0, sindex);
        }
        if (typeStr.length() == 0) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "blank type string", null);
            }
            return null;
        }
        boolean unsignedType = false;
        MagicMatcher matcher = MagicType.matcherfromString(typeStr);
        if (matcher == null) {
            if (typeStr.charAt(0) == 'u') {
                matcher = MagicType.matcherfromString(typeStr.substring(1));
                unsignedType = true;
            } else {
                int index = typeStr.indexOf(47);
                if (index > 0) {
                    matcher = MagicType.matcherfromString(typeStr.substring(0, index));
                }
            }
            if (matcher == null) {
                if (errorCallBack != null) {
                    errorCallBack.error(line, "unknown magic type string: " + typeStr, null);
                }
                return null;
            }
        }
        if ((testStr = parts[2]).equals("x")) {
            testValue = null;
        } else {
            try {
                testValue = matcher.convertTestString(typeStr, testStr);
            }
            catch (Exception e) {
                if (errorCallBack != null) {
                    errorCallBack.error(line, "could not convert magic test string: " + testStr, e);
                }
                return null;
            }
        }
        boolean formatSpacePrefix = true;
        boolean clearFormat = false;
        if (parts.length == 3) {
            formatter = null;
            name = UNKNOWN_NAME;
        } else {
            String format = parts[3];
            if (format.startsWith("\\b")) {
                format = format.substring(2);
                formatSpacePrefix = false;
            } else if (format.startsWith("\b")) {
                format = format.substring(1);
                formatSpacePrefix = false;
            } else if (format.startsWith("\\r")) {
                format = format.substring(2);
                clearFormat = true;
            }
            formatter = new MagicFormatter(format);
            String trimmedFormat = format.trim();
            int spaceIndex = trimmedFormat.indexOf(32);
            if (spaceIndex < 0) {
                spaceIndex = trimmedFormat.indexOf(9);
            }
            name = spaceIndex > 0 ? trimmedFormat.substring(0, spaceIndex) : (trimmedFormat.length() == 0 ? UNKNOWN_NAME : trimmedFormat);
        }
        MagicEntry entry = new MagicEntry(name, level, addOffset, offset, offsetInfo, matcher, andValue, unsignedType, testValue, formatSpacePrefix, clearFormat, formatter);
        return entry;
    }

    private static String[] splitLine(String line, ContentInfoUtil.ErrorCallBack errorCallBack) {
        int startPos = MagicEntryParser.findNonWhitespace(line, 0);
        if (startPos < 0) {
            return null;
        }
        int endPos = MagicEntryParser.findWhitespaceWithoutEscape(line, startPos);
        if (endPos < 0) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid number of whitespace separated fields, must be >= 4", null);
            }
            return null;
        }
        String levelStr = line.substring(startPos, endPos);
        startPos = MagicEntryParser.findNonWhitespace(line, endPos + 1);
        if (startPos < 0) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid number of whitespace separated fields, must be >= 4", null);
            }
            return null;
        }
        endPos = MagicEntryParser.findWhitespaceWithoutEscape(line, startPos);
        if (endPos < 0) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid number of whitespace separated fields, must be >= 4", null);
            }
            return null;
        }
        String typeStr = line.substring(startPos, endPos);
        startPos = MagicEntryParser.findNonWhitespace(line, endPos + 1);
        if (startPos < 0) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid number of whitespace separated fields, must be >= 4", null);
            }
            return null;
        }
        endPos = MagicEntryParser.findWhitespaceWithoutEscape(line, startPos);
        if (endPos < 0) {
            endPos = line.length();
        }
        String testStr = line.substring(startPos, endPos);
        startPos = MagicEntryParser.findNonWhitespace(line, endPos + 1);
        if (startPos < 0) {
            return new String[]{levelStr, typeStr, testStr};
        }
        return new String[]{levelStr, typeStr, testStr, line.substring(startPos)};
    }

    private static void handleSpecial(MagicEntry previous, String line, ContentInfoUtil.ErrorCallBack errorCallBack) {
        if (line.equals(OPTIONAL_LINE)) {
            previous.setOptional(true);
            return;
        }
        int startPos = MagicEntryParser.findNonWhitespace(line, 0);
        int index = MagicEntryParser.findWhitespaceWithoutEscape(line, startPos);
        if (index < 0) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid extension line has less than 2 whitespace separated fields", null);
            }
            return;
        }
        String key = line.substring(startPos, index);
        startPos = MagicEntryParser.findNonWhitespace(line, index);
        if (startPos < 0) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid extension line has less than 2 whitespace separated fields", null);
            }
            return;
        }
        index = MagicEntryParser.findWhitespaceWithoutEscape(line, startPos);
        if (index < 0) {
            index = line.length();
        }
        String value = line.substring(startPos, index);
        if (key.equals(MIME_TYPE_LINE)) {
            previous.setMimeType(value);
        }
    }

    private static int findNonWhitespace(String line, int startPos) {
        for (int pos = startPos; pos < line.length(); ++pos) {
            if (Character.isWhitespace(line.charAt(pos))) continue;
            return pos;
        }
        return -1;
    }

    private static int findWhitespaceWithoutEscape(String line, int startPos) {
        boolean lastEscape = false;
        for (int pos = startPos; pos < line.length(); ++pos) {
            char ch = line.charAt(pos);
            if (ch == ' ') {
                if (!lastEscape) {
                    return pos;
                }
                lastEscape = false;
                continue;
            }
            if (Character.isWhitespace(line.charAt(pos))) {
                return pos;
            }
            lastEscape = ch == '\\';
        }
        return -1;
    }

    private static MagicEntry.OffsetInfo parseOffset(String offsetString, String line, ContentInfoUtil.ErrorCallBack errorCallBack) {
        int offset;
        Matcher matcher = OFFSET_PATTERN.matcher(offsetString);
        if (!matcher.matches()) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid offset pattern: " + offsetString, null);
            }
            return null;
        }
        try {
            offset = Integer.decode(matcher.group(1));
        }
        catch (NumberFormatException e) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid long offset number: " + offsetString, e);
            }
            return null;
        }
        if (matcher.group(2) == null) {
            if (errorCallBack != null) {
                errorCallBack.error(line, "invalid long offset type: " + offsetString, null);
            }
            return null;
        }
        char ch = matcher.group(2).length() == 1 ? matcher.group(2).charAt(0) : (char)'\u0000';
        EndianConverter converter = null;
        boolean isId3 = false;
        int size = 0;
        switch (ch) {
            case 'b': {
                converter = EndianType.LITTLE.getConverter();
                size = 1;
                break;
            }
            case 's': {
                converter = EndianType.LITTLE.getConverter();
                size = 2;
                break;
            }
            case 'i': {
                converter = EndianType.LITTLE.getConverter();
                size = 4;
                isId3 = true;
                break;
            }
            case 'l': {
                converter = EndianType.LITTLE.getConverter();
                size = 4;
                break;
            }
            case 'B': {
                converter = EndianType.BIG.getConverter();
                size = 1;
                break;
            }
            case 'S': {
                converter = EndianType.BIG.getConverter();
                size = 2;
                break;
            }
            case 'I': {
                converter = EndianType.BIG.getConverter();
                size = 4;
                isId3 = true;
                break;
            }
            case 'L': {
                converter = EndianType.BIG.getConverter();
                size = 4;
                break;
            }
            case 'm': {
                converter = EndianType.MIDDLE.getConverter();
                size = 4;
                break;
            }
            default: {
                converter = EndianType.LITTLE.getConverter();
                size = 4;
            }
        }
        int add = 0;
        if (matcher.group(4) != null && matcher.group(4).length() > 0) {
            try {
                add = Integer.decode(matcher.group(4));
            }
            catch (NumberFormatException e) {
                if (errorCallBack != null) {
                    errorCallBack.error(line, "invalid long add value: " + matcher.group(4), e);
                }
                return null;
            }
            String offsetOperator = matcher.group(3);
            if ("-".equals(offsetOperator)) {
                add = -add;
            } else if ("*".equals(offsetOperator)) {
                offset = add;
                add = 0;
            }
        }
        return new MagicEntry.OffsetInfo(offset, converter, isId3, size, add);
    }
}

