/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.comp;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorLambda;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FieldComparator
implements StreamComparator {
    private static final long serialVersionUID = 1L;
    private UUID comparatorNodeId = UUID.randomUUID();
    private String leftFieldName;
    private String rightFieldName;
    private final ComparatorOrder order;
    private ComparatorLambda comparator;

    public FieldComparator(String fieldName, ComparatorOrder order) {
        this(fieldName, fieldName, order);
    }

    public FieldComparator(String leftFieldName, String rightFieldName, ComparatorOrder order) {
        this.leftFieldName = leftFieldName;
        this.rightFieldName = rightFieldName;
        this.order = order != null ? order : ComparatorOrder.ASCENDING;
        this.assignComparator();
    }

    public void setLeftFieldName(String leftFieldName) {
        this.leftFieldName = leftFieldName;
    }

    public String getLeftFieldName() {
        return this.leftFieldName;
    }

    public void setRightFieldName(String rightFieldName) {
        this.rightFieldName = rightFieldName;
    }

    public String getRightFieldName() {
        return this.rightFieldName;
    }

    public ComparatorOrder getOrder() {
        return this.order;
    }

    public boolean hasDifferentFieldNames() {
        return !this.leftFieldName.equals(this.rightFieldName);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.leftFieldName);
        if (this.hasDifferentFieldNames()) {
            sb.append("=");
            sb.append(this.rightFieldName);
        }
        sb.append(" ");
        sb.append((Object)this.order);
        return new StreamExpressionValue(sb.toString());
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.comparatorNodeId.toString()).withExpressionType("sorter").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    private void assignComparator() {
        this.comparator = ComparatorOrder.DESCENDING == this.order ? (leftTuple, rightTuple) -> {
            Comparable rightComp;
            Comparable leftComp = (Comparable)leftTuple.get(this.leftFieldName);
            if (leftComp == (rightComp = (Comparable)rightTuple.get(this.rightFieldName))) {
                return 0;
            }
            if (null == leftComp) {
                return 1;
            }
            if (null == rightComp) {
                return -1;
            }
            return rightComp.compareTo(leftComp);
        } : (leftTuple, rightTuple) -> {
            Comparable rightComp;
            Comparable leftComp = (Comparable)leftTuple.get(this.leftFieldName);
            if (leftComp == (rightComp = (Comparable)rightTuple.get(this.rightFieldName))) {
                return 0;
            }
            if (null == leftComp) {
                return -1;
            }
            if (null == rightComp) {
                return 1;
            }
            return leftComp.compareTo(rightComp);
        };
    }

    @Override
    public int compare(Tuple leftTuple, Tuple rightTuple) {
        return this.comparator.compare(leftTuple, rightTuple);
    }

    @Override
    public boolean isDerivedFrom(StreamComparator base) {
        MultipleFieldComparator baseComps;
        if (null == base) {
            return false;
        }
        if (base instanceof FieldComparator) {
            FieldComparator baseComp = (FieldComparator)base;
            return (this.leftFieldName.equals(baseComp.leftFieldName) || this.rightFieldName.equals(baseComp.rightFieldName)) && this.order == baseComp.order;
        }
        if (base instanceof MultipleFieldComparator && (baseComps = (MultipleFieldComparator)base).getComps().length > 0) {
            return this.isDerivedFrom(baseComps.getComps()[0]);
        }
        return false;
    }

    @Override
    public FieldComparator copyAliased(Map<String, String> aliases) {
        return new FieldComparator(aliases.containsKey(this.leftFieldName) ? aliases.get(this.leftFieldName) : this.leftFieldName, aliases.containsKey(this.rightFieldName) ? aliases.get(this.rightFieldName) : this.rightFieldName, this.order);
    }

    @Override
    public StreamComparator append(StreamComparator other) {
        return new MultipleFieldComparator(this).append(other);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldComparator)) {
            return false;
        }
        FieldComparator that = (FieldComparator)o;
        return this.leftFieldName.equals(that.leftFieldName) && this.rightFieldName.equals(that.rightFieldName) && this.order == that.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.leftFieldName, this.rightFieldName, this.order});
    }
}

