/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.carrot2.clustering.Document;

final class InputDocument
implements Document {
    private final Object id;
    private final Map<String, String> clusteredFields = new LinkedHashMap<String, String>();
    private final String language;

    InputDocument(Object docId, String language) {
        this.id = Objects.requireNonNull(docId);
        this.language = language;
    }

    public void visitFields(BiConsumer<String, String> fieldConsumer) {
        this.clusteredFields.forEach(fieldConsumer);
    }

    Object getId() {
        return this.id;
    }

    String language() {
        return this.language;
    }

    void addClusteredField(String fieldName, String fieldValue) {
        assert (!this.clusteredFields.containsKey(fieldName));
        this.clusteredFields.put(fieldName, fieldValue);
    }

    public String toString() {
        return String.format(Locale.ROOT, "doc[%s, lang=%s, fields=%s]", this.getId(), this.language, this.clusteredFields.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining(", ")));
    }
}

