/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.InstancemethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.InstancemethodBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetAttrO;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PInstancemethod})
public final class InstancemethodBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = InstancemethodBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return InstancemethodBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString reprBuiltinFunction(VirtualFrame frame, PDecoratedMethod self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getNameNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<instancemethod %s at 0x%s>", ReprNode.toStr(getNameNode.execute((Frame)frame, inliningTarget, self.getCallable(), SpecialAttributeNames.T___NAME__)), PythonAbstractObject.systemHashCodeAsHexString(self.getCallable()));
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStr(Object o) {
            return o.toString();
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class GetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        @Specialization
        static Object doGeneric(PDecoratedMethod self, Object obj, Object cls, @Bind Node inliningTarget, @Cached InlinedConditionProfile objIsNoneProfile) {
            if (objIsNoneProfile.profile(inliningTarget, obj == PNone.NO_VALUE)) {
                return self.getCallable();
            }
            return PFactory.createMethod(PythonLanguage.get(inliningTarget), obj, self.getCallable());
        }
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CallNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        protected static Object doIt(VirtualFrame frame, PDecoratedMethod self, Object[] arguments, PKeyword[] keywords, @Cached com.oracle.graal.python.nodes.call.CallNode callNode) {
            return callNode.execute((Frame)frame, self.getCallable(), arguments, keywords);
        }
    }

    @Builtin(name="__doc__", maxNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DocNode
    extends PythonUnaryBuiltinNode {
        DocNode() {
        }

        @Specialization
        static Object doc(VirtualFrame frame, PDecoratedMethod self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, self.getCallable(), SpecialAttributeNames.T___DOC__);
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class GetattributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        @Specialization
        protected static Object doIt(VirtualFrame frame, PDecoratedMethod self, Object key, @Bind Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode objectGetattrNode, @Cached PyObjectGetAttrO getAttrNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            try {
                return objectGetattrNode.execute(frame, self, key);
            }
            catch (PException e) {
                e.expectAttributeError(inliningTarget, errorProfile);
                return getAttrNode.execute((Frame)frame, inliningTarget, self.getCallable(), key);
            }
        }
    }

    @Builtin(name="__func__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class FuncNode
    extends PythonUnaryBuiltinNode {
        FuncNode() {
        }

        @Specialization
        protected static Object func(PDecoratedMethod self) {
            return self.getCallable();
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="instancemethod", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InitNode
    extends PythonBinaryBuiltinNode {
        InitNode() {
        }

        @Specialization(guards={"checkCallableNode.execute(this, callable)"})
        static PNone init(PDecoratedMethod self, Object callable, @Cached.Shared(value="checkCallable") @Cached PyCallableCheckNode checkCallableNode) {
            self.setCallable(callable);
            return PNone.NONE;
        }

        @Specialization(guards={"!checkCallableNode.execute(this, callable)"})
        static PNone noCallble(PDecoratedMethod self, Object callable, @Cached.Shared(value="checkCallable") @Cached PyCallableCheckNode checkCallableNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.FIRST_ARG_MUST_BE_CALLABLE_S, callable);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="instancemethod", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class InstancemethodNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doObjectIndirect(Object cls, Object callable, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createInstancemethod(language, cls, getInstanceShape.execute(cls));
        }
    }
}

