/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.FileIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.IOModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.modules.io.PTextIO;
import com.oracle.graal.python.builtins.modules.io.TextIOWrapperNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_io")
public final class IOModuleBuiltins
extends PythonBuiltins {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IOModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("SEEK_SET", (Object)0);
        this.addBuiltinConstant("SEEK_CUR", (Object)1);
        this.addBuiltinConstant("SEEK_END", (Object)2);
        this.addBuiltinConstant("DEFAULT_BUFFER_SIZE", (Object)8192);
        PythonBuiltinClass unsupportedOpExcType = core.lookupType(PythonBuiltinClassType.IOUnsupportedOperation);
        PythonBuiltinClass osError = core.lookupType(PythonBuiltinClassType.OSError);
        unsupportedOpExcType.setBases(null, osError, new PythonAbstractClass[]{osError, core.lookupType(PythonBuiltinClassType.ValueError)});
        this.addBuiltinConstant(PythonBuiltinClassType.IOUnsupportedOperation.getName(), (Object)unsupportedOpExcType);
        this.addBuiltinConstant(PythonBuiltinClassType.BlockingIOError.getName(), (Object)core.lookupType(PythonBuiltinClassType.BlockingIOError));
        this.addBuiltinConstant("_warn", core.lookupBuiltinModule(BuiltinNames.T__WARNINGS).getAttribute(WarningsModuleBuiltins.T_WARN));
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            this.addBuiltinConstant("_os", (Object)core.lookupBuiltinModule(BuiltinNames.T_NT));
            this.addBuiltinConstant("_WindowsConsoleIO", (Object)PythonBuiltinClassType.PWindowsConsoleIO);
        } else {
            this.addBuiltinConstant("_os", (Object)core.lookupBuiltinModule(BuiltinNames.T_POSIX));
        }
    }

    private static PFileIO createFileIO(VirtualFrame frame, Node inliningTarget, Object file, IONodes.IOMode mode, boolean closefd, Object opener, FileIOBuiltins.FileIOInit initFileIO) {
        mode.universal = false;
        mode.text = false;
        PFileIO fileIO = PFactory.createFileIO(PythonLanguage.get(inliningTarget));
        initFileIO.execute(frame, inliningTarget, fileIO, file, mode, closefd, opener);
        return fileIO;
    }

    @Builtin(name="text_encoding", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"encoding", "stacklevel"})
    @ArgumentClinic(name="stacklevel", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="2")
    @GenerateNodeFactory
    static abstract class TextEncodingNode
    extends PythonBinaryClinicBuiltinNode {
        TextEncodingNode() {
        }

        @Specialization
        Object textEncoding(VirtualFrame frame, PNone encoding, int stacklevel, @Cached WarningsModuleBuiltins.WarnNode warnNode) {
            if (PythonContext.get(this).getOption(PythonOptions.WarnDefaultEncodingFlag).booleanValue()) {
                warnNode.warnEx((Frame)frame, (Object)PythonBuiltinClassType.EncodingWarning, ErrorMessages.WARN_ENCODING_ARGUMENT_NOT_SPECIFIED, stacklevel);
            }
            return BuiltinNames.T_LOCALE;
        }

        @Fallback
        static Object textEncoding(Object encoding, Object stacklevel) {
            return encoding;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IOModuleBuiltinsClinicProviders.TextEncodingNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="open", minNumOfPositionalArgs=1, parameterNames={"file", "mode", "buffering", "encoding", "errors", "newline", "closefd", "opener"})
    @ArgumentsClinic(value={@ArgumentClinic(name="mode", conversionClass=IONodes.CreateIOModeNode.class, args={"true"}), @ArgumentClinic(name="buffering", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="newline", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="closefd", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true", useDefaultForNone=true)})
    @ImportStatic(value={IONodes.class, IONodes.IOMode.class})
    @GenerateNodeFactory
    public static abstract class IOOpenNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IOModuleBuiltinsClinicProviders.IOOpenNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!isXRWA(mode)", "!isUnknown(mode)", "!isTB(mode)", "isValidUniveral(mode)", "!isBinary(mode)", "bufferingValue != 0"})
        protected static Object openText(VirtualFrame frame, Object file, IONodes.IOMode mode, int bufferingValue, Object encoding, Object errors, Object newline, boolean closefd, Object opener, @Bind Node inliningTarget, @Cached.Exclusive @Cached FileIOBuiltins.FileIOInit initFileIO, @Cached.Exclusive @Cached IONodes.CreateBufferedIONode createBufferedIO, @Cached TextIOWrapperNodes.TextIOWrapperInitNode initTextIO, @Cached PyObjectSetAttr setAttrNode, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callClose, @Bind PythonLanguage language, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            PFileIO fileIO;
            PythonBuiltinObject result = fileIO = IOModuleBuiltins.createFileIO(frame, inliningTarget, file, mode, closefd, opener, initFileIO);
            try {
                boolean line_buffering;
                boolean isatty = false;
                int buffering = bufferingValue;
                if (buffering < 0) {
                    isatty = posixLib.isatty(PosixSupport.get(inliningTarget), fileIO.getFD());
                }
                if (buffering == 1 || isatty) {
                    buffering = -1;
                    line_buffering = true;
                } else {
                    line_buffering = false;
                }
                if (buffering < 0) {
                    buffering = fileIO.getBlksize();
                }
                if (buffering < 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_BUFFERING_SIZE);
                }
                if (buffering == 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.CAN_T_HAVE_UNBUFFERED_TEXT_IO);
                }
                PBuffered buffer = createBufferedIO.execute(frame, inliningTarget, fileIO, buffering, mode);
                result = buffer;
                PTextIO wrapper = PFactory.createTextIO(language);
                initTextIO.execute((Frame)frame, inliningTarget, wrapper, buffer, encoding, errors == PNone.NONE ? StringLiterals.T_STRICT : (TruffleString)errors, newline, line_buffering, false);
                result = wrapper;
                setAttrNode.execute((Frame)frame, inliningTarget, wrapper, IONodes.T_MODE, mode.mode);
                return result;
            }
            catch (PException e) {
                callClose.execute((Frame)frame, inliningTarget, result, IONodes.T_CLOSE, new Object[0]);
                throw e;
            }
        }

        @Specialization(guards={"!isXRWA(mode)", "!isUnknown(mode)", "!isTB(mode)", "isValidUniveral(mode)", "isBinary(mode)", "bufferingValue == 0"})
        protected static PFileIO openBinaryNoBuf(VirtualFrame frame, Object file, IONodes.IOMode mode, int bufferingValue, PNone encoding, PNone errors, PNone newline, boolean closefd, Object opener, @Bind Node inliningTarget, @Cached.Exclusive @Cached FileIOBuiltins.FileIOInit initFileIO) {
            return IOModuleBuiltins.createFileIO(frame, inliningTarget, file, mode, closefd, opener, initFileIO);
        }

        @Specialization(guards={"!isXRWA(mode)", "!isUnknown(mode)", "!isTB(mode)", "isValidUniveral(mode)", "isBinary(mode)", "bufferingValue == 1"})
        protected static Object openBinaryB1(VirtualFrame frame, Object file, IONodes.IOMode mode, int bufferingValue, PNone encoding, PNone errors, PNone newline, boolean closefd, Object opener, @Bind Node inliningTarget, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached.Exclusive @Cached FileIOBuiltins.FileIOInit initFileIO, @Cached.Exclusive @Cached IONodes.CreateBufferedIONode createBufferedIO, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callClose, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            warnNode.warnEx((Frame)frame, (Object)PythonErrorType.RuntimeWarning, ErrorMessages.LINE_BUFFERING_ISNT_SUPPORTED, 1);
            return IOOpenNode.openBinary(frame, file, mode, bufferingValue, encoding, errors, newline, closefd, opener, inliningTarget, initFileIO, createBufferedIO, posixLib, callClose, raiseNode);
        }

        @Specialization(guards={"!isXRWA(mode)", "!isUnknown(mode)", "!isTB(mode)", "isValidUniveral(mode)", "isBinary(mode)", "bufferingValue != 1", "bufferingValue != 0"})
        protected static Object openBinary(VirtualFrame frame, Object file, IONodes.IOMode mode, int bufferingValue, PNone encoding, PNone errors, PNone newline, boolean closefd, Object opener, @Bind Node inliningTarget, @Cached.Exclusive @Cached FileIOBuiltins.FileIOInit initFileIO, @Cached.Exclusive @Cached IONodes.CreateBufferedIONode createBufferedIO, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callClose, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            PFileIO fileIO = IOModuleBuiltins.createFileIO(frame, inliningTarget, file, mode, closefd, opener, initFileIO);
            try {
                boolean isatty = false;
                int buffering = bufferingValue;
                if (buffering < 0) {
                    isatty = posixLib.isatty(PosixSupport.get(inliningTarget), fileIO.getFD());
                }
                if (buffering == 1 || isatty) {
                    buffering = -1;
                }
                if (buffering < 0) {
                    buffering = fileIO.getBlksize();
                }
                if (buffering < 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_BUFFERING_SIZE);
                }
                if (buffering == 0) {
                    return fileIO;
                }
                return createBufferedIO.execute(frame, inliningTarget, fileIO, buffering, mode);
            }
            catch (PException e) {
                callClose.execute((Frame)frame, inliningTarget, fileIO, IONodes.T_CLOSE, new Object[0]);
                throw e;
            }
        }

        @Specialization(guards={"isUnknown(mode)"})
        protected static Object unknownMode(Object file, IONodes.IOMode mode, int bufferingValue, Object encoding, Object errors, Object newline, boolean closefd, Object opener, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.UNKNOWN_MODE_S, mode.mode);
        }

        @Specialization(guards={"isTB(mode)"})
        protected static Object invalidTB(Object file, IONodes.IOMode mode, int bufferingValue, Object encoding, Object errors, Object newline, boolean closefd, Object opener, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.CAN_T_HAVE_TEXT_AND_BINARY_MODE_AT_ONCE);
        }

        @Specialization(guards={"!isValidUniveral(mode)"})
        protected static Object invalidUniversal(Object file, IONodes.IOMode mode, int bufferingValue, Object encoding, Object errors, Object newline, boolean closefd, Object opener, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MODE_U_CANNOT_BE_COMBINED_WITH_X_W_A_OR);
        }

        @Specialization(guards={"isXRWA(mode)"})
        protected static Object invalidxrwa(Object file, IONodes.IOMode mode, int bufferingValue, Object encoding, Object errors, Object newline, boolean closefd, Object opener, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MUST_HAVE_EXACTLY_ONE_OF_CREATE_READ_WRITE_APPEND_MODE);
        }

        @Specialization(guards={"isBinary(mode)", "isAnyNotNone(encoding, errors, newline)"})
        protected static Object invalidBinary(Object file, IONodes.IOMode mode, int bufferingValue, Object encoding, Object errors, Object newline, boolean closefd, Object opener, @Bind Node inliningTarget) {
            String s = encoding != PNone.NONE ? "encoding" : (errors != PNone.NONE ? "errors" : "newline");
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.BINARY_MODE_DOESN_T_TAKE_AN_S_ARGUMENT, s);
        }

        @Specialization(guards={"!isBinary(mode)", "bufferingValue == 0"})
        protected static Object invalidunbuf(Object file, IONodes.IOMode mode, int bufferingValue, Object encoding, Object errors, Object newline, boolean closefd, Object opener, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.CAN_T_HAVE_UNBUFFERED_TEXT_IO);
        }

        public static boolean isAnyNotNone(Object encoding, Object errors, Object newline) {
            return encoding != PNone.NONE || errors != PNone.NONE || newline != PNone.NONE;
        }
    }

    @Builtin(name="open_code", minNumOfPositionalArgs=1, parameterNames={"path"})
    @ArgumentClinic(name="path", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class IOOpenCodeNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IOModuleBuiltinsClinicProviders.IOOpenCodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PFileIO openCode(VirtualFrame frame, TruffleString path, @Bind Node inliningTarget, @Cached FileIOBuiltins.FileIOInit initFileIO) {
            return IOModuleBuiltins.createFileIO(frame, inliningTarget, path, IONodes.IOMode.RB, true, PNone.NONE, initFileIO);
        }
    }
}

