/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.sql.legacy.cursor.Cursor;
import org.opensearch.sql.legacy.cursor.DefaultCursor;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.QueryActionElasticExecutor;
import org.opensearch.sql.legacy.executor.RestExecutor;
import org.opensearch.sql.legacy.executor.format.Protocol;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.pit.PointInTimeHandler;
import org.opensearch.sql.legacy.pit.PointInTimeHandlerImpl;
import org.opensearch.sql.legacy.query.DefaultQueryAction;
import org.opensearch.sql.legacy.query.QueryAction;
import org.opensearch.sql.legacy.query.join.BackOffRetryStrategy;
import org.opensearch.transport.client.Client;

public class PrettyFormatRestExecutor
implements RestExecutor {
    private static final Logger LOG = LogManager.getLogger();
    private final String format;

    public PrettyFormatRestExecutor(String format) {
        this.format = Objects.requireNonNull(format, "Format cannot be null").toLowerCase(Locale.ROOT);
    }

    @Override
    public void execute(Client client, Map<String, String> params, QueryAction queryAction, RestChannel channel) {
        String formattedResponse = this.execute(client, params, queryAction);
        BytesRestResponse bytesRestResponse = this.format.equals("jdbc") ? new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", formattedResponse) : new BytesRestResponse(RestStatus.OK, formattedResponse);
        if (!BackOffRetryStrategy.isHealthy(2 * bytesRestResponse.content().length(), this)) {
            throw new IllegalStateException("[PrettyFormatRestExecutor] Memory could be insufficient when sendResponse().");
        }
        channel.sendResponse((RestResponse)bytesRestResponse);
    }

    @Override
    public String execute(Client client, Map<String, String> params, QueryAction queryAction) {
        Protocol protocol;
        try {
            if (queryAction instanceof DefaultQueryAction) {
                protocol = this.buildProtocolForDefaultQuery(client, (DefaultQueryAction)queryAction);
            } else {
                Object queryResult = QueryActionElasticExecutor.executeAnyAction(client, queryAction);
                protocol = new Protocol(client, queryAction, queryResult, this.format, Cursor.NULL_CURSOR);
            }
        }
        catch (SqlParseException e) {
            LOG.warn("SQL parsing error: {}", (Object)e.getMessage(), (Object)e);
            protocol = new Protocol(e);
        }
        catch (OpenSearchException e) {
            LOG.warn("An error occurred in OpenSearch engine: {}", (Object)e.getDetailedMessage(), (Object)e);
            protocol = new Protocol((Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.warn("Error happened in pretty formatter", (Throwable)e);
            protocol = new Protocol(e);
        }
        return protocol.format();
    }

    private Protocol buildProtocolForDefaultQuery(Client client, DefaultQueryAction queryAction) throws SqlParseException {
        queryAction.explain();
        Integer fetchSize = queryAction.getSqlRequest().fetchSize();
        if (fetchSize != null && fetchSize > 0) {
            return this.buildProtocolWithPagination(client, queryAction, fetchSize);
        }
        return this.buildProtocolWithoutPagination(client, queryAction);
    }

    private Protocol buildProtocolWithPagination(Client client, DefaultQueryAction queryAction, Integer fetchSize) {
        PointInTimeHandlerImpl pit = new PointInTimeHandlerImpl(client, queryAction.getSelect().getIndexArr());
        pit.create();
        try {
            SearchRequestBuilder searchRequest = queryAction.getRequestBuilder();
            searchRequest.setPointInTime(new PointInTimeBuilder(pit.getPitId()));
            SearchResponse response = (SearchResponse)searchRequest.get();
            if (this.shouldCreateCursor(response, queryAction, fetchSize)) {
                DefaultCursor cursor = this.createCursorWithPit(pit, response, queryAction, fetchSize);
                return new Protocol(client, queryAction, response.getHits(), this.format, cursor);
            }
            pit.delete();
            return new Protocol(client, queryAction, response.getHits(), this.format, Cursor.NULL_CURSOR);
        }
        catch (RuntimeException e) {
            try {
                pit.delete();
            }
            catch (RuntimeException deleteException) {
                LOG.error("Failed to delete PIT", (Throwable)deleteException);
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
            }
            throw e;
        }
    }

    private Protocol buildProtocolWithoutPagination(Client client, DefaultQueryAction queryAction) {
        SearchRequestBuilder searchRequest = queryAction.getRequestBuilder();
        SearchResponse response = (SearchResponse)searchRequest.get();
        return new Protocol(client, queryAction, response.getHits(), this.format, Cursor.NULL_CURSOR);
    }

    private DefaultCursor createCursorWithPit(PointInTimeHandler pit, SearchResponse response, DefaultQueryAction queryAction, Integer fetchSize) {
        DefaultCursor cursor = new DefaultCursor();
        cursor.setLimit(queryAction.getSelect().getRowCount());
        cursor.setFetchSize(fetchSize);
        cursor.setPitId(pit.getPitId());
        cursor.setSearchSourceBuilder(((SearchRequest)queryAction.getRequestBuilder().request()).source());
        if (response.getHits().getHits().length > 0) {
            cursor.setSortFields(response.getHits().getAt(response.getHits().getHits().length - 1).getSortValues());
        }
        return cursor;
    }

    protected boolean shouldCreateCursor(SearchResponse searchResponse, DefaultQueryAction queryAction, Integer fetchSize) {
        return fetchSize != null && searchResponse.getHits() != null && Objects.requireNonNull(searchResponse.getHits().getTotalHits()).value() >= (long)fetchSize.intValue();
    }
}

