/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPartInternal;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.CompareCondition;
import org.jooq.impl.DSL;

final class IsDistinctFrom<T>
extends AbstractCondition {
    private static final long serialVersionUID = 4568269684824736461L;
    private final Field<T> lhs;
    private final Field<T> rhs;
    private final Comparator comparator;
    private transient QueryPartInternal mySQLCondition;
    private transient QueryPartInternal sqliteCondition;
    private transient QueryPartInternal compareCondition;
    private transient QueryPartInternal caseExpression;

    IsDistinctFrom(Field<T> lhs, Field<T> rhs, Comparator comparator) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.comparator = comparator;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx.configuration()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY).contains((Object)configuration.family())) {
            return this.comparator == Comparator.IS_DISTINCT_FROM ? (QueryPartInternal)((Object)DSL.notExists(DSL.select(this.lhs).intersect(DSL.select(this.rhs)))) : (QueryPartInternal)((Object)DSL.exists(DSL.select(this.lhs).intersect(DSL.select(this.rhs))));
        }
        if (Arrays.asList(new Object[0]).contains((Object)configuration.family())) {
            if (this.caseExpression == null) {
                this.caseExpression = this.comparator == Comparator.IS_DISTINCT_FROM ? (QueryPartInternal)((Object)DSL.decode().when(this.lhs.isNull().and(this.rhs.isNull()), DSL.zero()).when(this.lhs.isNull().and(this.rhs.isNotNull()), DSL.one()).when(this.lhs.isNotNull().and(this.rhs.isNull()), DSL.one()).when(this.lhs.equal(this.rhs), DSL.zero()).otherwise(DSL.one()).equal(DSL.one())) : (QueryPartInternal)((Object)DSL.decode().when(this.lhs.isNull().and(this.rhs.isNull()), DSL.one()).when(this.lhs.isNull().and(this.rhs.isNotNull()), DSL.zero()).when(this.lhs.isNotNull().and(this.rhs.isNull()), DSL.zero()).when(this.lhs.equal(this.rhs), DSL.one()).otherwise(DSL.zero()).equal(DSL.one()));
            }
            return this.caseExpression;
        }
        if (Arrays.asList(SQLDialect.MARIADB, SQLDialect.MYSQL).contains((Object)configuration.family())) {
            if (this.mySQLCondition == null) {
                this.mySQLCondition = (QueryPartInternal)((Object)(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{not}({0} <=> {1})", this.lhs, this.rhs) : DSL.condition("{0} <=> {1}", this.lhs, this.rhs)));
            }
            return this.mySQLCondition;
        }
        if (SQLDialect.SQLITE == configuration.family()) {
            if (this.sqliteCondition == null) {
                this.sqliteCondition = (QueryPartInternal)((Object)(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{0} {is not} {1}", this.lhs, this.rhs) : DSL.condition("{0} {is} {1}", this.lhs, this.rhs)));
            }
            return this.sqliteCondition;
        }
        if (this.compareCondition == null) {
            this.compareCondition = new CompareCondition(this.lhs, this.rhs, this.comparator);
        }
        return this.compareCondition;
    }
}

