"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@osd/config-schema");
var _common = require("../../data/common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  supportedTypes: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: [_common.DEFAULT_DATA.SET_TYPES.INDEX, _common.DEFAULT_DATA.SET_TYPES.INDEX_PATTERN]
  }),
  discoverTraces: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  discoverMetrics: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
});