/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.indices;

import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.InjectSecurity;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.transport.client.Client;

public class ForecastIndexManagement
extends IndexManagement<ForecastIndex> {
    private static final Logger logger = LogManager.getLogger(ForecastIndexManagement.class);
    public static final String FORECAST_RESULT_HISTORY_INDEX_PATTERN = "<opensearch-forecast-results-history-{now/d}-1>";
    public static final String ALL_FORECAST_RESULTS_INDEX_PATTERN = "opensearch-forecast-results*";

    public ForecastIndexManagement(Client client, ClusterService clusterService, ThreadPool threadPool, Settings settings, DiscoveryNodeFilterer nodeFilter, int maxUpdateRunningTimes, NamedXContentRegistry xContentRegistry) throws IOException {
        super(client, clusterService, threadPool, settings, nodeFilter, maxUpdateRunningTimes, ForecastIndex.class, (Integer)ForecastSettings.FORECAST_MAX_PRIMARY_SHARDS.get(settings), (TimeValue)ForecastSettings.FORECAST_RESULT_HISTORY_ROLLOVER_PERIOD.get(settings), (Long)ForecastSettings.FORECAST_RESULT_HISTORY_MAX_DOCS_PER_SHARD.get(settings), (TimeValue)ForecastSettings.FORECAST_RESULT_HISTORY_RETENTION_PERIOD.get(settings), ForecastIndex.RESULT.getMapping(), xContentRegistry, Forecaster::parse, "opensearch-forecast-result-", ".opensearch-forecasters");
        this.indexStates = new EnumMap(ForecastIndex.class);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_RESULT_HISTORY_MAX_DOCS_PER_SHARD, it -> {
            this.historyMaxDocs = it;
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_RESULT_HISTORY_ROLLOVER_PERIOD, it -> {
            this.historyRolloverPeriod = it;
            this.rescheduleRollover();
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_RESULT_HISTORY_RETENTION_PERIOD, it -> {
            this.historyRetentionPeriod = it;
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_MAX_PRIMARY_SHARDS, it -> {
            this.maxPrimaryShards = it;
        });
        this.updateRunningTimes = 0;
    }

    public static String getResultMappings() throws IOException {
        return ForecastIndexManagement.getMappings("mappings/forecast-results.json");
    }

    public static String getStateMappings() throws IOException {
        String forecastStateMappings = ForecastIndexManagement.getMappings("mappings/forecast-state.json");
        String forecasterIndexMappings = ForecastIndexManagement.getConfigMappings();
        forecasterIndexMappings = forecasterIndexMappings.substring(forecasterIndexMappings.indexOf("\"properties\""), forecasterIndexMappings.lastIndexOf("}"));
        return forecastStateMappings.replace("FORECASTER_INDEX_MAPPING_PLACE_HOLDER", forecasterIndexMappings);
    }

    public static String getCheckpointMappings() throws IOException {
        return ForecastIndexManagement.getMappings("mappings/forecast-checkpoint.json");
    }

    @Override
    public boolean doesDefaultResultIndexExist() {
        return this.doesAliasExist("opensearch-forecast-results");
    }

    @Override
    public boolean doesStateIndexExist() {
        return this.doesIndexExist(".opensearch-forecast-state");
    }

    @Override
    public boolean doesCheckpointIndexExist() {
        return this.doesIndexExist(".opensearch-forecast-checkpoints");
    }

    @Override
    public void initStateIndex(ActionListener<CreateIndexResponse> actionListener) {
        try {
            CreateIndexRequest request = new CreateIndexRequest(".opensearch-forecast-state").mapping(ForecastIndexManagement.getStateMappings(), XContentType.JSON).settings(this.settings);
            this.adminClient.indices().create(request, this.markMappingUpToDate(ForecastIndex.STATE, actionListener));
        }
        catch (IOException e) {
            logger.error("Fail to init AD detection state index", (Throwable)e);
            actionListener.onFailure((Exception)e);
        }
    }

    @Override
    public void initCheckpointIndex(ActionListener<CreateIndexResponse> actionListener) {
        String mapping;
        try {
            mapping = ForecastIndexManagement.getCheckpointMappings();
        }
        catch (IOException e) {
            throw new EndRunException("", "Cannot find checkpoint mapping file", true);
        }
        CreateIndexRequest request = new CreateIndexRequest(".opensearch-forecast-checkpoints").mapping(mapping, XContentType.JSON);
        this.choosePrimaryShards(request, true);
        this.adminClient.indices().create(request, this.markMappingUpToDate(ForecastIndex.CHECKPOINT, actionListener));
    }

    @Override
    protected void rolloverAndDeleteHistoryIndex() {
        this.rolloverAndDeleteHistoryIndex("opensearch-forecast-results", ALL_FORECAST_RESULTS_INDEX_PATTERN, FORECAST_RESULT_HISTORY_INDEX_PATTERN, ForecastIndex.RESULT);
    }

    @Override
    public void initConfigIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        super.initConfigIndex(this.markMappingUpToDate(ForecastIndex.CONFIG, actionListener));
    }

    @Override
    public void initJobIndex(ActionListener<CreateIndexResponse> actionListener) {
        super.initJobIndex(this.markMappingUpToDate(ForecastIndex.JOB, actionListener));
    }

    @Override
    protected IndexRequest createDummyIndexRequest(String resultIndex) throws IOException {
        ForecastResult dummyResult = ForecastResult.getDummyResult();
        return new IndexRequest(resultIndex).id("dummy_forecast_result_id").source(dummyResult.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
    }

    @Override
    protected DeleteRequest createDummyDeleteRequest(String resultIndex) throws IOException {
        return new DeleteRequest(resultIndex).id("dummy_forecast_result_id");
    }

    @Override
    public void initDefaultResultIndexDirectly(ActionListener<CreateIndexResponse> actionListener) {
        this.initResultIndexDirectly(FORECAST_RESULT_HISTORY_INDEX_PATTERN, ForecastIndex.RESULT.getIndexName(), false, true, ForecastIndex.RESULT, actionListener);
    }

    @Override
    public void initCustomResultIndexDirectly(String resultIndex, ActionListener<CreateIndexResponse> actionListener) {
        this.initResultIndexDirectly(this.getCustomResultIndexPattern(resultIndex), resultIndex, false, false, ForecastIndex.RESULT, actionListener);
    }

    public <T> void validateDefaultResultIndexForBackendJob(String configId, String user, List<String> roles, ExecutorFunction function, ActionListener<T> listener) {
        if (this.doesAliasExist("opensearch-forecast-results")) {
            this.validateResultIndexAndExecute("opensearch-forecast-results", () -> this.executeWithSecurityContext(configId, user, roles, function, listener, "opensearch-forecast-results"), false, listener);
        } else {
            this.initDefaultResultIndex(configId, user, roles, function, listener);
        }
    }

    private <T> void initDefaultResultIndex(String configId, String user, List<String> roles, ExecutorFunction function, ActionListener<T> listener) {
        this.initDefaultResultIndexDirectly((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.executeWithSecurityContext(configId, user, roles, function, listener, "opensearch-forecast-results");
            } else {
                String error = "Creating result index with mappings call not acknowledged";
                logger.error(error);
                listener.onFailure((Exception)new TimeSeriesException(error));
            }
        }, exception -> {
            if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                this.executeWithSecurityContext(configId, user, roles, function, listener, "opensearch-forecast-results");
            } else {
                listener.onFailure(exception);
            }
        }));
    }

    private <T> void executeWithSecurityContext(String securityLogId, String user, List<String> roles, ExecutorFunction function, ActionListener<T> listener, String indexOrAlias) {
        try (InjectSecurity injectSecurity = new InjectSecurity(securityLogId, this.settings, this.client.threadPool().getThreadContext());){
            injectSecurity.inject(user, roles);
            ActionListener wrappedListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                injectSecurity.close();
                listener.onFailure(e);
            });
            this.validateResultIndexAndExecute(indexOrAlias, () -> {
                injectSecurity.close();
                function.execute();
            }, true, wrappedListener);
        }
        catch (Exception e2) {
            logger.error("Failed to validate custom index for backend job " + securityLogId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }
}

