/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.alerting.comments.CommentsIndices;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportIndexAlertingCommentAction;
import org.opensearch.alerting.transport.TransportIndexAlertingCommentActionKt;
import org.opensearch.alerting.util.CommentsUtils;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.IndexCommentRequest;
import org.opensearch.commons.alerting.action.IndexCommentResponse;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.Comment;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u00019BI\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J&\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000308H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0018\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010&R\u0018\u0010'\u001a\n %*\u0004\u0018\u00010(0(X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010)R\u0018\u0010*\u001a\n %*\u0004\u0018\u00010(0(X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010)R\u0016\u0010+\u001a\n %*\u0004\u0018\u00010,0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010-\u001a\n %*\u0004\u0018\u00010$0$X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006:"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexAlertingCommentAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/commons/alerting/action/IndexCommentResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "commentsIndices", "Lorg/opensearch/alerting/comments/CommentsIndices;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/alerting/comments/CommentsIndices;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getCommentsIndices", "()Lorg/opensearch/alerting/comments/CommentsIndices;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "getNamedWriteableRegistry", "()Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "alertingCommentsEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "commentsMaxContentSize", "", "Ljava/lang/Long;", "maxCommentsPerAlert", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "filterByEnabled", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "IndexCommentHandler", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportIndexAlertingCommentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportIndexAlertingCommentAction.kt\norg/opensearch/alerting/transport/TransportIndexAlertingCommentAction\n+ 2 TransportHelpers.kt\norg/opensearch/commons/utils/TransportHelpersKt\n*L\n1#1,389:1\n48#2,5:390\n*S KotlinDebug\n*F\n+ 1 TransportIndexAlertingCommentAction.kt\norg/opensearch/alerting/transport/TransportIndexAlertingCommentAction\n*L\n115#1:390,5\n*E\n"})
public final class TransportIndexAlertingCommentAction
extends HandledTransportAction<ActionRequest, IndexCommentResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final CommentsIndices commentsIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile Boolean alertingCommentsEnabled;
    private volatile Long commentsMaxContentSize;
    private volatile Long maxCommentsPerAlert;
    private volatile TimeValue indexTimeout;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportIndexAlertingCommentAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull CommentsIndices commentsIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry, @NotNull NamedWriteableRegistry namedWriteableRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)commentsIndices, (String)"commentsIndices");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        super("cluster:admin/opensearch/alerting/comments/write", transportService, actionFilters, IndexCommentRequest::new);
        this.client = client;
        this.commentsIndices = commentsIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.alertingCommentsEnabled = (Boolean)AlertingSettings.Companion.getALERTING_COMMENTS_ENABLED().get(this.settings);
        this.commentsMaxContentSize = (Long)AlertingSettings.Companion.getCOMMENTS_MAX_CONTENT_SIZE().get(this.settings);
        this.maxCommentsPerAlert = (Long)AlertingSettings.Companion.getMAX_COMMENTS_PER_ALERT().get(this.settings);
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(this.settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERTING_COMMENTS_ENABLED(), arg_0 -> TransportIndexAlertingCommentAction._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getCOMMENTS_MAX_CONTENT_SIZE(), arg_0 -> TransportIndexAlertingCommentAction._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMAX_COMMENTS_PER_ALERT(), arg_0 -> TransportIndexAlertingCommentAction._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), arg_0 -> TransportIndexAlertingCommentAction._init_$lambda$3(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final CommentsIndices getCommentsIndices() {
        return this.commentsIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * Exception decompiling
     */
    protected void doExecute(@NotNull Task task, @NotNull ActionRequest request, @NotNull ActionListener<IndexCommentResponse> actionListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.super.listenFilterBySettingChange(clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.super.readUserFromThreadContext(client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.super.doFilterForUser(user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.super.isAdmin(user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.super.validateUserBackendRoles(user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.super.checkUserPermissionsWithResource(requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportIndexAlertingCommentAction this$0, Boolean it) {
        this$0.alertingCommentsEnabled = it;
    }

    private static final void _init_$lambda$1(TransportIndexAlertingCommentAction this$0, Long it) {
        this$0.commentsMaxContentSize = it;
    }

    private static final void _init_$lambda$2(TransportIndexAlertingCommentAction this$0, Long it) {
        this$0.maxCommentsPerAlert = it;
    }

    private static final void _init_$lambda$3(TransportIndexAlertingCommentAction this$0, TimeValue it) {
        this$0.indexTimeout = it;
    }

    public static final /* synthetic */ Long access$getMaxCommentsPerAlert$p(TransportIndexAlertingCommentAction $this) {
        return $this.maxCommentsPerAlert;
    }

    public static final /* synthetic */ TimeValue access$getIndexTimeout$p(TransportIndexAlertingCommentAction $this) {
        return $this.indexTimeout;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0011\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0082@\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0082@\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexAlertingCommentAction$IndexCommentHandler;", "", "client", "Lorg/opensearch/transport/client/Client;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/commons/alerting/action/IndexCommentResponse;", "request", "Lorg/opensearch/commons/alerting/action/IndexCommentRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Lorg/opensearch/alerting/transport/TransportIndexAlertingCommentAction;Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/commons/alerting/action/IndexCommentRequest;Lorg/opensearch/commons/authuser/User;)V", "start", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexComment", "updateComment", "getAlert", "Lorg/opensearch/commons/alerting/model/Alert;", "getComment", "Lorg/opensearch/commons/alerting/model/Comment;", "checkShardsFailure", "", "response", "Lorg/opensearch/action/index/IndexResponse;", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nTransportIndexAlertingCommentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportIndexAlertingCommentAction.kt\norg/opensearch/alerting/transport/TransportIndexAlertingCommentAction$IndexCommentHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,389:1\n1563#2:390\n1634#2,3:391\n1563#2:394\n1634#2,3:395\n13472#3,2:398\n*S KotlinDebug\n*F\n+ 1 TransportIndexAlertingCommentAction.kt\norg/opensearch/alerting/transport/TransportIndexAlertingCommentAction$IndexCommentHandler\n*L\n299#1:390\n299#1:391,3\n348#1:394\n348#1:395,3\n380#1:398,2\n*E\n"})
    public final class IndexCommentHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexCommentResponse> actionListener;
        @NotNull
        private final IndexCommentRequest request;
        @Nullable
        private final User user;

        public IndexCommentHandler(@NotNull Client client, @NotNull ActionListener<IndexCommentResponse> actionListener, @Nullable IndexCommentRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object start(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof start.1)) ** GOTO lbl-1000
            var3_2 = $completion;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.start((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = TransportIndexAlertingCommentAction.this.getCommentsIndices().createOrUpdateInitialCommentsHistoryIndex((Continuation<? super Unit>)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    if (this.request.getMethod() != RestRequest.Method.PUT) break;
                    $continuation.label = 2;
                    v1 = this.updateComment((Continuation<? super Unit>)$continuation);
                    if (v1 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl29
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl29:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            $continuation.label = 3;
            v2 = this.indexComment((Continuation<? super Unit>)$continuation);
            if (v2 == var4_4) {
                return var4_4;
            }
            ** GOTO lbl38
            {
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl38:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object indexComment(Continuation<? super Unit> $completion) {
            if (!($completion instanceof indexComment.1)) ** GOTO lbl-1000
            var9_2 = $completion;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexCommentHandler.access$indexComment(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.getAlert((Continuation<? super Alert>)$continuation);
                    if (v0 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    v1 = (Alert)v0;
                    if (v1 == null) {
                        return Unit.INSTANCE;
                    }
                    alert = v1;
                    $continuation.L$0 = alert;
                    $continuation.label = 2;
                    v2 = CommentsUtils.Companion.getCommentIDsByAlertIDs(this.client, CollectionsKt.listOf((Object)alert.getId()), (Continuation<? super List<String>>)$continuation);
                    if (v2 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl34
                }
                case 2: {
                    alert = (Alert)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl34:
                    // 2 sources

                    if ((long)(numCommentsOnThisAlert = ((List)v2).size()) >= TransportIndexAlertingCommentAction.access$getMaxCommentsPerAlert$p(TransportIndexAlertingCommentAction.this)) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new IllegalArgumentException("This request would create more than the allowed number of Commentsfor this Alert: " + TransportIndexAlertingCommentAction.access$getMaxCommentsPerAlert$p(TransportIndexAlertingCommentAction.this))));
                        return Unit.INSTANCE;
                    }
                    TransportIndexAlertingCommentActionKt.access$getLog$p().debug("checking user permissions in index comment");
                    TransportIndexAlertingCommentAction.this.checkUserPermissionsWithResource(this.user, alert.getMonitorUser(), this.actionListener, "monitor", alert.getMonitorId());
                    v3 = this.request.getEntityId();
                    v4 = this.request.getEntityType();
                    v5 = this.request.getContent();
                    v6 = Instant.now();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"now(...)");
                    comment = new Comment(v3, v4, v5, v6, this.user);
                    v7 = new IndexRequest(".opensearch-alerting-comments-history-write");
                    v8 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"jsonBuilder(...)");
                    indexRequest = (IndexRequest)((IndexRequest)v7.source(comment.toXContentWithUser(v8)).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexAlertingCommentAction.access$getIndexTimeout$p(TransportIndexAlertingCommentAction.this))).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    v9 = TransportIndexAlertingCommentActionKt.access$getLog$p();
                    v10 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"jsonBuilder(...)");
                    v9.debug("Creating new comment: " + comment.toXContentWithUser(v10));
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)alert);
                    $continuation.L$1 = comment;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                    $continuation.I$0 = numCommentsOnThisAlert;
                    $continuation.label = 3;
                    v11 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, indexComment$lambda$0(org.opensearch.alerting.transport.TransportIndexAlertingCommentAction$IndexCommentHandler org.opensearch.action.index.IndexRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexCommentHandler)this, (IndexRequest)indexRequest), (Continuation)$continuation);
                    ** if (v11 != var10_4) goto lbl64
lbl63:
                    // 1 sources

                    return var10_4;
lbl64:
                    // 1 sources

                    ** GOTO lbl74
                }
                case 3: {
                    numCommentsOnThisAlert = $continuation.I$0;
                    indexRequest = (IndexRequest)$continuation.L$2;
                    comment = (Comment)$continuation.L$1;
                    alert = (Alert)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v11 = $result;
lbl74:
                        // 2 sources

                        if ((failureReasons = this.checkShardsFailure(indexResponse = (IndexResponse)v11)) != null) {
                            this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), indexResponse.status(), new Object[0])));
                            return Unit.INSTANCE;
                        }
                        v12 = indexResponse.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getId(...)");
                        this.actionListener.onResponse((Object)new IndexCommentResponse(v12, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), comment));
                    }
                    catch (Exception t) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object updateComment(Continuation<? super Unit> $completion) {
            if (!($completion instanceof updateComment.1)) ** GOTO lbl-1000
            var8_2 = $completion;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexCommentHandler.access$updateComment(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.getComment((Continuation<? super Comment>)$continuation);
                    if (v0 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    v1 = (Comment)v0;
                    if (v1 == null) {
                        return Unit.INSTANCE;
                    }
                    currentComment = v1;
                    if (this.user != null && !TransportIndexAlertingCommentAction.this.isAdmin(this.user)) {
                        v2 = currentComment.getUser();
                        if (!Intrinsics.areEqual((Object)this.user.getName(), (Object)(v2 != null ? v2.getName() : null))) {
                            this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Comment can only be edited by Admin or author of comment", RestStatus.FORBIDDEN, new Object[0])));
                            return Unit.INSTANCE;
                        }
                    }
                    requestComment = Comment.copy$default((Comment)currentComment, null, null, null, (String)this.request.getContent(), null, (Instant)Instant.now(), null, (int)87, null);
                    v3 = new IndexRequest(".opensearch-alerting-comments-history-write");
                    v4 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"jsonBuilder(...)");
                    indexRequest = (IndexRequest)((IndexRequest)v3.source(requestComment.toXContentWithUser(v4)).id(requestComment.getId()).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexAlertingCommentAction.access$getIndexTimeout$p(TransportIndexAlertingCommentAction.this))).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    TransportIndexAlertingCommentActionKt.access$getLog$p().debug("Updating comment, " + currentComment.getId() + ", from: " + currentComment.getContent() + " to: " + requestComment.getContent());
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)currentComment);
                    $continuation.L$1 = requestComment;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                    $continuation.label = 2;
                    v5 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, updateComment$lambda$1(org.opensearch.alerting.transport.TransportIndexAlertingCommentAction$IndexCommentHandler org.opensearch.action.index.IndexRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexCommentHandler)this, (IndexRequest)indexRequest), (Continuation)$continuation);
                    ** if (v5 != var9_4) goto lbl44
lbl43:
                    // 1 sources

                    return var9_4;
lbl44:
                    // 1 sources

                    ** GOTO lbl53
                }
                case 2: {
                    indexRequest = (IndexRequest)$continuation.L$2;
                    requestComment = (Comment)$continuation.L$1;
                    currentComment = (Comment)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl53:
                        // 2 sources

                        if ((failureReasons = this.checkShardsFailure(indexResponse = (IndexResponse)v5)) != null) {
                            this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), indexResponse.status(), new Object[0])));
                            return Unit.INSTANCE;
                        }
                        v6 = indexResponse.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getId(...)");
                        this.actionListener.onResponse((Object)new IndexCommentResponse(v6, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), requestComment));
                    }
                    catch (Exception t) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object getAlert(Continuation<? super Alert> $completion) {
            if (!($completion instanceof getAlert.1)) ** GOTO lbl-1000
            var20_2 = $completion;
            if ((var20_2.label & -2147483648) != 0) {
                var20_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexCommentHandler.access$getAlert(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)CollectionsKt.listOf((Object)this.request.getEntityId())));
                    searchSourceBuilder = new SearchSourceBuilder().version(Boxing.boxBoolean((boolean)true)).seqNoAndPrimaryTerm(Boxing.boxBoolean((boolean)true)).query((QueryBuilder)queryBuilder);
                    var5_7 = new String[]{".opendistro-alerting-alert*"};
                    searchRequest = new SearchRequest().indices(var5_7).source(searchSourceBuilder);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)queryBuilder);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)searchSourceBuilder);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)searchRequest);
                    $continuation.label = 1;
                    v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getAlert$lambda$2(org.opensearch.action.search.SearchRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((SearchRequest)searchRequest), (Continuation)$continuation);
                    if (v0 == var21_4) {
                        return var21_4;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    searchRequest = (SearchRequest)$continuation.L$2;
                    searchSourceBuilder = (SearchSourceBuilder)$continuation.L$1;
                    queryBuilder = (BoolQueryBuilder)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    searchResponse = (SearchResponse)v0;
                    v1 = searchResponse.getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getHits(...)");
                    $this$map$iv = (Iterable)v1;
                    $i$f$map = false;
                    var9_11 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_16 = (SearchHit)item$iv$iv;
                        var18_20 = destination$iv$iv;
                        $i$a$-map-TransportIndexAlertingCommentAction$IndexCommentHandler$getAlert$alerts$1 = false;
                        xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        Intrinsics.checkNotNull((Object)xcp);
                        v2 = hit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getId(...)");
                        alert = Alert.Companion.parse(xcp, v2, hit.getVersion());
                        var18_20.add(alert);
                    }
                    alerts = (List)destination$iv$iv;
                    if (alerts.isEmpty()) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Alert not found", RestStatus.NOT_FOUND, new Object[0])));
                        return null;
                    }
                    if (alerts.size() > 1) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new IllegalStateException("Multiple alerts were found with the same ID")));
                        return null;
                    }
                    return alerts.get(0);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object getComment(Continuation<? super Comment> $completion) {
            if (!($completion instanceof getComment.1)) ** GOTO lbl-1000
            var20_2 = $completion;
            if ((var20_2.label & -2147483648) != 0) {
                var20_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexCommentHandler.access$getComment(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)CollectionsKt.listOf((Object)this.request.getCommentId())));
                    searchSourceBuilder = new SearchSourceBuilder().version(Boxing.boxBoolean((boolean)true)).seqNoAndPrimaryTerm(Boxing.boxBoolean((boolean)true)).query((QueryBuilder)queryBuilder);
                    var5_7 = new String[]{".opensearch-alerting-comments*"};
                    searchRequest = new SearchRequest().indices(var5_7).source(searchSourceBuilder);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)queryBuilder);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)searchSourceBuilder);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)searchRequest);
                    $continuation.label = 1;
                    v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getComment$lambda$4(org.opensearch.action.search.SearchRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((SearchRequest)searchRequest), (Continuation)$continuation);
                    if (v0 == var21_4) {
                        return var21_4;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    searchRequest = (SearchRequest)$continuation.L$2;
                    searchSourceBuilder = (SearchSourceBuilder)$continuation.L$1;
                    queryBuilder = (BoolQueryBuilder)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    searchResponse = (SearchResponse)v0;
                    v1 = searchResponse.getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getHits(...)");
                    $this$map$iv = (Iterable)v1;
                    $i$f$map = false;
                    var9_11 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_16 = (SearchHit)item$iv$iv;
                        var18_20 = destination$iv$iv;
                        $i$a$-map-TransportIndexAlertingCommentAction$IndexCommentHandler$getComment$comments$1 = false;
                        xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        Intrinsics.checkNotNull((Object)xcp);
                        v2 = hit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getId(...)");
                        comment = Comment.Companion.parse(xcp, v2);
                        var18_20.add(comment);
                    }
                    comments = (List)destination$iv$iv;
                    if (comments.isEmpty()) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Comment not found", RestStatus.NOT_FOUND, new Object[0])));
                        return null;
                    }
                    if (comments.size() > 1) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new IllegalStateException("Multiple comments were found with the same ID")));
                        return null;
                    }
                    return comments.get(0);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            if (response2.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"getFailures(...)");
                Object[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReplicationResponse.ShardInfo.Failure entry = (ReplicationResponse.ShardInfo.Failure)element$iv;
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        private static final Unit indexComment$lambda$0(IndexCommentHandler this$0, IndexRequest $indexRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.client.index($indexRequest, it);
            return Unit.INSTANCE;
        }

        private static final Unit updateComment$lambda$1(IndexCommentHandler this$0, IndexRequest $indexRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.client.index($indexRequest, it);
            return Unit.INSTANCE;
        }

        private static final Unit getAlert$lambda$2(SearchRequest $searchRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$suspendUntil.search($searchRequest, it);
            return Unit.INSTANCE;
        }

        private static final Unit getComment$lambda$4(SearchRequest $searchRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$suspendUntil.search($searchRequest, it);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$indexComment(IndexCommentHandler $this, Continuation $completion) {
            return $this.indexComment((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$updateComment(IndexCommentHandler $this, Continuation $completion) {
            return $this.updateComment((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$getAlert(IndexCommentHandler $this, Continuation $completion) {
            return $this.getAlert((Continuation<? super Alert>)$completion);
        }

        public static final /* synthetic */ Object access$getComment(IndexCommentHandler $this, Continuation $completion) {
            return $this.getComment((Continuation<? super Comment>)$completion);
        }
    }
}

