/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.util.Arrays;

public class SignatureSubpacket {
    int type;
    boolean critical;
    boolean isLongLength;
    protected byte[] data;

    protected SignatureSubpacket(int type, boolean critical, boolean isLongLength, byte[] data) {
        this.type = type;
        this.critical = critical;
        this.isLongLength = isLongLength;
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public boolean isLongLength() {
        return this.isLongLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public void encode(OutputStream out) throws IOException {
        int bodyLen = this.data.length + 1;
        if (this.isLongLength) {
            out.write(255);
            StreamUtil.writeBodyLen(out, bodyLen);
        } else {
            StreamUtil.writeNewPacketLength(out, bodyLen);
        }
        if (this.critical) {
            out.write(0x80 | this.type);
        } else {
            out.write(this.type);
        }
        out.write(this.data);
    }

    public int hashCode() {
        return (this.critical ? 1 : 0) + 7 * this.type + 49 * Arrays.hashCode((byte[])this.data);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SignatureSubpacket) {
            SignatureSubpacket ot = (SignatureSubpacket)other;
            if (this.type == ot.type && this.critical == ot.critical) {
                return Arrays.areEqual((byte[])this.data, (byte[])ot.data);
            }
        }
        return false;
    }
}

