/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.InputCoercionException;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.core.compress.NotCompressedException;
import org.opensearch.core.compress.NotXContentException;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.transport.grpc.util.RestToGrpcStatusConverter;

public class GrpcErrorHandler {
    private static final Logger logger = LogManager.getLogger(GrpcErrorHandler.class);

    private GrpcErrorHandler() {
    }

    public static StatusRuntimeException convertToGrpcError(Exception e) {
        if (e instanceof OpenSearchException) {
            return GrpcErrorHandler.handleOpenSearchException((OpenSearchException)e);
        }
        if (e instanceof OpenSearchRejectedExecutionException) {
            return Status.RESOURCE_EXHAUSTED.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof NotXContentException) {
            return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof NotCompressedException) {
            return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof InputCoercionException) {
            return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof JsonParseException) {
            return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof IllegalArgumentException) {
            return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof IllegalStateException) {
            return Status.FAILED_PRECONDITION.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof SecurityException) {
            return Status.PERMISSION_DENIED.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof TimeoutException) {
            return Status.DEADLINE_EXCEEDED.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof InterruptedException) {
            return Status.CANCELLED.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        if (e instanceof IOException) {
            return Status.INTERNAL.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
        }
        logger.warn("Unmapped exception type: {}, treating as INTERNAL error", (Object)e.getClass().getSimpleName());
        return Status.INTERNAL.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
    }

    private static StatusRuntimeException handleOpenSearchException(OpenSearchException e) {
        Status grpcStatus = RestToGrpcStatusConverter.convertRestToGrpcStatus(e.status());
        Throwable unwrapped = ExceptionsHelper.unwrapToOpenSearchException((Throwable)e);
        String description = ExceptionsHelper.summaryMessage((Throwable)unwrapped);
        return grpcStatus.withDescription(description).asRuntimeException();
    }
}

