/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.command.BootstrapAdmin;
import org.keycloak.quarkus.runtime.cli.command.Build;
import org.keycloak.quarkus.runtime.cli.command.Export;
import org.keycloak.quarkus.runtime.cli.command.Import;
import org.keycloak.quarkus.runtime.cli.command.ShowConfig;
import org.keycloak.quarkus.runtime.cli.command.Start;
import org.keycloak.quarkus.runtime.cli.command.StartDev;
import org.keycloak.quarkus.runtime.cli.command.Tools;
import org.keycloak.quarkus.runtime.cli.command.UpdateCompatibility;
import picocli.CommandLine;

@CommandLine.Command(name="keycloak", header={"Keycloak - Open Source Identity and Access Management", "", "Find more information at: https://www.keycloak.org/docs/latest"}, description={"%nUse this command-line tool to manage your Keycloak cluster."}, footerHeading="Examples:", footer={"  Start the server in development mode for local development or testing:%n%n      $ ${COMMAND-NAME} start-dev%n%n  Building an optimized server runtime:%n%n      $ ${COMMAND-NAME} build <OPTIONS>%n%n  Start the server in production mode:%n%n      $ ${COMMAND-NAME} start <OPTIONS>%n%n  Enable auto-completion to bash/zsh:%n%n      $ source <(${COMMAND-NAME} tools completion)%n%n  Please, take a look at the documentation for more details before deploying in production.", "", "Use \"${COMMAND-NAME} start --help\" for the available options when starting the server.", "Use \"${COMMAND-NAME} <command> --help\" for more information about other commands."}, version={"Keycloak ${sys:kc.version}", "JVM: ${java.version} (${java.vendor} ${java.vm.name} ${java.vm.version})", "OS: ${os.name} ${os.version} ${os.arch}"}, subcommands={Build.class, Start.class, StartDev.class, Export.class, Import.class, ShowConfig.class, Tools.class, BootstrapAdmin.class, UpdateCompatibility.class})
public final class Main {
    public static final String PROFILE_SHORT_NAME = "-pf";
    public static final String PROFILE_LONG_NAME = "--profile";
    public static final String CONFIG_FILE_SHORT_NAME = "-cf";
    public static final String CONFIG_FILE_LONG_NAME = "--config-file";
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-V", "--version"}, description={"Show version information"}, versionHelp=true)
    boolean version;

    @CommandLine.Option(names={"-v", "--verbose"}, description={"Print out error details when running this command."}, paramLabel="none", scope=CommandLine.ScopeType.INHERIT, defaultValue="${env:KC_VERBOSE}")
    public void setVerbose(boolean verbose) {
        ExecutionExceptionHandler exceptionHandler = (ExecutionExceptionHandler)this.spec.commandLine().getExecutionExceptionHandler();
        exceptionHandler.setVerbose(verbose);
    }

    @CommandLine.Option(names={"-pf", "--profile"}, hidden=true, description={"Set the profile. Use 'dev' profile to enable development mode."})
    public void setProfile(String profile) {
        Environment.setProfile(profile);
    }

    @CommandLine.Option(names={"-cf", "--config-file"}, arity="1", description={"Set the path to a configuration file. By default, configuration properties are read from the \"keycloak.conf\" file in the \"conf\" directory."}, paramLabel="file")
    public void setConfigFile(String path) {
        if (Files.notExists(Path.of(path, new String[0]), new LinkOption[0])) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("File specified via '%s' or '%s' option does not exist.", CONFIG_FILE_LONG_NAME, CONFIG_FILE_SHORT_NAME));
        }
        System.setProperty("kc.config.file", path);
    }
}

