/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.AnnotationTargetImpl;
import io.quarkus.arc.processor.bcextensions.ArrayTypeImpl;
import io.quarkus.arc.processor.bcextensions.ClassTypeImpl;
import io.quarkus.arc.processor.bcextensions.ParameterizedTypeImpl;
import io.quarkus.arc.processor.bcextensions.PrimitiveTypeImpl;
import io.quarkus.arc.processor.bcextensions.TypeVariableImpl;
import io.quarkus.arc.processor.bcextensions.UnresolvedTypeVariableImpl;
import io.quarkus.arc.processor.bcextensions.VoidTypeImpl;
import io.quarkus.arc.processor.bcextensions.WildcardTypeImpl;
import io.smallrye.common.annotation.SuppressForbidden;
import jakarta.enterprise.lang.model.AnnotationInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.EquivalenceKey;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;
import org.jboss.jandex.Type;

abstract class TypeImpl<JandexType extends Type>
extends AnnotationTargetImpl
implements jakarta.enterprise.lang.model.types.Type {
    final JandexType jandexType;

    TypeImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, JandexType jandexType) {
        super(jandexIndex, annotationOverlay, (EquivalenceKey)EquivalenceKey.of(jandexType));
        this.jandexType = jandexType;
    }

    static jakarta.enterprise.lang.model.types.Type fromJandexType(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, Type jandexType) {
        return switch (jandexType.kind()) {
            case Type.Kind.VOID -> new VoidTypeImpl(jandexIndex, annotationOverlay, jandexType.asVoidType());
            case Type.Kind.PRIMITIVE -> new PrimitiveTypeImpl(jandexIndex, annotationOverlay, jandexType.asPrimitiveType());
            case Type.Kind.CLASS -> new ClassTypeImpl(jandexIndex, annotationOverlay, jandexType.asClassType());
            case Type.Kind.ARRAY -> new ArrayTypeImpl(jandexIndex, annotationOverlay, jandexType.asArrayType());
            case Type.Kind.PARAMETERIZED_TYPE -> new ParameterizedTypeImpl(jandexIndex, annotationOverlay, jandexType.asParameterizedType());
            case Type.Kind.TYPE_VARIABLE -> new TypeVariableImpl(jandexIndex, annotationOverlay, jandexType.asTypeVariable());
            case Type.Kind.UNRESOLVED_TYPE_VARIABLE -> new UnresolvedTypeVariableImpl(jandexIndex, annotationOverlay, jandexType.asUnresolvedTypeVariable());
            case Type.Kind.WILDCARD_TYPE -> new WildcardTypeImpl(jandexIndex, annotationOverlay, jandexType.asWildcardType());
            default -> throw new IllegalArgumentException("Unknown type " + String.valueOf(jandexType));
        };
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        DotName annotationName = DotName.createSimple(annotationType);
        for (AnnotationInstance annotation : this.jandexType.annotations()) {
            if (!annotation.runtimeVisible() || !annotation.name().equals((Object)annotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        for (AnnotationInstance annotation : this.jandexType.annotations()) {
            if (!annotation.runtimeVisible() || !predicate.test(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation))) continue;
            return true;
        }
        return false;
    }

    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        AnnotationInstance jandexAnnotation = this.jandexType.annotation(DotName.createSimple(annotationType));
        if (jandexAnnotation == null || !jandexAnnotation.runtimeVisible()) {
            return null;
        }
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, jandexAnnotation);
    }

    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.jandexType.annotationsWithRepeatable(DotName.createSimple(annotationType), this.jandexIndex)) {
            if (!annotation.runtimeVisible()) continue;
            result.add(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation));
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.jandexType.annotations()) {
            AnnotationInfoImpl annotationInfo;
            if (!annotation.runtimeVisible() || !predicate.test(annotationInfo = new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation))) continue;
            result.add(annotationInfo);
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<AnnotationInfo> annotations() {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.jandexType.annotations()) {
            if (!annotation.runtimeVisible()) continue;
            result.add(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation));
        }
        return Collections.unmodifiableList(result);
    }

    @SuppressForbidden(reason="Using Type.toString() to build an informative message")
    public String toString() {
        return this.jandexType.toString();
    }
}

