/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.cycle_detection;

import com.tngtech.archunit.library.cycle_detection.Cycle;
import com.tngtech.archunit.library.cycle_detection.Edge;
import com.tngtech.archunit.library.cycle_detection.Path;
import java.util.List;
import java.util.Objects;

class CycleInternal<EDGE extends Edge<?>>
implements Cycle<EDGE> {
    private final Path<EDGE> path;

    CycleInternal(List<EDGE> edges) {
        this(new Path<EDGE>(edges));
    }

    CycleInternal(Path<EDGE> path) {
        if (!path.formsCycle()) {
            this.throwNoCycleException(path);
        }
        this.path = path;
    }

    private void throwNoCycleException(Path<EDGE> path) {
        throw new IllegalArgumentException("The supplied edges do not form a cycle. Edges were " + path);
    }

    @Override
    public List<EDGE> getEdges() {
        return this.path.getEdges();
    }

    public int hashCode() {
        return Objects.hash(this.path.getEdges());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CycleInternal other = (CycleInternal)obj;
        return Objects.equals(this.path.getEdges(), other.path.getEdges());
    }

    public String toString() {
        return "Cycle{" + this.path.edgesToString() + '}';
    }
}

