/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model.data;

import java.util.Locale;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickHouseDateTimeValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseArrayValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseBigNumberValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseBoolValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseEnumValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseGeometryValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseStructValueHandler;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClikhouseInetTypeValueHandler;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCNumberValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCUUIDValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ClickhouseValueHandlerProvider
implements DBDValueHandlerProvider {
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject type) {
        String lowerTypeName = type.getTypeName().toLowerCase(Locale.ENGLISH);
        DBPDataKind dataKind = type.getDataKind();
        if ("enum8".equals(lowerTypeName) || "enum16".equals(lowerTypeName)) {
            return ClickhouseEnumValueHandler.INSTANCE;
        }
        if (ClickhouseGeometryValueHandler.isGeometryType(lowerTypeName)) {
            return ClickhouseGeometryValueHandler.INSTANCE;
        }
        if (dataKind == DBPDataKind.ARRAY) {
            return ClickhouseArrayValueHandler.INSTANCE;
        }
        if (dataKind == DBPDataKind.STRUCT) {
            return ClickhouseStructValueHandler.INSTANCE;
        }
        if ("bool".equals(lowerTypeName)) {
            return ClickhouseBoolValueHandler.INSTANCE;
        }
        if ("uuid".equals(lowerTypeName)) {
            return JDBCUUIDValueHandler.INSTANCE;
        }
        if (dataKind == DBPDataKind.NUMERIC) {
            if (lowerTypeName.contains("int128") || lowerTypeName.contains("int256") || lowerTypeName.contains("uint64") || lowerTypeName.contains("uint128") || lowerTypeName.contains("uint256")) {
                return new ClickhouseBigNumberValueHandler(type, preferences);
            }
            return new JDBCNumberValueHandler(type, preferences);
        }
        if ("ipv4".equals(lowerTypeName) || "ipv6".equals(lowerTypeName)) {
            return ClikhouseInetTypeValueHandler.INSTANCE;
        }
        if (dataKind == DBPDataKind.DATETIME) {
            return new ClickHouseDateTimeValueHandler(preferences);
        }
        return null;
    }
}

