/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline
@GenerateCached(value=false)
public abstract class InlineWeakValueProfile
extends Node {
    public final <T> T execute(Node inliningTarget, T value) {
        return (T)this.executeImpl(inliningTarget, value);
    }

    abstract Object executeImpl(Node var1, Object var2);

    @Specialization(guards={"value == cachedValue"}, limit="1")
    static Object doCached(Object value, @Cached(value="value", weak=true) Object cachedValue) {
        return cachedValue;
    }

    @Specialization(replaces={"doCached"})
    static Object doUncached(Object value) {
        return value;
    }

    public static InlineWeakValueProfile getUncached() {
        return Uncached.INSTANCE;
    }

    @GenerateCached(value=false)
    private static final class Uncached
    extends InlineWeakValueProfile {
        private static final Uncached INSTANCE = new Uncached();

        private Uncached() {
        }

        @Override
        Object executeImpl(Node inliningTarget, Object value) {
            return value;
        }
    }
}

