/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;

public class DefaultBlrCalculator
implements BlrCalculator {
    private static final int FLAG_NONE = 0;
    private static final int FLAG_BLOB_AS_QUAD = 1;
    public static final DefaultBlrCalculator CALCULATOR_DIALECT_3 = new DefaultBlrCalculator(3);
    private final short dialect;
    private final int flags;

    public DefaultBlrCalculator(short dialect) {
        this(dialect, 0);
    }

    private DefaultBlrCalculator(short dialect, int flags) {
        this.dialect = dialect;
        this.flags = flags;
    }

    static BlrCalculator of(short dialect, GDSServerVersion version) {
        if (version.isEqualOrAbove(2, 5)) {
            if (dialect == 3) {
                return CALCULATOR_DIALECT_3;
            }
            return new DefaultBlrCalculator(dialect);
        }
        return new DefaultBlrCalculator(dialect, 1);
    }

    @Override
    public byte[] calculateBlr(RowDescriptor rowDescriptor) throws SQLException {
        ByteArrayOutputStream bout = this.getByteArrayOutputStream(rowDescriptor.getCount());
        for (FieldDescriptor field : rowDescriptor) {
            this.calculateFieldBlr(bout, field, field.getLength());
        }
        bout.write(255);
        bout.write(76);
        return bout.toByteArray();
    }

    @Override
    public byte[] calculateBlr(RowDescriptor rowDescriptor, RowValue rowValue) throws SQLException {
        ByteArrayOutputStream bout = this.getByteArrayOutputStream(rowValue.getCount());
        for (int idx = 0; idx < rowDescriptor.getCount(); ++idx) {
            byte[] fieldData = rowValue.getFieldData(idx);
            FieldDescriptor field = rowDescriptor.getFieldDescriptor(idx);
            int actualDataLength = fieldData != null ? fieldData.length : 0;
            this.calculateFieldBlr(bout, field, actualDataLength);
        }
        bout.write(255);
        bout.write(76);
        return bout.toByteArray();
    }

    private ByteArrayOutputStream getByteArrayOutputStream(int fieldCount) {
        int approximateSize = 8 + 7 * fieldCount;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(approximateSize);
        int parameterCount = 2 * fieldCount;
        bout.write(this.dialect <= 1 ? 4 : 5);
        bout.write(2);
        bout.write(4);
        bout.write(0);
        bout.write(parameterCount);
        bout.write(parameterCount >> 8);
        return bout;
    }

    private void calculateFieldBlr(ByteArrayOutputStream bout, FieldDescriptor field, int len) throws SQLException {
        int fieldType = field.getType() & 0xFFFFFFFE;
        switch (fieldType) {
            case 448: {
                bout.write(38);
                bout.write(field.getSubType());
                bout.write(0);
                bout.write(len);
                bout.write(len >> 8);
                break;
            }
            case 452: {
                bout.write(15);
                bout.write(field.getSubType());
                bout.write(0);
                bout.write(len);
                bout.write(len >> 8);
                break;
            }
            case 32766: {
                bout.write(14);
                bout.write(0);
                bout.write(0);
                break;
            }
            case 480: {
                bout.write(27);
                break;
            }
            case 482: {
                bout.write(10);
                break;
            }
            case 530: {
                bout.write(11);
                break;
            }
            case 570: {
                bout.write(12);
                break;
            }
            case 560: {
                bout.write(13);
                break;
            }
            case 510: {
                bout.write(35);
                break;
            }
            case 520: {
                if ((this.flags & 1) == 0) {
                    DefaultBlrCalculator.writeBlrBlob2(bout, field);
                    break;
                }
                DefaultBlrCalculator.writeBlrQuad(bout, 0);
                break;
            }
            case 540: {
                DefaultBlrCalculator.writeBlrQuad(bout, 0);
                break;
            }
            case 496: {
                bout.write(8);
                bout.write(field.getScale());
                break;
            }
            case 500: {
                bout.write(7);
                bout.write(field.getScale());
                break;
            }
            case 580: {
                bout.write(16);
                bout.write(field.getScale());
                break;
            }
            case 550: {
                DefaultBlrCalculator.writeBlrQuad(bout, field.getScale());
                break;
            }
            case 32764: {
                bout.write(23);
                break;
            }
            case 32760: {
                bout.write(24);
                break;
            }
            case 32762: {
                bout.write(25);
                break;
            }
            case 32752: {
                bout.write(26);
                bout.write(field.getScale());
                break;
            }
            case 32754: {
                bout.write(29);
                break;
            }
            case 32756: {
                bout.write(28);
                break;
            }
            case 32748: {
                bout.write(31);
                break;
            }
            case 32750: {
                bout.write(30);
                break;
            }
            default: {
                throw FbExceptionBuilder.toException(335544713);
            }
        }
        bout.write(7);
        bout.write(0);
    }

    private static void writeBlrQuad(ByteArrayOutputStream bout, int scale) {
        bout.write(9);
        bout.write(scale);
    }

    private static void writeBlrBlob2(ByteArrayOutputStream bout, FieldDescriptor field) {
        bout.write(17);
        bout.write(field.getSubType());
        bout.write(field.getSubType() >> 8);
        bout.write(field.getScale());
        bout.write(0);
    }

    @Override
    public int calculateIoLength(FieldDescriptor fieldDescriptor) throws SQLException {
        return switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
            case 452 -> fieldDescriptor.getLength() + 1;
            case 448 -> 0;
            case 482, 496, 500, 560, 570 -> -4;
            case 480, 510, 520, 540, 550, 580, 32756, 32760 -> -8;
            case 32750, 32754 -> -12;
            case 32748, 32752, 32762 -> -16;
            case 32766 -> 0;
            case 32764 -> 2;
            default -> throw FbExceptionBuilder.toException(335544573);
        };
    }

    @Override
    public int calculateIoLength(FieldDescriptor fieldDescriptor, byte[] fieldData) throws SQLException {
        int fieldType = fieldDescriptor.getType() & 0xFFFFFFFE;
        if (fieldType == 452) {
            return (fieldData != null ? fieldData.length : 0) + 1;
        }
        return this.calculateIoLength(fieldDescriptor);
    }

    @Override
    public int calculateBatchMessageLength(RowDescriptor rowDescriptor) throws SQLException {
        int length = 0;
        for (FieldDescriptor fieldDescriptor : rowDescriptor) {
            int align;
            int fieldLength = fieldDescriptor.getLength();
            switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
                case 452: 
                case 32764: 
                case 32766: {
                    align = 1;
                    break;
                }
                case 500: {
                    align = 2;
                    break;
                }
                case 448: {
                    align = 2;
                    fieldLength += 2;
                    break;
                }
                case 482: 
                case 496: 
                case 510: 
                case 520: 
                case 540: 
                case 550: 
                case 560: 
                case 570: 
                case 32748: 
                case 32750: 
                case 32754: 
                case 32756: {
                    align = 4;
                    break;
                }
                case 480: 
                case 530: 
                case 580: 
                case 32752: 
                case 32760: 
                case 32762: {
                    align = 8;
                    break;
                }
                default: {
                    throw FbExceptionBuilder.toException(335544573);
                }
            }
            if (align > 1) {
                length = this.blrAlign(length, align);
            }
            length += fieldLength;
            length = this.blrAlign(length, 2) + 2;
        }
        return length;
    }

    private int blrAlign(int length, int alignment) {
        return length + alignment - 1 & -alignment;
    }
}

