\name{OtsuMultipleThresholdsImageFilter}
\alias{OtsuMultipleThresholdsImageFilter}
\title{OtsuMultipleThresholdsImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Threshold an image using multiple Otsu Thresholds.
OtsuMultipleThresholdsImageFilter}
\details{
This filter creates a labeled image that separates the input image
into various classes. The filter computes the thresholds using the OtsuMultipleThresholdsCalculator and applies those thresholds to the input image using the ThresholdLabelerImageFilter . The NumberOfHistogramBins and NumberOfThresholds can be set for the
Calculator. The LabelOffset can be set for the ThresholdLabelerImageFilter .
This filter also includes an option to use the valley emphasis
algorithm from H.F. Ng, "Automatic thresholding for defect
detection", Pattern Recognition Letters, (27): 1644-1649, 2006. The
valley emphasis algorithm is particularly effective when the object to
be thresholded is small. See the following tests for examples:
itkOtsuMultipleThresholdsImageFilterTest3 and
itkOtsuMultipleThresholdsImageFilterTest4 To use this algorithm,
simple call the setter: SetValleyEmphasis(true) It is turned off by
default.
See:
ScalarImageToHistogramGenerator
OtsuMultipleThresholdsCalculator
ThresholdLabelerImageFilter
OtsuMultipleThresholds for the procedural interface
itk::OtsuMultipleThresholdsImageFilter for the Doxygen on the original ITK class.
OtsuMultipleThresholdsImageFilter}
%C++ includes: sitkOtsuMultipleThresholdsImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{uint8_t GetLabelOffset() const:}{
Set/Get the offset which labels have to start from. Default is 0.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfHistogramBins() const:}{
Set/Get the number of histogram bins. Default is 128.
}
\item{uint8_t GetNumberOfThresholds() const:}{
Set/Get the number of thresholds. Default is 1.
}
\item{bool GetReturnBinMidpoint() const:}{
Should the threshold value be mid-point of the bin or the maximum?
Default is to return bin maximum.
}
\item{std::vector< double > GetThresholds() const:}{
Get the computed threshold.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{bool GetValleyEmphasis() const:}{
Set/Get the use of valley emphasis. Default is false.
}
\item{ OtsuMultipleThresholdsImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self ReturnBinMidpointOff():}{}
\item{Self ReturnBinMidpointOn():}{
Set the value of ReturnBinMidpoint to true or false respectfully.
}
\item{Self SetLabelOffset(uint8_t LabelOffset):}{
Set/Get the offset which labels have to start from. Default is 0.
}
\item{Self SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins):}{
Set/Get the number of histogram bins. Default is 128.
}
\item{Self SetNumberOfThresholds(uint8_t NumberOfThresholds):}{
Set/Get the number of thresholds. Default is 1.
}
\item{Self SetReturnBinMidpoint(bool ReturnBinMidpoint):}{
Should the threshold value be mid-point of the bin or the maximum?
Default is to return bin maximum.
}
\item{Self SetValleyEmphasis(bool ValleyEmphasis):}{
Set/Get the use of valley emphasis. Default is false.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self ValleyEmphasisOff():}{}
\item{Self ValleyEmphasisOn():}{
Set the value of ValleyEmphasis to true or false respectfully.
}
\item{ ~OtsuMultipleThresholdsImageFilter():}{
Destructor
}
}
}
