/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class LabelStatement
extends Statement {
    public LabelStatement(int offset, String name) {
        super(offset);
        this.setLabel(name);
    }

    public final String getLabel() {
        return this.getChildByRole(Roles.LABEL).getName();
    }

    public final void setLabel(String value) {
        this.setChildByRole(Roles.LABEL, Identifier.create(value));
    }

    public final Identifier getLabelToken() {
        return this.getChildByRole(Roles.LABEL);
    }

    public final void setLabelToken(Identifier value) {
        this.setChildByRole(Roles.LABEL, value);
    }

    public final JavaTokenNode getColonToken() {
        return this.getChildByRole(Roles.COLON);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitLabelStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof LabelStatement && LabelStatement.matchString(this.getLabel(), ((LabelStatement)other).getLabel());
    }
}

