/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kgp extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arame";
        final String metaValue_ban = "marin\u1ebdj";
        final String metaValue_bax = "mam\u0169m";
        final String metaValue_bn = "megari";
        final String metaValue_chr = "seroki";
        final String metaValue_got = "g\u00f3tiko";
        final String metaValue_el = "gregu";
        final String metaValue_jv = "javan\u1ebdj";
        final String metaValue_km = "kym\u1ebdr";
        final String metaValue_ko = "korej\u1ef9n\u0169";
        final String metaValue_la = "rat\u0129nh";
        final String metaValue_mn = "m\u00e3g\u00f3r";
        final String metaValue_my = "mirm\u1ef9n\u1ebdj";
        final String metaValue_nqo = "nyko";
        final String metaValue_or = "orija";
        final String metaValue_phn = "fen\u0129so";
        final String metaValue_th = "tajr\u1ef9nej";
        final String metaValue_bo = "timet\u1ef9n\u0169";
        final String metaValue_vai = "vaj";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "T\u00e3 m\u0129 ke kar" },
            { "002", "Afrika" },
            { "003", "N\u00e3rti-Am\u1ebdrika" },
            { "005", "Sur-Am\u1ebdrika" },
            { "009", "Osean\u0129ja" },
            { "011", "Afrika R\u00e3pur" },
            { "013", "Am\u1ebdrika-Kuju" },
            { "014", "Afrika R\u00e3jur" },
            { "015", "N\u00e3rti-Afrika" },
            { "017", "Afrika-Kuju" },
            { "018", "Afrika M\u1ebdrinhon\u1ef9r" },
            { "019", "Am\u1ebdrika ag" },
            { "021", "Am\u1ebdrika Set\u1ebdntrion\u1ef9r" },
            { "029", "Karime" },
            { "030", "Ajia R\u00e3jur" },
            { "034", "Ajia M\u1ebdrinhon\u1ef9r" },
            { "035", "Ajia Sur-R\u00e3jur" },
            { "039", "Or\u00f3pa M\u1ebdrinhon\u1ef9r" },
            { "053", "Ausitrarajia" },
            { "054", "M\u1ebdran\u1ebdjia" },
            { "057", "M\u0129kron\u1ebdjia P\u00e9n\u0129n" },
            { "061", "Porin\u1ebdjia" },
            { "142", "Ajia" },
            { "143", "Ajia-Kuju" },
            { "145", "Ajia-R\u00e3pur" },
            { "150", "Or\u00f3pa" },
            { "151", "Or\u00f3pa-R\u00e3jur" },
            { "154", "Or\u00f3pa Set\u1ebdntrion\u1ef9r" },
            { "155", "Or\u00f3pa R\u00e3pur" },
            { "202", "Afrika Sahara-J\u1ebdgu" },
            { "419", "Am\u1ebdrika Ratin\u1ef9" },
            { "AC", "As\u1ebdns\u1ef9v Goj-v\u1ebdso" },
            { "AD", "\u1ef8nora" },
            { "AE", "Em\u0129rano Arame Un\u0129no" },
            { "AF", "Afegan\u0129t\u00e3" },
            { "AG", "\u1ef8ntiguva kar Marmuna" },
            { "AI", "\u1ef8ngira" },
            { "AL", "Arm\u00e1n\u0129ja" },
            { "AM", "Arm\u1ebdn\u0129ja" },
            { "AO", "\u1ef8g\u00f3ra" },
            { "AQ", "\u1ef8ntartina" },
            { "AR", "Arj\u1ebdtin\u1ef9" },
            { "AS", "Sam\u00e3va Am\u1ebdrikyn\u1ef9" },
            { "AT", "Agtirija" },
            { "AU", "Avotyraria" },
            { "AW", "Aruma" },
            { "AX", "Gojga Goj-v\u1ebdso" },
            { "AZ", "Ajermajj\u00e1v" },
            { "BA", "M\u00f3sin\u0129ja" },
            { "BB", "Juv\u00e3-m\u00e1g" },
            { "BD", "M\u00e1gran\u00e9si" },
            { "BE", "M\u00e9rjika" },
            { "BF", "Murkin\u1ef9 Faso" },
            { "BG", "Murgarjia" },
            { "BH", "Mar\u1ebdj" },
            { "BI", "Mur\u0169ni" },
            { "BJ", "Men\u0129nh" },
            { "BL", "S\u1ef9 Martoromeu" },
            { "BM", "Merm\u0169na" },
            { "BN", "Mrun\u1ebdj" },
            { "BO", "Morivija" },
            { "BQ", "Pajisi Rur Karimej\u00e3" },
            { "BR", "Mrasir" },
            { "BS", "Mah\u00e1m\u1ef9" },
            { "BT", "Mut\u1ef9v" },
            { "BV", "Muve Goj-v\u1ebdso" },
            { "BW", "Monsuv\u1ef9n\u1ef9" },
            { "BY", "Miero-Husija" },
            { "BZ", "Merije" },
            { "CA", "Kan\u1ef9na" },
            { "CC", "Kokonh Goj-v\u1ebdso (Killing)" },
            { "CD", "K\u00e3go - K\u0129saja" },
            { "CF", "Afrikan\u1ef9-kuju Repumrika" },
            { "CG", "K\u00e3go Repumrika" },
            { "CH", "Suvisa" },
            { "CI", "J\u00e3n-m\u00e1g-kupri Fyr" },
            { "CK", "Kuki Goj-v\u1ebdso" },
            { "CL", "Sire" },
            { "CM", "Kam\u1ef9r\u00e3j" },
            { "CN", "S\u0129n\u1ef9" },
            { "CO", "Kor\u00e3mija" },
            { "CP", "Kripert\u00e3n Goj-v\u1ebdso" },
            { "CR", "Konhta Rika" },
            { "CU", "Kuma" },
            { "CV", "Pu T\u00e1nh" },
            { "CW", "Kurasavo" },
            { "CX", "Kr\u0129tim\u1ef9nh Goj-v\u1ebdso" },
            { "CY", "Sipre" },
            { "CZ", "S\u00e9kija" },
            { "DE", "Arem\u1ef9ija" },
            { "DG", "Niego Garsija" },
            { "DJ", "Nhimuti" },
            { "DK", "Nin\u1ef9m\u1ef9rka" },
            { "DM", "Nom\u0129n\u0129ka" },
            { "DO", "Repumrika Nom\u0129n\u0129k\u1ef9n\u1ef9" },
            { "DZ", "Arj\u00e9rija" },
            { "EA", "Sevuta kar M\u1ebdrira" },
            { "EC", "Ekuvanor" },
            { "EE", "Enhton\u0129ja" },
            { "EG", "Ejito" },
            { "EH", "Sahara R\u00e3pur" },
            { "ER", "Erytir\u00e9ja" },
            { "ES", "Enhp\u1ef9nija" },
            { "ET", "Eti\u00f3pija" },
            { "EU", "Un\u0129j\u00e1v Orop\u00e9ja" },
            { "EZ", "Evoro Ga" },
            { "FI", "F\u0129r\u1ef9nija" },
            { "FJ", "Fiji" },
            { "FK", "M\u1ef9rv\u0129n\u1ef9 Goj-v\u1ebdso" },
            { "FM", "Goj-v\u1ebdso-s\u0129 K\u1ebdsir" },
            { "FO", "Far\u00f3ve Goj-v\u1ebdso" },
            { "FR", "Fr\u1ef9sa" },
            { "GA", "Gab\u00e3" },
            { "GB", "Rejn\u0169 Un\u0129nu" },
            { "GD", "Gran\u1ef9na" },
            { "GE", "Ji\u00f3rja" },
            { "GF", "Fr\u1ef9sa Gijan\u1ef9" },
            { "GG", "G\u00e9rnesej" },
            { "GH", "Gan\u1ef9" },
            { "GI", "Gimrar-tar" },
            { "GL", "Gro\u1ebdr\u1ef9nija" },
            { "GM", "G\u1ef9mija" },
            { "GN", "Gin\u1ebd" },
            { "GP", "Guvanarupe" },
            { "GQ", "Gin\u1ebd Ekuvatoriar" },
            { "GR", "Gr\u00e9sa" },
            { "GS", "Ji\u00f3rja-Sur kar S\u1ef9nvisi-Sur Goj-v\u1ebdso Ag" },
            { "GT", "Guvatim\u1ef9ra" },
            { "GU", "Guv\u1ef9m" },
            { "GW", "Gin\u1ebd-Misav" },
            { "GY", "Gij\u1ef9n\u1ef9" },
            { "HK", "H\u00e3g K\u00e3g, Sin\u1ef9 ERA" },
            { "HM", "H\u00e1rni kar Magtonarni Goj-v\u1ebdso Ag" },
            { "HN", "H\u00e3nura" },
            { "HR", "Kroasa" },
            { "HT", "Ajti" },
            { "HU", "\u0168grija" },
            { "IC", "Kan\u1ef9rija Goj-v\u1ebdso" },
            { "ID", "\u0128non\u1ebdja" },
            { "IE", "Ir\u1ef9na" },
            { "IL", "Isiha\u00e9" },
            { "IM", "M\u1ef9n Goj-v\u1ebdso" },
            { "IN", "\u0128nija" },
            { "IQ", "Iraki" },
            { "IR", "Ir\u1ef9" },
            { "IS", "Inhr\u1ef9nija" },
            { "IT", "Itarija" },
            { "JE", "J\u00e9rsej" },
            { "JM", "Jam\u1ef9jka" },
            { "JO", "Jorn\u00e1n\u0129ja" },
            { "JP", "Jap\u00e3" },
            { "KE", "Ken\u0129ja" },
            { "KG", "Kirginht\u1ef9v" },
            { "KH", "K\u1ef9m\u00f3ja" },
            { "KI", "Kirimati" },
            { "KM", "Kom\u00e3re" },
            { "KN", "S\u1ef9 Krinht\u00f3v\u1ef9v kar N\u1ebdvinh" },
            { "KP", "N\u00e3rti-Kor\u00e9ja" },
            { "KR", "Sur-Kor\u00e9ja" },
            { "KW", "Kuvajti" },
            { "KY", "Kajm\u1ef9m Goj-v\u1ebdso" },
            { "KZ", "Kajakinht\u1ef9v" },
            { "LA", "Raosi" },
            { "LB", "Riman\u00e3" },
            { "LC", "S\u1ef9ta Rusija" },
            { "LI", "Rinhsit\u00e9nh-tajin" },
            { "LK", "Siri R\u1ef9nka" },
            { "LR", "Rim\u00e9rija" },
            { "LS", "Resotu" },
            { "LT", "Ritu\u1ef9n\u0129ja" },
            { "LU", "Rus\u1ebdmurgu" },
            { "LV", "Ret\u00e3n\u0129ja" },
            { "LY", "Rimija" },
            { "MA", "M\u1ef9h\u00f3konh" },
            { "MC", "M\u00e3n\u1ef9ko" },
            { "MD", "M\u00e3rnova" },
            { "ME", "Kr\u0129s\u00e1" },
            { "MF", "S\u1ef9 M\u1ef9rt\u0129j\u0169" },
            { "MG", "M\u1ef9naganhtar" },
            { "MH", "M\u1ef9rSar Goj-v\u1ebdso" },
            { "MK", "N\u00e3rti-M\u1ef9senon\u0129ja" },
            { "ML", "M\u1ef9ri" },
            { "MM", "M\u0129j\u1ef9m\u1ef9r" },
            { "MN", "M\u00e3ng\u00f3rija" },
            { "MO", "M\u1ef9kav, S\u0129n\u1ef9 ERA" },
            { "MP", "N\u00e3rti-M\u1ef9rij\u1ef9n\u1ef9 Goj-v\u1ebdso" },
            { "MQ", "M\u1ef9rtin\u0129ka" },
            { "MR", "M\u00e3rit\u1ef9n\u0129ja" },
            { "MS", "M\u00e3tisehati" },
            { "MT", "M\u1ef9rta" },
            { "MU", "M\u00e3riso" },
            { "MV", "M\u1ef9rniva" },
            { "MW", "M\u1ef9ravi" },
            { "MX", "M\u1ebdsiku" },
            { "MY", "M\u1ef9raja" },
            { "MZ", "M\u00e3s\u1ef9miki" },
            { "NA", "N\u1ef9m\u0129mija" },
            { "NC", "Karenon\u0129ja T\u00e3g" },
            { "NE", "N\u0129jer" },
            { "NF", "N\u00e3rforki Goj-v\u1ebdso" },
            { "NG", "N\u0129j\u00e9rija" },
            { "NI", "N\u0129karagva" },
            { "NL", "Pajisi Rur" },
            { "NO", "N\u00e3rov\u00e9ga" },
            { "NP", "N\u1ebdpar" },
            { "NR", "N\u1ef9uru" },
            { "NU", "N\u0129vue" },
            { "NZ", "Jer\u1ef9nija T\u00e3g" },
            { "OM", "Om\u1ef9" },
            { "PA", "Pan\u1ef9m\u1ef9" },
            { "PE", "Piru" },
            { "PF", "Fr\u1ef9sa Porin\u1ebdja" },
            { "PG", "Papuva-Gin\u1ebd T\u00e3g" },
            { "PH", "Firipin\u1ef9" },
            { "PK", "Pakinht\u1ef9v" },
            { "PL", "Por\u00e3nija" },
            { "PM", "S\u1ef9 Penru kar M\u0129ker\u1ef9v" },
            { "PN", "Pinkajir Goj-v\u1ebdso" },
            { "PR", "Portu Hiku" },
            { "PS", "Tehit\u00f3rijo Parenhtin\u0169" },
            { "PT", "Portugar" },
            { "PW", "Paravu" },
            { "PY", "Paraguvaj" },
            { "QA", "Katar" },
            { "QO", "Osi\u1ef9n\u0129ja Kuvar-gy" },
            { "RE", "Huj\u00e1v" },
            { "RO", "Hom\u1ebdn\u0129ja" },
            { "RS", "S\u00e9rvija" },
            { "RU", "Husija" },
            { "RW", "Hu\u1ef9na" },
            { "SA", "Aramija Savnita" },
            { "SB", "Sarom\u1ef9v Goj-v\u1ebdso" },
            { "SC", "Sejserenh" },
            { "SD", "Sun\u00e1" },
            { "SE", "Su\u00e9sa" },
            { "SG", "S\u0129gapura" },
            { "SH", "S\u1ef9nta Eren\u1ef9" },
            { "SI", "Enhroven\u0129ja" },
            { "SJ", "Inhvarmarni kar Jan M\u1ef9j\u1ebdn" },
            { "SK", "Enhrovakija" },
            { "SL", "Kr\u0129 M\u0129gkus\u0169g-fi" },
            { "SM", "S\u1ef9 M\u1ef9r\u0129n\u0169" },
            { "SN", "Sen\u1ebdgar" },
            { "SO", "Som\u1ef9rija" },
            { "SR", "Surin\u1ef9m\u0129" },
            { "SS", "Sur-Sun\u00e1v" },
            { "ST", "S\u1ef9 Tom\u1ebd kar Pr\u0129sipi" },
            { "SV", "Er Sarvanor" },
            { "SX", "S\u0129ti M\u1ef9\u2019art\u1ebdn" },
            { "SY", "Sirija" },
            { "SZ", "Esuatin\u0129" },
            { "TA", "Trinht\u1ef9v Nak\u0169ja" },
            { "TC", "Turka kar Kajko Goj-v\u1ebdso Ag" },
            { "TD", "Sane" },
            { "TF", "Sur Fr\u1ef9sa Tehit\u00f3rijo" },
            { "TG", "Togo" },
            { "TH", "Taj-Ga" },
            { "TJ", "Tanijikinht\u1ef9v" },
            { "TK", "Tokeravu" },
            { "TL", "Tim\u00e3r-R\u00e3jur" },
            { "TM", "Turkom\u1ebdn\u0129nht\u1ef9v" },
            { "TN", "Tun\u0129ja" },
            { "TO", "T\u00e3ga" },
            { "TR", "Turkija" },
            { "TT", "Tr\u0129nane kar Tomagu" },
            { "TV", "Tuvaru" },
            { "TW", "Tajuv\u1ef9" },
            { "TZ", "T\u1ef9nj\u1ef9n\u0129ja" },
            { "UA", "Ukr\u1ef9n\u0129ja" },
            { "UG", "Ug\u1ef9na" },
            { "UM", "EUA Goj-v\u1ebdso K\u00e3sir" },
            { "UN", "N\u1ef9s\u00e3n Un\u0129na" },
            { "US", "Enhtano Un\u0129no" },
            { "UY", "Urugvaj" },
            { "UZ", "Unhmekinht\u1ef9v" },
            { "VA", "Vatik\u1ef9n\u0169 Em\u00e3-m\u00e1g" },
            { "VC", "S\u1ef9 Visenti kar Gran\u1ef9nin\u1ef9" },
            { "VE", "Ven\u1ebdjuv\u00e9ra" },
            { "VG", "Mrit\u1ef9n\u0129ja Goj-v\u1ebdso" },
            { "VI", "Virj\u0129g Goj-v\u1ebdso t\u1ef9 Am\u1ebdrik\u1ef9n\u1ef9" },
            { "VN", "Vij\u00e9tin\u1ef9" },
            { "VU", "Van\u0169vatu" },
            { "WF", "Varinh kar Futun\u1ef9" },
            { "WS", "Sam\u00e3va" },
            { "XA", "\u00d3n v\u0129 ag" },
            { "XB", "\u00d3n r\u00e9gre m\u0129." },
            { "XK", "Kosovo" },
            { "YE", "Jem\u1ebdn" },
            { "YT", "M\u1ef9j\u00f3te" },
            { "ZA", "Sur-Afrika" },
            { "ZM", "J\u1ef9mija" },
            { "ZW", "J\u0129mamuje" },
            { "ZZ", "Reji\u2019\u1ef9v Veja t\u0169" },
            { "aa", "afar" },
            { "ab", "amekaso" },
            { "ae", "av\u00e9tiko" },
            { "af", "afrik\u1ef9n\u1ebd" },
            { "ak", "ak\u1ef9n" },
            { "am", "am\u1ef9riko" },
            { "an", "aragon\u1ebd" },
            { "ar", metaValue_ar },
            { "as", "ajam\u1ebd" },
            { "av", "avariko" },
            { "ay", "ajim\u1ef9ra" },
            { "az", "ajermaj\u1ef9n\u0169" },
            { "ba", "majkir" },
            { "be", "huso-kupri" },
            { "bg", "mugaru" },
            { "bi", "miram\u00e1" },
            { "bm", "m\u00e1mara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "mret\u1ef9" },
            { "bs", "mojnia" },
            { "ca", "katar\u0169g" },
            { "ce", "ses\u1ebdn\u0169" },
            { "ch", "sam\u00e3hu" },
            { "co", "korso" },
            { "cr", "kri" },
            { "cs", "s\u00e9ko" },
            { "cu", "eravu ekresijatiko" },
            { "cv", "suvase" },
            { "cy", "garej" },
            { "da", "nhin\u1ef9m\u1ef9rkej" },
            { "de", "arim\u1ef9v" },
            { "dv", "nivehi" },
            { "dz", "j\u00e3nga" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "\u0129nhgrej" },
            { "eo", "enhper\u1ef9tu" },
            { "es", "enhp\u1ef9j\u00f3r" },
            { "et", "enhton\u0129j\u1ef9n\u0169" },
            { "eu", "manhku" },
            { "fa", "p\u00e9rsa" },
            { "ff", "fura" },
            { "fi", "f\u0129ran\u1ebdj" },
            { "fj", "fij\u1ef9n\u0169" },
            { "fo", "fervej" },
            { "fr", "fr\u1ef9sej" },
            { "fy", "friso r\u00e3pur" },
            { "ga", "ir\u1ef9nej" },
            { "gd", "gaj\u00e9riko enhkosej" },
            { "gl", "garego" },
            { "gn", "g\u00f3ran\u0129" },
            { "gu", "gujerati" },
            { "gv", "m\u1ef9nsi" },
            { "ha", "havusa" },
            { "he", "emrajko" },
            { "hi", "h\u0129ni" },
            { "ho", "hiri motu" },
            { "hr", "krovata" },
            { "ht", "hajtij\u1ef9n\u0169" },
            { "hu", "\u0169garu" },
            { "hy", "arm\u1ebdn\u0129ju" },
            { "hz", "herero" },
            { "ia", "v\u0129-j\u00e3gja" },
            { "id", "\u0129non\u1ebdsijo" },
            { "ie", "v\u0129-ag kuju ki" },
            { "ig", "igmo" },
            { "ii", "sisuv\u1ef9 ji" },
            { "ik", "\u0129n\u0169pijake" },
            { "io", "ino" },
            { "is", "kukryr" },
            { "it", "itarij\u1ef9n\u0169" },
            { "iu", "inugtituti" },
            { "ja", "japon\u1ebdj" },
            { "jv", metaValue_jv },
            { "ka", "ji\u00f3rjij\u1ef9n\u0169" },
            { "kg", "k\u00e3gorej" },
            { "ki", "kikuju" },
            { "kj", "kuvanh\u1ef9m\u1ef9" },
            { "kk", "kajake" },
            { "kl", "groh\u1ebdr\u1ef9nej" },
            { "km", metaValue_km },
            { "kn", "kan\u1ef9rim" },
            { "ko", metaValue_ko },
            { "kr", "kan\u0169ri" },
            { "ks", "kasem\u0129ra" },
            { "ku", "kurno" },
            { "kv", "kom\u0129" },
            { "kw", "k\u00f3rn\u0129ko" },
            { "ky", "kirginh" },
            { "la", metaValue_la },
            { "lb", "rus\u1ebdmurgej" },
            { "lg", "rug\u1ef9na" },
            { "li", "r\u0129murgej" },
            { "ln", "r\u0129gara" },
            { "lo", "raosij\u1ef9n\u0169" },
            { "lt", "rituv\u1ef9n\u0169" },
            { "lu", "ruma-kat\u1ef9ga" },
            { "lv", "ret\u1ef9v" },
            { "mg", "m\u1ef9rgase" },
            { "mh", "m\u1ef9rsarej" },
            { "mi", "m\u1ef9v\u00f3ri" },
            { "mk", "m\u1ef9senoj\u0169" },
            { "ml", "m\u1ef9rajara" },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "m\u1ef9rajo" },
            { "mt", "m\u1ef9rtej" },
            { "my", metaValue_my },
            { "na", "n\u1ef9vuruv\u00e1n\u0169" },
            { "nb", "m\u00f3gm\u1ef9r n\u00e3rovegej" },
            { "nd", "nemere n\u00e3rti" },
            { "ne", "n\u1ebdparej" },
            { "ng", "nog\u00e3" },
            { "nl", "or\u1ef9nej" },
            { "nn", "n\u0129n\u00e3rsig n\u00e3rovegej" },
            { "no", "n\u00e3rovegej" },
            { "nr", "nemere sur" },
            { "nv", "n\u1ef9vaho" },
            { "ny", "n\u0129j\u1ef9nja" },
            { "oc", "ogsit\u1ef9n\u0169" },
            { "oj", "ojimva" },
            { "om", "or\u00e3m\u0169" },
            { "or", metaValue_or },
            { "os", "oseto" },
            { "pa", "p\u1ef9jami" },
            { "pi", "pari" },
            { "pl", "poron\u1ebdj" },
            { "ps", "pasito" },
            { "pt", "f\u00f3g-v\u0129" },
            { "qu", "kinsuva" },
            { "rm", "hom\u1ef9se" },
            { "rn", "h\u0169ni" },
            { "ro", "hom\u1ebdn\u0169" },
            { "ru", "huso" },
            { "rw", "kin\u0129jarv\u1ef9na" },
            { "sa", "s\u1ef9nhkrito" },
            { "sc", "sarno" },
            { "sd", "s\u0129ni" },
            { "se", "sam\u0129 n\u00e3rti" },
            { "sg", "s\u1ef9go" },
            { "sh", "servo-krovata" },
            { "si", "s\u0129garej" },
            { "sk", "erovako" },
            { "sl", "eroven\u0169" },
            { "sm", "samov\u1ef9n\u0169" },
            { "sn", "s\u00e3n\u1ef9" },
            { "so", "som\u1ef9ri" },
            { "sq", "arm\u00e1n\u1ebdj" },
            { "sr", "s\u00e9rvijo" },
            { "ss", "suvaji" },
            { "st", "soto sur" },
            { "su", "sunan\u1ebdj" },
            { "sv", "suv\u00e9ko" },
            { "sw", "suvahiri" },
            { "ta", "t\u00e1m\u0129r" },
            { "te", "t\u00e9rugo" },
            { "tg", "tanhike" },
            { "th", metaValue_th },
            { "ti", "tigrin\u0129ja" },
            { "tk", "turkom\u1ebdn\u0169" },
            { "tl", "tagaro" },
            { "tn", "tisuvan\u1ef9" },
            { "to", "t\u00e3ngan\u1ebdj" },
            { "tr", "turko" },
            { "ts", "tes\u00e3ga" },
            { "tt", "tartaru" },
            { "tw", "tuvi" },
            { "ty", "tajtij\u1ef9n\u0169" },
            { "ug", "ujgur" },
            { "uk", "ukran\u0129j\u1ef9n\u0169" },
            { "ur", "urnu" },
            { "uz", "unhmeke" },
            { "ve", "v\u1ebdna" },
            { "vi", "vij\u00e9tin\u1ef9m\u0169" },
            { "vo", "vorapuke" },
            { "wa", "var\u1ef9v" },
            { "wo", "vorofe" },
            { "xh", "sosa" },
            { "yi", "jinhise" },
            { "yo", "joruma" },
            { "za", "juv\u1ef9g" },
            { "zh", "s\u0129n\u1ebdj" },
            { "zu", "suru" },
            { "ace", "ags\u1ebdm" },
            { "ach", "akori" },
            { "ada", "an\u00e1gme" },
            { "ady", "anhige" },
            { "afh", "afrihiri" },
            { "agq", "agh\u1ebdm" },
            { "ain", "ajin\u0169" },
            { "akk", "akaj\u1ef9n\u0169" },
            { "ale", "arevute" },
            { "alt", "artaj sur" },
            { "ang", "\u0129nhgrej arkajiku" },
            { "anp", "\u1ef9gika" },
            { "arc", "aramajiko" },
            { "arn", "m\u1ef9punug\u0169n" },
            { "arp", "arapaho" },
            { "ars", "arame n\u1ebdgene" },
            { "arw", "aruvaki" },
            { "asa", "asu" },
            { "ast", "anhturij\u1ef9n\u0169" },
            { "awa", "avanhi" },
            { "bal", "marusi" },
            { "ban", metaValue_ban },
            { "bas", "masa" },
            { "bax", metaValue_bax },
            { "bbj", "gum\u1ef9ra" },
            { "bej", "meja" },
            { "bem", "mema" },
            { "bez", "men\u1ef9" },
            { "bfd", "mafun" },
            { "bgn", "marusi-r\u00e3purja" },
            { "bho", "mojpuri" },
            { "bik", "mikor" },
            { "bin", "min\u0129" },
            { "bkm", "k\u00e3m" },
            { "bla", "sigsika" },
            { "bra", "mraj" },
            { "brx", "mono" },
            { "bss", "akuse" },
            { "bua", "murijato" },
            { "bug", "mugin\u1ebdj" },
            { "bum", "muru" },
            { "byn", "mr\u0129n" },
            { "byv", "menuma" },
            { "cad", "kano" },
            { "car", "karime" },
            { "cay", "kajuga" },
            { "cch", "ans\u1ef9m" },
            { "ccp", "sakim\u1ef9" },
            { "ceb", "semuj\u1ef9n\u0169" },
            { "cgg", "siga" },
            { "chb", "simsa" },
            { "chg", "sagataj" },
            { "chk", "sukese" },
            { "chm", "m\u1ef9ri" },
            { "chn", "jarg\u1ef9 sin\u0169ki" },
            { "cho", "sogtavo" },
            { "chp", "sipevyj\u1ef9" },
            { "chr", metaValue_chr },
            { "chy", "sej\u1ebdn\u1ebd" },
            { "ckb", "kurno kuju" },
            { "cop", "komta" },
            { "crh", "krim\u1ebdja t\u00e1 turko" },
            { "crs", "sejs\u00e9ri krijoro-fr\u1ef9sej" },
            { "csb", "kasumij\u1ef9" },
            { "dak", "nakota" },
            { "dar", "narguva" },
            { "dav", "tajta" },
            { "del", "neravare" },
            { "den", "sirave" },
            { "dgr", "nogrim" },
            { "din", "ninka" },
            { "dje", "jarma" },
            { "doi", "nogri" },
            { "dsb", "soramiv rur" },
            { "dua", "nuvara" },
            { "dum", "or\u1ef9nej kuju" },
            { "dyo", "jora-fonyj" },
            { "dyu", "nhivura" },
            { "dzg", "najaga" },
            { "ebu", "\u1ebdmu" },
            { "efi", "efike" },
            { "egy", "ejimso arkajku" },
            { "eka", "ekajuki" },
            { "elx", "eram\u0129te" },
            { "enm", "\u0129nhgrej kuju" },
            { "ewo", "ev\u00e3nu" },
            { "fan", "f\u1ef9nge" },
            { "fat", "f\u1ef9ti" },
            { "fil", "firip\u0129n\u0169" },
            { "fon", "f\u00e3m" },
            { "frc", "fr\u1ef9sej kaj\u0169n" },
            { "frm", "fr\u1ef9sej kuju" },
            { "fro", "fr\u1ef9sej arkajku" },
            { "frr", "friso t\u1ef9 n\u00e3rti" },
            { "frs", "fris\u1ef9 r\u00e3jur" },
            { "fur", "frijur\u1ef9n\u0169" },
            { "gaa", "ga" },
            { "gag", "gagavuj" },
            { "gan", "g\u1ef9n" },
            { "gay", "gajo" },
            { "gba", "gemaja" },
            { "gez", "gij" },
            { "gil", "gimertej" },
            { "gmh", "arim\u1ef9v-t\u00e9j kuju" },
            { "goh", "arim\u1ef9v-t\u00e9j arkajku" },
            { "gon", "g\u00e3nni" },
            { "gor", "gor\u00e3ntar" },
            { "got", metaValue_got },
            { "grb", "gremo" },
            { "grc", "gregu arkajku" },
            { "gsw", "arim\u1ef9v (Suvisa)" },
            { "guz", "gusij" },
            { "gwi", "guvis\u0129n" },
            { "hai", "hajna" },
            { "hak", "haka" },
            { "haw", "havaj\u1ef9n\u0169" },
            { "hil", "hirigajn\u00e3n" },
            { "hit", "hitita" },
            { "hmn", "hym\u00e3g" },
            { "hsb", "soramiv t\u00e9j" },
            { "hsn", "sij\u1ef9g" },
            { "hup", "hupa" },
            { "iba", "iman" },
            { "ibb", "imimijo" },
            { "ilo", "iruk\u1ef9n\u0169" },
            { "inh", "\u0129nguse" },
            { "jbo", "rojm\u00e1n" },
            { "jgo", "g\u1ebdma" },
            { "jmc", "m\u1ef9same" },
            { "jpr", "junajko-p\u00e9rsa" },
            { "jrb", "junajko-aramiko" },
            { "kaa", "kara-karkag" },
            { "kab", "kamyre" },
            { "kac", "kas\u0129n" },
            { "kaj", "ju" },
            { "kam", "k\u1ef9ma" },
            { "kaw", "kavi" },
            { "kbd", "kamarnhij\u1ef9n\u0169" },
            { "kbl", "kan\u1ebdnmu" },
            { "kcg", "tyjam" },
            { "kde", "m\u1ef9k\u00e3ne" },
            { "kea", "pu-t\u00e1nh-v\u0129" },
            { "kfo", "koro" },
            { "kgp", "kanhg\u00e1g" },
            { "kha", "kasi" },
            { "kho", "kotan\u1ebdj" },
            { "khq", "kujra s\u0129n\u0129" },
            { "kkj", "kako" },
            { "kln", "kar\u1ebdnj\u0129n" },
            { "kmb", "k\u0129muno" },
            { "koi", "kom\u0129-permyjag" },
            { "kok", "k\u00e3kani" },
            { "kos", "kosiraj\u1ef9n" },
            { "kpe", "kepere" },
            { "krc", "karasaj-markar" },
            { "krl", "kar\u00e9rijo" },
            { "kru", "kurug" },
            { "ksb", "s\u1ef9mara" },
            { "ksf", "mafija" },
            { "ksh", "k\u00e1rysi" },
            { "kum", "kumyg" },
            { "kut", "kutenaj" },
            { "lad", "ranin\u0169" },
            { "lag", "r\u1ef9ngi" },
            { "lah", "rahina" },
            { "lam", "r\u1ef9ma" },
            { "lez", "resgi" },
            { "lkt", "rak\u00f3ta" },
            { "lol", "m\u00e3go" },
            { "lou", "rovusij\u1ef9n\u1ef9 t\u00e1 ke p\u1ebd" },
            { "loz", "roji" },
            { "lrc", "ruri n\u00e3rti" },
            { "lua", "ruma-ruruva" },
            { "lui", "rujs\u1ebdn\u0169" },
            { "lun", "r\u0169na" },
            { "luo", "ruvo" },
            { "lus", "rusaj" },
            { "luy", "ruja" },
            { "mad", "m\u1ef9nurej" },
            { "maf", "mafa" },
            { "mag", "m\u1ef9gahi" },
            { "mai", "m\u1ef9jtiri" },
            { "mak", "m\u1ef9kasar" },
            { "man", "m\u1ef9nh\u0129ga" },
            { "mas", "m\u1ef9saj" },
            { "mde", "mama" },
            { "mdf", "mogsa" },
            { "mdr", "m\u1ef9nar" },
            { "men", "m\u1ebdne" },
            { "mer", "m\u1ebdru" },
            { "mfe", "m\u00e3risij\u1ebdn" },
            { "mga", "ir\u1ef9nej kuju" },
            { "mgh", "m\u1ef9kuva" },
            { "mgo", "m\u1ebdta" },
            { "mic", "m\u0129kem\u1ef9ke" },
            { "min", "m\u0129n\u1ef9gkamavu" },
            { "mnc", "m\u1ef9su" },
            { "mni", "m\u1ef9n\u0129puri" },
            { "moh", "m\u00e3jk\u1ef9n\u0169" },
            { "mos", "mosi" },
            { "mua", "m\u0169n\u00e1g" },
            { "mul", "v\u1ebdnhv\u0129\u2019e" },
            { "mus", "krig" },
            { "mwl", "m\u0129r\u1ef9nej" },
            { "mwr", "m\u1ef9rvari" },
            { "mye", "myene" },
            { "myv", "\u00e9rsija" },
            { "mzn", "m\u1ef9s\u00e1nar\u1ef9ni" },
            { "nan", "m\u0129n n\u1ef9n" },
            { "nap", "n\u1ef9porit\u1ef9n\u0169" },
            { "naq", "n\u1ef9m\u1ef9" },
            { "nds", "arim\u1ef9v rur" },
            { "new", "n\u1ebdvari" },
            { "nia", "n\u0129ja" },
            { "niu", "nivuvej\u1ef9n\u0169" },
            { "nmg", "kivasijo" },
            { "nnh", "gij\u1ebdmun" },
            { "nog", "n\u00e3gaj" },
            { "non", "n\u00e3rniko arkajku" },
            { "nqo", metaValue_nqo },
            { "nso", "soto n\u00e3rti" },
            { "nus", "n\u0169ver" },
            { "nwc", "n\u1ebdvari h\u00e1 t\u1ef9v\u0129" },
            { "nym", "nyj\u1ef9m-vesi" },
            { "nyn", "nyj\u1ef9mkore" },
            { "nyo", "nyjor" },
            { "nzi", "n\u0129sim\u1ef9" },
            { "osa", "osage" },
            { "ota", "turko otom\u1ef9n\u0169" },
            { "pag", "pangasin\u1ef9" },
            { "pal", "paravi" },
            { "pam", "pamp\u1ef9ga" },
            { "pap", "papijam\u1ebdto" },
            { "pau", "parav\u1ef9n\u0169" },
            { "pcm", "ping\u0129n n\u0129jerij\u1ef9n\u0169" },
            { "peo", "p\u00e9rsa arkajku" },
            { "phn", metaValue_phn },
            { "pon", "p\u00e3nhpej\u1ef9n\u0169" },
            { "prg", "prusij\u1ef9n\u0169" },
            { "pro", "prov\u1ebdsar arkajku" },
            { "quc", "kis\u00e9" },
            { "raj", "hajanht\u1ef9n\u0129" },
            { "rap", "hapan\u0169j" },
            { "rar", "harot\u00e3gan\u0169" },
            { "rof", "h\u00e3mo" },
            { "rom", "hom\u1ef9n\u0129" },
            { "rup", "arom\u1ebdn\u0169" },
            { "rwk", "hywa" },
            { "sad", "s\u1ef9nave" },
            { "sah", "saka" },
            { "sam", "aram\u1ef9jko samarit\u1ef9n\u0169" },
            { "saq", "s\u1ef9muru" },
            { "sas", "sasag" },
            { "sat", "s\u1ef9tari" },
            { "sba", "g\u1ef9maji" },
            { "sbp", "s\u1ef9gu" },
            { "scn", "sisirij\u1ef9n\u0169" },
            { "sco", "isikoti" },
            { "sdh", "kurno sur" },
            { "see", "sen\u1ebdka" },
            { "seh", "sen\u1ef9" },
            { "sel", "serkum" },
            { "ses", "kojyramoro sen\u0129" },
            { "sga", "ir\u1ef9nej arkajku" },
            { "shi", "tasehiti" },
            { "shn", "s\u1ef9n" },
            { "shu", "arame sanij\u1ef9n\u0169" },
            { "sid", "sinam\u0169" },
            { "sma", "sam\u0129 sur" },
            { "smj", "sam\u0129 Rure t\u00e1" },
            { "smn", "sam\u0129 Inari t\u00e1" },
            { "sms", "sam\u0129 Isik\u00f3rti t\u00e1" },
            { "snk", "s\u00e3n\u0129ke" },
            { "sog", "sognij\u1ef9n\u0169" },
            { "srn", "surin\u1ef9m\u1ebdj" },
            { "srr", "serere" },
            { "ssy", metaValue_ssy },
            { "suk", "sukum\u1ef9" },
            { "sus", "susu" },
            { "sux", "sum\u1ebdrijo" },
            { "swb", "komorij\u1ef9n\u0169" },
            { "syc", "sirijako h\u00e1 t\u1ef9v\u0129" },
            { "syr", "sirijako" },
            { "tem", "timn\u1ebd" },
            { "teo", "teso" },
            { "ter", "ter\u1ebdn\u0169" },
            { "tet", "t\u00e9t\u0169m" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tivi" },
            { "tkl", "tokerav\u00e1n\u0169" },
            { "tlh", "kr\u0129ng\u00e3g" },
            { "tli", "tiringite" },
            { "tmh", "tam\u1ef9s\u00e9ke" },
            { "tog", "t\u00e3ngan\u1ebdj Nyjasa t\u00e1" },
            { "tpi", "t\u00f3g-pis\u0129n" },
            { "trv", "taroko" },
            { "tsi", "simsij\u1ef9n\u0169" },
            { "tum", "t\u0169muka" },
            { "tvl", "tuvaruv\u1ef9n\u0169" },
            { "twq", "tasavag" },
            { "tyv", "tuvinij\u1ef9n\u0169" },
            { "tzm", "tam\u1ef9jirte Atara Kuju t\u00e1" },
            { "udm", "unm\u0169rte" },
            { "uga", "ugaritiko" },
            { "umb", "\u0169munu" },
            { "und", "v\u1ebdnhv\u0129 ki kagt\u0129g" },
            { "vai", metaValue_vai },
            { "vot", "v\u00f3tiko" },
            { "vun", "v\u0169jo" },
            { "wae", "varser" },
            { "wal", "vorajta" },
            { "war", "varaj" },
            { "was", "vaso" },
            { "wbp", "varpiri" },
            { "wuu", "vu" },
            { "xal", "karm\u0129g" },
            { "xog", "rusoga" },
            { "yao", "javo" },
            { "yap", "japese" },
            { "yav", "j\u1ef9gmen" },
            { "ybb", "j\u1ebdma" },
            { "yrl", "nh\u1ebdgatu" },
            { "yue", "k\u1ef9ton\u1ebdj" },
            { "zap", "japoteko" },
            { "zbl", "s\u0129moru mrij" },
            { "zen", "sen\u1ef9ga" },
            { "zgh", "tam\u1ef9jirte m\u1ef9h\u00f3kin\u0169 p\u00e3" },
            { "zun", "sunhi" },
            { "zxx", "n\u00e9n \u0169 v\u1ebdnhv\u0129 ki t\u0169" },
            { "zza", "sasaki" },
            { "Arab", metaValue_ar },
            { "Armi", "arm\u0129" },
            { "Armn", "arm\u1ebdnjo" },
            { "Avst", "av\u00e9nhko" },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Batk", "mataki" },
            { "Beng", metaValue_bn },
            { "Blis", "s\u0129muru mrij" },
            { "Bopo", "mopom\u00e3fo" },
            { "Brah", "mram\u0129" },
            { "Brai", "mrajiri" },
            { "Bugi", "mugn\u1ebdj" },
            { "Buhd", "muhin" },
            { "Cakm", "kagme" },
            { "Cans", "sirama-v\u1ebdnhr\u00e1 pir kan\u1ef9na t\u00e1 kanhg\u00e1g" },
            { "Cari", "karij\u1ef9n\u0169" },
            { "Cham", "s\u1ef9m" },
            { "Cher", metaValue_chr },
            { "Cirt", "sirti" },
            { "Copt", "k\u00f3mtiko" },
            { "Cprt", "siprijota" },
            { "Cyrl", "siririko" },
            { "Cyrs", "siririko esiravo ekresijatiko" },
            { "Deva", "nevan\u1ef9gari" },
            { "Dsrt", "nesereti" },
            { "Egyd", "nem\u00e3tiko ejimso" },
            { "Egyh", "jeratiko ejimso" },
            { "Egyp", "jer\u00f3grifo ejimso" },
            { "Ethi", "etij\u00f3piko" },
            { "Geok", "kehunsuri ge\u00f3rgij\u1ef9n\u0169" },
            { "Geor", "ge\u00f3rgij\u1ef9n\u0169" },
            { "Glag", "gragoritiko" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "guserate" },
            { "Guru", "gurm\u0169ki" },
            { "Hanb", "h\u1ef9nme" },
            { "Hang", "h\u1ef9ngur" },
            { "Hani", "h\u1ef9n" },
            { "Hano", "h\u1ef9n\u0169n\u0169" },
            { "Hans", "s\u0129pri-h\u00e1" },
            { "Hant", "si-p\u1ebd" },
            { "Hebr", "hemraiko" },
            { "Hira", "hirag\u1ef9n\u1ef9" },
            { "Hmng", "pahav hom\u00e3g" },
            { "Hrkt", "sirama-v\u1ebdnhr\u00e1 japun\u1ebdj" },
            { "Hung", "h\u0169garu si" },
            { "Inds", "\u0129nu" },
            { "Ital", "itariko si" },
            { "Jamo", "j\u1ef9mo" },
            { "Java", metaValue_jv },
            { "Jpan", "japun\u1ebdj" },
            { "Kali", "kaja-ri" },
            { "Kana", "katak\u1ef9n\u1ef9" },
            { "Khar", "karositi" },
            { "Khmr", metaValue_km },
            { "Knda", "kan-n\u1ef9na" },
            { "Kore", metaValue_ko },
            { "Kthi", "kanhi" },
            { "Lana", "r\u1ef9n\u1ef9" },
            { "Laoo", "ra\u2019o" },
            { "Latf", "rat\u0129nh fragtur" },
            { "Latg", "rat\u0129nh gaj\u00e9riko" },
            { "Latn", metaValue_la },
            { "Lepc", "r\u00e9msa" },
            { "Limb", "r\u0129mu" },
            { "Lina", "r\u0129n\u1ebdjar A" },
            { "Linb", "r\u0129n\u1ebdjar B" },
            { "Lisu", "risu" },
            { "Lyci", "risijo" },
            { "Lydi", "rinh-jo" },
            { "Mand", "m\u1ef9najku" },
            { "Mani", "m\u1ef9n\u0129kej\u1ef9n\u0169" },
            { "Maya", "hijer\u00f3grifu maja" },
            { "Merc", "m\u1ebdrojitiku n\u0129g\u00e9-t\u1ef9" },
            { "Mero", "m\u1ebdrojitiku" },
            { "Mlym", "marajara" },
            { "Mong", metaValue_mn },
            { "Moon", "m\u0169n" },
            { "Mtei", "m\u1ebdjtej m\u1ef9j\u00e9ki" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "og\u1ef9miku" },
            { "Olck", "or siki" },
            { "Orkh", "orkih\u00e3n" },
            { "Orya", metaValue_or },
            { "Osma", "ojm\u1ef9nja" },
            { "Perm", "p\u00e9rm\u0129ku si" },
            { "Phag", "fagpa" },
            { "Phli", "pahir" },
            { "Phlp", "pahin" },
            { "Phlv", "pahiravi si" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fon\u1ebdtiko porarne" },
            { "Prti", "priti" },
            { "Rjng", "rej\u1ef9g" },
            { "Roro", "r\u00e3gor\u00e3go" },
            { "Runr", "run\u0129ku" },
            { "Samr", "sam\u1ef9rit\u1ef9n\u0169" },
            { "Sara", "sarati" },
            { "Saur", "savurajtera" },
            { "Sgnw", "v\u1ebdnh-mu v\u1ebdnhr\u00e1d" },
            { "Shaw", "savij\u1ef9n\u0169" },
            { "Sinh", "s\u0129gar\u1ebdj" },
            { "Sund", "s\u0169nan\u1ebdj" },
            { "Sylo", "syroti n\u1ef9gri" },
            { "Syrc", "sirijaku" },
            { "Syre", "sirijaku esitarageru" },
            { "Syrj", "sirijaku r\u00e3pur" },
            { "Syrn", "sirijaku r\u00e3jur" },
            { "Tagb", "tagm\u00e1nva" },
            { "Tale", "taj-re" },
            { "Talu", "taj-re t\u00e3g" },
            { "Taml", "t\u1ef9m\u0129r" },
            { "Tavt", "tavuti" },
            { "Telu", "t\u00e9rugu" },
            { "Teng", "t\u1ebdgvar" },
            { "Tfng", "tifin\u1ef9g" },
            { "Tglg", "tagaru" },
            { "Thaa", "ta\u2019an\u1ef9" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "ugaritiku" },
            { "Vaii", metaValue_vai },
            { "Visp", "v\u0129-ve-h\u00e1" },
            { "Xpeo", "p\u00e9rsa si" },
            { "Xsux", "sum\u1ebdrijo-akanh\u1ef9n\u0169 kaf\u00e9n ja" },
            { "Yiii", "yji" },
            { "Zinh", "ernanu" },
            { "Zmth", "v\u1ebdnhn\u0129kr\u00e9n r\u00e1" },
            { "Zsye", "Em\u00e3ji" },
            { "Zsym", "zsym" },
            { "Zxxx", "v\u1ebdnhr\u00e1-t\u0169" },
            { "Zyyy", "k\u00e3m\u0169" },
            { "Zzzz", "v\u1ebdnhr\u00e1 ki kagt\u0129g" },
            { "root", "haji" },
            { "de_CH", "suvisa arim\u1ef9v-t\u00e9j" },
            { "nl_BE", "fram\u1ebdgo" },
            { "ro_MD", "m\u00e3rnavijo" },
            { "sw_CD", "suvahiri K\u00e3go t\u00e1" },
            { "%%1901", "arim\u1ef9v v\u1ebdnhr\u00e1 si-p\u1ebd" },
            { "%%1994", "resij\u1ef9n\u1ef9 v\u1ebdnhr\u00e1 h\u00e1r-p\u1ebd" },
            { "%%1996", "pr\u1ef9g t\u1ef9 1996 k\u00e3 v\u1ebdnhr\u00e1 arim\u1ef9" },
            { "ar_001", "arame ta\u2019\u0169n" },
            { "key.ca", "Kur\u00e3-kar" },
            { "key.cf", "t\u1ef9 n\u0129kri ve" },
            { "key.co", "jagn\u1ebd n\u00f3n f\u1ebdgf\u1ebdg h\u00e1 han" },
            { "key.cu", "J\u1ebdnkamu" },
            { "key.hc", "\u00d3ra t\u0129g t\u1ef9 (12 vs. 24)" },
            { "key.lb", "v\u1ebdfe mranh to ke" },
            { "key.ms", "v\u1ebdnhk\u00e3mun to ke" },
            { "key.nu", "V\u1ebdnh n\u0129krer" },
            { "key.tz", "\u00d3ra t\u1ef9\u2019\u0169n" },
            { "key.va", "v\u1ebdnhm\u1ef9 t\u00e1 n\u0129n\u0129 ke" },
            { "nds_NL", "sags\u1ef9v rur" },
            { "%%BISKE", "s\u1ef9n j\u00f3rjo/ mira v\u0129 p\u1ebd" },
            { "%%BOONT", "mutr\u0129g - jam\u00e3 v\u0129 p\u1ebd" },
            { "%%KKCOR", "v\u1ebdnhr\u00e1 to ke v\u1ebdnhm\u1ef9 ke kar" },
            { "%%LIPAW", "Resij\u1ef9n t\u1ef9 ripovasi v\u0129 p\u1ebd" },
            { "%%NEDIS", "natison\u1ebd v\u0129 p\u1ebd" },
            { "%%NJIVA", "giva/niva v\u0129 p\u1ebd" },
            { "%%OSOJS", "osejako/osoj\u1ef9n\u1ebd v\u0129 p\u1ebd" },
            { "%%POSIX", "k\u00e3putanor" },
            { "%%ROZAJ", "resij\u1ef9n\u0169" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "setorvisa/ sormika v\u0129 p\u1ebd" },
            { "%%UCCOR", "v\u1ebdnhr\u00e1 to ke pir" },
            { "az_Arab", "aseri sur" },
            { "zh_Hans", "s\u0129n\u1ebdj m\u1ebd" },
            { "zh_Hant", "s\u0129n\u1ebdj p\u1ebd" },
            { "%%AO1990", "1990 F\u00f3g V\u0129 v\u1ebdnhr\u00e1 to V\u1ebdnhkr\u00e9n ja" },
            { "%%FONIPA", "Arfam\u00e9to Fon\u1ebdtiku \u0128nhtern\u1ef9son\u1ef9v to Fon\u1ebdtika" },
            { "%%FONUPA", "Arfam\u00e9to Fon\u1ebdtiku Urariko" },
            { "%%NDYUKA", "nyjuka v\u0129 p\u1ebd" },
            { "%%PAMAKA", "pam\u1ef9ka v\u0129 p\u1ebd" },
            { "%%PINYIN", "Piny\u2019in v\u1ebdnhr\u00e1 ratin\u0169 to" },
            { "%%SCOUSE", "enhkose v\u0129 p\u1ebd" },
            { "%%TARASK", "tarasikevika v\u1ebdnhr\u00e1-p\u1ebd" },
            { "%%UCRCOR", "v\u1ebdnhr\u00e1 j\u1ebdnf\u0129n t\u1ef9 pir ke" },
            { "%%ABL1943", "1943 k\u00e3 F\u00f3g V\u0129 V\u1ebdnhr\u00e1n Form\u0169rariv j\u00e9 h\u00e1r" },
            { "%%AREVELA", "arm\u1ebdn\u0129ju r\u00e3jur" },
            { "%%AREVMDA", "arm\u1ebdn\u0129ju r\u00e3pur" },
            { "%%HEPBURN", "japonej v\u1ebdnhr\u00e1 ratin\u0169 to h\u00e9pymur" },
            { "%%MONOTON", "kyr m\u00e1g ve" },
            { "%%POLYTON", "\u0169 ag t\u00e9j" },
            { "%%REVISED", "v\u1ebdnhr\u00e1 j\u00e3f\u0129" },
            { "%%1606NICT", "1606 k\u00e3 fr\u1ef9sej si" },
            { "%%1694ACAD", "fr\u1ef9sej t\u1ef9 uri" },
            { "%%1959ACAD", "kan\u1ebdm\u0129ku" },
            { "%%BAKU1926", "arfam\u00e9to turko ratin\u0169 t\u1ef9 \u0169n pir" },
            { "%%BISCAYAN", "misikajo" },
            { "%%COLB1945", "Ruso-Mrasirera ki v\u1ebdnhr\u00e1 to 1945 V\u1ebdnhkr\u00e9n ja" },
            { "%%HOGNORSK", "n\u00e3rovegej kynhm\u1ef9" },
            { "%%SCOTLAND", "\u0129nhgrej Enhk\u00f3sija t\u00e1" },
            { "%%VALENCIA", "varensijan\u0169" },
            { "%%WADEGILE", "Wade-Giles v\u1ebdnhr\u00e1 ratin\u0169 to" },
            { "type.ca.roc", "S\u0129n\u1ef9 Kar-m\u1ef9 Pr\u1ef9g-kur\u00e3-kar" },
            { "type.co.eor", "Or\u00f3pa t\u00e1 v\u1ebdnhvin han to ke" },
            { "type.hc.h11", "12 \u00f3ra tuke (0\u201311)" },
            { "type.hc.h12", "12 \u00f3ra tuke (1\u201312)" },
            { "type.hc.h23", "24 \u00f3ra tuke (0\u201323)" },
            { "type.hc.h24", "24 \u00f3ra tuke (1\u201324)" },
            { "type.m0.bgn", "V\u1ebdnhr\u00e1 \u0169 ra t\u0129n BGN EUA (V\u1ebdnhv\u0129 \u0169ra t\u0129n)" },
            { "type.nu.arab", "\u0128no-aramiko r\u00e1 pipir" },
            { "type.nu.armn", "Arm\u1ebdn\u0129jo r\u00e1 pipir" },
            { "type.nu.beng", "Meggari r\u00e1 pipir" },
            { "type.nu.deva", "Nevan\u1ef9gari r\u00e1 pipir" },
            { "type.nu.ethi", "Etij\u00f3pij\u00e1n\u0169 r\u00e1 pipir" },
            { "type.nu.geor", "Jejorj\u1ef9n\u0169 r\u00e1 pipir" },
            { "type.nu.grek", "Grego r\u00e1 pipir" },
            { "type.nu.gujr", "Guserate r\u00e1 pipir" },
            { "type.nu.guru", "Gurm\u0169r\u00e1 pipir r\u00e1 pipir" },
            { "type.nu.hans", "S\u0129n\u1ebdj r\u00e1 pipir s\u0129mpri h\u00e1" },
            { "type.nu.hant", "S\u0129n\u1ebdj r\u00e1 pipir p\u1ebd" },
            { "type.nu.hebr", "Emrajko r\u00e1 pipir" },
            { "type.nu.jpan", "Japon\u1ebdj r\u00e1 pipir" },
            { "type.nu.khmr", "Khm\u1ebdr r\u00e1 pipir" },
            { "type.nu.knda", "Kan\u1ef9r\u1ebdse r\u00e1 pipir" },
            { "type.nu.laoo", "Ravosij\u1ef9n\u0169 r\u00e1 pipir" },
            { "type.nu.latn", "R\u00e3pur r\u00e1 pipir" },
            { "type.nu.mlym", "Marajaro r\u00e1 pipir" },
            { "type.nu.mong", "M\u00e3g\u00f3r r\u00e1 pipir" },
            { "type.nu.mymr", "M\u1ef9j\u1ef9m\u1ef9r r\u00e1 pipir" },
            { "type.nu.orya", "Orija r\u00e1 pipir" },
            { "type.nu.taml", "T\u1ef9m\u0129r p\u1ebd r\u00e1 pipir" },
            { "type.nu.telu", "Terugo r\u00e1 pipir" },
            { "type.nu.thai", "Tajr\u1ef9nej r\u00e1 pipir" },
            { "type.nu.tibt", "Timet\u1ef9n\u0169 r\u00e1 pipir" },
            { "type.nu.vaii", "Vaj n\u0129kr\u00e9n pipir" },
            { "type.ca.dangi", "N\u00e1gi Pr\u1ef9g-kur\u00e3-kar" },
            { "type.co.ducet", "Unicode to ke p\u1ebd" },
            { "type.lb.loose", "V\u1ebdfe mranh han f\u00e3 p\u00e3 tovan ka" },
            { "type.nu.roman", "Rom\u1ef9n\u0169 r\u00e1 pipir" },
            { "type.ca.coptic", "Komtike Pr\u1ef9g-kur\u00e3-kar" },
            { "type.ca.hebrew", "Emrajko Pr\u1ef9g-kur\u00e3-kar" },
            { "type.ca.indian", "\u0128nija Pr\u1ef9g-kur\u00e3-kar p\u1ebd" },
            { "type.co.compat", "\u1ebcgno t\u00e1 j\u1ebdn\u1ebd j\u00e1 k\u1ef9 ta ki j\u00e1" },
            { "type.co.pinyin", "Pin-yin to n\u1ef9t\u0129" },
            { "type.co.search", "J\u1ebdnf\u0129n to ke Kar" },
            { "type.co.stroke", "Junhjoj to ke" },
            { "type.co.unihan", "Ranikar-jonhjoj to n\u1ef9t\u0129 p\u1ebd" },
            { "type.d0.fwidth", "T\u00e3p\u00e9r kar" },
            { "type.d0.hwidth", "T\u00e3p\u00e9r kuju" },
            { "type.lb.normal", "V\u1ebdfe mranh han f\u00e3 p\u1ebd ki" },
            { "type.lb.strict", "V\u1ebdfe mranh han f\u00e3 r\u00e1 ki" },
            { "type.m0.ungegn", "V\u1ebdnhr\u00e1 \u0169 ra t\u0129n UN GEGN" },
            { "type.ms.metric", "K\u00e3mur to ke p\u1ebd" },
            { "type.nu.native", "N\u0129krer \u0169 vep\u00e3 r\u00e1 pipir" },
            { "type.ca.chinese", "S\u0129n\u1ebdj Pr\u1ef9g-kur\u00e3-kar" },
            { "type.ca.iso8601", "Pr\u1ef9g-kur\u00e3-kar ISO-8601" },
            { "type.ca.persian", "P\u00e9rsa Pr\u1ef9g-kur\u00e3-kar" },
            { "type.cf.account", "Kaj\u1ebdm j\u00e9 n\u0129kri h\u00e1r" },
            { "type.co.big5han", "S\u0129n\u1ebdj V\u1ef9sa ke to ke p\u1ebd - Big5" },
            { "type.d0.npinyin", "N\u0129krer" },
            { "type.nu.arabext", "\u0128no-aramiko kugjer r\u00e1 pipir" },
            { "type.nu.armnlow", "Arm\u1ebdn\u0129jo r\u00e1 pipir k\u1ebdsir" },
            { "type.nu.finance", "J\u00e3nkamu vin h\u00e1r n\u0129krer" },
            { "type.nu.greklow", "Grego k\u1ebdsir r\u00e1 pipir" },
            { "type.nu.hanidec", "S\u0129n\u1ebdj n\u00e9j ki r\u00e1 pipir" },
            { "type.nu.hansfin", "S\u0129n\u1ebdj r\u00e1 pipir j\u1ebdnkamu s\u0129mpri h\u00e1" },
            { "type.nu.hantfin", "S\u0129n\u1ebdj r\u00e1 pipir j\u1ebdnkamu p\u1ebd" },
            { "type.nu.jpanfin", "Japon\u1ebdj vin h\u00e1r" },
            { "type.nu.tamldec", "T\u1ef9m\u0129r r\u00e1 pipir" },
            { "type.ca.buddhist", "Munisita Pr\u1ef9g-kur\u00e3-kar" },
            { "type.ca.ethiopic", "Etij\u00f3pi Pr\u1ef9g-kur\u00e3-kar" },
            { "type.ca.japanese", "Japon\u1ebdj Pr\u1ef9g-kur\u00e3-kar" },
            { "type.cf.standard", "N\u0129kri han ka n\u0129 p\u1ebd" },
            { "type.co.phonetic", "Fon\u1ebdtika to ke kupr\u00e3g" },
            { "type.co.searchjl", "Hangul k\u00e3son\u1ef9te ve j\u00e3nf\u0129n" },
            { "type.co.standard", "to ke p\u1ebd" },
            { "type.ms.uksystem", "V\u1ebdnhk\u00e3mur \u0129perijar ki" },
            { "type.ms.ussystem", "Am\u1ebdrik\u1ef9n\u0169 v\u1ebdnhk\u00e3mur to h\u00e1r" },
            { "type.nu.fullwide", "ti t\u00e9j kar r\u00e1 pipir" },
            { "type.nu.romanlow", "Rom\u1ef9n\u0169 r\u00e1 k\u1ebdsir r\u00e1 pipir" },
            { "type.ca.gregorian", "Papa Gregorju Pr\u1ef9g-kur\u00e3-kar" },
            { "type.co.gb2312han", "S\u0129n\u1ebdj ke to ke (s\u0129mpri h\u00e1) - GB2312" },
            { "type.co.phonebook", "Terefon\u0129 Risita to ke" },
            { "type.co.dictionary", "V\u1ebdnhr\u00e1 N\u1ef9t\u0129j-f\u1ebd n\u1ef9t\u0129 h\u00e1" },
            { "type.co.traditional", "To ke n\u1ef9t\u0129 p\u1ebd" },
            { "type.nu.traditional", "N\u0129krer p\u1ebd" },
            { "type.ca.ethiopic-amete-alem", "Amete Alem Etij\u00f3pi Pr\u1ef9g-kur\u00e3-kar" },
        };
        return data;
    }
}
