/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.J2SIgnoreImport;
import javajs.util.BinaryDocument;
import javajs.util.Rdr;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;
import jspecview.source.JDXHeader;
import jspecview.source.JDXReader;
import jspecview.source.JDXSource;

@J2SIgnoreImport(value={FileInputStream.class})
public class BrukerReader {
    private static final int TYPE_INT = 0;
    boolean allowPhasing = false;

    public JDXSource readBrukerZip(byte[] bytes, String fullPath) throws FileNotFoundException, Exception {
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(bytes == null ? new FileInputStream(fullPath) : new ByteArrayInputStream(bytes));
            Hashtable<String, String> map = new Hashtable<String, String>();
            byte[] data1r = new byte[]{};
            byte[] data1i = new byte[]{};
            byte[] data2rr = new byte[]{};
            String root = null;
            String title = null;
            while ((ze = zis.getNextEntry()) != null) {
                String zeName = ze.getName();
                int pt = zeName.lastIndexOf(47);
                String zeShortName = zeName.substring(pt + 1);
                if (root == null && (pt = (root = zeName.substring(0, pt + 1)).indexOf("/pdata/")) >= 0) {
                    root = root.substring(0, pt + 1);
                }
                if (!zeName.startsWith(root)) break;
                boolean isacq = false;
                if (zeShortName.equals("title")) {
                    title = new String(this.getBytes(zis, (int)ze.getSize(), false));
                    map.put("##title", title);
                    continue;
                }
                if (zeShortName.equals("1r")) {
                    data1r = this.getBytes(zis, (int)ze.getSize(), false);
                    continue;
                }
                if (zeShortName.equals("1i")) {
                    if (!this.allowPhasing) continue;
                    data1i = this.getBytes(zis, (int)ze.getSize(), false);
                    continue;
                }
                if (zeShortName.equals("2rr")) {
                    data2rr = this.getBytes(zis, (int)ze.getSize(), false);
                    continue;
                }
                if (zeShortName.equals("proc2s") || zeShortName.equals("acqu2s")) {
                    JDXReader.getHeaderMapS(new ByteArrayInputStream(this.getBytes(zis, (int)ze.getSize(), false)), map, 0, "_2");
                    continue;
                }
                if (!zeShortName.equals("procs") && !(isacq = zeShortName.equals("acqus"))) continue;
                if (isacq) {
                    root = zeName.substring(0, pt + 1);
                }
                JDXReader.getHeaderMap(new ByteArrayInputStream(this.getBytes(zis, (int)ze.getSize(), false)), map);
            }
            zis.close();
            map.put("##TITLE", title == null ? "" : title);
            return this.getSource(fullPath, map, data1r, data1i, data2rr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JDXSource readBrukerDir(String fullPath) throws FileNotFoundException, Exception {
        File procs;
        File dir = new File(fullPath);
        if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        if (!(procs = new File(dir, "procs")).exists()) {
            procs = new File(dir, "pdata/1/procs");
        }
        File pdata = procs.getParentFile();
        File brukerDir = pdata.getParentFile().getParentFile();
        Hashtable<String, String> map = new Hashtable<String, String>();
        this.mapParameters(brukerDir, "acqus", map, null);
        this.mapParameters(brukerDir, "acqu2s", map, "_2");
        this.mapParameters(pdata, "procs", map, null);
        this.mapParameters(pdata, "proc2s", map, "_2");
        map.put("##TITLE", new String(this.getFileContentsAsBytes(new File(pdata, "title"))));
        byte[] data1r = this.getFileContentsAsBytes(new File(procs.getParent(), "1r"));
        byte[] data1i = this.allowPhasing ? this.getFileContentsAsBytes(new File(procs.getParent(), "1i")) : new byte[]{};
        byte[] data2rr = this.getFileContentsAsBytes(new File(procs.getParent(), "2rr"));
        return this.getSource(brukerDir.toString(), map, data1r, data1i, data2rr);
    }

    private void mapParameters(File dir, String fname, Map<String, String> map, String suffix) throws Exception {
        File f = new File(dir, fname);
        if (!f.exists()) {
            return;
        }
        FileInputStream is = new FileInputStream(f);
        JDXReader.getHeaderMapS(is, map, 0, suffix);
        ((InputStream)is).close();
    }

    private JDXSource getSource(String brukerDir, Map<String, String> map, byte[] data1r, byte[] data1i, byte[] data2rr) throws IOException {
        int byteorp;
        int dtypp = Integer.parseInt(map.get("##$DTYPP"));
        int n = byteorp = dtypp == 0 ? Integer.parseInt(map.get("##$BYTORDP")) : Integer.MAX_VALUE;
        if (dtypp == Integer.MIN_VALUE || byteorp == Integer.MIN_VALUE) {
            return null;
        }
        JDXSource source = null;
        if (data1r.length > 0) {
            source = new JDXSource(data1i.length == 0 ? 0 : 2, brukerDir);
            this.setSource(this.getData(data1r, dtypp, byteorp), this.getData(data1i, dtypp, byteorp), map, source, false);
        } else if (data2rr.length > 0) {
            source = new JDXSource(2, brukerDir);
            this.setSource(this.getData(data2rr, dtypp, byteorp), null, map, source, true);
        }
        return source;
    }

    private void setSource(double[] datar, double[] datai, Map<String, String> map, JDXSource source, boolean is2D) {
        JDXHeader.DataLDRTable myLDRTable = new JDXHeader.DataLDRTable();
        Spectrum spectrum0 = new Spectrum();
        spectrum0.setTitle(map.get("##TITLE"));
        spectrum0.setJcampdx(is2D ? "6.0" : "5.1");
        spectrum0.setDataClass("XYDATA");
        spectrum0.setDataType(is2D ? "nD NMR SPECTRUM" : "NMR SPECTRUM");
        spectrum0.setContinuous(true);
        spectrum0.setIncreasing(false);
        spectrum0.setLongDate(map.get("##$DATE"));
        spectrum0.setOrigin("Bruker BioSpin GmbH/JSpecView");
        spectrum0.setOwner(map.get("##OWNER"));
        double freq = BrukerReader.parseDouble(map.get("##$SFO1"));
        double ref = BrukerReader.parseDouble(map.get("##$ABSF1"));
        if (ref == 0.0) {
            ref = BrukerReader.parseDouble(map.get("##$OFFSET"));
        }
        String nuc1 = this.cleanJDXValue(map.get("##$NUC1"));
        String nuc2 = this.cleanJDXValue(map.get("##$NUC2"));
        if (nuc2.length() == 0) {
            nuc2 = nuc1;
        }
        double sw_hz = BrukerReader.parseDouble(map.get("##$SWP"));
        double sw = sw_hz / freq;
        double shift = ref - sw;
        String solvent = this.cleanJDXValue(map.get("##$SOLVENT"));
        String shiftType = "INTERNAL";
        myLDRTable.addHeader("##.SHIFTREFERENCE", shiftType + ", " + solvent + ", 1, " + ref);
        myLDRTable.addHeader("##.OBSERVEFREQUENCY", "" + freq);
        myLDRTable.addHeader("##.OBSERVENUCLEUS", nuc1);
        myLDRTable.addHeader("##SPECTROMETER/DATA SYSTEM", this.cleanJDXValue(map.get("##$INSTRUM")));
        spectrum0.setHeaderTable(myLDRTable.table);
        spectrum0.setObservedNucleus(nuc1);
        spectrum0.setObservedFreq(freq);
        spectrum0.setHZtoPPM(true);
        if (is2D) {
            source.isCompoundSource = true;
            spectrum0.setNumDim(2);
            spectrum0.setNucleusAndFreq(nuc2, false);
            int si0 = Integer.parseInt(map.get("##$SI"));
            int si1 = Integer.parseInt(map.get("##$SI_2"));
            double ref1 = BrukerReader.parseDouble(map.get("##$ABSF1_2"));
            if (ref1 == 0.0) {
                ref1 = BrukerReader.parseDouble(map.get("##$OFFSET"));
            }
            double freq1 = BrukerReader.parseDouble(map.get("##$SFO1_2"));
            double sw_hz1 = BrukerReader.parseDouble(map.get("##$SWP_2"));
            int npoints = si0;
            double xfactor = sw_hz / (double)npoints;
            double xfactor1 = sw_hz1 / (double)si1;
            double freq2 = freq1;
            freq1 = ref1 * freq1 - xfactor1;
            spectrum0.fileNPoints = npoints;
            spectrum0.fileFirstX = sw_hz - xfactor;
            spectrum0.fileLastX = 0.0;
            double f = 1.0;
            int pt = 0;
            for (int j = 0; j < si1; ++j) {
                Spectrum spectrum = new Spectrum();
                spectrum0.copyTo(spectrum);
                spectrum.setTitle(spectrum0.getTitle());
                spectrum.setY2D(freq1);
                spectrum.blockID = Math.random();
                spectrum0.fileNPoints = npoints;
                spectrum0.fileFirstX = sw_hz - xfactor;
                spectrum0.fileLastX = 0.0;
                spectrum.setY2DUnits("HZ");
                spectrum.setXFactor(1.0);
                spectrum.setYFactor(1.0);
                spectrum.setObservedNucleus(nuc2);
                spectrum.setObservedFreq(freq2);
                Coordinate[] xyCoords = new Coordinate[npoints];
                for (int i = 0; i < npoints; ++i) {
                    xyCoords[npoints - i - 1] = new Coordinate().set((double)(npoints - i) * xfactor / freq + shift, datar[pt++] * f);
                }
                spectrum.setXYCoords(xyCoords);
                source.addJDXSpectrum(null, spectrum, j > 0);
                freq1 -= xfactor1;
            }
        } else {
            int npoints = datar.length;
            double xfactor = sw_hz / (double)npoints;
            spectrum0.fileFirstX = sw_hz - xfactor;
            spectrum0.fileLastX = 0.0;
            spectrum0.fileNPoints = npoints;
            Coordinate[] xyCoords = new Coordinate[npoints];
            for (int i = 0; i < npoints; ++i) {
                xyCoords[npoints - i - 1] = new Coordinate().set((double)(npoints - i - 1) * xfactor / freq + shift, datar[i]);
            }
            spectrum0.setXYCoords(xyCoords);
            spectrum0.fileNPoints = npoints;
            spectrum0.setXFactor(xfactor);
            spectrum0.setYFactor(1.0);
            spectrum0.setXUnits("ppm");
            spectrum0.setYUnits("ARBITRARY UNITS");
            spectrum0.setNumDim(1);
            if (spectrum0.getMaxY() >= 10000.0) {
                spectrum0.normalizeSimulation(1000.0);
            }
            source.addJDXSpectrum(null, spectrum0, false);
        }
    }

    private static double parseDouble(String val) {
        return val == null || val.length() == 0 ? Double.NaN : Double.parseDouble(val);
    }

    private double[] getData(byte[] bytes, int dtypp, int byteorp) throws IOException {
        int len = bytes.length / (dtypp == 0 ? 4 : 8);
        BinaryDocument doc = new BinaryDocument();
        doc.setStream(new BufferedInputStream(new ByteArrayInputStream(bytes)), byteorp != 0);
        double[] ad = new double[len];
        double d = 0.0;
        double dmin = Double.MAX_VALUE;
        double dmax = -1.7976931348623157E308;
        if (dtypp == 0) {
            for (int i = 0; i < len; ++i) {
                double f = 1.0;
                ad[i] = d = (double)doc.readInt() * f;
                if (d < dmin) {
                    dmin = d;
                }
                if (!(d > dmax)) continue;
                dmax = d;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                ad[i] = d = doc.readDouble();
                if (d < dmin) {
                    dmin = d;
                }
                if (!(d > dmax)) continue;
                dmax = d;
            }
        }
        doc.close();
        return ad;
    }

    private String cleanJDXValue(String val) {
        String s = val == null ? "" : (val.startsWith("<") ? val.substring(1, val.length() - 1) : val);
        return s.equals("off") ? "" : s;
    }

    private byte[] getFileContentsAsBytes(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            return new byte[0];
        }
        int len = (int)file.length();
        return this.getBytes(new FileInputStream(file), len, true);
    }

    private byte[] getBytes(InputStream in, int len, boolean andClose) {
        try {
            byte[] bytes = Rdr.getLimitedStreamBytes(in, len);
            if (andClose) {
                in.close();
            }
            return bytes;
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }
}

