/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.repositories.descriptor.MavenRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadata;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.M2ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotModuleSource;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.MutableModuleSources;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.jspecify.annotations.Nullable;

public class MavenResolver
extends ExternalResourceResolver {
    private final URI root;
    private final MavenMetadataLoader mavenMetaDataLoader;
    private static final Pattern UNIQUE_SNAPSHOT = Pattern.compile("(?:.+)-(\\d{8}\\.\\d{6}-\\d+)");
    private final MavenLocalRepositoryAccess localAccess = new MavenLocalRepositoryAccess();
    private final MavenRemoteRepositoryAccess remoteAccess = new MavenRemoteRepositoryAccess();

    public MavenResolver(MavenRepositoryDescriptor descriptor, URI rootUri, RepositoryTransport transport, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, ImmutableMetadataSources metadataSources, MetadataArtifactProvider metadataArtifactProvider, MavenMetadataLoader mavenMetaDataLoader, @Nullable InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory, @Nullable InstantiatingAction<ComponentMetadataListerDetails> versionListerFactory, Instantiator injector, ChecksumService checksumService, boolean continueOnConnectionFailure) {
        super(descriptor, transport.isLocal(), transport.getRepository(), transport.getResourceAccessor(), locallyAvailableResourceFinder, artifactFileStore, metadataSources, metadataArtifactProvider, componentMetadataSupplierFactory, versionListerFactory, injector, checksumService, continueOnConnectionFailure);
        this.mavenMetaDataLoader = mavenMetaDataLoader;
        this.root = rootUri;
    }

    public String toString() {
        return "Maven repository '" + this.getName() + "'";
    }

    public URI getRoot() {
        return this.root;
    }

    @Override
    protected void doResolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result) {
        MavenUniqueSnapshotModuleSource uniqueSnapshotVersion;
        MavenUniqueSnapshotModuleSource mavenUniqueSnapshotModuleSource = uniqueSnapshotVersion = MavenResolver.isNonUniqueSnapshot(moduleComponentIdentifier) ? this.findUniqueSnapshotVersion(moduleComponentIdentifier, result) : this.composeUniqueSnapshotVersion(moduleComponentIdentifier);
        if (uniqueSnapshotVersion != null) {
            MavenUniqueSnapshotComponentIdentifier snapshotIdentifier = this.composeSnapshotIdentifier(moduleComponentIdentifier, uniqueSnapshotVersion);
            this.resolveUniqueSnapshotDependency(snapshotIdentifier, prescribedMetaData, result, uniqueSnapshotVersion);
        } else {
            this.resolveStaticDependency(moduleComponentIdentifier, prescribedMetaData, result, super.createArtifactResolver());
        }
    }

    @Override
    protected boolean isMetaDataArtifact(ArtifactType artifactType) {
        return artifactType == ArtifactType.MAVEN_POM;
    }

    private void resolveUniqueSnapshotDependency(MavenUniqueSnapshotComponentIdentifier module, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result, MavenUniqueSnapshotModuleSource snapshotSource) {
        this.resolveStaticDependency(module, prescribedMetaData, result, this.createArtifactResolver(MutableModuleSources.of(snapshotSource)));
    }

    @Override
    protected ExternalResourceArtifactResolver createArtifactResolver(@Nullable ModuleSources moduleSources) {
        if (moduleSources == null) {
            return super.createArtifactResolver(null);
        }
        return moduleSources.withSource(MavenUniqueSnapshotModuleSource.class, source -> {
            if (source.isPresent()) {
                return new MavenUniqueSnapshotExternalResourceArtifactResolver(super.createArtifactResolver(moduleSources), (MavenUniqueSnapshotModuleSource)source.get());
            }
            return super.createArtifactResolver(moduleSources);
        });
    }

    private M2ResourcePattern getWholePattern() {
        return new M2ResourcePattern(this.root, "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier])(.[ext])");
    }

    private @Nullable MavenUniqueSnapshotModuleSource findUniqueSnapshotVersion(ModuleComponentIdentifier module, ResourceAwareResolveResult result) {
        M2ResourcePattern wholePattern = this.getWholePattern();
        if (!wholePattern.isComplete(module)) {
            return null;
        }
        ExternalResourceName metadataLocation = wholePattern.toModuleVersionPath(module).resolve("maven-metadata.xml");
        result.attempted(metadataLocation);
        MavenMetadata mavenMetadata = this.parseMavenMetadata(metadataLocation);
        if (mavenMetadata.timestamp != null) {
            String timestamp = mavenMetadata.timestamp + "-" + mavenMetadata.buildNumber;
            return new MavenUniqueSnapshotModuleSource(timestamp);
        }
        return null;
    }

    private @Nullable MavenUniqueSnapshotModuleSource composeUniqueSnapshotVersion(ModuleComponentIdentifier moduleComponentIdentifier) {
        Matcher matcher = UNIQUE_SNAPSHOT.matcher(moduleComponentIdentifier.getVersion());
        if (!matcher.matches()) {
            return null;
        }
        return new MavenUniqueSnapshotModuleSource(matcher.group(1));
    }

    private MavenMetadata parseMavenMetadata(ExternalResourceName metadataLocation) {
        try {
            return this.mavenMetaDataLoader.load(metadataLocation);
        }
        catch (MissingResourceException e) {
            return new MavenMetadata();
        }
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentResolveMetadata> getLocalAccess() {
        return this.localAccess;
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentResolveMetadata> getRemoteAccess() {
        return this.remoteAccess;
    }

    public static MutableMavenModuleResolveMetadata processMetaData(MutableMavenModuleResolveMetadata metaData) {
        ModuleComponentIdentifier id = metaData.getId();
        if (MavenResolver.isNonUniqueSnapshot(id)) {
            metaData.setChanging(true);
        }
        if (MavenResolver.isUniqueSnapshot(id)) {
            MavenUniqueSnapshotComponentIdentifier mus = (MavenUniqueSnapshotComponentIdentifier)id;
            metaData.setSnapshotTimestamp(mus.getTimestamp());
        }
        return metaData;
    }

    private static boolean isUniqueSnapshot(ModuleComponentIdentifier id) {
        return id instanceof MavenUniqueSnapshotComponentIdentifier;
    }

    protected static boolean isNonUniqueSnapshot(ModuleComponentIdentifier moduleComponentIdentifier) {
        return moduleComponentIdentifier.getVersion().endsWith("-SNAPSHOT");
    }

    private MavenUniqueSnapshotComponentIdentifier composeSnapshotIdentifier(ModuleComponentIdentifier moduleComponentIdentifier, MavenUniqueSnapshotModuleSource uniqueSnapshotVersion) {
        return new MavenUniqueSnapshotComponentIdentifier(moduleComponentIdentifier.getModuleIdentifier(), moduleComponentIdentifier.getVersion(), uniqueSnapshotVersion.getTimestamp());
    }

    private class MavenLocalRepositoryAccess
    extends ExternalResourceResolver.LocalRepositoryAccess {
        private MavenLocalRepositoryAccess() {
        }

        @Override
        protected void resolveJavadocArtifacts(ComponentArtifactResolveMetadata module, BuildableArtifactSetResolveResult result) {
        }

        @Override
        protected void resolveSourceArtifacts(ComponentArtifactResolveMetadata module, BuildableArtifactSetResolveResult result) {
        }
    }

    private class MavenRemoteRepositoryAccess
    extends ExternalResourceResolver.RemoteRepositoryAccess {
        private MavenRemoteRepositoryAccess() {
        }
    }
}

