/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.BooleanBuildOption;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;

public class ToolchainBuildOptions {
    public static BuildOptionSet<ToolchainConfiguration> forToolChainConfiguration() {
        return new BuildOptionSet<ToolchainConfiguration>(){
            private final List<? extends BuildOption<? super ToolchainConfiguration>> options = Arrays.asList(new AbstractBuildOption[]{new JavaInstallationPathsOption<ToolchainConfiguration>(){

                public void applyTo(String value, ToolchainConfiguration settings, Origin origin) {
                    settings.setInstallationsFromPaths(Arrays.asList(value.split(",")));
                }
            }, new JavaInstallationEnvironmentPathsOption<ToolchainConfiguration>(){

                public void applyTo(String value, ToolchainConfiguration settings, Origin origin) {
                    settings.setJavaInstallationsFromEnvironment(Arrays.asList(value.split(",")));
                }
            }, new AutoDetectionOption<ToolchainConfiguration>(){

                public void applyTo(boolean value, ToolchainConfiguration settings, Origin origin) {
                    settings.setAutoDetectEnabled(value);
                }
            }, new AutoDownloadOption<ToolchainConfiguration>(){

                public void applyTo(boolean value, ToolchainConfiguration settings, Origin origin) {
                    settings.setDownloadEnabled(value);
                }
            }, new IntellijJdkBuildOption<ToolchainConfiguration>(){

                public void applyTo(String value, ToolchainConfiguration settings, Origin origin) {
                    settings.setIntelliJdkDirectory(new File(value));
                }
            }});

            public List<? extends BuildOption<? super ToolchainConfiguration>> getAllOptions() {
                return this.options;
            }
        };
    }

    public static BuildOptionSet<StartParameter> forStartParameter() {
        return new BuildOptionSet<StartParameter>(){
            private final List<? extends BuildOption<? super StartParameter>> options = Arrays.asList(new AbstractBuildOption[]{new JavaInstallationPathsOption<StartParameter>(){

                public void applyTo(String value, StartParameter settings, Origin origin) {
                    settings.getProjectProperties().putIfAbsent(this.getProperty(), value);
                }
            }, new JavaInstallationEnvironmentPathsOption<StartParameter>(){

                public void applyTo(String value, StartParameter settings, Origin origin) {
                    settings.getProjectProperties().putIfAbsent(this.getProperty(), value);
                }
            }, new AutoDetectionOption<StartParameter>(){

                public void applyTo(boolean value, StartParameter settings, Origin origin) {
                    settings.getProjectProperties().putIfAbsent(this.getProperty(), Boolean.toString(value));
                }
            }, new AutoDownloadOption<StartParameter>(){

                public void applyTo(boolean value, StartParameter settings, Origin origin) {
                    settings.getProjectProperties().putIfAbsent(this.getProperty(), Boolean.toString(value));
                }
            }, new IntellijJdkBuildOption<StartParameter>(){

                public void applyTo(String value, StartParameter settings, Origin origin) {
                    settings.getProjectProperties().putIfAbsent(this.getProperty(), value);
                }
            }});

            public List<? extends BuildOption<? super StartParameter>> getAllOptions() {
                return this.options;
            }
        };
    }

    private static abstract class IntellijJdkBuildOption<T>
    extends StringBuildOption<T> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.idea-jdks-directory";

        public IntellijJdkBuildOption() {
            super(GRADLE_PROPERTY);
        }
    }

    private static abstract class AutoDownloadOption<T>
    extends BooleanBuildOption<T> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.auto-download";

        public AutoDownloadOption() {
            super(GRADLE_PROPERTY);
        }
    }

    private static abstract class AutoDetectionOption<T>
    extends BooleanBuildOption<T> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.auto-detect";

        public AutoDetectionOption() {
            super(GRADLE_PROPERTY);
        }
    }

    private static abstract class JavaInstallationEnvironmentPathsOption<T>
    extends StringBuildOption<T> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.fromEnv";

        public JavaInstallationEnvironmentPathsOption() {
            super(GRADLE_PROPERTY);
        }
    }

    private static abstract class JavaInstallationPathsOption<T>
    extends StringBuildOption<T> {
        private static final String GRADLE_PROPERTY = "org.gradle.java.installations.paths";

        public JavaInstallationPathsOption() {
            super(GRADLE_PROPERTY);
        }
    }
}

