/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.DataSourcePageDescriptor;
import org.jkiss.utils.CommonUtils;

public class DataSourceConfiguratorDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.ui.dataSourceConfigurator";
    private final String id;
    private final List<DataSourcePageDescriptor> pages = new ArrayList<DataSourcePageDescriptor>();

    public DataSourceConfiguratorDescriptor(IConfigurationElement config) {
        super(config.getContributor().getName());
        this.id = config.getAttribute("id");
        for (IConfigurationElement pageCfg : config.getChildren("dataSourcePage")) {
            this.pages.add(new DataSourcePageDescriptor(pageCfg));
        }
    }

    public String getId() {
        return this.id;
    }

    public List<DataSourcePageDescriptor> getAllPages() {
        return this.pages;
    }

    public List<DataSourcePageDescriptor> getRootPages(DBPDataSourceContainer dataSource) {
        ArrayList<DataSourcePageDescriptor> roots = new ArrayList<DataSourcePageDescriptor>();
        for (DataSourcePageDescriptor page : this.pages) {
            if (!CommonUtils.isEmpty((String)page.getParentId()) || !page.appliesTo(dataSource)) continue;
            roots.add(page);
        }
        return roots;
    }

    public List<DataSourcePageDescriptor> getChildPages(DBPDataSourceContainer dataSource, String parentId) {
        ArrayList<DataSourcePageDescriptor> children = new ArrayList<DataSourcePageDescriptor>();
        for (DataSourcePageDescriptor page : this.pages) {
            if (!parentId.equals(page.getParentId()) || !page.appliesTo(dataSource)) continue;
            children.add(page);
        }
        return children;
    }

    public String toString() {
        return this.id;
    }

    public boolean appliesTo(DBPDataSourceContainer dataSourceContainer) {
        return true;
    }
}

